package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddServersToServerGroup invokes the alb.AddServersToServerGroup API synchronously
func (client *Client) AddServersToServerGroup(request *AddServersToServerGroupRequest) (response *AddServersToServerGroupResponse, err error) {
	response = CreateAddServersToServerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddServersToServerGroupWithChan invokes the alb.AddServersToServerGroup API asynchronously
func (client *Client) AddServersToServerGroupWithChan(request *AddServersToServerGroupRequest) (<-chan *AddServersToServerGroupResponse, <-chan error) {
	responseChan := make(chan *AddServersToServerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddServersToServerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddServersToServerGroupWithCallback invokes the alb.AddServersToServerGroup API asynchronously
func (client *Client) AddServersToServerGroupWithCallback(request *AddServersToServerGroupRequest, callback func(response *AddServersToServerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddServersToServerGroupResponse
		var err error
		defer close(result)
		response, err = client.AddServersToServerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddServersToServerGroupRequest is the request struct for api AddServersToServerGroup
type AddServersToServerGroupRequest struct {
	*requests.RpcRequest
	ClientToken   string                            `position:"Query" name:"ClientToken"`
	ServerGroupId string                            `position:"Query" name:"ServerGroupId"`
	Servers       *[]AddServersToServerGroupServers `position:"Query" name:"Servers"  type:"Repeated"`
	DryRun        requests.Boolean                  `position:"Query" name:"DryRun"`
}

// AddServersToServerGroupServers is a repeated param struct in AddServersToServerGroupRequest
type AddServersToServerGroupServers struct {
	RemoteIpEnabled string `name:"RemoteIpEnabled"`
	ServerType      string `name:"ServerType"`
	Port            string `name:"Port"`
	Description     string `name:"Description"`
	ServerIp        string `name:"ServerIp"`
	Weight          string `name:"Weight"`
	ServerId        string `name:"ServerId"`
}

// AddServersToServerGroupResponse is the response struct for api AddServersToServerGroup
type AddServersToServerGroupResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddServersToServerGroupRequest creates a request to invoke AddServersToServerGroup API
func CreateAddServersToServerGroupRequest() (request *AddServersToServerGroupRequest) {
	request = &AddServersToServerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "AddServersToServerGroup", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddServersToServerGroupResponse creates a response to parse from AddServersToServerGroup response
func CreateAddServersToServerGroupResponse() (response *AddServersToServerGroupResponse) {
	response = &AddServersToServerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
