package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetRoutineSubdomain invokes the dcdn.SetRoutineSubdomain API synchronously
func (client *Client) SetRoutineSubdomain(request *SetRoutineSubdomainRequest) (response *SetRoutineSubdomainResponse, err error) {
	response = CreateSetRoutineSubdomainResponse()
	err = client.DoAction(request, response)
	return
}

// SetRoutineSubdomainWithChan invokes the dcdn.SetRoutineSubdomain API asynchronously
func (client *Client) SetRoutineSubdomainWithChan(request *SetRoutineSubdomainRequest) (<-chan *SetRoutineSubdomainResponse, <-chan error) {
	responseChan := make(chan *SetRoutineSubdomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetRoutineSubdomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetRoutineSubdomainWithCallback invokes the dcdn.SetRoutineSubdomain API asynchronously
func (client *Client) SetRoutineSubdomainWithCallback(request *SetRoutineSubdomainRequest, callback func(response *SetRoutineSubdomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetRoutineSubdomainResponse
		var err error
		defer close(result)
		response, err = client.SetRoutineSubdomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetRoutineSubdomainRequest is the request struct for api SetRoutineSubdomain
type SetRoutineSubdomainRequest struct {
	*requests.RpcRequest
	Subdomains string           `position:"Body" name:"Subdomains"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// SetRoutineSubdomainResponse is the response struct for api SetRoutineSubdomain
type SetRoutineSubdomainResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Content   map[string]interface{} `json:"Content" xml:"Content"`
}

// CreateSetRoutineSubdomainRequest creates a request to invoke SetRoutineSubdomain API
func CreateSetRoutineSubdomainRequest() (request *SetRoutineSubdomainRequest) {
	request = &SetRoutineSubdomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "SetRoutineSubdomain", "", "")
	request.Method = requests.POST
	return
}

// CreateSetRoutineSubdomainResponse creates a response to parse from SetRoutineSubdomain response
func CreateSetRoutineSubdomainResponse() (response *SetRoutineSubdomainResponse) {
	response = &SetRoutineSubdomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
