package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNodeBatch invokes the dds.CreateNodeBatch API synchronously
func (client *Client) CreateNodeBatch(request *CreateNodeBatchRequest) (response *CreateNodeBatchResponse, err error) {
	response = CreateCreateNodeBatchResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNodeBatchWithChan invokes the dds.CreateNodeBatch API asynchronously
func (client *Client) CreateNodeBatchWithChan(request *CreateNodeBatchRequest) (<-chan *CreateNodeBatchResponse, <-chan error) {
	responseChan := make(chan *CreateNodeBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNodeBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNodeBatchWithCallback invokes the dds.CreateNodeBatch API asynchronously
func (client *Client) CreateNodeBatchWithCallback(request *CreateNodeBatchRequest, callback func(response *CreateNodeBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNodeBatchResponse
		var err error
		defer close(result)
		response, err = client.CreateNodeBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNodeBatchRequest is the request struct for api CreateNodeBatch
type CreateNodeBatchRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NodesInfo            string           `position:"Query" name:"NodesInfo"`
	CouponNo             string           `position:"Query" name:"CouponNo"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	BusinessInfo         string           `position:"Query" name:"BusinessInfo"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	FromApp              string           `position:"Query" name:"FromApp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateNodeBatchResponse is the response struct for api CreateNodeBatch
type CreateNodeBatchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
	NodeId    string `json:"NodeId" xml:"NodeId"`
}

// CreateCreateNodeBatchRequest creates a request to invoke CreateNodeBatch API
func CreateCreateNodeBatchRequest() (request *CreateNodeBatchRequest) {
	request = &CreateNodeBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "CreateNodeBatch", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNodeBatchResponse creates a response to parse from CreateNodeBatch response
func CreateCreateNodeBatchResponse() (response *CreateNodeBatchResponse) {
	response = &CreateNodeBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
