package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEpnInstanceAttribute invokes the ens.DescribeEpnInstanceAttribute API synchronously
func (client *Client) DescribeEpnInstanceAttribute(request *DescribeEpnInstanceAttributeRequest) (response *DescribeEpnInstanceAttributeResponse, err error) {
	response = CreateDescribeEpnInstanceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEpnInstanceAttributeWithChan invokes the ens.DescribeEpnInstanceAttribute API asynchronously
func (client *Client) DescribeEpnInstanceAttributeWithChan(request *DescribeEpnInstanceAttributeRequest) (<-chan *DescribeEpnInstanceAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeEpnInstanceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEpnInstanceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEpnInstanceAttributeWithCallback invokes the ens.DescribeEpnInstanceAttribute API asynchronously
func (client *Client) DescribeEpnInstanceAttributeWithCallback(request *DescribeEpnInstanceAttributeRequest, callback func(response *DescribeEpnInstanceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEpnInstanceAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeEpnInstanceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEpnInstanceAttributeRequest is the request struct for api DescribeEpnInstanceAttribute
type DescribeEpnInstanceAttributeRequest struct {
	*requests.RpcRequest
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
}

// DescribeEpnInstanceAttributeResponse is the response struct for api DescribeEpnInstanceAttribute
type DescribeEpnInstanceAttributeResponse struct {
	*responses.BaseResponse
	EPNInstanceId   string             `json:"EPNInstanceId" xml:"EPNInstanceId"`
	EPNInstanceName string             `json:"EPNInstanceName" xml:"EPNInstanceName"`
	NetworkingModel string             `json:"NetworkingModel" xml:"NetworkingModel"`
	RequestId       string             `json:"RequestId" xml:"RequestId"`
	ConfVersions    []ConfVersionsItem `json:"ConfVersions" xml:"ConfVersions"`
	Instances       []EPNInstance      `json:"Instances" xml:"Instances"`
	VSwitches       []EPNInstance      `json:"VSwitches" xml:"VSwitches"`
}

// CreateDescribeEpnInstanceAttributeRequest creates a request to invoke DescribeEpnInstanceAttribute API
func CreateDescribeEpnInstanceAttributeRequest() (request *DescribeEpnInstanceAttributeRequest) {
	request = &DescribeEpnInstanceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEpnInstanceAttribute", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEpnInstanceAttributeResponse creates a response to parse from DescribeEpnInstanceAttribute response
func CreateDescribeEpnInstanceAttributeResponse() (response *DescribeEpnInstanceAttributeResponse) {
	response = &DescribeEpnInstanceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
