package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVpcEndpointServiceAttribute invokes the privatelink.UpdateVpcEndpointServiceAttribute API synchronously
func (client *Client) UpdateVpcEndpointServiceAttribute(request *UpdateVpcEndpointServiceAttributeRequest) (response *UpdateVpcEndpointServiceAttributeResponse, err error) {
	response = CreateUpdateVpcEndpointServiceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVpcEndpointServiceAttributeWithChan invokes the privatelink.UpdateVpcEndpointServiceAttribute API asynchronously
func (client *Client) UpdateVpcEndpointServiceAttributeWithChan(request *UpdateVpcEndpointServiceAttributeRequest) (<-chan *UpdateVpcEndpointServiceAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateVpcEndpointServiceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVpcEndpointServiceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVpcEndpointServiceAttributeWithCallback invokes the privatelink.UpdateVpcEndpointServiceAttribute API asynchronously
func (client *Client) UpdateVpcEndpointServiceAttributeWithCallback(request *UpdateVpcEndpointServiceAttributeRequest, callback func(response *UpdateVpcEndpointServiceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVpcEndpointServiceAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateVpcEndpointServiceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVpcEndpointServiceAttributeRequest is the request struct for api UpdateVpcEndpointServiceAttribute
type UpdateVpcEndpointServiceAttributeRequest struct {
	*requests.RpcRequest
	PrivateServiceDomainEnabled requests.Boolean `position:"Query" name:"PrivateServiceDomainEnabled"`
	PrivateServiceDomain        string           `position:"Query" name:"PrivateServiceDomain"`
	AutoAcceptEnabled           requests.Boolean `position:"Query" name:"AutoAcceptEnabled"`
	ClientToken                 string           `position:"Query" name:"ClientToken"`
	ConnectBandwidth            requests.Integer `position:"Query" name:"ConnectBandwidth"`
	ZoneAffinityEnabled         requests.Boolean `position:"Query" name:"ZoneAffinityEnabled"`
	DryRun                      requests.Boolean `position:"Query" name:"DryRun"`
	ServiceDescription          string           `position:"Query" name:"ServiceDescription"`
	ServiceId                   string           `position:"Query" name:"ServiceId"`
}

// UpdateVpcEndpointServiceAttributeResponse is the response struct for api UpdateVpcEndpointServiceAttribute
type UpdateVpcEndpointServiceAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateVpcEndpointServiceAttributeRequest creates a request to invoke UpdateVpcEndpointServiceAttribute API
func CreateUpdateVpcEndpointServiceAttributeRequest() (request *UpdateVpcEndpointServiceAttributeRequest) {
	request = &UpdateVpcEndpointServiceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "UpdateVpcEndpointServiceAttribute", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVpcEndpointServiceAttributeResponse creates a response to parse from UpdateVpcEndpointServiceAttribute response
func CreateUpdateVpcEndpointServiceAttributeResponse() (response *UpdateVpcEndpointServiceAttributeResponse) {
	response = &UpdateVpcEndpointServiceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
