#!/bin/bash

# encoding bitrate
MP3_BITRATE="192"

# MP3 audio quality (0 - 9, lower is better/slower)
MP3_QUALITY="2"

# --- DO NOT EDIT BELOW HERE ---

# create backup directory
echo "* Creating backup directory..."
mkdir -p backup || die "* ERROR: Couldn't create backup directory!"

# copy old mp3's to backup directory
echo "* Copying mp3's to backup directory..."
cp *.mp3 backup || die "* ERROR: Couldn't backup mp3's to the backup directory!"

# begin reencoding
echo "* Reencoding MP3s to ${MP3_BITRATE}K bitrate, quality=${MP3_QUALITY}..."
for file in *.mp3
do
	taginfo "${file}" > "${file}tag"
	source "${file}tag"
	mv "${file}" "${file}old"
	lame -q ${MP3_QUALITY} -b ${MP3_BITRATE} --mp3input --tt "${TITLE}" --ta "${ARTIST}" --tl "${ALBUM}" --tn "${TRACK}" --tg "${GENRE}" --ty "${YEAR}" "${file}old" "${file}"
	unset FILE TITLE ARTIST ALBUM TITLE TRACK GENRE YEAR COMMENT LENGTH BITRATE SAMPLERATE CHANNELS
	rm "${file}old" "${file}tag"
done

echo "* Encoding complete!"

exit
