/* congestion_control.c -- generated by Trunnel v1.5.3.
 * https://gitweb.torproject.org/trunnel.git
 * You probably shouldn't edit this file.
 */
#include <stdlib.h>
#include "trunnel-impl.h"

#include "congestion_control.h"

#define TRUNNEL_SET_ERROR_CODE(obj) \
  do {                              \
    (obj)->trunnel_error_code_ = 1; \
  } while (0)

#if defined(__COVERITY__) || defined(__clang_analyzer__)
/* If we're running a static analysis tool, we don't want it to complain
 * that some of our remaining-bytes checks are dead-code. */
int congestioncontrol_deadcode_dummy__ = 0;
#define OR_DEADCODE_DUMMY || congestioncontrol_deadcode_dummy__
#else
#define OR_DEADCODE_DUMMY
#endif

#define CHECK_REMAINING(nbytes, label)                           \
  do {                                                           \
    if (remaining < (nbytes) OR_DEADCODE_DUMMY) {                \
      goto label;                                                \
    }                                                            \
  } while (0)

trn_extension_field_cc_t *
trn_extension_field_cc_new(void)
{
  trn_extension_field_cc_t *val = trunnel_calloc(1, sizeof(trn_extension_field_cc_t));
  if (NULL == val)
    return NULL;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
trn_extension_field_cc_clear(trn_extension_field_cc_t *obj)
{
  (void) obj;
}

void
trn_extension_field_cc_free(trn_extension_field_cc_t *obj)
{
  if (obj == NULL)
    return;
  trn_extension_field_cc_clear(obj);
  trunnel_memwipe(obj, sizeof(trn_extension_field_cc_t));
  trunnel_free_(obj);
}

uint8_t
trn_extension_field_cc_get_sendme_inc(const trn_extension_field_cc_t *inp)
{
  return inp->sendme_inc;
}
int
trn_extension_field_cc_set_sendme_inc(trn_extension_field_cc_t *inp, uint8_t val)
{
  inp->sendme_inc = val;
  return 0;
}
const char *
trn_extension_field_cc_check(const trn_extension_field_cc_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  return NULL;
}

ssize_t
trn_extension_field_cc_encoded_len(const trn_extension_field_cc_t *obj)
{
  ssize_t result = 0;

  if (NULL != trn_extension_field_cc_check(obj))
     return -1;


  /* Length of u8 sendme_inc */
  result += 1;
  return result;
}
int
trn_extension_field_cc_clear_errors(trn_extension_field_cc_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
trn_extension_field_cc_encode(uint8_t *output, const size_t avail, const trn_extension_field_cc_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = trn_extension_field_cc_encoded_len(obj);
#endif

  if (NULL != (msg = trn_extension_field_cc_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u8 sendme_inc */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->sendme_inc));
  written += 1; ptr += 1;


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As trn_extension_field_cc_parse(), but do not allocate the output
 * object.
 */
static ssize_t
trn_extension_field_cc_parse_into(trn_extension_field_cc_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u8 sendme_inc */
  CHECK_REMAINING(1, truncated);
  obj->sendme_inc = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
}

ssize_t
trn_extension_field_cc_parse(trn_extension_field_cc_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = trn_extension_field_cc_new();
  if (NULL == *output)
    return -1;
  result = trn_extension_field_cc_parse_into(*output, input, len_in);
  if (result < 0) {
    trn_extension_field_cc_free(*output);
    *output = NULL;
  }
  return result;
}
