// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/network/http_connection_manager/v4alpha/http_connection_manager.proto

package envoy_extensions_filters_network_http_connection_manager_v4alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}
)

// Validate checks the field values on HttpConnectionManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *HttpConnectionManager) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := HttpConnectionManager_CodecType_name[int32(m.GetCodecType())]; !ok {
		return HttpConnectionManagerValidationError{
			field:  "CodecType",
			reason: "value must be one of the defined enum values",
		}
	}

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		return HttpConnectionManagerValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
	}

	for idx, item := range m.GetHttpFilters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  fmt.Sprintf("HttpFilters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetAddUserAgent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "AddUserAgent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetCommonHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "CommonHttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "HttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetHttp2ProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "Http2ProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if !_HttpConnectionManager_ServerName_Pattern.MatchString(m.GetServerName()) {
		return HttpConnectionManagerValidationError{
			field:  "ServerName",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
	}

	if _, ok := HttpConnectionManager_ServerHeaderTransformation_name[int32(m.GetServerHeaderTransformation())]; !ok {
		return HttpConnectionManagerValidationError{
			field:  "ServerHeaderTransformation",
			reason: "value must be one of the defined enum values",
		}
	}

	if wrapper := m.GetMaxRequestHeadersKb(); wrapper != nil {

		if val := wrapper.GetValue(); val <= 0 || val > 96 {
			return HttpConnectionManagerValidationError{
				field:  "MaxRequestHeadersKb",
				reason: "value must be inside range (0, 96]",
			}
		}

	}

	if v, ok := interface{}(m.GetStreamIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "StreamIdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRequestTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "RequestTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetRequestHeadersTimeout(); d != nil {
		dur, err := ptypes.Duration(d)
		if err != nil {
			return HttpConnectionManagerValidationError{
				field:  "RequestHeadersTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gte := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur < gte {
			return HttpConnectionManagerValidationError{
				field:  "RequestHeadersTimeout",
				reason: "value must be greater than or equal to 0s",
			}
		}

	}

	if v, ok := interface{}(m.GetDrainTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "DrainTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetDelayedCloseTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "DelayedCloseTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetAccessLog() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  fmt.Sprintf("AccessLog[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetUseRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "UseRemoteAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for XffNumTrustedHops

	if v, ok := interface{}(m.GetInternalAddressConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "InternalAddressConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for SkipXffAppend

	// no validation rules for Via

	if v, ok := interface{}(m.GetGenerateRequestId()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "GenerateRequestId",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for PreserveExternalRequestId

	// no validation rules for AlwaysSetRequestIdInResponse

	if _, ok := HttpConnectionManager_ForwardClientCertDetails_name[int32(m.GetForwardClientCertDetails())]; !ok {
		return HttpConnectionManagerValidationError{
			field:  "ForwardClientCertDetails",
			reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetSetCurrentClientCertDetails()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "SetCurrentClientCertDetails",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Proxy_100Continue

	// no validation rules for RepresentIpv4RemoteAddressAsIpv4MappedIpv6

	for idx, item := range m.GetUpgradeConfigs() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetNormalizePath()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "NormalizePath",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for MergeSlashes

	if v, ok := interface{}(m.GetRequestIdExtension()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "RequestIdExtension",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetLocalReplyConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "LocalReplyConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetStreamErrorOnInvalidHttpMessage()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManagerValidationError{
				field:  "StreamErrorOnInvalidHttpMessage",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.RouteSpecifier.(type) {

	case *HttpConnectionManager_Rds:

		if v, ok := interface{}(m.GetRds()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  "Rds",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HttpConnectionManager_RouteConfig:

		if v, ok := interface{}(m.GetRouteConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  "RouteConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HttpConnectionManager_ScopedRoutes:

		if v, ok := interface{}(m.GetScopedRoutes()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManagerValidationError{
					field:  "ScopedRoutes",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return HttpConnectionManagerValidationError{
			field:  "RouteSpecifier",
			reason: "value is required",
		}

	}

	switch m.StripPortMode.(type) {

	case *HttpConnectionManager_StripMatchingHostPort:
		// no validation rules for StripMatchingHostPort

	case *HttpConnectionManager_StripAnyHostPort:
		// no validation rules for StripAnyHostPort

	}

	return nil
}

// HttpConnectionManagerValidationError is the validation error returned by
// HttpConnectionManager.Validate if the designated constraints aren't met.
type HttpConnectionManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManagerValidationError) ErrorName() string {
	return "HttpConnectionManagerValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManagerValidationError{}

var _HttpConnectionManager_ServerName_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on LocalReplyConfig with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *LocalReplyConfig) Validate() error {
	if m == nil {
		return nil
	}

	for idx, item := range m.GetMappers() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LocalReplyConfigValidationError{
					field:  fmt.Sprintf("Mappers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetBodyFormat()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LocalReplyConfigValidationError{
				field:  "BodyFormat",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// LocalReplyConfigValidationError is the validation error returned by
// LocalReplyConfig.Validate if the designated constraints aren't met.
type LocalReplyConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocalReplyConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocalReplyConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocalReplyConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocalReplyConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocalReplyConfigValidationError) ErrorName() string { return "LocalReplyConfigValidationError" }

// Error satisfies the builtin error interface
func (e LocalReplyConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocalReplyConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocalReplyConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocalReplyConfigValidationError{}

// Validate checks the field values on ResponseMapper with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ResponseMapper) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetFilter() == nil {
		return ResponseMapperValidationError{
			field:  "Filter",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResponseMapperValidationError{
				field:  "Filter",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if wrapper := m.GetStatusCode(); wrapper != nil {

		if val := wrapper.GetValue(); val < 200 || val >= 600 {
			return ResponseMapperValidationError{
				field:  "StatusCode",
				reason: "value must be inside range [200, 600)",
			}
		}

	}

	if v, ok := interface{}(m.GetBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResponseMapperValidationError{
				field:  "Body",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetBodyFormatOverride()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResponseMapperValidationError{
				field:  "BodyFormatOverride",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetHeadersToAdd()) > 1000 {
		return ResponseMapperValidationError{
			field:  "HeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ResponseMapperValidationError{
					field:  fmt.Sprintf("HeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// ResponseMapperValidationError is the validation error returned by
// ResponseMapper.Validate if the designated constraints aren't met.
type ResponseMapperValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResponseMapperValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResponseMapperValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResponseMapperValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResponseMapperValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResponseMapperValidationError) ErrorName() string { return "ResponseMapperValidationError" }

// Error satisfies the builtin error interface
func (e ResponseMapperValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResponseMapper.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResponseMapperValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResponseMapperValidationError{}

// Validate checks the field values on Rds with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *Rds) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetConfigSource() == nil {
		return RdsValidationError{
			field:  "ConfigSource",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RdsValidationError{
				field:  "ConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RouteConfigName

	return nil
}

// RdsValidationError is the validation error returned by Rds.Validate if the
// designated constraints aren't met.
type RdsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RdsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RdsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RdsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RdsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RdsValidationError) ErrorName() string { return "RdsValidationError" }

// Error satisfies the builtin error interface
func (e RdsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRds.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RdsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RdsValidationError{}

// Validate checks the field values on ScopedRouteConfigurationsList with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ScopedRouteConfigurationsList) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetScopedRouteConfigurations()) < 1 {
		return ScopedRouteConfigurationsListValidationError{
			field:  "ScopedRouteConfigurations",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetScopedRouteConfigurations() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRouteConfigurationsListValidationError{
					field:  fmt.Sprintf("ScopedRouteConfigurations[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// ScopedRouteConfigurationsListValidationError is the validation error
// returned by ScopedRouteConfigurationsList.Validate if the designated
// constraints aren't met.
type ScopedRouteConfigurationsListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRouteConfigurationsListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRouteConfigurationsListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRouteConfigurationsListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRouteConfigurationsListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRouteConfigurationsListValidationError) ErrorName() string {
	return "ScopedRouteConfigurationsListValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRouteConfigurationsListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRouteConfigurationsList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRouteConfigurationsListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRouteConfigurationsListValidationError{}

// Validate checks the field values on ScopedRoutes with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ScopedRoutes) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetName()) < 1 {
		return ScopedRoutesValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
	}

	if m.GetScopeKeyBuilder() == nil {
		return ScopedRoutesValidationError{
			field:  "ScopeKeyBuilder",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetScopeKeyBuilder()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ScopedRoutesValidationError{
				field:  "ScopeKeyBuilder",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetRdsConfigSource() == nil {
		return ScopedRoutesValidationError{
			field:  "RdsConfigSource",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetRdsConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ScopedRoutesValidationError{
				field:  "RdsConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.ConfigSpecifier.(type) {

	case *ScopedRoutes_ScopedRouteConfigurationsList:

		if v, ok := interface{}(m.GetScopedRouteConfigurationsList()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutesValidationError{
					field:  "ScopedRouteConfigurationsList",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ScopedRoutes_ScopedRds:

		if v, ok := interface{}(m.GetScopedRds()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutesValidationError{
					field:  "ScopedRds",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return ScopedRoutesValidationError{
			field:  "ConfigSpecifier",
			reason: "value is required",
		}

	}

	return nil
}

// ScopedRoutesValidationError is the validation error returned by
// ScopedRoutes.Validate if the designated constraints aren't met.
type ScopedRoutesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRoutesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRoutesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRoutesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRoutesValidationError) ErrorName() string { return "ScopedRoutesValidationError" }

// Error satisfies the builtin error interface
func (e ScopedRoutesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutesValidationError{}

// Validate checks the field values on ScopedRds with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ScopedRds) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetScopedRdsConfigSource() == nil {
		return ScopedRdsValidationError{
			field:  "ScopedRdsConfigSource",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetScopedRdsConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ScopedRdsValidationError{
				field:  "ScopedRdsConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// ScopedRdsValidationError is the validation error returned by
// ScopedRds.Validate if the designated constraints aren't met.
type ScopedRdsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRdsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRdsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRdsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRdsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRdsValidationError) ErrorName() string { return "ScopedRdsValidationError" }

// Error satisfies the builtin error interface
func (e ScopedRdsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRds.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRdsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRdsValidationError{}

// Validate checks the field values on HttpFilter with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *HttpFilter) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetName()) < 1 {
		return HttpFilterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
	}

	// no validation rules for IsOptional

	switch m.ConfigType.(type) {

	case *HttpFilter_TypedConfig:

		if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpFilterValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HttpFilter_ConfigDiscovery:

		if v, ok := interface{}(m.GetConfigDiscovery()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpFilterValidationError{
					field:  "ConfigDiscovery",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// HttpFilterValidationError is the validation error returned by
// HttpFilter.Validate if the designated constraints aren't met.
type HttpFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpFilterValidationError) ErrorName() string { return "HttpFilterValidationError" }

// Error satisfies the builtin error interface
func (e HttpFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpFilterValidationError{}

// Validate checks the field values on RequestIDExtension with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RequestIDExtension) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RequestIDExtensionValidationError{
				field:  "TypedConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// RequestIDExtensionValidationError is the validation error returned by
// RequestIDExtension.Validate if the designated constraints aren't met.
type RequestIDExtensionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RequestIDExtensionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RequestIDExtensionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RequestIDExtensionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RequestIDExtensionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RequestIDExtensionValidationError) ErrorName() string {
	return "RequestIDExtensionValidationError"
}

// Error satisfies the builtin error interface
func (e RequestIDExtensionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRequestIDExtension.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RequestIDExtensionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RequestIDExtensionValidationError{}

// Validate checks the field values on HttpConnectionManager_Tracing with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *HttpConnectionManager_Tracing) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetClientSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "ClientSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRandomSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "RandomSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetOverallSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "OverallSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Verbose

	if v, ok := interface{}(m.GetMaxPathTagLength()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "MaxPathTagLength",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetCustomTags() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManager_TracingValidationError{
					field:  fmt.Sprintf("CustomTags[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_TracingValidationError{
				field:  "Provider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// HttpConnectionManager_TracingValidationError is the validation error
// returned by HttpConnectionManager_Tracing.Validate if the designated
// constraints aren't met.
type HttpConnectionManager_TracingValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_TracingValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManager_TracingValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManager_TracingValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManager_TracingValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_TracingValidationError) ErrorName() string {
	return "HttpConnectionManager_TracingValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_TracingValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_Tracing.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_TracingValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_TracingValidationError{}

// Validate checks the field values on
// HttpConnectionManager_InternalAddressConfig with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *HttpConnectionManager_InternalAddressConfig) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UnixSockets

	return nil
}

// HttpConnectionManager_InternalAddressConfigValidationError is the validation
// error returned by HttpConnectionManager_InternalAddressConfig.Validate if
// the designated constraints aren't met.
type HttpConnectionManager_InternalAddressConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManager_InternalAddressConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_InternalAddressConfigValidationError) ErrorName() string {
	return "HttpConnectionManager_InternalAddressConfigValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_InternalAddressConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_InternalAddressConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_InternalAddressConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_InternalAddressConfigValidationError{}

// Validate checks the field values on
// HttpConnectionManager_SetCurrentClientCertDetails with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *HttpConnectionManager_SetCurrentClientCertDetails) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetSubject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_SetCurrentClientCertDetailsValidationError{
				field:  "Subject",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Cert

	// no validation rules for Chain

	// no validation rules for Dns

	// no validation rules for Uri

	return nil
}

// HttpConnectionManager_SetCurrentClientCertDetailsValidationError is the
// validation error returned by
// HttpConnectionManager_SetCurrentClientCertDetails.Validate if the
// designated constraints aren't met.
type HttpConnectionManager_SetCurrentClientCertDetailsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) ErrorName() string {
	return "HttpConnectionManager_SetCurrentClientCertDetailsValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_SetCurrentClientCertDetailsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_SetCurrentClientCertDetails.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_SetCurrentClientCertDetailsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_SetCurrentClientCertDetailsValidationError{}

// Validate checks the field values on HttpConnectionManager_UpgradeConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *HttpConnectionManager_UpgradeConfig) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UpgradeType

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HttpConnectionManager_UpgradeConfigValidationError{
					field:  fmt.Sprintf("Filters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpConnectionManager_UpgradeConfigValidationError{
				field:  "Enabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// HttpConnectionManager_UpgradeConfigValidationError is the validation error
// returned by HttpConnectionManager_UpgradeConfig.Validate if the designated
// constraints aren't met.
type HttpConnectionManager_UpgradeConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpConnectionManager_UpgradeConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpConnectionManager_UpgradeConfigValidationError) ErrorName() string {
	return "HttpConnectionManager_UpgradeConfigValidationError"
}

// Error satisfies the builtin error interface
func (e HttpConnectionManager_UpgradeConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpConnectionManager_UpgradeConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpConnectionManager_UpgradeConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpConnectionManager_UpgradeConfigValidationError{}

// Validate checks the field values on ScopedRoutes_ScopeKeyBuilder with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ScopedRoutes_ScopeKeyBuilder) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetFragments()) < 1 {
		return ScopedRoutes_ScopeKeyBuilderValidationError{
			field:  "Fragments",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetFragments() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutes_ScopeKeyBuilderValidationError{
					field:  fmt.Sprintf("Fragments[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilderValidationError is the validation error returned
// by ScopedRoutes_ScopeKeyBuilder.Validate if the designated constraints
// aren't met.
type ScopedRoutes_ScopeKeyBuilderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilderValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilderValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilderValidationError{}

// Validate checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder) Validate() error {
	if m == nil {
		return nil
	}

	switch m.Type.(type) {

	case *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_:

		if v, ok := interface{}(m.GetHeaderValueExtractor()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
					field:  "HeaderValueExtractor",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{
			field:  "Type",
			reason: "value is required",
		}

	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError is the
// validation error returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder.Validate if the designated
// constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder_FragmentBuilder.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilder_FragmentBuilderValidationError{}

// Validate checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetName()) < 1 {
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
	}

	// no validation rules for ElementSeparator

	switch m.ExtractType.(type) {

	case *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Index:
		// no validation rules for Index

	case *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_Element:

		if v, ok := interface{}(m.GetElement()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{
					field:  "Element",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError
// is the validation error returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor.Validate
// if the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractorValidationError{}

// Validate checks the field values on
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement
// with the rules defined in the proto definition for this message. If any
// rules are violated, an error is returned.
func (m *ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetSeparator()) < 1 {
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{
			field:  "Separator",
			reason: "value length must be at least 1 runes",
		}
	}

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		return ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
	}

	return nil
}

// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError
// is the validation error returned by
// ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement.Validate
// if the designated constraints aren't met.
type ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Key() bool {
	return e.key
}

// ErrorName returns error name.
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) ErrorName() string {
	return "ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError"
}

// Error satisfies the builtin error interface
func (e ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElement.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScopedRoutes_ScopeKeyBuilder_FragmentBuilder_HeaderValueExtractor_KvElementValidationError{}
