#pragma once

struct ParseCase { const char *name; const char *callsign; bool valid; const char *normalized; const char *host; const char *hostDelim; const char *base; const char *basePrefix; const char *basePrefixNumber; const char *suffix; const char *suffixDelim; const char *wpx; };
static const ParseCase kParseCases[] = {
    {"Callsign empty", "", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC", "ABC", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC/1", "ABC/1", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC/P", "ABC/P", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign 1/ABC", "1/ABC", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign P/ABC", "P/ABC", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign #ABC", "#ABC", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC$", "ABC$", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC AB", "ABC AB", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign 12345", "12345", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign INVALID", "INVALID", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC@123.AA", "ABC@123.AA", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign ABC12AA", "ABC12AA", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign AB1234", "AB1234", false, "", "", "", "", "", "", "", "", ""},
    {"Callsign OK1ABC", "OK1ABC", true, "OK1ABC", "", "", "OK1ABC", "OK", "1", "", "", "OK1"},
    {"Callsign OK10ABC", "OK10ABC", true, "OK10ABC", "", "", "OK10ABC", "OK", "10", "", "", "OK10"},
    {"Callsign OK100ABC", "OK100ABC", true, "OK100ABC", "", "", "OK100ABC", "OK", "100", "", "", "OK100"},
    {"Callsign OK2ABC", "OK2ABC", true, "OK2ABC", "", "", "OK2ABC", "OK", "2", "", "", "OK2"},
    {"Callsign 9A1ABC", "9A1ABC", true, "9A1ABC", "", "", "9A1ABC", "9A", "1", "", "", "9A1"},
    {"Callsign 9A12ABC", "9A12ABC", true, "9A12ABC", "", "", "9A12ABC", "9A", "12", "", "", "9A12"},
    {"Callsign A12ABC", "A12ABC", true, "A12ABC", "", "", "A12ABC", "A1", "2", "", "", "A12"},
    {"Callsign OK1abc", "OK1abc", true, "OK1ABC", "", "", "OK1ABC", "OK", "1", "", "", "OK1"},
    {"Callsign ok10ABC", "ok10ABC", true, "OK10ABC", "", "", "OK10ABC", "OK", "10", "", "", "OK10"},
    {"Callsign ok100abc", "ok100abc", true, "OK100ABC", "", "", "OK100ABC", "OK", "100", "", "", "OK100"},
    {"Callsign oK2ABc", "oK2ABc", true, "OK2ABC", "", "", "OK2ABC", "OK", "2", "", "", "OK2"},
    {"Callsign 9a1ABC", "9a1ABC", true, "9A1ABC", "", "", "9A1ABC", "9A", "1", "", "", "9A1"},
    {"Callsign 9A12AbC", "9A12AbC", true, "9A12ABC", "", "", "9A12ABC", "9A", "12", "", "", "9A12"},
    {"Callsign A12ABc", "A12ABc", true, "A12ABC", "", "", "A12ABC", "A1", "2", "", "", "A12"},
    {"Callsign OK1ABC/P", "OK1ABC/P", true, "OK1ABC/P", "", "", "OK1ABC", "OK", "1", "P", "/P", "OK1"},
    {"Callsign OK1ABC/p", "OK1ABC/p", true, "OK1ABC/P", "", "", "OK1ABC", "OK", "1", "P", "/P", "OK1"},
    {"Callsign OK1aBC/p", "OK1aBC/p", true, "OK1ABC/P", "", "", "OK1ABC", "OK", "1", "P", "/P", "OK1"},
    {"Callsign OK10ABC/P", "OK10ABC/P", true, "OK10ABC/P", "", "", "OK10ABC", "OK", "10", "P", "/P", "OK10"},
    {"Callsign OK100ABC/P", "OK100ABC/P", true, "OK100ABC/P", "", "", "OK100ABC", "OK", "100", "P", "/P", "OK100"},
    {"Callsign OK2ABC/P", "OK2ABC/P", true, "OK2ABC/P", "", "", "OK2ABC", "OK", "2", "P", "/P", "OK2"},
    {"Callsign 9A1ABC/P", "9A1ABC/P", true, "9A1ABC/P", "", "", "9A1ABC", "9A", "1", "P", "/P", "9A1"},
    {"Callsign 9A12ABC/P", "9A12ABC/P", true, "9A12ABC/P", "", "", "9A12ABC", "9A", "12", "P", "/P", "9A12"},
    {"Callsign A12ABC/P", "A12ABC/P", true, "A12ABC/P", "", "", "A12ABC", "A1", "2", "P", "/P", "A12"},
    {"Callsign OK1ABC/A", "OK1ABC/A", true, "OK1ABC/A", "", "", "OK1ABC", "OK", "1", "A", "/A", "OK1"},
    {"Callsign OK1ABC/a", "OK1ABC/a", true, "OK1ABC/A", "", "", "OK1ABC", "OK", "1", "A", "/A", "OK1"},
    {"Callsign OK1aBC/a", "OK1aBC/a", true, "OK1ABC/A", "", "", "OK1ABC", "OK", "1", "A", "/A", "OK1"},
    {"Callsign OK10ABC/A", "OK10ABC/A", true, "OK10ABC/A", "", "", "OK10ABC", "OK", "10", "A", "/A", "OK10"},
    {"Callsign OK100ABC/A", "OK100ABC/A", true, "OK100ABC/A", "", "", "OK100ABC", "OK", "100", "A", "/A", "OK100"},
    {"Callsign OK2ABC/A", "OK2ABC/A", true, "OK2ABC/A", "", "", "OK2ABC", "OK", "2", "A", "/A", "OK2"},
    {"Callsign 9A1ABC/A", "9A1ABC/A", true, "9A1ABC/A", "", "", "9A1ABC", "9A", "1", "A", "/A", "9A1"},
    {"Callsign 9A12ABC/A", "9A12ABC/A", true, "9A12ABC/A", "", "", "9A12ABC", "9A", "12", "A", "/A", "9A12"},
    {"Callsign A12ABC/A", "A12ABC/A", true, "A12ABC/A", "", "", "A12ABC", "A1", "2", "A", "/A", "A12"},
    {"Callsign OK1ABC/AM", "OK1ABC/AM", true, "OK1ABC/AM", "", "", "OK1ABC", "OK", "1", "AM", "/AM", "OK1"},
    {"Callsign OK1ABC/AM", "OK1ABC/AM", true, "OK1ABC/AM", "", "", "OK1ABC", "OK", "1", "AM", "/AM", "OK1"},
    {"Callsign OK1aBC/AM", "OK1aBC/AM", true, "OK1ABC/AM", "", "", "OK1ABC", "OK", "1", "AM", "/AM", "OK1"},
    {"Callsign OK10ABC/AM", "OK10ABC/AM", true, "OK10ABC/AM", "", "", "OK10ABC", "OK", "10", "AM", "/AM", "OK10"},
    {"Callsign OK100ABC/AM", "OK100ABC/AM", true, "OK100ABC/AM", "", "", "OK100ABC", "OK", "100", "AM", "/AM", "OK100"},
    {"Callsign OK2ABC/AM", "OK2ABC/AM", true, "OK2ABC/AM", "", "", "OK2ABC", "OK", "2", "AM", "/AM", "OK2"},
    {"Callsign 9A1ABC/AM", "9A1ABC/AM", true, "9A1ABC/AM", "", "", "9A1ABC", "9A", "1", "AM", "/AM", "9A1"},
    {"Callsign 9A12ABC/AM", "9A12ABC/AM", true, "9A12ABC/AM", "", "", "9A12ABC", "9A", "12", "AM", "/AM", "9A12"},
    {"Callsign A12ABC/AM", "A12ABC/AM", true, "A12ABC/AM", "", "", "A12ABC", "A1", "2", "AM", "/AM", "A12"},
    {"Callsign OK1ABC/M", "OK1ABC/M", true, "OK1ABC/M", "", "", "OK1ABC", "OK", "1", "M", "/M", "OK1"},
    {"Callsign OK1ABC/M", "OK1ABC/M", true, "OK1ABC/M", "", "", "OK1ABC", "OK", "1", "M", "/M", "OK1"},
    {"Callsign OK1aBC/M", "OK1aBC/M", true, "OK1ABC/M", "", "", "OK1ABC", "OK", "1", "M", "/M", "OK1"},
    {"Callsign OK10ABC/M", "OK10ABC/M", true, "OK10ABC/M", "", "", "OK10ABC", "OK", "10", "M", "/M", "OK10"},
    {"Callsign OK100ABC/M", "OK100ABC/M", true, "OK100ABC/M", "", "", "OK100ABC", "OK", "100", "M", "/M", "OK100"},
    {"Callsign OK2ABC/M", "OK2ABC/M", true, "OK2ABC/M", "", "", "OK2ABC", "OK", "2", "M", "/M", "OK2"},
    {"Callsign 9A1ABC/M", "9A1ABC/M", true, "9A1ABC/M", "", "", "9A1ABC", "9A", "1", "M", "/M", "9A1"},
    {"Callsign 9A12ABC/M", "9A12ABC/M", true, "9A12ABC/M", "", "", "9A12ABC", "9A", "12", "M", "/M", "9A12"},
    {"Callsign A12ABC/M", "A12ABC/M", true, "A12ABC/M", "", "", "A12ABC", "A1", "2", "M", "/M", "A12"},
    {"Callsign OK1ABC/MM", "OK1ABC/MM", true, "OK1ABC/MM", "", "", "OK1ABC", "OK", "1", "MM", "/MM", "OK1"},
    {"Callsign OK1ABC/MM", "OK1ABC/MM", true, "OK1ABC/MM", "", "", "OK1ABC", "OK", "1", "MM", "/MM", "OK1"},
    {"Callsign OK1aBC/MM", "OK1aBC/MM", true, "OK1ABC/MM", "", "", "OK1ABC", "OK", "1", "MM", "/MM", "OK1"},
    {"Callsign OK10ABC/MM", "OK10ABC/MM", true, "OK10ABC/MM", "", "", "OK10ABC", "OK", "10", "MM", "/MM", "OK10"},
    {"Callsign OK100ABC/MM", "OK100ABC/MM", true, "OK100ABC/MM", "", "", "OK100ABC", "OK", "100", "MM", "/MM", "OK100"},
    {"Callsign OK2ABC/MM", "OK2ABC/MM", true, "OK2ABC/MM", "", "", "OK2ABC", "OK", "2", "MM", "/MM", "OK2"},
    {"Callsign 9A1ABC/MM", "9A1ABC/MM", true, "9A1ABC/MM", "", "", "9A1ABC", "9A", "1", "MM", "/MM", "9A1"},
    {"Callsign 9A12ABC/MM", "9A12ABC/MM", true, "9A12ABC/MM", "", "", "9A12ABC", "9A", "12", "MM", "/MM", "9A12"},
    {"Callsign A12ABC/MM", "A12ABC/MM", true, "A12ABC/MM", "", "", "A12ABC", "A1", "2", "MM", "/MM", "A12"},
    {"Callsign OK1ABC/P", "OK1ABC/P", true, "OK1ABC/P", "", "", "OK1ABC", "OK", "1", "P", "/P", "OK1"},
    {"Callsign OK1ABC/P", "OK1ABC/P", true, "OK1ABC/P", "", "", "OK1ABC", "OK", "1", "P", "/P", "OK1"},
    {"Callsign OK1aBC/P", "OK1aBC/P", true, "OK1ABC/P", "", "", "OK1ABC", "OK", "1", "P", "/P", "OK1"},
    {"Callsign OK10ABC/P", "OK10ABC/P", true, "OK10ABC/P", "", "", "OK10ABC", "OK", "10", "P", "/P", "OK10"},
    {"Callsign OK100ABC/P", "OK100ABC/P", true, "OK100ABC/P", "", "", "OK100ABC", "OK", "100", "P", "/P", "OK100"},
    {"Callsign OK2ABC/P", "OK2ABC/P", true, "OK2ABC/P", "", "", "OK2ABC", "OK", "2", "P", "/P", "OK2"},
    {"Callsign 9A1ABC/P", "9A1ABC/P", true, "9A1ABC/P", "", "", "9A1ABC", "9A", "1", "P", "/P", "9A1"},
    {"Callsign 9A12ABC/P", "9A12ABC/P", true, "9A12ABC/P", "", "", "9A12ABC", "9A", "12", "P", "/P", "9A12"},
    {"Callsign A12ABC/P", "A12ABC/P", true, "A12ABC/P", "", "", "A12ABC", "A1", "2", "P", "/P", "A12"},
    {"Callsign OK1ABC/QRP", "OK1ABC/QRP", true, "OK1ABC/QRP", "", "", "OK1ABC", "OK", "1", "QRP", "/QRP", "OK1"},
    {"Callsign OK1ABC/QRP", "OK1ABC/QRP", true, "OK1ABC/QRP", "", "", "OK1ABC", "OK", "1", "QRP", "/QRP", "OK1"},
    {"Callsign OK1aBC/QRP", "OK1aBC/QRP", true, "OK1ABC/QRP", "", "", "OK1ABC", "OK", "1", "QRP", "/QRP", "OK1"},
    {"Callsign OK10ABC/QRP", "OK10ABC/QRP", true, "OK10ABC/QRP", "", "", "OK10ABC", "OK", "10", "QRP", "/QRP", "OK10"},
    {"Callsign OK100ABC/QRP", "OK100ABC/QRP", true, "OK100ABC/QRP", "", "", "OK100ABC", "OK", "100", "QRP", "/QRP", "OK100"},
    {"Callsign OK2ABC/QRP", "OK2ABC/QRP", true, "OK2ABC/QRP", "", "", "OK2ABC", "OK", "2", "QRP", "/QRP", "OK2"},
    {"Callsign 9A1ABC/QRP", "9A1ABC/QRP", true, "9A1ABC/QRP", "", "", "9A1ABC", "9A", "1", "QRP", "/QRP", "9A1"},
    {"Callsign 9A12ABC/QRP", "9A12ABC/QRP", true, "9A12ABC/QRP", "", "", "9A12ABC", "9A", "12", "QRP", "/QRP", "9A12"},
    {"Callsign A12ABC/QRP", "A12ABC/QRP", true, "A12ABC/QRP", "", "", "A12ABC", "A1", "2", "QRP", "/QRP", "A12"},
    {"Callsign OK1ABC/R", "OK1ABC/R", true, "OK1ABC/R", "", "", "OK1ABC", "OK", "1", "R", "/R", "OK1"},
    {"Callsign OK1ABC/R", "OK1ABC/R", true, "OK1ABC/R", "", "", "OK1ABC", "OK", "1", "R", "/R", "OK1"},
    {"Callsign OK1aBC/R", "OK1aBC/R", true, "OK1ABC/R", "", "", "OK1ABC", "OK", "1", "R", "/R", "OK1"},
    {"Callsign OK10ABC/R", "OK10ABC/R", true, "OK10ABC/R", "", "", "OK10ABC", "OK", "10", "R", "/R", "OK10"},
    {"Callsign OK100ABC/R", "OK100ABC/R", true, "OK100ABC/R", "", "", "OK100ABC", "OK", "100", "R", "/R", "OK100"},
    {"Callsign OK2ABC/R", "OK2ABC/R", true, "OK2ABC/R", "", "", "OK2ABC", "OK", "2", "R", "/R", "OK2"},
    {"Callsign 9A1ABC/R", "9A1ABC/R", true, "9A1ABC/R", "", "", "9A1ABC", "9A", "1", "R", "/R", "9A1"},
    {"Callsign 9A12ABC/R", "9A12ABC/R", true, "9A12ABC/R", "", "", "9A12ABC", "9A", "12", "R", "/R", "9A12"},
    {"Callsign A12ABC/R", "A12ABC/R", true, "A12ABC/R", "", "", "A12ABC", "A1", "2", "R", "/R", "A12"},
    {"Callsign OK1ABC/B", "OK1ABC/B", true, "OK1ABC/B", "", "", "OK1ABC", "OK", "1", "B", "/B", "OK1"},
    {"Callsign OK1ABC/B", "OK1ABC/B", true, "OK1ABC/B", "", "", "OK1ABC", "OK", "1", "B", "/B", "OK1"},
    {"Callsign OK1aBC/B", "OK1aBC/B", true, "OK1ABC/B", "", "", "OK1ABC", "OK", "1", "B", "/B", "OK1"},
    {"Callsign OK10ABC/B", "OK10ABC/B", true, "OK10ABC/B", "", "", "OK10ABC", "OK", "10", "B", "/B", "OK10"},
    {"Callsign OK100ABC/B", "OK100ABC/B", true, "OK100ABC/B", "", "", "OK100ABC", "OK", "100", "B", "/B", "OK100"},
    {"Callsign OK2ABC/B", "OK2ABC/B", true, "OK2ABC/B", "", "", "OK2ABC", "OK", "2", "B", "/B", "OK2"},
    {"Callsign 9A1ABC/B", "9A1ABC/B", true, "9A1ABC/B", "", "", "9A1ABC", "9A", "1", "B", "/B", "9A1"},
    {"Callsign 9A12ABC/B", "9A12ABC/B", true, "9A12ABC/B", "", "", "9A12ABC", "9A", "12", "B", "/B", "9A12"},
    {"Callsign A12ABC/B", "A12ABC/B", true, "A12ABC/B", "", "", "A12ABC", "A1", "2", "B", "/B", "A12"},
    {"Callsign OK1ABC/LGT", "OK1ABC/LGT", true, "OK1ABC/LGT", "", "", "OK1ABC", "OK", "1", "LGT", "/LGT", "OK1"},
    {"Callsign OK1ABC/LGT", "OK1ABC/LGT", true, "OK1ABC/LGT", "", "", "OK1ABC", "OK", "1", "LGT", "/LGT", "OK1"},
    {"Callsign OK1aBC/LGT", "OK1aBC/LGT", true, "OK1ABC/LGT", "", "", "OK1ABC", "OK", "1", "LGT", "/LGT", "OK1"},
    {"Callsign OK10ABC/LGT", "OK10ABC/LGT", true, "OK10ABC/LGT", "", "", "OK10ABC", "OK", "10", "LGT", "/LGT", "OK10"},
    {"Callsign OK100ABC/LGT", "OK100ABC/LGT", true, "OK100ABC/LGT", "", "", "OK100ABC", "OK", "100", "LGT", "/LGT", "OK100"},
    {"Callsign OK2ABC/LGT", "OK2ABC/LGT", true, "OK2ABC/LGT", "", "", "OK2ABC", "OK", "2", "LGT", "/LGT", "OK2"},
    {"Callsign 9A1ABC/LGT", "9A1ABC/LGT", true, "9A1ABC/LGT", "", "", "9A1ABC", "9A", "1", "LGT", "/LGT", "9A1"},
    {"Callsign 9A12ABC/LGT", "9A12ABC/LGT", true, "9A12ABC/LGT", "", "", "9A12ABC", "9A", "12", "LGT", "/LGT", "9A12"},
    {"Callsign A12ABC/LGT", "A12ABC/LGT", true, "A12ABC/LGT", "", "", "A12ABC", "A1", "2", "LGT", "/LGT", "A12"},
    {"Callsign OK1ABC/E", "OK1ABC/E", true, "OK1ABC/E", "", "", "OK1ABC", "OK", "1", "E", "/E", "OK1"},
    {"Callsign OK1ABC-1", "OK1ABC-1", true, "OK1ABC-1", "", "", "OK1ABC", "OK", "1", "", "", "OK1"},
    {"Callsign OE/OK1ABC", "OE/OK1ABC", true, "OE/OK1ABC", "OE", "OE/", "OK1ABC", "OK", "1", "", "", "OE0"},
    {"Callsign Oe/OK1ABC", "Oe/OK1ABC", true, "OE/OK1ABC", "OE", "OE/", "OK1ABC", "OK", "1", "", "", "OE0"},
    {"Callsign SP1/OK1ABC", "SP1/OK1ABC", true, "SP1/OK1ABC", "SP1", "SP1/", "OK1ABC", "OK", "1", "", "", "SP1"},
    {"Callsign OE/OK1ABC/M", "OE/OK1ABC/M", true, "OE/OK1ABC/M", "OE", "OE/", "OK1ABC", "OK", "1", "M", "/M", "OE0"},
    {"Callsign OE/OK1ABC/MM", "OE/OK1ABC/MM", true, "OE/OK1ABC/MM", "OE", "OE/", "OK1ABC", "OK", "1", "MM", "/MM", "OE0"},
    {"Callsign OE/OK1ABC/AM", "OE/OK1ABC/AM", true, "OE/OK1ABC/AM", "OE", "OE/", "OK1ABC", "OK", "1", "AM", "/AM", "OE0"},
    {"Callsign OE/OK1ABC/qrp", "OE/OK1ABC/qrp", true, "OE/OK1ABC/QRP", "OE", "OE/", "OK1ABC", "OK", "1", "QRP", "/QRP", "OE0"},
    {"Callsign KH6XX/W0", "KH6XX/W0", true, "KH6XX/W0", "", "", "KH6XX", "KH", "6", "W0", "/W0", "W0"},
    {"Callsign VE7ABC/2", "VE7ABC/2", true, "VE7ABC/2", "", "", "VE7ABC", "VE", "7", "2", "/2", "VE2"},
};

struct WPXCase { const char *name; const char *callsign; const char *wpx; };
static const WPXCase kWPXCases[] = {
    {"Callsign OK1AA", "OK1AA", "OK1"},
    {"Callsign OK2AA", "OK2AA", "OK2"},
    {"Callsign OL80ABC", "OL80ABC", "OL80"},
    {"Callsign 9A1AA", "9A1AA", "9A1"},
    {"Callsign 9A10AA", "9A10AA", "9A10"},
    {"Callsign SP/OK1AA", "SP/OK1AA", "SP0"},
    {"Callsign SP1/OK1AA", "SP1/OK1AA", "SP1"},
    {"Callsign SP1/OK1AA/P", "SP1/OK1AA/P", "SP1"},
    {"Callsign SP1/OK1AA/M", "SP1/OK1AA/M", "SP1"},
    {"Callsign A1/OK1AA", "A1/OK1AA", "A1"},
    {"Callsign VE7aBC/2", "VE7aBC/2", "VE2"},
    {"Callsign OK1AA/P", "OK1AA/P", "OK1"},
    {"Callsign OK1AA/E", "OK1AA/E", "OK1"},
    {"Callsign OK1AA/AM", "OK1AA/AM", "OK1"},
    {"Callsign OK1AA/QRP", "OK1AA/QRP", "OK1"},
    {"Callsign N8ABC/KH9", "N8ABC/KH9", "KH9"},
    {"Callsign OK1AA/22", "OK1AA/22", "OK1"},
    {"Callsign OK1AA-22", "OK1AA-22", "OK1"},
    {"Callsign OK1AA/KH", "OK1AA/KH", "KH0"},
};
