/** VSys:$iflist.h:0.0.3-019$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: iflist.h; File version: 0.0.3-019
 */
#ifndef __IFLIST_H__
#define __IFLIST_H__

#ifdef WIN32
#include <winsock2.h>
#else
#include <sys/types.h>
#include <sys/socket.h>

#ifdef __OS_LINUX_LIKE
#include <net/if.h>
#else
#include <net/if.h>
#endif

#endif
#include <pthread.h>
#include "handlers.h"


// Constant for bad ifindex
#define      IFI_BAD      ((u_int16_t) 0xffff)
#define      IFI_IP_BAD   0x0
#define      IFI_IP_FATAL 0xffffffff

#ifdef __OS_BSD_LIKE
/*
 * Structure for storing names after sysctl call 
 */

struct if_name {
	char ifn_name[IFN_SIZE];
};

#endif

/*
 * ifl_ family routines are for operating with global
 * list of supported/processing ifaces
 *
 * ifi_ family is for IOCTL related feautures - such
 * as retrieving ifindex of device
 */

iff_list *   ifl_family  ( const char * );
 if_list *   ifl_iface   ( const char * );
int          ifl_remove  ( const char * );
 if_list *   ifl_add     ( const char * );
 
void         ifl_halt    ();
#ifdef  TRAP_SIGSEGV
void         ifl_panic   ();
#endif//TRAP_SIGSEGV
int          ifi_update  ();

u_int16_t    ifi_index   ( const char * );
u_int32_t    ifi_ipv4    ( const char * );
int          ifi_up      ( const char * );
int          ifi_ifvalid ( const char * );
int          ifi_valid   ();
int          ifi_count   ( void **  user = 0 );
void *       ifi_list    ( const int _ls = 1 );
//ifconf *     ifi_list    ();

extern int   ifi_ios;   // Socket for device ioctl calls
extern int   ifl_dump;  // Flag for imidiate dump

#endif//__IFLIST_H__
