/** VSys:$nf.c:0.0.3-014$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: nf.c; File version: 0.0.3-014
 */
#include <string.h>

#ifdef WIN32
#include <winsock2.h>
#include "win32/types.h"
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

//#include <arpa/inet.h>

#include "nf.h"
#include "config.h"

#include "debug.h"

/*
 * nf_valid checks if NFlow may be continued
 * Only two of three Cisco criterias are used:
 *  a) TCP FIN packet was seen
 *  b) NF lifetime is grater the half an hour
 * Idle time check is not implemented'
 *
 * If nf is valid - 1 is returnd.
 * Otherwise - 0
 */


int nf_valid( const nf5_stat * nf ) {
	if( !nf ) return 0;
#ifdef __TS_DEBUG__
//	printf( "Flags %o\n", nf->tcp_flags );
#endif//__TS_DEBUG__
	if( (nf->tcp_flags & TCP_FIN) ) return 0;
#ifdef __TS_DEBUG__
	printf( "L:%d\n", nf->ts_last - nf->ts_first );
#endif//__TS_DEBUG__
	if( ((int32_t) (nf->ts_last - nf->ts_first)) > cfg.nf_lifetime ) return 0;
	return 1;
}

/*
 * nf_valid_ts 
 *        Addon to nf_valid.
 *        Timestamp is supplied. Check of idle time is implemented.
 */

int nf_valid_ts( const nf5_stat * nf, u_int32_t ts ) {
#ifdef __TS_DEBUG__
	printf( "I:%d>", ts - nf->ts_last );
#endif//__TS_DEBUG__
	if( ((int32_t) (ts - nf->ts_last)) > NF_IDLETIME ) return 0;
	return nf_valid( nf );
}

int nf_queue( const nf5_stat * nf, nf5_msg * msg ) {
	if( !nf ) return 0;
#ifdef __VERBOSE__
	print_nf( nf );
#endif//__VERBISE__
	if( !msg ) {
		nf_send( nf );
		return 1;
	}
	if( msg->header.count == V5MSG_SIZE ) {
		nfm_send( msg );
		msg->header.count = 0;
	}
	nf5_stat *ptr = msg->records + msg->header.count;
	memcpy( ptr, nf, sizeof( nf5_stat ));
	nf_prepare( ptr );
	return (msg->header.count++);
}

void nf_send( const nf5_stat * nf ) {
#ifdef __VERBOSE__
	print_nf( nf );
#endif//__VERBISE__
//	DEB( fputc( '.', stdout ));
	nf5_msg *msg = ( nf5_msg * ) new  char[sizeof(nf5_stat) + sizeof(nf5_hdr)];
	memset( msg, 0, sizeof( nf5_hdr ));
	memcpy( (char *) msg->records, (const char *) nf, sizeof( nf5_stat ) );
	msg->header.version = htons( 5 );
	msg->header.count = htons( 1 );
	nf_prepare( msg->records );
	nfm_send( msg );
	delete msg;
	
}

void nfm_send( nf5_msg * msg ) {
//	static sockaddr_in sa = { AF_INET, htons( 9996 ), { htonl( 0x7F000001 ) }, {0} };
//	static int s, flag = 0;
	if( !msg ) return;
	if( !msg->header.count ) return;
/*	if( !flag ) {
		s = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
		if( s > 0 ) flag = 1;
	}*/
	nfm_prepare( msg );
	/*
	DEB(printf("MSG: to %x:%d\n", 
				ntohl(cfg.sa_in.sin_addr.s_addr), htons(cfg.sa_in.sin_port )));
	DEB(printf("MSG: %x family, %d size\n", cfg.sa.sa.sa_family, cfg.sas ));
	DEB(printf("MSG: %d size\n", (sizeof(nf5_stat)*msg->header.count+sizeof(nf5_hdr))));
	DEB(printf("MSG: %d nf5, %d count, %d hdr\n", sizeof(nf5_stat), msg->header.count, sizeof(nf5_hdr)));
	*/
	if( sendto( cfg.sock,msg,(sizeof(nf5_stat)*ntohs(msg->header.count)+sizeof(nf5_hdr)), 0, &cfg.sa.sa, cfg.sas) < 0 )
		DEB(_verror( "nfm_send" ));
	 
}

void nf_prepare( nf5_stat * nf ) {
	nf->iface    = htons( nf->iface );
	nf->d_pkt    = htonl( nf->d_pkt );
	nf->d_oct    = htonl( nf->d_oct );
	nf->ts_first = htonl( nf->ts_first );
	nf->ts_last  = htonl( nf->ts_last  );
}

void nfm_prepare( nf5_msg * nfm ) {
	nfm->header.seq     = htonl( ntohl(nfm->header.seq) + nfm->header.count );
	nfm->header.count   = htons( nfm->header.count );
	nfm->header.version = htons( NF5_VER );
}

#ifndef __HASH_MACRO__
int nf_hash( const nf5_stat * nf ) {
	return ( nf->daddr ^ nf->saddr ^ nf->sport ^ nf->dport );
}
#endif//__HASH_MACRO__
