searchData={"items":[{"type":"module","doc":"Main API of the Event Trace (ET) application\n\nInterface module for the Event Trace (ET) application","title":"et","ref":"et.html"},{"type":"type","doc":"","title":"et.actor/0","ref":"et.html#t:actor/0"},{"type":"type","doc":"","title":"et.level/0","ref":"et.html#t:level/0"},{"type":"function","doc":"","title":"et.phone_home/4","ref":"et.html#phone_home/4"},{"type":"function","doc":"These functions sends a signal to the outer space and the caller hopes that\nsomeone is listening. In other words, they invoke `et:trace_me/4` and\n`et:trace_me/5` respectively.","title":"et.phone_home/5","ref":"et.html#phone_home/5"},{"type":"function","doc":"","title":"et.report_event/4","ref":"et.html#report_event/4"},{"type":"function","doc":"Deprecated functions which for the time being are kept for backwards\ncompatibility. Invokes `et:trace_me/4` and `et:trace_me/5` respectively.","title":"et.report_event/5","ref":"et.html#report_event/5"},{"type":"function","doc":"Invokes `et:trace_me/5` with both `From` and `To` set to `FromTo`.","title":"et.trace_me/4","ref":"et.html#trace_me/4"},{"type":"function","doc":"A function that is intended to be traced.\n\nThis function is intended to be invoked at strategic places in user applications\nin order to enable simplified tracing. The functions are extremely light weight\nas they do nothing besides returning an atom. The functions are designed for\nbeing traced. The global tracing mechanism in `et_collector` defaults to set its\ntrace pattern to these functions.\n\nThe label is intended to provide a brief summary of the event. It is preferred\nto use an atom but a string would also do.\n\nThe contents can be any term but in order to simplify post processing of the\ntraced events, a plain list of \\{Key, Value\\} tuples is preferred.\n\nSome events, such as messages, are directed from some actor to another. Other\nevents (termed actions) may be undirected and only have one actor.","title":"et.trace_me/5","ref":"et.html#trace_me/5"},{"type":"module","doc":"Collect trace events and provide a backing storage appropriate for iteration\n\nInterface module for the Event Trace (ET) application","title":"et_collector","ref":"et_collector.html"},{"type":"type","doc":"","title":"et_collector.actor/0","ref":"et_collector.html#t:actor/0"},{"type":"function","doc":"Change active trace pattern globally on all trace nodes.","title":"et_collector.change_pattern/2","ref":"et_collector.html#change_pattern/2"},{"type":"function","doc":"Clear the event table.","title":"et_collector.clear_table/1","ref":"et_collector.html#clear_table/1"},{"type":"type","doc":"","title":"et_collector.collector_fun/0","ref":"et_collector.html#t:collector_fun/0"},{"type":"type","doc":"","title":"et_collector.dbg_match_spec/0","ref":"et_collector.html#t:dbg_match_spec/0"},{"type":"type","doc":"","title":"et_collector.dbg_trace_parameters/0","ref":"et_collector.html#t:dbg_trace_parameters/0"},{"type":"type","doc":"","title":"et_collector.dbg_trace_type/0","ref":"et_collector.html#t:dbg_trace_type/0"},{"type":"function","doc":"Delete a dictionary entry and send a \\{et, \\{dict_delete, Key\\}\\} tuple to all\nregistered subscribers.\n\nIf the deleted entry is a registered subscriber, it will imply that the\nsubscriber process gets is unregistered as subscriber as well as it gets it\nfinal message.","title":"et_collector.dict_delete/2","ref":"et_collector.html#dict_delete/2"},{"type":"function","doc":"Insert a dictionary entry and send a `{et, {dict_insert, Key, Val}}` tuple to\nall registered subscribers.\n\nIf the entry is a new subscriber, it will imply that the new subscriber process\nfirst will get one message for each already stored dictionary entry, before it\nand all old subscribers will get this particular entry. The collector process\nlinks to and then supervises the subscriber process. If the subscriber process\ndies it will imply that it gets unregistered as with a normal dict_delete/2.","title":"et_collector.dict_insert/3","ref":"et_collector.html#dict_insert/3"},{"type":"function","doc":"Lookup a dictionary entry and return zero or one value.","title":"et_collector.dict_lookup/2","ref":"et_collector.html#dict_lookup/2"},{"type":"function","doc":"Match some dictionary entries","title":"et_collector.dict_match/2","ref":"et_collector.html#dict_match/2"},{"type":"type","doc":"","title":"et_collector.ets_match_object_pattern/0","ref":"et_collector.html#t:ets_match_object_pattern/0"},{"type":"type","doc":"","title":"et_collector.event/0","ref":"et_collector.html#t:event/0"},{"type":"type","doc":"","title":"et_collector.event_filter_fun/0","ref":"et_collector.html#t:event_filter_fun/0"},{"type":"type","doc":"","title":"et_collector.event_ts/0","ref":"et_collector.html#t:event_ts/0"},{"type":"function","doc":"Return a the identity of the globally registered collector if there is any.","title":"et_collector.get_global_pid/0","ref":"et_collector.html#get_global_pid/0"},{"type":"function","doc":"","title":"et_collector.iterate/3","ref":"et_collector.html#iterate/3"},{"type":"function","doc":"Iterate over the currently stored events.\n\nIterates over the currently stored events and applies a function for each event.\nThe iteration may be performed forwards or backwards and may be limited to a\nmaximum number of events (abs(Limit)).","title":"et_collector.iterate/5","ref":"et_collector.html#iterate/5"},{"type":"type","doc":"","title":"et_collector.level/0","ref":"et_collector.html#t:level/0"},{"type":"function","doc":"Make a key out of an event record or an old key.","title":"et_collector.make_key/2","ref":"et_collector.html#make_key/2"},{"type":"function","doc":"Sends a message to all registered subscribers.","title":"et_collector.multicast/2","ref":"et_collector.html#multicast/2"},{"type":"type","doc":"","title":"et_collector.option/0","ref":"et_collector.html#t:option/0"},{"type":"function","doc":"","title":"et_collector.report/2","ref":"et_collector.html#report/2"},{"type":"function","doc":"","title":"et_collector.report_event/5","ref":"et_collector.html#report_event/5"},{"type":"function","doc":"Report an event to the collector.\n\nAll events are filtered thru the collector filter, which optionally may\ntransform or discard the event. The first call should use the pid of the\ncollector process as report handle, while subsequent calls should use the table\nhandle.","title":"et_collector.report_event/6","ref":"et_collector.html#report_event/6"},{"type":"function","doc":"Save the events to a file.\n\nBy default the currently stored events (existing) are written to a brand new\nfile (write) and the events are kept (keep) after they have been written to the\nfile.\n\nInstead of keeping the events after writing them to file, it is possible to\nremove all stored events after they have successfully written to file (clear).\n\nThe options defaults to existing, write and keep.","title":"et_collector.save_event_file/3","ref":"et_collector.html#save_event_file/3"},{"type":"function","doc":"Start a collector process.\n\nThe collector collects trace events and keeps them ordered by their timestamp.\nThe timestamp may either reflect the time when the actual trace data was\ngenerated (trace_ts) or when the trace data was transformed into an event record\n(event_ts). If the time stamp is missing in the trace data (missing timestamp\noption to erlang:trace/4) the trace_ts will be set to the event_ts.\n\nEvents are reported to the collector directly with the report function or\nindirectly via one or more trace clients. All reported events are first filtered\nthru the collector filter before they are stored by the collector. By replacing\nthe default collector filter with a customized dito it is possible to allow any\ntrace data as input. The collector filter is a dictionary entry with the\npredefined key \\{filter, collector\\} and the value is a fun of arity 1. See\net_selector:make_event/1 for interface details, such as which erlang:trace/1\ntuples that are accepted.\n\nThe collector has a built-in dictionary service. Any term may be stored as value\nin the dictionary and bound to a unique key. When new values are inserted with\nan existing key, the new values will overwrite the existing ones. Processes may\nsubscribe on dictionary updates by using \\{subscriber, pid()\\} as dictionary\nkey. All dictionary updates will be propagated to the subscriber processes\nmatching the pattern \\{\\{subscriber, '_'\\}, '_'\\} where the first '\\_' is\ninterpreted as a pid().\n\nIn global trace mode, the collector will automatically start tracing on all\nconnected Erlang nodes. When a node connects, a port tracer will be started on\nthat node and a corresponding trace client on the collector node.\n\nDefault values:\n\n- parent_pid - self().\n- event_order - trace_ts.\n- trace_global - false.\n- trace_pattern - undefined.\n- trace_port - 4711.\n- trace_max_queue - 50.","title":"et_collector.start_link/1","ref":"et_collector.html#start_link/1"},{"type":"function","doc":"Load raw Erlang trace from a file, port or process.","title":"et_collector.start_trace_client/3","ref":"et_collector.html#start_trace_client/3"},{"type":"function","doc":"Stop a collector process.","title":"et_collector.stop/1","ref":"et_collector.html#stop/1"},{"type":"type","doc":"","title":"et_collector.table_handle/0","ref":"et_collector.html#t:table_handle/0"},{"type":"type","doc":"","title":"et_collector.trace_filter_fun/0","ref":"et_collector.html#t:trace_filter_fun/0"},{"type":"type","doc":"","title":"et_collector.trace_ts/0","ref":"et_collector.html#t:trace_ts/0"},{"type":"module","doc":"Define event transforms and trace patterns","title":"et_selector","ref":"et_selector.html"},{"type":"function","doc":"Activates/deactivates tracing by changing the current trace pattern.\n\n`min` detail level deactivates tracing of calls to `et:trace_me/4,5`\n\n`max` detail level activates tracing of all calls to `et:trace_me/4,5`\n\n`integer(X)` detail level activates tracing of all calls to `et:trace_me/4,5`\nwhose detail level argument is lesser than `X`.\n\nAn empty match spec deactivates tracing of calls to `et:trace_me/4,5`\n\nOther match specs activates tracing of calls to `et:trace_me/4,5` accordingly\nwith `erlang:trace_pattern/2`.","title":"et_selector.change_pattern/1","ref":"et_selector.html#change_pattern/1"},{"type":"type","doc":"","title":"et_selector.event/0","ref":"et_selector.html#t:event/0"},{"type":"type","doc":"","title":"et_selector.level/0","ref":"et_selector.html#t:level/0"},{"type":"function","doc":"Makes a trace pattern suitable to feed change_pattern/1\n\nMin detail level deactivates tracing of calls to `et:trace_me/4,5`\n\nMax detail level activates tracing of all calls to `et:trace_me/4,5`\n\ninteger(X) detail level activates tracing of all calls to `et:trace_me/4,5`\nwhose detail level argument is lesser than X.\n\nSee also `erlang:trace_pattern/2` for more info about its `match_spec()`","title":"et_selector.make_pattern/1","ref":"et_selector.html#make_pattern/1"},{"type":"function","doc":"Transforms trace data and makes an event record out of it.\n\nSee `erlang:trace/3` for more info about the semantics of the trace data.\n\nAn event record consists of the following fields:\n\n- **_detail_level_** - Noise has a high level as opposed to essentials.\n\n- **_trace_ts_** - Time when the trace was generated. Same as event_ts if\n  omitted in trace data.\n\n- **_event_ts_** - Time when the event record was created.\n\n- **_from_** - From actor, such as sender of a message.\n\n- **_to_** - To actor, such as receiver of message.\n\n- **_label_** - Label intended to provide a brief event summary.\n\n- **_contents_** - All nitty gritty details of the event.\n\nSee `et:trace_me/4`and `et:trace_me/5` for details.\n\nReturns:\n\n- **_\\{true, Event\\}_** - where Event is an #event\\{\\} record representing the\n  trace data\n\n- **_true_** - means that the trace data already is an event record and that it\n  is valid as it is. No transformation is needed.\n\n- **_false_** - means that the trace data is uninteresting and should be dropped","title":"et_selector.parse_event/2","ref":"et_selector.html#parse_event/2"},{"type":"module","doc":"Displays a sequence chart for trace events (messages/actions)","title":"et_viewer","ref":"et_viewer.html"},{"type":"type","doc":"","title":"et_viewer.actors/0","ref":"et_viewer.html#t:actors/0"},{"type":"function","doc":"Start a new event viewer and a corresponding collector and load them with trace\nevents from a trace file.","title":"et_viewer.file/1","ref":"et_viewer.html#file/1"},{"type":"type","doc":"","title":"et_viewer.first_key/0","ref":"et_viewer.html#t:first_key/0"},{"type":"function","doc":"Returns the identifier of the collector process.","title":"et_viewer.get_collector_pid/1","ref":"et_viewer.html#get_collector_pid/1"},{"type":"type","doc":"","title":"et_viewer.option/0","ref":"et_viewer.html#t:option/0"},{"type":"function","doc":"Simplified start of a sequence chart viewer with global tracing activated.\n\nConvenient to be used from the command line (erl -s et_viewer).","title":"et_viewer.start/0","ref":"et_viewer.html#start/0"},{"type":"function","doc":"Start of a sequence chart viewer without linking to the parent process.","title":"et_viewer.start/1","ref":"et_viewer.html#start/1"},{"type":"function","doc":"Start a sequence chart viewer for trace events (messages/actions)\n\nA filter_fun() takes an event record as sole argument and returns\n`false | true | {true, NewEvent}`.\n\nIf the `collector_pid` is `undefined` a new `et_collector` will be started with\nthe following parameter settings: `parent_pid`, `event_order`, `trace_global`,\n`trace_pattern`, `trace_port`, `trace_max_queue`, `trace_client`, `dict_insert`\nand `dict_delete`. The new `et_viewer` will register itself as an `et_collector`\nsubscriber.\n\nDefault values:\n\n- parent_pid - self().\n- title - \"et_viewer\".\n- detail_level - max.\n- is_suspended - false.\n- scale - 2.\n- width - 800.\n- height - 600.\n- collector_pid - undefined.\n- event_order - trace_ts.\n- active_filter - collector.\n- max_actors - 5.\n- actors - \\[\"UNKNOWN\"].\n- first_event - first.\n- hide_unknown - false.\n- hide_actions - false.\n- display_mode - all.","title":"et_viewer.start_link/1","ref":"et_viewer.html#start_link/1"},{"type":"function","doc":"Stops a viewer process.","title":"et_viewer.stop/1","ref":"et_viewer.html#stop/1"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Event Tracer (ET) Release Notes\n\nThis document describes the changes made to the `Event Tracer (ET)` system from\nversion to version. The intention of this document is to list all\nincompatibilities as well as all enhancements and bugfixes for every release of\n`Event Tracer (ET)`. Each release of `Event Tracer (ET) `thus constitutes one\nsection in this document. The title of each section is the version number of\n`Event Tracer (ET)`.","title":"Event Tracer (ET) Release Notes","ref":"notes.html"},{"type":"extras","doc":"","title":"ET 1.7.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-7-1"},{"type":"extras","doc":"- The dependencies for this application are now listed in the app file.\n\n  Own Id: OTP-18831 Aux Id: [PR-7441]\n\n- Dialyzer warnings due to type specs added in `m:dbg` have been eliminated.\n\n  Own Id: OTP-18860\n\n[PR-7441]: https://github.com/erlang/otp/pull/7441","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.7 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-7"},{"type":"extras","doc":"- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.6.5 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-6-5"},{"type":"extras","doc":"- Fixed warnings in code matching on underscore prefixed variables.\n\n  Own Id: OTP-17385 Aux Id: OTP-17123","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.6.4 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-6-4"},{"type":"extras","doc":"- The scroll bar of the et_viewer window could not be dragged all the way to the\n  top of the window. It would always stop at the second event. This is now\n  corrected.\n\n  Own Id: OTP-15463 Aux Id: ERL-780","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.6.3 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-6-3"},{"type":"extras","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.6.2 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-6-2"},{"type":"extras","doc":"- Calls to `erlang:get_stacktrace()` are removed.\n\n  Own Id: OTP-14861","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.6.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-6-1"},{"type":"extras","doc":"- Tools are updated to show Unicode atoms correctly.\n\n  Own Id: OTP-14464","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.6 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-6"},{"type":"extras","doc":"- Update selector to utilize new garbage collection trace tags.\n\n  Own Id: OTP-13545","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.5.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-5-1"},{"type":"extras","doc":"- The `et` application must continue to use `erlang:now/0` in order to obtain\n  timestamps that are consistent with timestamps obtained from tracing. The\n  application has been updated to suppress the warning for `erlang:now/0`.\n\n  Own Id: OTP-12780","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.5 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-5"},{"type":"extras","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"- Removed gs based applications and gs based backends. The `observer`\n  application replaces the removed applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10915","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.4.4.5 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-4-5"},{"type":"extras","doc":"- The encoding of the `notes.xml` file has been changed from latin1 to utf-8 to\n  avoid future merge problems.\n\n  Own Id: OTP-11310","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.4.4.4 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-4-4"},{"type":"extras","doc":"- Use erlang:demonitor(Ref, \\[flush]) where applicable. Thanks to Loïc Hoguin.\n\n  Own Id: OTP-11039\n\n- Rename and document lists:zf/2 as lists:filtermap/2. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11078","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.4.4.3 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-4-3"},{"type":"extras","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.4.4.2 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-4-2"},{"type":"extras","doc":"- Fix typo in ET doc (Thanks to Ricardo Catalinas Jiménez)\n\n  Own Id: OTP-10119","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.4.4.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-4-1"},{"type":"extras","doc":"- The GS applications is now deprecated and will be removed in the R16 release.\n  The following GS-based applications have been superseded by the Observer\n  application and will removed in R16: Appmon, Pman, Tv.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9907","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.4.4 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-4"},{"type":"extras","doc":"- Dialyzer warnings have been fixed.\n\n  Own Id: OTP-9470","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.4.3 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-3"},{"type":"extras","doc":"- The popup window 'contents viewer' did not display properly on Windows.\n\n  Own Id: OTP-9238","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.4.2 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-2"},{"type":"extras","doc":"- Fix error when module et was used in et_selector trace patterns.\n\n  Own Id: OTP-8904","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"","title":"ET 1.4.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4-1"},{"type":"extras","doc":"- Fixed broken links in the documentation.\n\n  Own Id: OTP-8796","title":"Fixed Bugs and Malfunctions - Event Tracer (ET) Release Notes","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","doc":"- Fixed gui crash on windows.\n\n  Own Id: OTP-8830","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.4 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-4"},{"type":"extras","doc":"- Thanks to Olle Mattsson the GUI parts are rewritten to use `wxWidgets`. For\n  the time being it is still possible to use the old `GS` based version of the\n  tool, but it is deprecated. The `wxWidgets` based version is started by\n  default.\n\n  A print function has been added, in order to enable printing of sequence\n  charts.\n\n  A new tutorial has been added to the documentation. It is based on\n  `Jayson Vantuyl's` article\n  `http://souja.net/2009/04/making-sense-of-erlangs-event-tracer.html`.\n\n  The functions `et:trace_me/4` and `et:trace_me/5` has been introduced in order\n  to replace the deprecated functions `et:report_event/4` and\n  `et:report_event/5`. Hopefully the new names makes it a little more obvious\n  what the intended usage of the functions are.\n\n  The `max_events` configuration parameter to `et_viewer` is not used any more.\n  Now the event cache in the `Viewer` only contains those events that actually\n  are displayed in the GUI.\n\n  Own Id: OTP-8058","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.3.3 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-3-3"},{"type":"extras","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the HTML frames are\n  removed.\n\n  Own Id: OTP-8201","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.3.2 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-3-2"},{"type":"extras","doc":"- The start module in the app file has been corrected.\n\n  Own Id: OTP-8078","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.3.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-3-1"},{"type":"extras","doc":"- Changed copyright\n\n  Own Id: OTP-7830","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.3 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-3"},{"type":"extras","doc":"- Adjusted copyright\n\n  Own Id: OTP-6985","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.0.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-0-1"},{"type":"extras","doc":"- Document source changed from SGML to XML.\n\n  Own Id: OTP-6774","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"ET 1.0.0.1 - Event Tracer (ET) Release Notes","ref":"notes.html#et-1-0-0-1"},{"type":"extras","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689","title":"Improvements and New Features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"","title":"Event Tracer (ET) 1.0 - Event Tracer (ET) Release Notes","ref":"notes.html#event-tracer-et-1-0"},{"type":"extras","doc":"This is the first release of the `Event Tracer (ET)` as a stand-alone\napplication separated from the Megaco application.","title":"Improvements and new features - Event Tracer (ET) Release Notes","ref":"notes.html#improvements-and-new-features"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction\n\nThe `Event Tracer (ET)` uses the built-in trace mechanism in Erlang and provides\ntools for collection and graphical viewing of trace data.\n\nThe viewed trace data is normally collected from Erlang trace ports or files.","title":"Introduction","ref":"et_intro.html"},{"type":"extras","doc":"This manual describes the `Event Tracer (ET)` application, as a component of the\nErlang/Open Telecom Platform development environment. It is assumed that the\nreader is familiar with the Erlang Development Environment, which is described\nin a separate User's Guide.","title":"Scope and Purpose - Introduction","ref":"et_intro.html#scope-and-purpose"},{"type":"extras","doc":"The following prerequisites are required for understanding the material in the\n`Event Tracer (ET)` User's Guide:\n\n- familiarity with the Erlang system and Erlang programming in general and the\n  especially the art of Erlang tracing.\n\nThe application requires Erlang/OTP release R13BB or later. If you use the old\n`GS` based GUI it does suffice with R7B.","title":"Prerequisites - Introduction","ref":"et_intro.html#prerequisites"},{"type":"extras","doc":"In addition to this introductory chapter, the `Event Tracers` User's Guide\ncontains the following chapters:\n\n- Chapter 2: \"Tutorial\" provides a walk-through of the various parts of the\n  application. The tutorial is based on `Jayson Vantuyl's` article\n  `http://souja.net/2009/04/making-sense-of-erlangs-event-tracer.html`.\n- Chapter 3: \"Description\" describes the architecture and typical usage of the\n  application.\n- Chapter 4: \"Advanced examples\" gives some usage examples","title":"About This Manual - Introduction","ref":"et_intro.html#about-this-manual"},{"type":"extras","doc":"Refer to the following documentation for more information about\n`Event Tracer (ET)` and about the Erlang/OTP development system:\n\n- the Reference Manual of the `Event Tracer (ET)`.\n- documentation of basic tracing in `erlang:trace/3` and\n  `erlang:trace_pattern/3` and then the utilities derived from these: `dbg`,\n  `observer`, `invisio` and `et`.\n- Programming Erlang: Software for a Concurrent World by Joe Armstrong; ISBN:\n  978-1-93435-600-5","title":"Where to Find More Information - Introduction","ref":"et_intro.html#where-to-find-more-information"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Tutorial","title":"Tutorial","ref":"et_tutorial.html"},{"type":"extras","doc":"The easiest way of using `ET`, is to just use it as a graphical tool for\ndisplaying message sequence charts. In order to do that you need to first start\na `Viewer` (which by default starts a `Collector`):\n\n```erlang\n      {ok, ViewerPid} = et_viewer:start([{title,\"Coffee Order\"}]),\n      CollectorPid = et_viewer:get_collector_pid(ViewerPid).\n```\n\n[](){: #report_event }\n\nThen you send events to the `Collector` with the function\n`et_collector:report_event/6` like this:\n\n```text\n      et_collector:report_event(CollectorPid,85,from,to,message,extra_stuff).\n```\n\nThe `Viewer` will automatically pull events from the `Collector` and display\nthem on the screen.\n\nThe number (in this case 85) is an integer from 1 to 100 that specifies the\n\"detail level\" of the message. The higher the number, the more important it is.\nThis provides a crude form of priority filtering.\n\nThe `from`, `to`, and `message` parameters are exactly what they sound like.\n`from` and `to` are visualized in the `Viewer` as \"lifelines\", with the message\npassing from one to the other. If `from` and `to` are the same value, then it is\ndisplayed next to the lifeline as an \"action\". The `extra_stuff `value is simply\ndata that you can attach that will be displayed when someone actually clicks on\nthe action or message in the `Viewer` window.\n\nThe module `et/examples/et_display_demo.erl` illustrates how it can be used:\n\n```erlang\n\n-module(et_display_demo).\n\n-export([test/0]).\n\ntest() ->\n    {ok, Viewer} = et_viewer:start([{title,\"Coffee Order\"}, {max_actors,10}]),\n    Drink = {drink,iced_chai_latte},\n    Size = {size,grande},\n    Milk = {milk,whole},\n    Flavor = {flavor,vanilla},\n    C = et_viewer:get_collector_pid(Viewer),\n    et_collector:report_event(C,99,customer,barrista1,place_order,[Drink,Size,Milk,Flavor]),\n    et_collector:report_event(C,80,barrista1,register,enter_order,[Drink,Size,Flavor]),\n    et_collector:report_event(C,80,register,barrista1,give_total,\"$5\"),\n    et_collector:report_event(C,80,barrista1,barrista1,get_cup,[Drink,Size]),\n    et_collector:report_event(C,80,barrista1,barrista2,give_cup,[]),\n    et_collector:report_event(C,90,barrista1,customer,request_money,\"$5\"),\n    et_collector:report_event(C,90,customer,barrista1,pay_money,\"$5\"),\n    et_collector:report_event(C,80,barrista2,barrista2,get_chai_mix,[]),\n    et_collector:report_event(C,80,barrista2,barrista2,add_flavor,[Flavor]),\n    et_collector:report_event(C,80,barrista2,barrista2,add_milk,[Milk]),\n    et_collector:report_event(C,80,barrista2,barrista2,add_ice,[]),\n    et_collector:report_event(C,80,barrista2,barrista2,swirl,[]),\n    et_collector:report_event(C,80,barrista2,customer,give_tasty_beverage,[Drink,Size]),\n    ok.\n```\n\nWhen you run the `et_display_demo:test().` function in the example above, the\n`Viewer` window will look like this:\n\n![Screenshot of the Viewer window](assets/coffee_order.png \"Screenshot of the Viewer window\")","title":"Visualizing Message Sequence Charts - Tutorial","ref":"et_tutorial.html#visualizing-message-sequence-charts"},{"type":"extras","doc":"The event tracer framework is made up of four modules:\n\n- `et`\n- `et_collector`\n- `et_viewer`\n- `et_selector`\n\nIn addition, you'll probably want to familiarize yourself with the `dbg` module\nand possibly `seq_trace` module as well.","title":"Four Modules - Tutorial","ref":"et_tutorial.html#four-modules"},{"type":"extras","doc":"The `et` module is not like other modules. It contains a function called\n`et:trace_me/5`. Which is a function that does not do any useful stuff at all.\nIts sole purpose is to be a function that is easy to trace. A call to it may be\nsomething like:\n\n```text\n      et:trace_me(85,from,to,message,extra_stuff).\n```\n\nThe parameters to `et:trace_me/5` are the same as to\n[`et_collector:report_event/6`](et_tutorial.md#report_event) in the previous\nchapter. The big difference between the two is in the semantics of the two\nfunctions. The second actually reports an `Event` to the `Collector` while the\nfirst does nothing, it just returns the atom `hopefully_traced`. In order to\nmake the parameters to `et:trace_me/5` turn up in the `Collector`, tracing of\nthat function must be activated and the `Collector` must be registered as a\n`Tracer` of the `Raw Trace Data`.\n\nErlang tracing is a seething pile of pain that involves reasonably complex\nknowledge of clever ports, tracing return formats, and specialized tracing\n`MatchSpecs` (which are really their own special kind of hell). The tracing\nmechanism is very powerful indeed, but it can be hard to grasp.\n\nLuckily there is a simplified way to start tracing of `et:trace_me/5` function\ncalls. The idea is that you should instrument your code with calls to\n`et:trace_me/5` in strategic places where you have interesting information\navailable in your program. Then you just start the `Collector` with global\ntracing enabled:\n\n```erlang\n      et_viewer:start([{trace_global, true}, {trace_pattern, {et,max}}]).\n```\n\nThis will start a `Collector`, a `Viewer` and also start the tracing of\n`et:trace_me/5` function calls. The `Raw Trace Data` is collected by the\n`Collector` and a view of it is displayed on the screen by the `Viewer`. You can\ndefine your own \"views\" of the data by implementing your own `Filter` functions\nand register them in the `Viewer`.","title":"The Event Tracer Interface - Tutorial","ref":"et_tutorial.html#the-event-tracer-interface"},{"type":"extras","doc":"These two pieces work in concert. Basically, the `Collector` receives\n`Raw Trace Data` and processes it into `Events` in a `et` specific format\n(defined in `et/include/et.hrl`). The `Viewer` interrogates the `Collector` and\ndisplays an interactive representation of the data.\n\nYou might wonder why these aren't just one module. The `Collector` is a generic\nfull-fledged framework that allows processes to \"subscribe\" to the `Events` that\nit collects. One `Collector` can serve several `Viewers`. The typical case is\nthat you have one `Viewer` that visualizes `Events` in one flavor and another\n`Viewer` that visualizes them in another flavor. If you for example are tracing\na text based protocol like `HTML` (or `Megaco/H.248`) it would be useful to be\nable to display the `Events` as plain text as well as the internal\nrepresentation of the message. The architecture does also allow you to implement\nyour own `Viewer` program as long as it complies to the protocol between the\n`Collector/Viewer` protocol. Currently two kinds of `Viewers` exists. That is\nthe old `GS` based one and the new based on `wxWidgets`. But if you feel for it\nyou may implement your own `Viewer`, which for example could display the\n`Events` as ASCII art or whatever you feel useful.\n\nThe `Viewer` will by default create a `Collector` for you. With a few options\nand some configuration settings you can start collecting `Events`.\n\nThe `Collector` API does also allow you to save the collected `Events` to file\nand later load them in a later session.","title":"The Collector and Viewer - Tutorial","ref":"et_tutorial.html#the-collector-and-viewer"},{"type":"extras","doc":"This is perhaps the most central module in the entirety of the `et` suite. The\n`Collector` needs \"filters\" to convert the `Raw Trace Data` into \"events\" that\nit can display. The `et_selector` module provides the default `Filter` and some\nAPI calls to manage the `Trace Pattern`. The `Selector` provides various\nfunctions that achieve the following:\n\n- Convert `Raw Trace Data` into an appropriate `Event`\n- Magically notice traces of the `et:trace_me/5` function and make appropriate\n  `Events`\n- Carefully prevent translating the `Raw Trace Data` twice\n- Manage a `Trace Pattern`\n\nThe `Trace Pattern` is basically a tuple of a `module` and a `detail level`\n(either an integer or the atom max for full detail). In most cases the\n`Trace Pattern` `{et,max}` does suffice. But if you do not want any runtime\ndependency of `et` you can implement your own `trace_me/5` function in some\nmodule and refer to that module in the `Trace Pattern`.\n\nThe specified module flows from your instantiation of the `Viewer`, to the\n`Collector` that it automatically creates, gets stashed in as the\n`Trace Pattern`, and eventually goes down into the bowels of the `Selector`.\n\nThe module that you specify gets passed down (eventually) into `Selector`'s\ndefault `Filter`. The format of the `et:trace_me/5` function call is hardcoded\nin that `Filter`.","title":"The Selector - Tutorial","ref":"et_tutorial.html#the-selector"},{"type":"extras","doc":"The `Collector` automatically registers itself to listen for trace `Events`, so\nall you have to do is enable them.\n\nFor those people who want to do general tracing, consult the `dbg` module on how\nto trace whatever you're interested in and let it work its magic. If you just\nwant `et:trace_me/5` to work, do the following:\n\n1. Create a `Collector`\n1. Create a `Viewer` (this can do step #1 for you)\n1. Turn on and pare down debugging\n\nThe module `et/examples/et_trace_demo.erl` achieves this.\n\n```erlang\n\n-module(et_trace_demo).\n\n-export([test/0]).\n\ntest() ->\n    et_viewer:start([\n        {title,\"Coffee Order\"},\n        {trace_global,true},\n        {trace_pattern,{et,max}},\n        {max_actors,10}\n      ]),\n      %% dbg:p(all,call),\n      %% dbg:tpl(et, trace_me, 5, []),\n      Drink = {drink,iced_chai_latte},\n      Size = {size,grande},\n      Milk = {milk,whole},\n      Flavor = {flavor,vanilla},\n      et:trace_me(99,customer,barrista1,place_order,[Drink,Size,Milk,Flavor]),\n      et:trace_me(80,barrista1,register,enter_order,[Drink,Size,Flavor]),\n      et:trace_me(80,register,barrista1,give_total,\"$5\"),\n      et:trace_me(80,barrista1,barrista1,get_cup,[Drink,Size]),\n      et:trace_me(80,barrista1,barrista2,give_cup,[]),\n      et:trace_me(90,barrista1,customer,request_money,\"$5\"),\n      et:trace_me(90,customer,barrista1,pay_money,\"$5\"),\n      et:trace_me(80,barrista2,barrista2,get_chai_mix,[]),\n      et:trace_me(80,barrista2,barrista2,add_flavor,[Flavor]),\n      et:trace_me(80,barrista2,barrista2,add_milk,[Milk]),\n      et:trace_me(80,barrista2,barrista2,add_ice,[]),\n      et:trace_me(80,barrista2,barrista2,swirl,[]),\n      et:trace_me(80,barrista2,customer,give_tasty_beverage,[Drink,Size]),\n      ok.\n```\n\nRunning through the above, the most important points are:\n\n- Turn on global tracing\n- Set a `Trace Pattern`\n- Tell `dbg` to trace function Calls\n- Tell it specifically to trace the `et:trace_me/5` function\n\nWhen you run the `et_trace_demo:test()` function above, the `Viewer` window will\nlook like this screenshot:\n\n![Screenshot of the Viewer window](assets/coffee_order.png \"Screenshot of the Viewer window\")","title":"How To Put It Together - Tutorial","ref":"et_tutorial.html#how-to-put-it-together"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Description","title":"Description","ref":"et_desc.html"},{"type":"extras","doc":"The two major components of the `Event Tracer (ET)` tool is a graphical sequence\nchart viewer (`et_viewer`) and its backing storage (`et_collector`). One\n`Collector` may be used as backing storage for several simultaneous `Viewers`\nwhere each one may display a different view of the same trace data.\n\nThe interface between the `Collector` and its `Viewers` is public in order to\nenable other types of `Viewers`. However in the following text we will focus on\nusage of the `et_viewer`.\n\nThe main start function is `et_viewer:start/1`. By default it will start both an\n`et_collector` and an `et_viewer`:\n\n```erlang\n% erl -pa et/examples\nErlang R13B03 (erts-5.7.4) [64-bit] [smp:4:4] [rq:4] [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.4  (abort with ^G)\n1> {ok, Viewer} = et_viewer:start([]).\n{ok,<0.40.0>}\n```\n\nA `Viewer` gets trace `Events` from its `Collector` by polling it regularly for\nmore `Events` to display. `Events` are for example reported to the `Collector`\nwith `et_collector:report_event/6`:\n\n```erlang\n2> Collector = et_viewer:get_collector_pid(Viewer).\n<0.39.0>\n3> et_collector:report_event(Collector, 60, my_shell, mnesia_tm, start_outer,\n3>                           \"Start outer transaction\"),\n3> et_collector:report_event(Collector, 40, mnesia_tm, my_shell, new_tid,\n3>                           \"New transaction id is 4711\"),\n3> et_collector:report_event(Collector, 20, my_shell, mnesia_locker, try_write_lock,\n3>                           \"Acquire write lock for {my_tab, key}\"),\n3> et_collector:report_event(Collector, 10, mnesia_locker, my_shell, granted,\n3>                           \"You got the write lock for {my_tab, key}\"),\n3> et_collector:report_event(Collector, 60, my_shell, do_commit,\n3>                           \"Perform  transaction commit\"),\n3> et_collector:report_event(Collector, 40, my_shell, mnesia_locker, release_tid,\n3>                           \"Release all locks for transaction 4711\"),\n3> et_collector:report_event(Collector, 60, my_shell, mnesia_tm, delete_transaction,\n3>                           \"End of outer transaction\"),\n3> et_collector:report_event(Collector, 20, my_shell, end_outer,\n3>                           \"Transaction returned {atomic, ok}\").\n{ok,{table_handle,<0.39.0>,16402,trace_ts,\n     #Fun }}\n```\n\nThis actually is a simulation of the process `Events` caused by a `Mnesia`\ntransaction that writes a record in a local table:\n\n```erlang\nmnesia:transaction(fun() -> mnesia:write({my_tab, key, val}) end).\n```\n\nAt this stage when we have a couple of `Events`, it is time to show how it looks\nlike in the graphical interface of `et_viewer`:\n\n![A simulated Mnesia transaction which writes one record](assets/sim_trans.png \"A simulated Mnesia transaction which writes one record\")\n\nIn the sequence chart, the actors (which symbolically has performed the `Event`)\nare shown as named vertical bars. The order of the actors may be altered by\ndragging (hold mouse button 1 pressed during the operation) the name tag of an\nactor and drop it elsewhere:\n\n![Two actors has switched places](assets/sim_trans_move_actor.png \"Two actors has switched places\")\n\nAn `Event` may be an action performed by one single actor (blue text label) or\nit may involve two actors and is then depicted as an arrow directed from one\nactor to another (red text label). Details of an `Event` can be shown by\nclicking (press and release the mouse button 1) on the event label text or on\nthe arrow. When doing that a `Contents Viewer` window pops up. It may look like\nthis:\n\n![Details of a write lock message](assets/sim_trans_write_lock.png \"Details of a write lock message\")","title":"Overview - Description","ref":"et_desc.html#overview"},{"type":"extras","doc":"The `Event Tracer (ET)` uses named filters in various contexts. An Event Trace\nfilter is an `Erlang fun` that takes some trace data as input and returns a\npossibly modified version of it:\n\n```erlang\nfilter(TraceData) -> false | true | {true, NewEvent}\n\nTraceData = Event | erlang_trace_data()\nEvent = #event{}\nNewEvent = #event{}\n```\n\nThe interface of the filter function is the same as the the filter functions for\nthe good old `lists:filtermap/2`. If the filter returns `false` it means that\nthe trace data should silently be dropped. `true` means that the trace data data\nalready is an `Event Record` and that it should be kept as it is. `true` means\nthat the `TraceData` already is an `Event Record` and that it should be kept as\nit is. `{true, NewEvent}` means that the original trace data should be replaced\nwith `Event`. This provides means to get rid of unwanted `Events` as well as\nenabling alternate views of an `Event`.\n\nThe first filter that the trace data is exposed for is the `Collector Filter`.\nWhen a trace `Event` is reported with `et_collector:report/2` (or\n`et_collector:report_event/5,6`) the first thing that happens, is that a message\nis sent to the `Collector` process to fetch a handle that contains some useful\nstuff, such as the `Collector Filter Fun` and an Ets table identifier. Then the\n`Collector Filter Fun` is applied and if it returns `true` (or\n`{true, NewEvent}`), the `Event` will be stored in an Ets table. As an\noptimization, subsequent calls to `et_collector:report`\\-functions can use the\nhandle directly instead of the `Collector Pid`.\n\nAll filters (registered in a `Collector` or in a `Viewer`) must be able to\nhandle an `Event record` as input. The `Collector Filter` (that is the filter\nnamed `all`) is a little bit special, as its input also may be raw\n`Erlang Trace Data`\n\nThe `Collector` manages a key/value based dictionary, where the filters are\nstored. Updates of the dictionary is propagated to all subscribing processes.\nWhen a `Viewer` is started it is registered as a subscriber of dictionary\nupdates.\n\nIn each `Viewer` there is only one filter that is active and all trace `Events`\nthat the `Viewer` gets from the `Collector` will pass thru that filter. By\nwriting clever filters it is possible to customize how the `Events` looks like\nin the viewer. The following filter in `et/examples/et_demo.erl` replaces the\nactor names `mnesia_tm` and `mnesia_locker` and leaves everything else in the\nrecord as it was:\n\n```erlang\n\nmgr_actors(E) when is_record(E, event) ->\n    Actor = fun(A) ->\n               case A of\n                   mnesia_tm     -> trans_mgr;\n                   mnesia_locker -> lock_mgr;\n                   _             -> A\n               end\n            end,\n    {true, E#event{from = Actor(E#event.from),\n                   to = Actor(E#event.to),\n                   contents = [{orig_from, E#event.from},\n                               {orig_to,   E#event.to},\n                               {orig_contents, E#event.contents}]}}.\n```\n\nIf we now add the filter to the running `Collector`:\n\n```erlang\n4> Fun = fun(E) -> et_demo:mgr_actors(E) end.\n#Fun \n5> et_collector:dict_insert(Collector, {filter, mgr_actors}, Fun).\nok\n```\n\nyou will see that the `Filter` menu in all viewers have got a new entry called\n`mgr_actors`. Select it, and a new `Viewer` window will pop up:\n\n![The same trace data in a different view](assets/sim_trans_mgr_actors.png \"The same trace data in a different view\")\n\nIn order to see the nitty gritty details of an `Event` you may click on the\n`Event` in order to start a `Contents Viewer` for that `Event`. In the\n`Contents Viewer` there also is a filter menu that enables inspection of the\n`Event` from other views than the one selected in the viewer. A click on the\n`new_tid` `Event` will cause a `Contents Viewer` window to pop up, showing the\n`Event` in the `mgr_actors` view:\n\n![The trace Event in the mgr_actors view](assets/sim_trans_contents_viewer_mgr_actors.png \"The trace Event in the mgr_actors view\")\n\nSelect the `all` entry in the `Filters` menu and a new `Contents Viewer window`\nwill pop up showing the same trace `Event` in the collectors view:\n\n![The same trace Event in the collectors view](assets/sim_trans_contents_viewer_collector.png \"The same trace Event in the collectors view\")","title":"Filters and dictionary - Description","ref":"et_desc.html#filters-and-dictionary"},{"type":"extras","doc":"As you have seen, it is possible to use the `et_collector:report_event/5,6`\nfunctions explicitly. By using those functions you can write your own trace\nclient that reads trace data from any source stored in any format and just feed\nthe `Collector` with it. You may replace the default `Collector Filter` with a\nfilter that converts new exciting trace data formats to `Event Records` or you\nmay convert it to an `Event Record` before you invoke `et_collector:report/2`\nand then rely on the default `Collector Filter` to handle the new format.\n\nThere are also existing functions in the API that reads from various sources and\ncalls `et_collector:report/2`:\n\n- The trace `Events` that are hosted by the `Collector` may be stored to file\n  and later be loaded by selecting `save` and `load` entries in the `Viewers`\n  `File` menu or via the `et_collector` API.\n- It is also possible to perform live tracing of a running system by making use\n  of the built-in trace support in the Erlang emulator. These Erlang traces can\n  be directed to files or to ports. See the reference manual for\n  `erlang:trace/3`, `erlang:trace_pattern/3`, `dbg` and `ttb` for more info.\n\n  There are also corresponding trace client types that can read the Erlang trace\n  data format from such files or ports. The `et_collector:start_trace_client/3`\n  function makes use of these Erlang trace clients and redirects the trace data\n  to the `Collector`.\n\n  The default `Collector Filter` converts the raw Erlang trace data format into\n  `Event Records`. If you want to perform this differently you can of course\n  write your own `Collector Filter` from scratch. But it may probably save you\n  some efforts if you first apply the default filter in\n  `et_selector:parse_event/2` before you apply your own conversions of its\n  output.","title":"Trace clients - Description","ref":"et_desc.html#trace-clients"},{"type":"extras","doc":"Setting up an Erlang tracer on a set of nodes and connecting trace clients to\nthe ports of these tracers is not intuitive. In order to make this it easier the\n`Event Tracer` has a notion of global tracing. When used, the `et_collector`\nprocess will monitor Erlang nodes and when one connects, an Erlang tracer will\nautomatically be started on the newly connected node. A corresponding trace\nclient will also be started on the `Collector` node in order to automatically\nforward the trace `Events` to the `Collector`. Set the boolean parameter\n`trace_global` to `true` for either the `et_collector` or `et_viewer` in order\nto activate the global tracing. There is no restriction on how many concurrent\n(anonymous) collectors you can have, but you can only have one _global_\n`Collector` as its name is registered in `global`.\n\nIn order to further simplify the tracing, you can make use of the\n`et:trace_me/4,5` functions. These functions are intended to be invoked from\nother applications when there are interesting `Events`, in your application that\nneeds to be highlighted. The functions are extremely light weight as they do\nnothing besides returning an atom. These functions are specifically designed to\nbe traced for. As the caller explicitly provides the values for the\n`Event Record` fields, the default `Collector Filter` is able to automatically\nprovide a customized `Event Record` without any user defined filter functions.\n\nIn normal operation, the `et:trace_me/4,5` calls are almost for free. When\ntracing is needed, you can either activate tracing on these functions\nexplicitly. Or you can combine the usage of `trace_global` with the usage of\n`trace_pattern`. When set, the `trace_pattern` will automatically be activated\non all connected nodes.\n\nOne nice thing with the `trace_pattern` is that it provides a very simple way of\nminimizing the amount of generated trace data by allowing you to explicitly\ncontrol the detail level of the tracing. As you may have seen the `et_viewer`\nhave a slider called `\"Detail Level\"` that allows you to control the detail\nlevel of the trace `Events` displayed in the `Viewer`. On the other hand if you\nset a low detail level in the `trace_pattern`, lots of the trace data will never\nbe generated and thus not sent over the socket to the trace client and stored in\nthe `Collector`.","title":"Global tracing - Description","ref":"et_desc.html#global-tracing"},{"type":"extras","doc":"Almost all functionality available in the `et_viewer` is also available via\nshortcuts. Which key that has the same effect as selecting a menu entry is shown\nenclosed in parentheses. For example pressing the key `r` is equivalent to\nselecting the menu entry `Viewer->Refresh`.\n\nFile menu:\n\n- `Clear all events in the Collector` \\- Deletes all `Events` stored in the\n  `Collector` and notifies all connected `Viewers` about this.\n- `Load events to the Collector from file` \\- Loads the `Collector` with\n  `Events` from a file and notifies all connected `Viewers` about this.\n- `Save all events in the Collector to file` \\- Saves all `Events` stored in the\n  `Collector` to file.\n- `Print setup` \\- Enables editing of printer setting, such as paper and layout.\n- `Print current page` \\- Prints the events on the current page. The page size\n  is dependent of the selected paper type.\n- `Print all pages` \\- Prints all events. The page size is dependent of the\n  selected paper type.\n- `Close this Viewer` \\- Closes this `Viewer` window, but keeps all other\n  `Viewers` windows and the `Collector` process.\n- `Close other Viewers, but this` \\- Keeps this `Viewer` window and its\n  `Collector` process, but closes all other `Viewers` windowsconnected to the\n  same `Collector`.\n- `Close all Viewers and the Collector` \\- Closes the `Collector` and all\n  `Viewers` connected to it.\n\nViewer menu:\n\n- `First` \\- Scrolls `this` viewer to the first `Event` in the `Collector`.\n- `Last` \\- Scrolls `this` viewer to the last `Event` in the `Collector`.\n- `Prev` \\- Scrolls `this` viewer one page backwards.\n- `Next` \\- Scrolls `this` viewer one page forward.\n- `Refresh` \\- Clears `this` viewer and re-read its `Events` from the\n  `Collector`.\n- `Up` \\- Scrolls a few `Events` backwards.\n- `Down` \\- Scrolls a few `Events` forward.\n- `Display all actors.` \\- Reset the settings for hidden and/or highlighted\n  actors.\n\nCollector menu:\n\n- `First` \\- Scrolls`all` viewers to the first `Event` in the `Collector`.\n- `Last` \\- Scrolls `all` viewers to the last `Event` in the `Collector`.\n- `Prev` \\- Scrolls `all` viewers one page backwards.\n- `Next` \\- Scrolls `all` viewers one page forward.\n- `Refresh` \\- Clears `all` viewers and re-read their `Events` from the\n  `Collector`.\n\nFilters and scaling menu:\n\n- `ActiveFilter (=)` \\- Starts a new `Viewer` window with the same active filter\n  and scale as the current one.\n- `ActiveFilter (+)` \\- Starts a new `Viewer` window with the same active filter\n  but a larger scale than the current one.\n- `ActiveFilter (-)` \\- Starts a new `Viewer `window with the same active filter\n  but a smaller scale than the current one.\n- `all (0)` \\- Starts a new `Viewer` with the `Collector Filter` as active\n  filter. It will cause all events in the collector to be viewed.\n- `AnotherFilter (2)` \\- If more filters are inserted into the dictionary, these\n  will turn up here as entries in the `Filters` menu. The second filter will get\n  the shortcut number 2, the next one number 3 etc. The names are sorted.\n\nSlider and radio buttons:\n\n- `Hide From=To` \\- When true, this means that the `Viewer` will hide all\n  `Events` where the from-actor equals to its to-actor. These events are\n  sometimes called actions.\n- `Hide (excluded actors)` \\- When true, this means that the `Viewer` will hide\n  all `Events` whose actors are marked as excluded. Excluded actors are normally\n  enclosed in round brackets when they are displayed in the `Viewer`.\n- `Detail level` \\- This slider controls the resolution of the `Viewer`. Only\n  `Events` with a detail level `smaller` than the selected one (default=100=max)\n  are displayed.\n\nOther features:\n\n- `Vertical scroll` \\- Use mouse wheel and up/down arrows to scroll little. Use\n  page up/down and home/end buttons to scroll more.\n- `Display details of an event` \\- Left mouse click on the event label or the\n  arrowand a new `Contents Viewer` window will pop up, displaying the contents\n  of an `Event`.\n- `Highlight actor (toggle)` \\- Left mouse click on the actor name tag. The\n  actor name will be enclosed in square brackets `[]`. When one or more actors\n  are highlighted, only events related to those actors are displayed. All others\n  are hidden.\n- `Exclude actor (toggle)` \\- Right mouse click on the actor name tag. The actor\n  name will be enclosed in round brackets `()`. When an actor is excluded, all\n  events related to this actor is hidden. If the checkbox\n  `Hide (excluded actors)` is checked, even the name tags and corresponding\n  vertical line of excluded actors will be hidden.\n- `Move actor` \\- Left mouse button drag and drop on actor name tag. Move the\n  actor by first clicking on the actor name, keeping the button pressed while\n  moving the cursor to a new location and release the button where the actor\n  should be moved to.\n- `Display all actors` \\- Press the 'a' button. Reset the settings for hidden\n  and/or highlighted actors.","title":"Viewer window - Description","ref":"et_desc.html#viewer-window"},{"type":"extras","doc":"The `Event Records` in the Ets table are ordered by their timestamp. Which\ntimestamp that should be used is controlled via the `event_order` parameter.\nDefault is `trace_ts` which means the time when the trace data was generated.\n`event_ts` means the time when the trace data was parsed (transformed into an\n`Event Record`).","title":"Configuration - Description","ref":"et_desc.html#configuration"},{"type":"extras","doc":"File menu:\n\n- `Close` \\- Close this window.\n- `Save` \\- Save the contents of this window to file.\n\nFilters menu:\n\n- `ActiveFilter` \\- Start a new `Contents Viewer window` with the same active\n  filter.\n- `AnotherFilter (2)` \\- If more filters are inserted into the dictionary, these\n  will turn up here as entries in the `Filters` menu. The second filter will be\n  number 2, the next one number 3 etc. The names are sorted.\n\nHide menu:\n\n- `Hide actor in viewer` \\- Known actors are shown as a named vertical bars in\n  the `Viewer` window. By hiding the actor, its vertical bar will be removed and\n  the `Viewer` will be refreshed.\n\n  `Hiding the actor` is only useful if the `max_actors` threshold has been\n  reached, as it then will imply that the \"hidden\" actor will be displayed as if\n  it were `\"UNKNOWN\"`. If the `max_actors` threshold not have been reached, the\n  actor will re-appear as a vertical bar in the `Viewer`.\n\n- `Show actor in viewer` \\- This implies that the actor will be added as a known\n  actor in the `Viewer` with its own vertical bar.\n\nSearch menu:\n\n- `Forward from this event` \\- Set this event to be the first event in the\n  viewer and change its display mode to be enter forward search mode. The actor\n  of this event (from, to or both) will be added to the list of selected actors.\n- `Reverse from this event` \\- Set this event to be the first `Event` in the\n  `Viewer` and change its display mode to be enter reverse search mode. The\n  actor of this `Event` (from, to or both) will be added to the list of selected\n  actors. Observe, that the `Events` will be shown in reverse order.\n- `Abort search. Display all` \\- Switch the display mode of the `Viewer` to show\n  all `Events` regardless of any ongoing searches. Abort the searches.","title":"Contents viewer window - Description","ref":"et_desc.html#contents-viewer-window"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Advanced examples","title":"Advanced examples","ref":"et_examples.html"},{"type":"extras","doc":"The Erlang code for running the simulated `Mnesia` transaction example in the\nprevious chapter is included in the `et/examples/et_demo.erl` file:\n\n```erlang\n\nsim_trans() ->\n    sim_trans([]).\n\nsim_trans(ExtraOptions) ->\n    Options = [{dict_insert, {filter, mgr_actors}, fun mgr_actors/1}],\n    {ok, Viewer} = et_viewer:start_link(Options ++ ExtraOptions),\n    Collector = et_viewer:get_collector_pid(Viewer),\n    et_collector:report_event(Collector, 60, my_shell, mnesia_tm, start_outer,\n                              \"Start outer transaction\"),\n    et_collector:report_event(Collector, 40, mnesia_tm, my_shell, new_tid,\n                              \"New transaction id is 4711\"),\n    et_collector:report_event(Collector, 20, my_shell, mnesia_locker, try_write_lock,\n                              \"Acquire write lock for {my_tab, key}\"),\n    et_collector:report_event(Collector, 10, mnesia_locker, my_shell, granted,\n                              \"You got the write lock for {my_tab, key}\"),\n    et_collector:report_event(Collector, 60, my_shell, do_commit,\n                              \"Perform  transaction commit\"),\n    et_collector:report_event(Collector, 40, my_shell, mnesia_locker, release_tid,\n                              \"Release all locks for transaction 4711\"),\n    et_collector:report_event(Collector, 60, my_shell, mnesia_tm, delete_transaction,\n                              \"End of outer transaction\"),\n    et_collector:report_event(Collector, 20, my_shell, end_outer,\n                              \"Transaction returned {atomic, ok}\"),\n    {collector, Collector}.\n```\n\n```erlang\n\nmgr_actors(E) when is_record(E, event) ->\n    Actor = fun(A) ->\n               case A of\n                   mnesia_tm     -> trans_mgr;\n                   mnesia_locker -> lock_mgr;\n                   _             -> A\n               end\n            end,\n    {true, E#event{from = Actor(E#event.from),\n                   to = Actor(E#event.to),\n                   contents = [{orig_from, E#event.from},\n                               {orig_to,   E#event.to},\n                               {orig_contents, E#event.contents}]}}.\n```\n\nIf you invoke the `et_demo:sim_trans()` function, a `Viewer` window will pop up\nand the sequence trace will be almost the same as if the following `Mnesia`\ntransaction would have been run:\n\n```erlang\nmnesia:transaction(fun() -> mnesia:write({my_tab, key, val}) end).\n```\n\nAnd the viewer window will look like:\n\n```erlang\nErlang R13B03 (erts-5.7.4) [64-bit] [smp:4:4] [rq:4] [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.4  (abort with ^G)\n1> {ok, Viewer} = et_viewer:start([]).\n{ok,<0.40.0>;}\n2> et_demo:sim_trans().\n{ok,{table_handle,<0.45.0>,24596,trace_ts,\n     #Fun }}\n```\n\n![A simulated Mnesia transaction which writes one record](assets/sim_trans.png \"A simulated Mnesia transaction which writes one record\")","title":"A simulated Mnesia transaction - Advanced examples","ref":"et_examples.html#a-simulated-mnesia-transaction"},{"type":"extras","doc":"The `module_as_actor` filter converts the `Event Records` so the module names\nbecomes actors and the invoked functions becomes labels. If the information\nabout who the caller was it will be displayed as an arrow directed from the\ncaller to the callee. The `[{message, {caller}}, {return_trace}]` options to\n`dbg:tpl/2` function will imply the necessary information in the Erlang traces.\nHere follows the `module_as_actor` filter:\n\n```erlang\n\nmodule_as_actor(E) when is_record(E, event) ->\n    case lists:keysearch(mfa, 1, E#event.contents) of\n        {value, {mfa, {M, F, _A}}} ->\n            case lists:keysearch(pam_result, 1, E#event.contents) of\n                {value, {pam_result, {M2, _F2, _A2}}} ->\n                    {true, E#event{label = F, from = M2, to = M}};\n                _ ->\n                    {true, E#event{label = F, from = M, to = M}}\n            end;\n        _ ->\n            false\n    end.\n```\n\nThe `plain_process_info` filter does not alter the `Event Records`. It merely\nensures that the event not related to processes are skipped:\n\n```erlang\n\nplain_process_info(E) when is_record(E, event) ->\n    case E#event.label of\n        send                          -> true;\n        send_to_non_existing_process  -> true;\n        'receive'                     -> true;\n        spawn                         -> true;\n        exit                          -> true;\n        link                          -> true;\n        unlink                        -> true;\n        getting_linked                -> true;\n        {seq_send, _Label}            -> true;\n        {seq_receive, _Label}         -> true;\n        {seq_print, _Label}           -> true;\n        {drop, _N}                    -> true;\n        _                             -> false\n    end.\n```\n\nThe `plain_process_info_nolink` filter does not alter the `Event Records`. It do\nmakes use of the `plain_process_info` , but do also ensure that the process info\nrelated to linking and unlinking is skipped:\n\n```erlang\n\nplain_process_info_nolink(E) when is_record(E, event) ->\n    (E#event.label /= link) and\n    (E#event.label /= unlink) and\n    (E#event.label /= getting_linked) and\n    plain_process_info(E).\n```\n\nIn order to simplify the startup of an `et_viewer` process with the filters\nmentioned above, plus some others (that also are found in\n`et/examples/et_demo.erl` src/et_collector.erl the `et_demo:start/0,1` functions\ncan be used:\n\n```erlang\n\nstart() ->\n    start([]).\n\nstart(ExtraOptions) ->\n    Options = [{trace_global, true},\n               {parent_pid, undefined},\n               {max_actors, infinity},\n               {max_events, 1000},\n               {active_filter, module_as_actor}],\n    et_viewer:start_link(filters() ++ Options ++ ExtraOptions).\n```\n\nA simple one-liner starts the tool:\n\n```text\n          erl -pa ../examples -s et_demo\n```\n\nThe filters are included by the following parameters:\n\n```erlang\n\nfilters() ->\n    [{dict_insert, {filter, module_as_actor},\n                   fun module_as_actor/1},\n     {dict_insert, {filter, plain_process_info},\n                   fun plain_process_info/1},\n     {dict_insert, {filter, plain_process_info_nolink},\n                   fun plain_process_info_nolink/1},\n     {dict_insert, {filter, named_process_info},\n                   fun named_process_info/1},\n     {dict_insert, {filter, named_process_info_nolink},\n                   fun named_process_info_nolink/1},\n     {dict_insert, {filter, node_process_info},\n                   fun node_process_info/1},\n     {dict_insert, {filter, node_process_info_nolink},\n                   fun node_process_info_nolink/1},\n     {dict_insert, {filter, application_as_actor},\n                   fun application_as_actor/1}\n    ].\n```","title":"Some convenient functions used in the Mnesia transaction example - Advanced examples","ref":"et_examples.html#some-convenient-functions-used-in-the-mnesia-transaction-example"},{"type":"extras","doc":"The following piece of code `et_demo:trace_mnesia/0` activates call tracing of\nboth local and external function calls for all modules in the `Mnesia`\napplication. The call traces are configured cover all processes (both existing\nand those that are spawned in the future) and include timestamps for trace data.\nIt do also activate tracing of process related events for `Mnesia`'s static\nprocesses plus the calling process (that is your shell). Please, observe that\nthe [`whereis/1`](`whereis/1`) call in the following code requires that both the\ntraced `Mnesia` application and the `et_viewer` is running on the same node:\n\n```erlang\n\ntrace_mnesia() ->\n    Modules = mnesia:ms(),\n    Spec = [{message, {caller}}, {return_trace}],\n    Flags = [send, 'receive', procs, timestamp],\n    dbg:p(all, [call, timestamp]),\n    [dbg:tpl(M, [{'_', [], Spec}]) || M <- Modules],\n    LocallyRunningServers = [M || M <- Modules, whereis(M) /= undefined],\n    [dbg:p(whereis(RS), Flags) || RS <- LocallyRunningServers],\n    dbg:p(self(), Flags),\n    LocallyRunningServers.\n```\n\nThe `et_demo:live_trans/0` function starts the global `Collector`, starts a\n`Viewer`, starts `Mnesia`, creates a local table, activates tracing (as\ndescribed above) and registers the shell process is as 'my_shell' for clarity.\nFinally a simple `Mnesia` transaction that writes a single record is run:\n\n```erlang\n\nlive_trans() ->\n    live_trans([]).\n\nlive_trans(ExtraOptions) ->\n    Options = [{title, \"Mnesia tracer\"},\n\t       {hide_actions, true},\n\t       {active_filter, named_process_info_nolink}],\n    et_demo:start(Options ++ ExtraOptions),\n    mnesia:start(),\n    mnesia:create_table(my_tab, [{ram_copies, [node()]}]),\n    et_demo:trace_mnesia(),\n    register(my_shell, self()),\n\n    mnesia:transaction(fun() -> mnesia:write({my_tab, key, val}) end).\n```\n\nNow we run the `et_demo:live_trans/0` function:\n\n```text\nerl -pa ../examples\nErlang R13B03 (erts-5.7.4) [64-bit] [smp:4:4] [rq:4]\n                           [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.4  (abort with ^G)\n1> et_demo:live_trans().\n{atomic,ok}\n```\n\nPlease, explore the different filters in order to see how the traced transaction\ncan be seen from different point of views:\n\n![A real Mnesia transaction which writes one record](assets/live_trans.png \"A real Mnesia transaction which writes one record\")","title":"Erlang trace of a real Mnesia transaction - Advanced examples","ref":"et_examples.html#erlang-trace-of-a-real-mnesia-transaction"},{"type":"extras","doc":"The `Event Tracer (ET)` tool was initially written in order to demonstrate how\nmessages where sent over the `Megaco` protocol. This were back in the old days\nbefore the standard bodies of `IETF` and `ITU` had approved `Megaco` (also\ncalled `H.248`) as an international standard.\n\nIn the `Megaco` application of Erlang/OTP, the code is carefully instrumented\nwith calls to `et:trace_me/5`. For each call a detail level is given in order to\nenable dynamic control of the trace level in a simple manner.\n\nThe `megaco_filter` module implements a customized filter for `Megaco` messages.\nIt does also make use of `trace_global` combined with usage of the\n`trace_pattern`:\n\n```erlang\n-module(megaco_filter).\n-export([start/0]).\n\nstart() ->\n    Options =\n        [{event_order, event_ts},\n         {scale, 3},\n         {max_actors, infinity},\n         {trace_pattern, {megaco, max}},\n         {trace_global, true},\n         {dict_insert, {filter, megaco_filter}, fun filter/1},\n         {active_filter, megaco_filter},\n         {title, \"Megaco tracer - Erlang/OTP\"}],\n    et_viewer:start(Options).\n```\n\nFirst we start an Erlang node with a global `Collector` and its `Viewer`.\n\n```erlang\nerl -sname observer\nErlang R13B03 (erts-5.7.4) [64-bit] [smp:4:4] [rq:4] [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.4  (abort with ^G)\n(observer@falco)1> megaco_filter:start().\n{ok,<0.48.0>}\n```\n\nSecondly we start another Erlang node which we connect the observer node, before\nwe start the application that we want to trace. In this case we start a Media\nGateway Controller that listens for both TCP and UDP on the text and binary\nports for Megaco:\n\n```erlang\nerl -sname mgc -pa ../../megaco/examples/simple\nErlang R13B03 (erts-5.7.4) [64-bit] [smp:4:4] [rq:4] [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.4  (abort with ^G)\n(mgc@falco)1> net:ping(observer@falco).\npong\n(mgc@falco)2> megaco:start().\nok\n(mgc@falco)3> megaco_simple_mgc:start().\n{ok,[{ok,2944,\n         {megaco_receive_handle,{deviceName,\"controller\"},\n                                megaco_pretty_text_encoder,[],megaco_tcp,dynamic}},\n     {ok,2944,\n         {megaco_receive_handle,{deviceName,\"controller\"},\n                                megaco_pretty_text_encoder,[],megaco_udp,dynamic}},\n     {ok,2945,\n         {megaco_receive_handle,{deviceName,\"controller\"},\n                                megaco_binary_encoder,[],megaco_tcp,dynamic}},\n     {ok,2945,\n         {megaco_receive_handle,{deviceName,\"controller\"},\n                                megaco_binary_encoder,[],megaco_udp,dynamic}}]}\n```\n\nAnd finally we start an Erlang node for the Media Gateways and connect to the\nobserver node. Each Media Gateway connects to the controller and sends an\ninitial Service Change message. The controller accepts the gateways and sends a\nreply to each one using the same transport mechanism and message encoding\naccording to the preference of each gateway. That is all combinations of TCP/IP\ntransport, UDP/IP transport, text encoding and ASN.1 BER encoding:\n\n```erlang\nErlang R13B03 (erts-5.7.4) [64-bit] [smp:4:4] [rq:4] [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.4  (abort with ^G)\n(mg@falco)1> net:ping(observer@falco).\npong\n(mg@falco)2> megaco_simple_mg:start().\n[{{deviceName,\"gateway_tt\"},\n  {error,{start_user,megaco_not_started}}},\n {{deviceName,\"gateway_tb\"},\n  {error,{start_user,megaco_not_started}}},\n {{deviceName,\"gateway_ut\"},\n  {error,{start_user,megaco_not_started}}},\n {{deviceName,\"gateway_ub\"},\n  {error,{start_user,megaco_not_started}}}]\n(mg@falco)3> megaco:start().\nok\n(mg@falco)4> megaco_simple_mg:start().\n[{{deviceName,\"gateway_tt\"},\n  {1,\n   {ok,[{'ActionReply',0,asn1_NOVALUE,asn1_NOVALUE,\n            [{serviceChangeReply,\n                 {'ServiceChangeReply',\n                     [{megaco_term_id,false,[\"root\"]}],\n                     {serviceChangeResParms,\n                         {'ServiceChangeResParm',\n                             {deviceName,\"controller\"},\n                             asn1_NOVALUE,asn1_NOVALUE,asn1_NOVALUE,\n                             asn1_NOVALUE}}}}]}]}}},\n {{deviceName,\"gateway_tb\"},\n  {1,\n   {ok,[{'ActionReply',0,asn1_NOVALUE,asn1_NOVALUE,\n            [{serviceChangeReply,\n                 {'ServiceChangeReply',\n                     [{megaco_term_id,false,[\"root\"]}],\n                     {serviceChangeResParms,\n                         {'ServiceChangeResParm',\n                             {deviceName,\"controller\"},\n                             asn1_NOVALUE,asn1_NOVALUE,asn1_NOVALUE,\n                             asn1_NOVALUE}}}}]}]}}},\n {{deviceName,\"gateway_ut\"},\n  {1,\n   {ok,[{'ActionReply',0,asn1_NOVALUE,asn1_NOVALUE,\n            [{serviceChangeReply,\n                 {'ServiceChangeReply',\n                     [{megaco_term_id,false,[\"root\"]}],\n                     {serviceChangeResParms,\n                         {'ServiceChangeResParm',\n                             {deviceName,\"controller\"},\n                             asn1_NOVALUE,asn1_NOVALUE,asn1_NOVALUE,\n                             asn1_NOVALUE}}}}]}]}}},\n {{deviceName,\"gateway_ub\"},\n  {1,\n   {ok,[{'ActionReply',0,asn1_NOVALUE,asn1_NOVALUE,\n            [{serviceChangeReply,\n                 {'ServiceChangeReply',\n                     [{megaco_term_id,false,[\"root\"]}],\n                     {serviceChangeResParms,\n                         {'ServiceChangeResParm',\n                             {deviceName,\"controller\"},\n                             asn1_NOVALUE,asn1_NOVALUE,\n                             asn1_NOVALUE,...}}}}]}]}}}]\n```\n\nThe `Megaco` adopted viewer looks like this, when we have clicked on the\n_\\[gateway_tt]_ actor name in order to only display the events regarding that\nactor:\n\n![The viewer adopted for Megaco](assets/megaco_tracer.png \"The viewer adopted for Megaco\")\n\nA pretty printed `Megaco` message looks like this:\n\n![A textual Megaco message](assets/megaco_filter.png \"A textual Megaco message\")\n\nAnd the corresponding internal form for the same `Megaco` message looks like\nthis:\n\n![The internal form of a Megaco message](assets/megaco_collector.png \"The internal form of a Megaco message\")","title":"Erlang trace of Megaco startup - Advanced examples","ref":"et_examples.html#erlang-trace-of-megaco-startup"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.0-rc.2"}}