// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ServerParams server params
//
// swagger:model server_params
type ServerParams struct {
	// agent addr
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	AgentAddr string `json:"agent-addr,omitempty"`

	// agent check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	AgentCheck string `json:"agent-check,omitempty"`

	// agent inter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	AgentInter *int64 `json:"agent-inter,omitempty"`

	// agent port
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	AgentPort *int64 `json:"agent-port,omitempty"`

	// agent send
	AgentSend string `json:"agent-send,omitempty"`

	// allow 0rtt
	Allow0rtt bool `json:"allow_0rtt,omitempty"`

	// alpn
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Alpn string `json:"alpn,omitempty"`

	// backup
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Backup string `json:"backup,omitempty"`

	// check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Check string `json:"check,omitempty"`

	// check send proxy
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	CheckSendProxy string `json:"check-send-proxy,omitempty"`

	// check sni
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CheckSni string `json:"check-sni,omitempty"`

	// check ssl
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	CheckSsl string `json:"check-ssl,omitempty"`

	// check alpn
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CheckAlpn string `json:"check_alpn,omitempty"`

	// check proto
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CheckProto string `json:"check_proto,omitempty"`

	// check via socks4
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	CheckViaSocks4 string `json:"check_via_socks4,omitempty"`

	// ciphers
	Ciphers string `json:"ciphers,omitempty"`

	// ciphersuites
	Ciphersuites string `json:"ciphersuites,omitempty"`

	// client sigalgs
	ClientSigalgs string `json:"client_sigalgs,omitempty"`

	// cookie
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Cookie string `json:"cookie,omitempty"`

	// crl file
	CrlFile string `json:"crl_file,omitempty"`

	// curves
	Curves string `json:"curves,omitempty"`

	// downinter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Downinter *int64 `json:"downinter,omitempty"`

	// error limit
	ErrorLimit int64 `json:"error_limit,omitempty"`

	// fall
	Fall *int64 `json:"fall,omitempty"`

	// fastinter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Fastinter *int64 `json:"fastinter,omitempty"`

	// force sslv3
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ForceSslv3 string `json:"force_sslv3,omitempty"`

	// force tlsv10
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ForceTlsv10 string `json:"force_tlsv10,omitempty"`

	// force tlsv11
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ForceTlsv11 string `json:"force_tlsv11,omitempty"`

	// force tlsv12
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ForceTlsv12 string `json:"force_tlsv12,omitempty"`

	// force tlsv13
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ForceTlsv13 string `json:"force_tlsv13,omitempty"`

	// guid
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	GUID string `json:"guid,omitempty"`

	// hash key
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	HashKey string `json:"hash_key,omitempty"`

	// health check address
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	HealthCheckAddress string `json:"health_check_address,omitempty"`

	// health check port
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	HealthCheckPort *int64 `json:"health_check_port,omitempty"`

	// init addr
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	InitAddr *string `json:"init-addr,omitempty"`

	// inter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Inter *int64 `json:"inter,omitempty"`

	// log bufsize
	LogBufsize *int64 `json:"log-bufsize,omitempty"`

	// log proto
	// Enum: ["legacy","octet-count"]
	// +kubebuilder:validation:Enum="legacy","octet-count";
	LogProto string `json:"log_proto,omitempty"`

	// maintenance
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Maintenance string `json:"maintenance,omitempty"`

	// max reuse
	MaxReuse *int64 `json:"max_reuse,omitempty"`

	// maxconn
	Maxconn *int64 `json:"maxconn,omitempty"`

	// maxqueue
	Maxqueue *int64 `json:"maxqueue,omitempty"`

	// minconn
	Minconn *int64 `json:"minconn,omitempty"`

	// namespace
	Namespace string `json:"namespace,omitempty"`

	// no sslv3
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NoSslv3 string `json:"no_sslv3,omitempty"`

	// no tlsv10
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NoTlsv10 string `json:"no_tlsv10,omitempty"`

	// no tlsv11
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NoTlsv11 string `json:"no_tlsv11,omitempty"`

	// no tlsv12
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NoTlsv12 string `json:"no_tlsv12,omitempty"`

	// no tlsv13
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NoTlsv13 string `json:"no_tlsv13,omitempty"`

	// no verifyhost
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NoVerifyhost string `json:"no_verifyhost,omitempty"`

	// npn
	Npn string `json:"npn,omitempty"`

	// observe
	// Enum: ["layer4","layer7"]
	// +kubebuilder:validation:Enum="layer4","layer7";
	Observe string `json:"observe,omitempty"`

	// on error
	// Enum: ["fastinter","fail-check","sudden-death","mark-down"]
	// +kubebuilder:validation:Enum="fastinter","fail-check","sudden-death","mark-down";
	OnError string `json:"on-error,omitempty"`

	// on marked down
	// Enum: ["shutdown-sessions"]
	// +kubebuilder:validation:Enum="shutdown-sessions";
	OnMarkedDown string `json:"on-marked-down,omitempty"`

	// on marked up
	// Enum: ["shutdown-backup-sessions"]
	// +kubebuilder:validation:Enum="shutdown-backup-sessions";
	OnMarkedUp string `json:"on-marked-up,omitempty"`

	// pool conn name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	PoolConnName string `json:"pool_conn_name,omitempty"`

	// pool low conn
	PoolLowConn *int64 `json:"pool_low_conn,omitempty"`

	// pool max conn
	PoolMaxConn *int64 `json:"pool_max_conn,omitempty"`

	// pool purge delay
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	PoolPurgeDelay *int64 `json:"pool_purge_delay,omitempty"`

	// proto
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Proto string `json:"proto,omitempty"`

	// proxy v2 options
	ProxyV2Options []string `json:"proxy-v2-options,omitempty"`

	// redir
	Redir string `json:"redir,omitempty"`

	// resolve net
	// Pattern: ^([A-Za-z0-9.:/]+)(,[A-Za-z0-9.:/]+)*$
	// +kubebuilder:validation:Pattern=`^([A-Za-z0-9.:/]+)(,[A-Za-z0-9.:/]+)*$`
	ResolveNet string `json:"resolve-net,omitempty"`

	// resolve prefer
	// Enum: ["ipv4","ipv6"]
	// +kubebuilder:validation:Enum="ipv4","ipv6";
	ResolvePrefer string `json:"resolve-prefer,omitempty"`

	// resolve opts
	// Pattern: ^(allow-dup-ip|ignore-weight|prevent-dup-ip)(,(allow-dup-ip|ignore-weight|prevent-dup-ip))*$
	// +kubebuilder:validation:Pattern=`^(allow-dup-ip|ignore-weight|prevent-dup-ip)(,(allow-dup-ip|ignore-weight|prevent-dup-ip))*$`
	ResolveOpts string `json:"resolve_opts,omitempty"`

	// resolvers
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Resolvers string `json:"resolvers,omitempty"`

	// rise
	Rise *int64 `json:"rise,omitempty"`

	// send proxy
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SendProxy string `json:"send-proxy,omitempty"`

	// send proxy v2
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SendProxyV2 string `json:"send-proxy-v2,omitempty"`

	// send proxy v2 ssl
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SendProxyV2Ssl string `json:"send_proxy_v2_ssl,omitempty"`

	// send proxy v2 ssl cn
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SendProxyV2SslCn string `json:"send_proxy_v2_ssl_cn,omitempty"`

	// set proxy v2 tlv fmt
	SetProxyV2TlvFmt *ServerParamsSetProxyV2TlvFmt `json:"set-proxy-v2-tlv-fmt,omitempty"`

	// shard
	Shard int64 `json:"shard,omitempty"`

	// sigalgs
	Sigalgs string `json:"sigalgs,omitempty"`

	// slowstart
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Slowstart *int64 `json:"slowstart,omitempty"`

	// sni
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Sni string `json:"sni,omitempty"`

	// socks4
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Socks4 string `json:"socks4,omitempty"`

	// source
	Source string `json:"source,omitempty"`

	// ssl
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Ssl string `json:"ssl,omitempty"`

	// ssl cafile
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SslCafile string `json:"ssl_cafile,omitempty"`

	// ssl certificate
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SslCertificate string `json:"ssl_certificate,omitempty"`

	// ssl max ver
	// Enum: ["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]
	// +kubebuilder:validation:Enum="SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3";
	SslMaxVer string `json:"ssl_max_ver,omitempty"`

	// ssl min ver
	// Enum: ["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]
	// +kubebuilder:validation:Enum="SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3";
	SslMinVer string `json:"ssl_min_ver,omitempty"`

	// ssl reuse
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SslReuse string `json:"ssl_reuse,omitempty"`

	// stick
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Stick string `json:"stick,omitempty"`

	// tcp ut
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TCPUt *int64 `json:"tcp_ut,omitempty"`

	// tfo
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Tfo string `json:"tfo,omitempty"`

	// tls tickets
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	TLSTickets string `json:"tls_tickets,omitempty"`

	// track
	Track string `json:"track,omitempty"`

	// verify
	// Enum: ["none","required"]
	// +kubebuilder:validation:Enum="none","required";
	Verify string `json:"verify,omitempty"`

	// verifyhost
	Verifyhost string `json:"verifyhost,omitempty"`

	// weight
	Weight *int64 `json:"weight,omitempty"`

	// ws
	// Enum: ["auto","h1","h2"]
	// +kubebuilder:validation:Enum="auto","h1","h2";
	Ws string `json:"ws,omitempty"`
}

// Validate validates this server params
func (m *ServerParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAgentAddr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentInter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentPort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAlpn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckSendProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckSni(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckSsl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckAlpn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckProto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckViaSocks4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCookie(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDowninter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFastinter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceSslv3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv10(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv11(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv12(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv13(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthCheckAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthCheckPort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitAddr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogProto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaintenance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoSslv3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv10(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv11(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv12(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv13(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoVerifyhost(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObserve(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnMarkedDown(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnMarkedUp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePoolConnName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePoolPurgeDelay(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyV2Options(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResolveNet(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResolvePrefer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResolveOpts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResolvers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxyV2(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxyV2Ssl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxyV2SslCn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetProxyV2TlvFmt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSlowstart(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSni(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSocks4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSsl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslCafile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslMaxVer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslMinVer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslReuse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStick(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPUt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLSTickets(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerify(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServerParams) validateAgentAddr(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentAddr) { // not required
		return nil
	}

	if err := validate.Pattern("agent-addr", "body", m.AgentAddr, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeAgentCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeAgentCheckPropEnum = append(serverParamsTypeAgentCheckPropEnum, v)
	}
}

const (

	// ServerParamsAgentCheckEnabled captures enum value "enabled"
	ServerParamsAgentCheckEnabled string = "enabled"

	// ServerParamsAgentCheckDisabled captures enum value "disabled"
	ServerParamsAgentCheckDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateAgentCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeAgentCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateAgentCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateAgentCheckEnum("agent-check", "body", m.AgentCheck); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateAgentInter(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentInter) { // not required
		return nil
	}

	if err := validate.MinimumInt("agent-inter", "body", *m.AgentInter, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateAgentPort(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentPort) { // not required
		return nil
	}

	if err := validate.MinimumInt("agent-port", "body", *m.AgentPort, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("agent-port", "body", *m.AgentPort, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateAlpn(formats strfmt.Registry) error {
	if swag.IsZero(m.Alpn) { // not required
		return nil
	}

	if err := validate.Pattern("alpn", "body", m.Alpn, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeBackupPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeBackupPropEnum = append(serverParamsTypeBackupPropEnum, v)
	}
}

const (

	// ServerParamsBackupEnabled captures enum value "enabled"
	ServerParamsBackupEnabled string = "enabled"

	// ServerParamsBackupDisabled captures enum value "disabled"
	ServerParamsBackupDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateBackupEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeBackupPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.Backup) { // not required
		return nil
	}

	// value enum
	if err := m.validateBackupEnum("backup", "body", m.Backup); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeCheckPropEnum = append(serverParamsTypeCheckPropEnum, v)
	}
}

const (

	// ServerParamsCheckEnabled captures enum value "enabled"
	ServerParamsCheckEnabled string = "enabled"

	// ServerParamsCheckDisabled captures enum value "disabled"
	ServerParamsCheckDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.Check) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckEnum("check", "body", m.Check); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeCheckSendProxyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeCheckSendProxyPropEnum = append(serverParamsTypeCheckSendProxyPropEnum, v)
	}
}

const (

	// ServerParamsCheckSendProxyEnabled captures enum value "enabled"
	ServerParamsCheckSendProxyEnabled string = "enabled"

	// ServerParamsCheckSendProxyDisabled captures enum value "disabled"
	ServerParamsCheckSendProxyDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateCheckSendProxyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeCheckSendProxyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateCheckSendProxy(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckSendProxy) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckSendProxyEnum("check-send-proxy", "body", m.CheckSendProxy); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateCheckSni(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckSni) { // not required
		return nil
	}

	if err := validate.Pattern("check-sni", "body", m.CheckSni, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeCheckSslPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeCheckSslPropEnum = append(serverParamsTypeCheckSslPropEnum, v)
	}
}

const (

	// ServerParamsCheckSslEnabled captures enum value "enabled"
	ServerParamsCheckSslEnabled string = "enabled"

	// ServerParamsCheckSslDisabled captures enum value "disabled"
	ServerParamsCheckSslDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateCheckSslEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeCheckSslPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateCheckSsl(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckSsl) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckSslEnum("check-ssl", "body", m.CheckSsl); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateCheckAlpn(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckAlpn) { // not required
		return nil
	}

	if err := validate.Pattern("check_alpn", "body", m.CheckAlpn, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateCheckProto(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckProto) { // not required
		return nil
	}

	if err := validate.Pattern("check_proto", "body", m.CheckProto, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeCheckViaSocks4PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeCheckViaSocks4PropEnum = append(serverParamsTypeCheckViaSocks4PropEnum, v)
	}
}

const (

	// ServerParamsCheckViaSocks4Enabled captures enum value "enabled"
	ServerParamsCheckViaSocks4Enabled string = "enabled"

	// ServerParamsCheckViaSocks4Disabled captures enum value "disabled"
	ServerParamsCheckViaSocks4Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateCheckViaSocks4Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeCheckViaSocks4PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateCheckViaSocks4(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckViaSocks4) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckViaSocks4Enum("check_via_socks4", "body", m.CheckViaSocks4); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateCookie(formats strfmt.Registry) error {
	if swag.IsZero(m.Cookie) { // not required
		return nil
	}

	if err := validate.Pattern("cookie", "body", m.Cookie, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateDowninter(formats strfmt.Registry) error {
	if swag.IsZero(m.Downinter) { // not required
		return nil
	}

	if err := validate.MinimumInt("downinter", "body", *m.Downinter, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateFastinter(formats strfmt.Registry) error {
	if swag.IsZero(m.Fastinter) { // not required
		return nil
	}

	if err := validate.MinimumInt("fastinter", "body", *m.Fastinter, 0, false); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeForceSslv3PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeForceSslv3PropEnum = append(serverParamsTypeForceSslv3PropEnum, v)
	}
}

const (

	// ServerParamsForceSslv3Enabled captures enum value "enabled"
	ServerParamsForceSslv3Enabled string = "enabled"

	// ServerParamsForceSslv3Disabled captures enum value "disabled"
	ServerParamsForceSslv3Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateForceSslv3Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeForceSslv3PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateForceSslv3(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceSslv3) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceSslv3Enum("force_sslv3", "body", m.ForceSslv3); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeForceTlsv10PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeForceTlsv10PropEnum = append(serverParamsTypeForceTlsv10PropEnum, v)
	}
}

const (

	// ServerParamsForceTlsv10Enabled captures enum value "enabled"
	ServerParamsForceTlsv10Enabled string = "enabled"

	// ServerParamsForceTlsv10Disabled captures enum value "disabled"
	ServerParamsForceTlsv10Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateForceTlsv10Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeForceTlsv10PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateForceTlsv10(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv10) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv10Enum("force_tlsv10", "body", m.ForceTlsv10); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeForceTlsv11PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeForceTlsv11PropEnum = append(serverParamsTypeForceTlsv11PropEnum, v)
	}
}

const (

	// ServerParamsForceTlsv11Enabled captures enum value "enabled"
	ServerParamsForceTlsv11Enabled string = "enabled"

	// ServerParamsForceTlsv11Disabled captures enum value "disabled"
	ServerParamsForceTlsv11Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateForceTlsv11Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeForceTlsv11PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateForceTlsv11(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv11) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv11Enum("force_tlsv11", "body", m.ForceTlsv11); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeForceTlsv12PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeForceTlsv12PropEnum = append(serverParamsTypeForceTlsv12PropEnum, v)
	}
}

const (

	// ServerParamsForceTlsv12Enabled captures enum value "enabled"
	ServerParamsForceTlsv12Enabled string = "enabled"

	// ServerParamsForceTlsv12Disabled captures enum value "disabled"
	ServerParamsForceTlsv12Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateForceTlsv12Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeForceTlsv12PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateForceTlsv12(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv12) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv12Enum("force_tlsv12", "body", m.ForceTlsv12); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeForceTlsv13PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeForceTlsv13PropEnum = append(serverParamsTypeForceTlsv13PropEnum, v)
	}
}

const (

	// ServerParamsForceTlsv13Enabled captures enum value "enabled"
	ServerParamsForceTlsv13Enabled string = "enabled"

	// ServerParamsForceTlsv13Disabled captures enum value "disabled"
	ServerParamsForceTlsv13Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateForceTlsv13Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeForceTlsv13PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateForceTlsv13(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv13) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv13Enum("force_tlsv13", "body", m.ForceTlsv13); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateGUID(formats strfmt.Registry) error {
	if swag.IsZero(m.GUID) { // not required
		return nil
	}

	if err := validate.Pattern("guid", "body", m.GUID, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateHashKey(formats strfmt.Registry) error {
	if swag.IsZero(m.HashKey) { // not required
		return nil
	}

	if err := validate.Pattern("hash_key", "body", m.HashKey, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateHealthCheckAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.HealthCheckAddress) { // not required
		return nil
	}

	if err := validate.Pattern("health_check_address", "body", m.HealthCheckAddress, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateHealthCheckPort(formats strfmt.Registry) error {
	if swag.IsZero(m.HealthCheckPort) { // not required
		return nil
	}

	if err := validate.MinimumInt("health_check_port", "body", *m.HealthCheckPort, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("health_check_port", "body", *m.HealthCheckPort, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateInitAddr(formats strfmt.Registry) error {
	if swag.IsZero(m.InitAddr) { // not required
		return nil
	}

	if err := validate.Pattern("init-addr", "body", *m.InitAddr, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateInter(formats strfmt.Registry) error {
	if swag.IsZero(m.Inter) { // not required
		return nil
	}

	if err := validate.MinimumInt("inter", "body", *m.Inter, 0, false); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeLogProtoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy","octet-count"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeLogProtoPropEnum = append(serverParamsTypeLogProtoPropEnum, v)
	}
}

const (

	// ServerParamsLogProtoLegacy captures enum value "legacy"
	ServerParamsLogProtoLegacy string = "legacy"

	// ServerParamsLogProtoOctetDashCount captures enum value "octet-count"
	ServerParamsLogProtoOctetDashCount string = "octet-count"
)

// prop value enum
func (m *ServerParams) validateLogProtoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeLogProtoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateLogProto(formats strfmt.Registry) error {
	if swag.IsZero(m.LogProto) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogProtoEnum("log_proto", "body", m.LogProto); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeMaintenancePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeMaintenancePropEnum = append(serverParamsTypeMaintenancePropEnum, v)
	}
}

const (

	// ServerParamsMaintenanceEnabled captures enum value "enabled"
	ServerParamsMaintenanceEnabled string = "enabled"

	// ServerParamsMaintenanceDisabled captures enum value "disabled"
	ServerParamsMaintenanceDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateMaintenanceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeMaintenancePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateMaintenance(formats strfmt.Registry) error {
	if swag.IsZero(m.Maintenance) { // not required
		return nil
	}

	// value enum
	if err := m.validateMaintenanceEnum("maintenance", "body", m.Maintenance); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeNoSslv3PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeNoSslv3PropEnum = append(serverParamsTypeNoSslv3PropEnum, v)
	}
}

const (

	// ServerParamsNoSslv3Enabled captures enum value "enabled"
	ServerParamsNoSslv3Enabled string = "enabled"

	// ServerParamsNoSslv3Disabled captures enum value "disabled"
	ServerParamsNoSslv3Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateNoSslv3Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeNoSslv3PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateNoSslv3(formats strfmt.Registry) error {
	if swag.IsZero(m.NoSslv3) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoSslv3Enum("no_sslv3", "body", m.NoSslv3); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeNoTlsv10PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeNoTlsv10PropEnum = append(serverParamsTypeNoTlsv10PropEnum, v)
	}
}

const (

	// ServerParamsNoTlsv10Enabled captures enum value "enabled"
	ServerParamsNoTlsv10Enabled string = "enabled"

	// ServerParamsNoTlsv10Disabled captures enum value "disabled"
	ServerParamsNoTlsv10Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateNoTlsv10Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeNoTlsv10PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateNoTlsv10(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv10) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv10Enum("no_tlsv10", "body", m.NoTlsv10); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeNoTlsv11PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeNoTlsv11PropEnum = append(serverParamsTypeNoTlsv11PropEnum, v)
	}
}

const (

	// ServerParamsNoTlsv11Enabled captures enum value "enabled"
	ServerParamsNoTlsv11Enabled string = "enabled"

	// ServerParamsNoTlsv11Disabled captures enum value "disabled"
	ServerParamsNoTlsv11Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateNoTlsv11Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeNoTlsv11PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateNoTlsv11(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv11) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv11Enum("no_tlsv11", "body", m.NoTlsv11); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeNoTlsv12PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeNoTlsv12PropEnum = append(serverParamsTypeNoTlsv12PropEnum, v)
	}
}

const (

	// ServerParamsNoTlsv12Enabled captures enum value "enabled"
	ServerParamsNoTlsv12Enabled string = "enabled"

	// ServerParamsNoTlsv12Disabled captures enum value "disabled"
	ServerParamsNoTlsv12Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateNoTlsv12Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeNoTlsv12PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateNoTlsv12(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv12) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv12Enum("no_tlsv12", "body", m.NoTlsv12); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeNoTlsv13PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeNoTlsv13PropEnum = append(serverParamsTypeNoTlsv13PropEnum, v)
	}
}

const (

	// ServerParamsNoTlsv13Enabled captures enum value "enabled"
	ServerParamsNoTlsv13Enabled string = "enabled"

	// ServerParamsNoTlsv13Disabled captures enum value "disabled"
	ServerParamsNoTlsv13Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateNoTlsv13Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeNoTlsv13PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateNoTlsv13(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv13) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv13Enum("no_tlsv13", "body", m.NoTlsv13); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeNoVerifyhostPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeNoVerifyhostPropEnum = append(serverParamsTypeNoVerifyhostPropEnum, v)
	}
}

const (

	// ServerParamsNoVerifyhostEnabled captures enum value "enabled"
	ServerParamsNoVerifyhostEnabled string = "enabled"

	// ServerParamsNoVerifyhostDisabled captures enum value "disabled"
	ServerParamsNoVerifyhostDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateNoVerifyhostEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeNoVerifyhostPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateNoVerifyhost(formats strfmt.Registry) error {
	if swag.IsZero(m.NoVerifyhost) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoVerifyhostEnum("no_verifyhost", "body", m.NoVerifyhost); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeObservePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["layer4","layer7"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeObservePropEnum = append(serverParamsTypeObservePropEnum, v)
	}
}

const (

	// ServerParamsObserveLayer4 captures enum value "layer4"
	ServerParamsObserveLayer4 string = "layer4"

	// ServerParamsObserveLayer7 captures enum value "layer7"
	ServerParamsObserveLayer7 string = "layer7"
)

// prop value enum
func (m *ServerParams) validateObserveEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeObservePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateObserve(formats strfmt.Registry) error {
	if swag.IsZero(m.Observe) { // not required
		return nil
	}

	// value enum
	if err := m.validateObserveEnum("observe", "body", m.Observe); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeOnErrorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fastinter","fail-check","sudden-death","mark-down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeOnErrorPropEnum = append(serverParamsTypeOnErrorPropEnum, v)
	}
}

const (

	// ServerParamsOnErrorFastinter captures enum value "fastinter"
	ServerParamsOnErrorFastinter string = "fastinter"

	// ServerParamsOnErrorFailDashCheck captures enum value "fail-check"
	ServerParamsOnErrorFailDashCheck string = "fail-check"

	// ServerParamsOnErrorSuddenDashDeath captures enum value "sudden-death"
	ServerParamsOnErrorSuddenDashDeath string = "sudden-death"

	// ServerParamsOnErrorMarkDashDown captures enum value "mark-down"
	ServerParamsOnErrorMarkDashDown string = "mark-down"
)

// prop value enum
func (m *ServerParams) validateOnErrorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeOnErrorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateOnError(formats strfmt.Registry) error {
	if swag.IsZero(m.OnError) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnErrorEnum("on-error", "body", m.OnError); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeOnMarkedDownPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown-sessions"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeOnMarkedDownPropEnum = append(serverParamsTypeOnMarkedDownPropEnum, v)
	}
}

const (

	// ServerParamsOnMarkedDownShutdownDashSessions captures enum value "shutdown-sessions"
	ServerParamsOnMarkedDownShutdownDashSessions string = "shutdown-sessions"
)

// prop value enum
func (m *ServerParams) validateOnMarkedDownEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeOnMarkedDownPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateOnMarkedDown(formats strfmt.Registry) error {
	if swag.IsZero(m.OnMarkedDown) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnMarkedDownEnum("on-marked-down", "body", m.OnMarkedDown); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeOnMarkedUpPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown-backup-sessions"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeOnMarkedUpPropEnum = append(serverParamsTypeOnMarkedUpPropEnum, v)
	}
}

const (

	// ServerParamsOnMarkedUpShutdownDashBackupDashSessions captures enum value "shutdown-backup-sessions"
	ServerParamsOnMarkedUpShutdownDashBackupDashSessions string = "shutdown-backup-sessions"
)

// prop value enum
func (m *ServerParams) validateOnMarkedUpEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeOnMarkedUpPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateOnMarkedUp(formats strfmt.Registry) error {
	if swag.IsZero(m.OnMarkedUp) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnMarkedUpEnum("on-marked-up", "body", m.OnMarkedUp); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validatePoolConnName(formats strfmt.Registry) error {
	if swag.IsZero(m.PoolConnName) { // not required
		return nil
	}

	if err := validate.Pattern("pool_conn_name", "body", m.PoolConnName, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validatePoolPurgeDelay(formats strfmt.Registry) error {
	if swag.IsZero(m.PoolPurgeDelay) { // not required
		return nil
	}

	if err := validate.MinimumInt("pool_purge_delay", "body", *m.PoolPurgeDelay, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateProto(formats strfmt.Registry) error {
	if swag.IsZero(m.Proto) { // not required
		return nil
	}

	if err := validate.Pattern("proto", "body", m.Proto, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsProxyV2OptionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["authority","cert-cn","cert-key","cert-sig","crc32c","ssl","ssl-cipher","unique-id"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsProxyV2OptionsItemsEnum = append(serverParamsProxyV2OptionsItemsEnum, v)
	}
}

func (m *ServerParams) validateProxyV2OptionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsProxyV2OptionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateProxyV2Options(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyV2Options) { // not required
		return nil
	}

	for i := 0; i < len(m.ProxyV2Options); i++ {

		// value enum
		if err := m.validateProxyV2OptionsItemsEnum("proxy-v2-options"+"."+strconv.Itoa(i), "body", m.ProxyV2Options[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *ServerParams) validateResolveNet(formats strfmt.Registry) error {
	if swag.IsZero(m.ResolveNet) { // not required
		return nil
	}

	if err := validate.Pattern("resolve-net", "body", m.ResolveNet, `^([A-Za-z0-9.:/]+)(,[A-Za-z0-9.:/]+)*$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeResolvePreferPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ipv4","ipv6"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeResolvePreferPropEnum = append(serverParamsTypeResolvePreferPropEnum, v)
	}
}

const (

	// ServerParamsResolvePreferIPV4 captures enum value "ipv4"
	ServerParamsResolvePreferIPV4 string = "ipv4"

	// ServerParamsResolvePreferIPV6 captures enum value "ipv6"
	ServerParamsResolvePreferIPV6 string = "ipv6"
)

// prop value enum
func (m *ServerParams) validateResolvePreferEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeResolvePreferPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateResolvePrefer(formats strfmt.Registry) error {
	if swag.IsZero(m.ResolvePrefer) { // not required
		return nil
	}

	// value enum
	if err := m.validateResolvePreferEnum("resolve-prefer", "body", m.ResolvePrefer); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateResolveOpts(formats strfmt.Registry) error {
	if swag.IsZero(m.ResolveOpts) { // not required
		return nil
	}

	if err := validate.Pattern("resolve_opts", "body", m.ResolveOpts, `^(allow-dup-ip|ignore-weight|prevent-dup-ip)(,(allow-dup-ip|ignore-weight|prevent-dup-ip))*$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateResolvers(formats strfmt.Registry) error {
	if swag.IsZero(m.Resolvers) { // not required
		return nil
	}

	if err := validate.Pattern("resolvers", "body", m.Resolvers, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSendProxyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSendProxyPropEnum = append(serverParamsTypeSendProxyPropEnum, v)
	}
}

const (

	// ServerParamsSendProxyEnabled captures enum value "enabled"
	ServerParamsSendProxyEnabled string = "enabled"

	// ServerParamsSendProxyDisabled captures enum value "disabled"
	ServerParamsSendProxyDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateSendProxyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSendProxyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSendProxy(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxy) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyEnum("send-proxy", "body", m.SendProxy); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSendProxyV2PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSendProxyV2PropEnum = append(serverParamsTypeSendProxyV2PropEnum, v)
	}
}

const (

	// ServerParamsSendProxyV2Enabled captures enum value "enabled"
	ServerParamsSendProxyV2Enabled string = "enabled"

	// ServerParamsSendProxyV2Disabled captures enum value "disabled"
	ServerParamsSendProxyV2Disabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateSendProxyV2Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSendProxyV2PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSendProxyV2(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxyV2) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyV2Enum("send-proxy-v2", "body", m.SendProxyV2); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSendProxyV2SslPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSendProxyV2SslPropEnum = append(serverParamsTypeSendProxyV2SslPropEnum, v)
	}
}

const (

	// ServerParamsSendProxyV2SslEnabled captures enum value "enabled"
	ServerParamsSendProxyV2SslEnabled string = "enabled"

	// ServerParamsSendProxyV2SslDisabled captures enum value "disabled"
	ServerParamsSendProxyV2SslDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateSendProxyV2SslEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSendProxyV2SslPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSendProxyV2Ssl(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxyV2Ssl) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyV2SslEnum("send_proxy_v2_ssl", "body", m.SendProxyV2Ssl); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSendProxyV2SslCnPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSendProxyV2SslCnPropEnum = append(serverParamsTypeSendProxyV2SslCnPropEnum, v)
	}
}

const (

	// ServerParamsSendProxyV2SslCnEnabled captures enum value "enabled"
	ServerParamsSendProxyV2SslCnEnabled string = "enabled"

	// ServerParamsSendProxyV2SslCnDisabled captures enum value "disabled"
	ServerParamsSendProxyV2SslCnDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateSendProxyV2SslCnEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSendProxyV2SslCnPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSendProxyV2SslCn(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxyV2SslCn) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyV2SslCnEnum("send_proxy_v2_ssl_cn", "body", m.SendProxyV2SslCn); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateSetProxyV2TlvFmt(formats strfmt.Registry) error {
	if swag.IsZero(m.SetProxyV2TlvFmt) { // not required
		return nil
	}

	if m.SetProxyV2TlvFmt != nil {
		if err := m.SetProxyV2TlvFmt.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("set-proxy-v2-tlv-fmt")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("set-proxy-v2-tlv-fmt")
			}
			return err
		}
	}

	return nil
}

func (m *ServerParams) validateSlowstart(formats strfmt.Registry) error {
	if swag.IsZero(m.Slowstart) { // not required
		return nil
	}

	if err := validate.MinimumInt("slowstart", "body", *m.Slowstart, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateSni(formats strfmt.Registry) error {
	if swag.IsZero(m.Sni) { // not required
		return nil
	}

	if err := validate.Pattern("sni", "body", m.Sni, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateSocks4(formats strfmt.Registry) error {
	if swag.IsZero(m.Socks4) { // not required
		return nil
	}

	if err := validate.Pattern("socks4", "body", m.Socks4, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSslPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSslPropEnum = append(serverParamsTypeSslPropEnum, v)
	}
}

const (

	// ServerParamsSslEnabled captures enum value "enabled"
	ServerParamsSslEnabled string = "enabled"

	// ServerParamsSslDisabled captures enum value "disabled"
	ServerParamsSslDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateSslEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSslPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSsl(formats strfmt.Registry) error {
	if swag.IsZero(m.Ssl) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslEnum("ssl", "body", m.Ssl); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateSslCafile(formats strfmt.Registry) error {
	if swag.IsZero(m.SslCafile) { // not required
		return nil
	}

	if err := validate.Pattern("ssl_cafile", "body", m.SslCafile, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateSslCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.SslCertificate) { // not required
		return nil
	}

	if err := validate.Pattern("ssl_certificate", "body", m.SslCertificate, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSslMaxVerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSslMaxVerPropEnum = append(serverParamsTypeSslMaxVerPropEnum, v)
	}
}

const (

	// ServerParamsSslMaxVerSSLv3 captures enum value "SSLv3"
	ServerParamsSslMaxVerSSLv3 string = "SSLv3"

	// ServerParamsSslMaxVerTLSv1Dot0 captures enum value "TLSv1.0"
	ServerParamsSslMaxVerTLSv1Dot0 string = "TLSv1.0"

	// ServerParamsSslMaxVerTLSv1Dot1 captures enum value "TLSv1.1"
	ServerParamsSslMaxVerTLSv1Dot1 string = "TLSv1.1"

	// ServerParamsSslMaxVerTLSv1Dot2 captures enum value "TLSv1.2"
	ServerParamsSslMaxVerTLSv1Dot2 string = "TLSv1.2"

	// ServerParamsSslMaxVerTLSv1Dot3 captures enum value "TLSv1.3"
	ServerParamsSslMaxVerTLSv1Dot3 string = "TLSv1.3"
)

// prop value enum
func (m *ServerParams) validateSslMaxVerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSslMaxVerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSslMaxVer(formats strfmt.Registry) error {
	if swag.IsZero(m.SslMaxVer) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslMaxVerEnum("ssl_max_ver", "body", m.SslMaxVer); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSslMinVerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSslMinVerPropEnum = append(serverParamsTypeSslMinVerPropEnum, v)
	}
}

const (

	// ServerParamsSslMinVerSSLv3 captures enum value "SSLv3"
	ServerParamsSslMinVerSSLv3 string = "SSLv3"

	// ServerParamsSslMinVerTLSv1Dot0 captures enum value "TLSv1.0"
	ServerParamsSslMinVerTLSv1Dot0 string = "TLSv1.0"

	// ServerParamsSslMinVerTLSv1Dot1 captures enum value "TLSv1.1"
	ServerParamsSslMinVerTLSv1Dot1 string = "TLSv1.1"

	// ServerParamsSslMinVerTLSv1Dot2 captures enum value "TLSv1.2"
	ServerParamsSslMinVerTLSv1Dot2 string = "TLSv1.2"

	// ServerParamsSslMinVerTLSv1Dot3 captures enum value "TLSv1.3"
	ServerParamsSslMinVerTLSv1Dot3 string = "TLSv1.3"
)

// prop value enum
func (m *ServerParams) validateSslMinVerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSslMinVerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSslMinVer(formats strfmt.Registry) error {
	if swag.IsZero(m.SslMinVer) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslMinVerEnum("ssl_min_ver", "body", m.SslMinVer); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeSslReusePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeSslReusePropEnum = append(serverParamsTypeSslReusePropEnum, v)
	}
}

const (

	// ServerParamsSslReuseEnabled captures enum value "enabled"
	ServerParamsSslReuseEnabled string = "enabled"

	// ServerParamsSslReuseDisabled captures enum value "disabled"
	ServerParamsSslReuseDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateSslReuseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeSslReusePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateSslReuse(formats strfmt.Registry) error {
	if swag.IsZero(m.SslReuse) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslReuseEnum("ssl_reuse", "body", m.SslReuse); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeStickPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeStickPropEnum = append(serverParamsTypeStickPropEnum, v)
	}
}

const (

	// ServerParamsStickEnabled captures enum value "enabled"
	ServerParamsStickEnabled string = "enabled"

	// ServerParamsStickDisabled captures enum value "disabled"
	ServerParamsStickDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateStickEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeStickPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateStick(formats strfmt.Registry) error {
	if swag.IsZero(m.Stick) { // not required
		return nil
	}

	// value enum
	if err := m.validateStickEnum("stick", "body", m.Stick); err != nil {
		return err
	}

	return nil
}

func (m *ServerParams) validateTCPUt(formats strfmt.Registry) error {
	if swag.IsZero(m.TCPUt) { // not required
		return nil
	}

	if err := validate.MinimumInt("tcp_ut", "body", *m.TCPUt, 0, false); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeTfoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeTfoPropEnum = append(serverParamsTypeTfoPropEnum, v)
	}
}

const (

	// ServerParamsTfoEnabled captures enum value "enabled"
	ServerParamsTfoEnabled string = "enabled"

	// ServerParamsTfoDisabled captures enum value "disabled"
	ServerParamsTfoDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateTfoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeTfoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateTfo(formats strfmt.Registry) error {
	if swag.IsZero(m.Tfo) { // not required
		return nil
	}

	// value enum
	if err := m.validateTfoEnum("tfo", "body", m.Tfo); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeTLSTicketsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeTLSTicketsPropEnum = append(serverParamsTypeTLSTicketsPropEnum, v)
	}
}

const (

	// ServerParamsTLSTicketsEnabled captures enum value "enabled"
	ServerParamsTLSTicketsEnabled string = "enabled"

	// ServerParamsTLSTicketsDisabled captures enum value "disabled"
	ServerParamsTLSTicketsDisabled string = "disabled"
)

// prop value enum
func (m *ServerParams) validateTLSTicketsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeTLSTicketsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateTLSTickets(formats strfmt.Registry) error {
	if swag.IsZero(m.TLSTickets) { // not required
		return nil
	}

	// value enum
	if err := m.validateTLSTicketsEnum("tls_tickets", "body", m.TLSTickets); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeVerifyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeVerifyPropEnum = append(serverParamsTypeVerifyPropEnum, v)
	}
}

const (

	// ServerParamsVerifyNone captures enum value "none"
	ServerParamsVerifyNone string = "none"

	// ServerParamsVerifyRequired captures enum value "required"
	ServerParamsVerifyRequired string = "required"
)

// prop value enum
func (m *ServerParams) validateVerifyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeVerifyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateVerify(formats strfmt.Registry) error {
	if swag.IsZero(m.Verify) { // not required
		return nil
	}

	// value enum
	if err := m.validateVerifyEnum("verify", "body", m.Verify); err != nil {
		return err
	}

	return nil
}

var serverParamsTypeWsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["auto","h1","h2"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		serverParamsTypeWsPropEnum = append(serverParamsTypeWsPropEnum, v)
	}
}

const (

	// ServerParamsWsAuto captures enum value "auto"
	ServerParamsWsAuto string = "auto"

	// ServerParamsWsH1 captures enum value "h1"
	ServerParamsWsH1 string = "h1"

	// ServerParamsWsH2 captures enum value "h2"
	ServerParamsWsH2 string = "h2"
)

// prop value enum
func (m *ServerParams) validateWsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, serverParamsTypeWsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ServerParams) validateWs(formats strfmt.Registry) error {
	if swag.IsZero(m.Ws) { // not required
		return nil
	}

	// value enum
	if err := m.validateWsEnum("ws", "body", m.Ws); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this server params based on the context it is used
func (m *ServerParams) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetProxyV2TlvFmt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServerParams) contextValidateSetProxyV2TlvFmt(ctx context.Context, formats strfmt.Registry) error {

	if m.SetProxyV2TlvFmt != nil {

		if swag.IsZero(m.SetProxyV2TlvFmt) { // not required
			return nil
		}

		if err := m.SetProxyV2TlvFmt.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("set-proxy-v2-tlv-fmt")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("set-proxy-v2-tlv-fmt")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServerParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServerParams) UnmarshalBinary(b []byte) error {
	var res ServerParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ServerParamsSetProxyV2TlvFmt server params set proxy v2 tlv fmt
//
// swagger:model ServerParamsSetProxyV2TlvFmt
type ServerParamsSetProxyV2TlvFmt struct {

	// id
	// Required: true
	ID *string `json:"id"`

	// value
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this server params set proxy v2 tlv fmt
func (m *ServerParamsSetProxyV2TlvFmt) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServerParamsSetProxyV2TlvFmt) validateID(formats strfmt.Registry) error {

	if err := validate.Required("set-proxy-v2-tlv-fmt"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ServerParamsSetProxyV2TlvFmt) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("set-proxy-v2-tlv-fmt"+"."+"value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this server params set proxy v2 tlv fmt based on context it is used
func (m *ServerParamsSetProxyV2TlvFmt) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ServerParamsSetProxyV2TlvFmt) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServerParamsSetProxyV2TlvFmt) UnmarshalBinary(b []byte) error {
	var res ServerParamsSetProxyV2TlvFmt
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
