/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class ClassListBuilder {
    public static Class[] getClassesInPackage(String pckgname) {
        File directory = ClassListBuilder.getPackageDirectory(pckgname);
        if (!directory.exists()) {
            throw new IllegalArgumentException("Could not get directory resource for package " + pckgname + ".");
        }
        return ClassListBuilder.getClassesInPackage(pckgname, directory);
    }

    private static Class[] getClassesInPackage(String pckgname, File directory) {
        ArrayList classes = new ArrayList();
        String[] stringArray = directory.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename.endsWith(".class")) {
                String classname = ClassListBuilder.buildClassname(pckgname, filename);
                try {
                    classes.add(Class.forName(classname));
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Error creating class " + classname);
                }
            }
            ++n2;
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static String buildClassname(String pckgname, String filename) {
        return String.valueOf(pckgname) + '.' + filename.replace(".class", "");
    }

    private static File getPackageDirectory(String pckgname) {
        Enumeration<URL> resources;
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        if (cld == null) {
            throw new IllegalStateException("Can't get class loader.");
        }
        try {
            resources = cld.getResources(pckgname.replace('.', '/'));
        }
        catch (IOException e) {
            throw new IllegalStateException("can't get resourcs.");
        }
        System.out.println("Found any elements: " + resources.hasMoreElements());
        while (resources.hasMoreElements()) {
            System.out.println(resources.nextElement().getPath());
        }
        URL resource = cld.getResource(pckgname.replace('.', '/'));
        if (resource == null) {
            throw new RuntimeException("Package " + pckgname + " not found on classpath.");
        }
        return new File(resource.getFile());
    }
}

