//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file ProcessesCount.hh
/// \brief Definition of the ProcessesCount class

#ifndef ProcessesCount_HH
#define ProcessesCount_HH

#include "G4VAccumulable.hh"
#include "globals.hh"

#include <map>

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class ProcessesCount : public G4VAccumulable
{
  public:
    ProcessesCount() = delete;
    ProcessesCount(const G4String& name);
    ~ProcessesCount() = default;

    G4int GetCounter(const G4String& procName) { return fProcCounter[procName]; };
    void Count(const G4String& procName);

    void Print(G4PrintOptions options = G4PrintOptions()) const override;

    void Merge(const G4VAccumulable&) override;
    void Reset() override { fProcCounter.clear(); }

  private:
    std::map<G4String, G4int> fProcCounter;
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif
