/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.CommentsInserter;
import org.javamodularity.moduleplugin.shadow.javaparser.LineEndingProcessingProvider;
import org.javamodularity.moduleplugin.shadow.javaparser.ParseResult;
import org.javamodularity.moduleplugin.shadow.javaparser.Problem;
import org.javamodularity.moduleplugin.shadow.javaparser.Processor;
import org.javamodularity.moduleplugin.shadow.javaparser.Provider;
import org.javamodularity.moduleplugin.shadow.javaparser.Providers;
import org.javamodularity.moduleplugin.shadow.javaparser.Range;
import org.javamodularity.moduleplugin.shadow.javaparser.UnicodeEscapeProcessingProvider;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.comments.CommentsCollection;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.ProblemReporter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java10PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java10Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java11PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java11Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java12PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java12Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java13PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java13Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java14PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java14Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java15PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java15Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java16PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java16Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java17PreviewValidator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java17Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java18Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java1_0Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java1_1Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java1_2Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java1_3Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java1_4Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java5Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java6Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java7Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java8Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.language_level_validations.Java9Validator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java10PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java11PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java12PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java13PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java14PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java15PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java16PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java17PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.Java18PostProcessor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.validator.postprocessors.PostProcessors;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.SymbolResolver;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.LineSeparator;

public class ParserConfiguration {
    private boolean detectOriginalLineSeparator = true;
    private boolean storeTokens = true;
    private boolean attributeComments = true;
    private boolean doNotAssignCommentsPrecedingEmptyLines = true;
    private boolean ignoreAnnotationsWhenAttributingComments = false;
    private boolean lexicalPreservationEnabled = false;
    private boolean preprocessUnicodeEscapes = false;
    private SymbolResolver symbolResolver = null;
    private int tabSize = 1;
    private LanguageLevel languageLevel = LanguageLevel.POPULAR;
    private Charset characterEncoding = Providers.UTF8;
    private final List<Supplier<Processor>> processors = new ArrayList<Supplier<Processor>>();

    public ParserConfiguration() {
        this.processors.add((Supplier<Processor> & Serializable)() -> new UnicodeEscapeProcessor());
        this.processors.add((Supplier<Processor> & Serializable)() -> new LineEndingProcessor());
        this.processors.add((Supplier<Processor> & Serializable)() -> new Processor(){

            @Override
            public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
                if (configuration.isAttributeComments()) {
                    result.ifSuccessful((Consumer<? extends Node>)(Consumer<Node> & Serializable)resultNode -> result.getCommentsCollection().ifPresent((Consumer<CommentsCollection> & Serializable)comments -> new CommentsInserter(configuration).insertComments((Node)resultNode, comments.copy().getComments())));
                }
            }
        });
        this.processors.add((Supplier<Processor> & Serializable)() -> new Processor(){

            @Override
            public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
                LanguageLevel languageLevel = ParserConfiguration.this.getLanguageLevel();
                if (languageLevel != null) {
                    if (languageLevel.postProcessor != null) {
                        languageLevel.postProcessor.postProcess(result, configuration);
                    }
                    if (languageLevel.validator != null) {
                        languageLevel.validator.accept(result.getResult().get(), new ProblemReporter((Consumer<Problem> & Serializable)newProblem -> result.getProblems().add((Problem)newProblem)));
                    }
                }
            }
        });
        this.processors.add((Supplier<Processor> & Serializable)() -> new Processor(){

            @Override
            public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
                configuration.getSymbolResolver().ifPresent((Consumer<SymbolResolver> & Serializable)symbolResolver -> result.ifSuccessful((Consumer<Node> & Serializable)resultNode -> {
                    if (resultNode instanceof CompilationUnit) {
                        resultNode.setData(Node.SYMBOL_RESOLVER_KEY, symbolResolver);
                    }
                }));
            }
        });
        this.processors.add((Supplier<Processor> & Serializable)() -> new Processor(){

            @Override
            public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
                if (configuration.isLexicalPreservationEnabled()) {
                    result.ifSuccessful((Consumer<? extends Node>)((Consumer<Node> & Serializable)LexicalPreservingPrinter::setup));
                }
            }
        });
    }

    public boolean isAttributeComments() {
        return this.attributeComments;
    }

    public ParserConfiguration setAttributeComments(boolean attributeComments) {
        this.attributeComments = attributeComments;
        return this;
    }

    public boolean isDoNotAssignCommentsPrecedingEmptyLines() {
        return this.doNotAssignCommentsPrecedingEmptyLines;
    }

    public ParserConfiguration setDoNotAssignCommentsPrecedingEmptyLines(boolean doNotAssignCommentsPrecedingEmptyLines) {
        this.doNotAssignCommentsPrecedingEmptyLines = doNotAssignCommentsPrecedingEmptyLines;
        return this;
    }

    public boolean isIgnoreAnnotationsWhenAttributingComments() {
        return this.ignoreAnnotationsWhenAttributingComments;
    }

    public ParserConfiguration setIgnoreAnnotationsWhenAttributingComments(boolean ignoreAnnotationsWhenAttributingComments) {
        this.ignoreAnnotationsWhenAttributingComments = ignoreAnnotationsWhenAttributingComments;
        return this;
    }

    public ParserConfiguration setStoreTokens(boolean storeTokens) {
        this.storeTokens = storeTokens;
        if (!storeTokens) {
            this.setAttributeComments(false);
        }
        return this;
    }

    public boolean isStoreTokens() {
        return this.storeTokens;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public ParserConfiguration setTabSize(int tabSize) {
        this.tabSize = tabSize;
        return this;
    }

    public ParserConfiguration setLexicalPreservationEnabled(boolean lexicalPreservationEnabled) {
        this.lexicalPreservationEnabled = lexicalPreservationEnabled;
        return this;
    }

    public boolean isLexicalPreservationEnabled() {
        return this.lexicalPreservationEnabled;
    }

    public Optional<SymbolResolver> getSymbolResolver() {
        return Optional.ofNullable(this.symbolResolver);
    }

    public ParserConfiguration setSymbolResolver(SymbolResolver symbolResolver) {
        this.symbolResolver = symbolResolver;
        return this;
    }

    public List<Supplier<Processor>> getProcessors() {
        return this.processors;
    }

    public ParserConfiguration setLanguageLevel(LanguageLevel languageLevel) {
        this.languageLevel = languageLevel;
        return this;
    }

    public LanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public ParserConfiguration setPreprocessUnicodeEscapes(boolean preprocessUnicodeEscapes) {
        this.preprocessUnicodeEscapes = preprocessUnicodeEscapes;
        return this;
    }

    public boolean isPreprocessUnicodeEscapes() {
        return this.preprocessUnicodeEscapes;
    }

    public ParserConfiguration setDetectOriginalLineSeparator(boolean detectOriginalLineSeparator) {
        this.detectOriginalLineSeparator = detectOriginalLineSeparator;
        return this;
    }

    public boolean isDetectOriginalLineSeparator() {
        return this.detectOriginalLineSeparator;
    }

    public Charset getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ParserConfiguration setCharacterEncoding(Charset characterEncoding) {
        this.characterEncoding = characterEncoding;
        return this;
    }

    private class LineEndingProcessor
    extends Processor {
        private LineEndingProcessingProvider _lineEndingProcessingProvider;

        private LineEndingProcessor() {
        }

        @Override
        public Provider preProcess(Provider innerProvider) {
            if (ParserConfiguration.this.isDetectOriginalLineSeparator()) {
                this._lineEndingProcessingProvider = new LineEndingProcessingProvider(innerProvider);
                return this._lineEndingProcessingProvider;
            }
            return innerProvider;
        }

        @Override
        public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
            if (ParserConfiguration.this.isDetectOriginalLineSeparator()) {
                result.getResult().ifPresent((Consumer<? extends Node>)(Consumer<Node> & Serializable)rootNode -> {
                    LineSeparator detectedLineSeparator = this._lineEndingProcessingProvider.getDetectedLineEnding();
                    rootNode.setData(Node.LINE_SEPARATOR_KEY, detectedLineSeparator);
                });
            }
        }
    }

    private class UnicodeEscapeProcessor
    extends Processor {
        private UnicodeEscapeProcessingProvider _unicodeDecoder;

        private UnicodeEscapeProcessor() {
        }

        @Override
        public Provider preProcess(Provider innerProvider) {
            if (ParserConfiguration.this.isPreprocessUnicodeEscapes()) {
                this._unicodeDecoder = new UnicodeEscapeProcessingProvider(innerProvider);
                return this._unicodeDecoder;
            }
            return innerProvider;
        }

        @Override
        public void postProcess(ParseResult<? extends Node> result, ParserConfiguration configuration) {
            if (ParserConfiguration.this.isPreprocessUnicodeEscapes()) {
                result.getResult().ifPresent((Consumer<? extends Node>)(Consumer<Node> & Serializable)root -> {
                    UnicodeEscapeProcessingProvider.PositionMapping mapping = this._unicodeDecoder.getPositionMapping();
                    if (!mapping.isEmpty()) {
                        root.walk((Consumer<Node> & Serializable)node -> node.getRange().ifPresent((Consumer<Range> & Serializable)range -> node.setRange(mapping.transform((Range)range))));
                    }
                });
            }
        }
    }

    public static enum LanguageLevel {
        JAVA_1_0(new Java1_0Validator(), null),
        JAVA_1_1(new Java1_1Validator(), null),
        JAVA_1_2(new Java1_2Validator(), null),
        JAVA_1_3(new Java1_3Validator(), null),
        JAVA_1_4(new Java1_4Validator(), null),
        JAVA_5(new Java5Validator(), null),
        JAVA_6(new Java6Validator(), null),
        JAVA_7(new Java7Validator(), null),
        JAVA_8(new Java8Validator(), null),
        JAVA_9(new Java9Validator(), null),
        JAVA_10(new Java10Validator(), new Java10PostProcessor()),
        JAVA_10_PREVIEW(new Java10PreviewValidator(), new Java10PostProcessor()),
        JAVA_11(new Java11Validator(), new Java11PostProcessor()),
        JAVA_11_PREVIEW(new Java11PreviewValidator(), new Java11PostProcessor()),
        JAVA_12(new Java12Validator(), new Java12PostProcessor()),
        JAVA_12_PREVIEW(new Java12PreviewValidator(), new Java12PostProcessor()),
        JAVA_13(new Java13Validator(), new Java13PostProcessor()),
        JAVA_13_PREVIEW(new Java13PreviewValidator(), new Java13PostProcessor()),
        JAVA_14(new Java14Validator(), new Java14PostProcessor()),
        JAVA_14_PREVIEW(new Java14PreviewValidator(), new Java14PostProcessor()),
        JAVA_15(new Java15Validator(), new Java15PostProcessor()),
        JAVA_15_PREVIEW(new Java15PreviewValidator(), new Java15PostProcessor()),
        JAVA_16(new Java16Validator(), new Java16PostProcessor()),
        JAVA_16_PREVIEW(new Java16PreviewValidator(), new Java16PostProcessor()),
        JAVA_17(new Java17Validator(), new Java17PostProcessor()),
        JAVA_17_PREVIEW(new Java17PreviewValidator(), new Java17PostProcessor()),
        JAVA_18(new Java18Validator(), new Java18PostProcessor());

        public static LanguageLevel RAW;
        public static LanguageLevel POPULAR;
        public static LanguageLevel CURRENT;
        public static LanguageLevel BLEEDING_EDGE;
        final Validator validator;
        final PostProcessors postProcessor;
        private static final LanguageLevel[] yieldSupport;

        private LanguageLevel(Validator validator, PostProcessors postProcessor) {
            this.validator = validator;
            this.postProcessor = postProcessor;
        }

        public boolean isYieldSupported() {
            return Arrays.stream(yieldSupport).anyMatch((Predicate<LanguageLevel> & Serializable)level -> level == this);
        }

        static {
            RAW = null;
            POPULAR = JAVA_11;
            CURRENT = JAVA_16;
            BLEEDING_EDGE = JAVA_17_PREVIEW;
            yieldSupport = new LanguageLevel[]{JAVA_13, JAVA_13_PREVIEW, JAVA_14, JAVA_14_PREVIEW, JAVA_15, JAVA_15_PREVIEW, JAVA_16, JAVA_16_PREVIEW, JAVA_17, JAVA_17_PREVIEW, JAVA_18};
        }
    }
}

