/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.type;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.javamodularity.moduleplugin.shadow.javaparser.StaticJavaParser;
import org.javamodularity.moduleplugin.shadow.javaparser.TokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AllFieldsConstructor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.ObservableProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.ClassOrInterfaceType;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.CloneVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.GenericVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.VoidVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.JavaParserMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.PrimitiveTypeMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Utils;

public class PrimitiveType
extends Type
implements NodeWithAnnotations<PrimitiveType> {
    static final HashMap<String, Primitive> unboxMap = new HashMap();
    private Primitive type;

    public static PrimitiveType booleanType() {
        return new PrimitiveType(Primitive.BOOLEAN);
    }

    public static PrimitiveType charType() {
        return new PrimitiveType(Primitive.CHAR);
    }

    public static PrimitiveType byteType() {
        return new PrimitiveType(Primitive.BYTE);
    }

    public static PrimitiveType shortType() {
        return new PrimitiveType(Primitive.SHORT);
    }

    public static PrimitiveType intType() {
        return new PrimitiveType(Primitive.INT);
    }

    public static PrimitiveType longType() {
        return new PrimitiveType(Primitive.LONG);
    }

    public static PrimitiveType floatType() {
        return new PrimitiveType(Primitive.FLOAT);
    }

    public static PrimitiveType doubleType() {
        return new PrimitiveType(Primitive.DOUBLE);
    }

    public PrimitiveType() {
        this(null, Primitive.INT, new NodeList<AnnotationExpr>());
    }

    public PrimitiveType(Primitive type) {
        this(null, type, new NodeList<AnnotationExpr>());
    }

    @AllFieldsConstructor
    public PrimitiveType(Primitive type, NodeList<AnnotationExpr> annotations) {
        this(null, type, annotations);
    }

    public PrimitiveType(TokenRange tokenRange, Primitive type, NodeList<AnnotationExpr> annotations) {
        super(tokenRange, annotations);
        this.setType(type);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Primitive getType() {
        return this.type;
    }

    public ClassOrInterfaceType toBoxedType() {
        return this.type.toBoxedType();
    }

    @Override
    public String toDescriptor() {
        return this.type.toDescriptor();
    }

    public PrimitiveType setType(Primitive type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = type;
        return this;
    }

    @Override
    public String asString() {
        return this.type.asString();
    }

    @Override
    public PrimitiveType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (PrimitiveType)super.setAnnotations(annotations);
    }

    @Override
    public PrimitiveType clone() {
        return (PrimitiveType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public PrimitiveTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.primitiveTypeMetaModel;
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public PrimitiveType asPrimitiveType() {
        return this;
    }

    @Override
    public void ifPrimitiveType(Consumer<PrimitiveType> action) {
        action.accept(this);
    }

    @Override
    public ResolvedPrimitiveType resolve() {
        return this.getSymbolResolver().toResolvedType(this, ResolvedPrimitiveType.class);
    }

    @Override
    public Optional<PrimitiveType> toPrimitiveType() {
        return Optional.of(this);
    }

    @Override
    public ResolvedType convertToUsage(Context context) {
        return ResolvedPrimitiveType.byName(this.getType().name());
    }

    static {
        for (Primitive unboxedType : Primitive.values()) {
            unboxMap.put(unboxedType.nameOfBoxedType, unboxedType);
        }
    }

    public static enum Primitive {
        BOOLEAN("Boolean", "Z"),
        CHAR("Character", "C"),
        BYTE("Byte", "B"),
        SHORT("Short", "S"),
        INT("Integer", "I"),
        LONG("Long", "J"),
        FLOAT("Float", "F"),
        DOUBLE("Double", "D");

        final String nameOfBoxedType;
        final String descriptor;
        private String codeRepresentation;

        public static Optional<Primitive> byTypeName(String name) {
            for (Primitive primitive : Primitive.values()) {
                if (!primitive.name().toLowerCase().equals(name)) continue;
                return Optional.of(primitive);
            }
            return Optional.empty();
        }

        public static Optional<Primitive> byBoxedTypeName(String simpleName) {
            return Optional.ofNullable(unboxMap.getOrDefault(simpleName, null));
        }

        public ClassOrInterfaceType toBoxedType() {
            return StaticJavaParser.parseClassOrInterfaceType(this.nameOfBoxedType);
        }

        public String asString() {
            return this.codeRepresentation;
        }

        public String toDescriptor() {
            return this.descriptor;
        }

        private Primitive(String nameOfBoxedType, String descriptor) {
            this.nameOfBoxedType = nameOfBoxedType;
            this.codeRepresentation = this.name().toLowerCase();
            this.descriptor = descriptor;
        }
    }
}

