/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import mslinks.Serializable;

public class Filetime
extends GregorianCalendar
implements Serializable {
    private static final long serialVersionUID = 2258831109960118017L;
    private long residue;

    public Filetime() {
    }

    public Filetime(ByteReader data) throws IOException {
        this(data.read8bytes());
    }

    public Filetime(long time) {
        long t = time / 10000L;
        this.residue = time - t;
        this.setTimeInMillis(t);
        this.add(1, -369);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Filetime obj = (Filetime)o;
        return this.residue == obj.residue;
    }

    @Override
    public int hashCode() {
        return (int)((long)super.hashCode() ^ (this.residue & 0xFFFFFFFF00000000L) >> 32 ^ this.residue & 0xFFFFFFFFL);
    }

    public long toLong() {
        GregorianCalendar tmp = (GregorianCalendar)this.clone();
        tmp.add(1, 369);
        return tmp.getTimeInMillis() + this.residue;
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write8bytes(this.toLong());
    }

    @Override
    public String toString() {
        return String.format("%d:%d:%d %d.%d.%d", this.get(11), this.get(12), this.get(13), this.get(5), this.get(2) + 1, this.get(1));
    }
}

