/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.IndependentAttributeProviderFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class EmbeddedAttributeProvider
implements AttributeProvider {
    public static final IndependentAttributeProviderFactory Factory = new IndependentAttributeProviderFactory(){

        @Override
        @NotNull
        public AttributeProvider apply(@NotNull LinkResolverContext context) {
            return new EmbeddedAttributeProvider();
        }
    };

    EmbeddedAttributeProvider() {
    }

    @Override
    public void setAttributes(@NotNull Node node, @NotNull AttributablePart part, @NotNull MutableAttributes attributes) {
        Node firstChild;
        if (part == AttributablePart.NODE && (firstChild = node.getChildOfType(new Class[]{EmbeddedNodeAttributes.class})) instanceof EmbeddedNodeAttributes) {
            attributes.addValues(((EmbeddedNodeAttributes)firstChild).attributes);
        }
    }

    public static class EmbeddedNodeAttributes
    extends Node {
        @NotNull
        final Attributes attributes;

        public EmbeddedNodeAttributes(@NotNull Node parent, @NotNull Attributes attributes) {
            super(parent.getChars().subSequence(0, 0));
            this.attributes = attributes;
        }

        @NotNull
        public BasedSequence[] getSegments() {
            return Node.EMPTY_SEGMENTS;
        }

        public void astString(@NotNull StringBuilder out, boolean withExtra) {
            out.append(EmbeddedNodeAttributes.class.getSimpleName());
            out.append("[").append(this.getStartOffset()).append(", ").append(this.getEndOffset()).append("]");
            out.append(", attributes: ").append(this.attributes.toString());
            if (withExtra) {
                this.getAstExtra(out);
            }
        }

        public void astExtraChars(@NotNull StringBuilder out) {
        }
    }
}

