/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.BeanMapPropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutablePropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapImmutableSetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

class ImmutableMapPropertyField<M, K, V, T extends ObservableMap<K, V>, R extends Property<T>>
implements ImmutablePropertyField<T, M, R> {
    private final MapGetter<M, K, V> getter;
    private final MapImmutableSetter<M, K, V> immutableSetter;
    private Map<K, V> defaultValue;
    private final MapProperty<K, V> targetProperty;

    ImmutableMapPropertyField(SideEffect updateFunction, MapGetter<M, K, V> getter, MapImmutableSetter<M, K, V> immutableSetter, Supplier<MapProperty<K, V>> propertySupplier) {
        this(updateFunction, getter, immutableSetter, propertySupplier, Collections.emptyMap());
    }

    ImmutableMapPropertyField(SideEffect updateFunction, MapGetter<M, K, V> getter, MapImmutableSetter<M, K, V> immutableSetter, Supplier<MapProperty<K, V>> propertySupplier, Map<K, V> defaultValue) {
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.immutableSetter = immutableSetter;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableMap(new HashMap()));
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
    }

    @Override
    public M commitImmutable(M wrappedObject) {
        return this.immutableSetter.apply(wrappedObject, (Map<K, V>)this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        BeanMapPropertyField.setAll(this.targetProperty, this.getter.apply((Object)wrappedObject));
    }

    @Override
    public void resetToDefault() {
        BeanMapPropertyField.setAll(this.targetProperty, this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new HashMap(this.getter.apply((Object)wrappedObject));
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        MapProperty<K, V> wrappedValue;
        Object modelValue = this.getter.apply((Object)wrappedObject);
        return !Objects.equals(modelValue, wrappedValue = this.targetProperty);
    }
}

