/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiAttributedCharacterIterator
implements AttributedCharacterIterator {
    private final List<AttributedCharacterIterator> realIterators = new ArrayList<AttributedCharacterIterator>();
    private int currentList;

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public void appendAttributedCharacterIterator(AttributedCharacterIterator attributedCharacterIterator) {
        this.realIterators.add(attributedCharacterIterator);
        this.first();
    }

    private int sumUpToNotIncluding(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            AttributedCharacterIterator attributedCharacterIterator = this.realIterators.get(i);
            n2 += attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        return n2;
    }

    private int currentOffset() {
        int n = this.sumUpToNotIncluding(this.currentList);
        return n -= this.realIterators.get(this.currentList).getBeginIndex();
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        HashSet<AttributedCharacterIterator.Attribute> hashSet = new HashSet<AttributedCharacterIterator.Attribute>();
        for (AttributedCharacterIterator attributedCharacterIterator : this.realIterators) {
            hashSet.addAll(attributedCharacterIterator.getAllAttributeKeys());
        }
        return hashSet;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.realIterators.get(this.currentList).getAttribute(attribute);
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        return this.realIterators.get(this.currentList).getAttributes();
    }

    @Override
    public int getRunLimit() {
        return this.realIterators.get(this.currentList).getRunLimit() + this.currentOffset();
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        return this.realIterators.get(this.currentList).getRunLimit(attribute) + this.currentOffset();
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
        return this.realIterators.get(this.currentList).getRunLimit(set) + this.currentOffset();
    }

    @Override
    public int getRunStart() {
        return this.realIterators.get(this.currentList).getRunStart() + this.currentOffset();
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return this.realIterators.get(this.currentList).getRunStart(attribute) + this.currentOffset();
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
        return this.realIterators.get(this.currentList).getRunStart(set) + this.currentOffset();
    }

    @Override
    public char current() {
        return this.realIterators.get(this.currentList).current();
    }

    @Override
    public char first() {
        this.currentList = 0;
        return this.realIterators.get(this.currentList).first();
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.sumUpToNotIncluding(this.realIterators.size());
    }

    @Override
    public int getIndex() {
        return this.currentOffset() + this.realIterators.get(this.currentList).getIndex();
    }

    @Override
    public char last() {
        this.currentList = this.realIterators.size() - 1;
        return this.realIterators.get(this.currentList).last();
    }

    @Override
    public char next() {
        char c = this.realIterators.get(this.currentList).next();
        while (c == '\uffff' && this.currentList < this.realIterators.size() - 1) {
            ++this.currentList;
            c = this.realIterators.get(this.currentList).first();
        }
        return c;
    }

    @Override
    public char previous() {
        char c = this.realIterators.get(this.currentList).previous();
        while (c == '\uffff' && this.currentList > 0) {
            --this.currentList;
            c = this.realIterators.get(this.currentList).previous();
        }
        return c;
    }

    @Override
    public char setIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.realIterators.size(); ++i) {
            AttributedCharacterIterator attributedCharacterIterator = this.realIterators.get(i);
            n2 = n3;
            int n4 = attributedCharacterIterator.getBeginIndex();
            if ((n2 > n || (n3 += attributedCharacterIterator.getEndIndex() - n4) <= n) && (n3 != n || i != this.realIterators.size() - 1)) continue;
            this.currentList = i;
            return attributedCharacterIterator.setIndex(n4 + n - n2);
        }
        throw new IllegalArgumentException();
    }
}

