/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring;

import com.github.javakeyring.internal.KeyringBackend;
import com.github.javakeyring.internal.freedesktop.FreedesktopKeyringBackend;
import com.github.javakeyring.internal.kde.KWalletBackend;
import com.github.javakeyring.internal.osx.ModernOsxKeychainBackend;
import com.github.javakeyring.internal.osx.OsxKeychainBackend;
import com.github.javakeyring.internal.windows.WinCredentialStoreBackend;
import java.util.Arrays;

public enum KeyringStorageType {
    OSX_KEYCHAIN(ModernOsxKeychainBackend.class),
    LEGACY_OSX_KEYCHAIN(OsxKeychainBackend.class),
    GNOME_KEYRING(FreedesktopKeyringBackend.class),
    WINDOWS_CREDENTIAL_STORE(WinCredentialStoreBackend.class),
    KWALLET(KWalletBackend.class);

    private final Class<? extends KeyringBackend> supportingClass;

    private KeyringStorageType(Class<? extends KeyringBackend> backendClass) {
        this.supportingClass = backendClass;
    }

    public Class<? extends KeyringBackend> getSupportingClass() {
        return this.supportingClass;
    }

    public static KeyringStorageType getLabelForBackend(Class<? extends KeyringBackend> backendClass) {
        return Arrays.asList(KeyringStorageType.values()).stream().filter(keyring -> keyring.supportingClass == backendClass).findFirst().orElseThrow(() -> new IllegalArgumentException(String.valueOf(backendClass) + " is not backed by an enum value in " + String.valueOf(KeyringStorageType.class)));
    }
}

