/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.LocalTimePicker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.TimeFormat;
import com.dlsc.pickerfx.skins.PickerSkinBase;
import java.time.LocalTime;
import javafx.beans.InvalidationListener;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class LocalTimePickerSkin
extends PickerSkinBase<LocalTimePicker> {
    private final Segment<LocalTime, Integer> hourSegment;
    private final Segment<LocalTime, Integer> minuteSegment;
    private final Segment<LocalTime, LocalTimePicker.Meridiem> meridiemSegment;
    private final Label colon;
    private boolean updatingValue;

    public LocalTimePickerSkin(LocalTimePicker picker) {
        super(picker);
        InvalidationListener updateValueListener = it -> this.updateValue();
        this.hourSegment = new Segment(picker);
        this.hourSegment.getStyleClass().add((Object)"hour");
        this.hourSegment.valueProperty().addListener(updateValueListener);
        this.hourSegment.cellFactoryProperty().bind(picker.hourCellFactoryProperty());
        this.minuteSegment = new Segment(picker);
        this.minuteSegment.getStyleClass().add((Object)"minute");
        this.minuteSegment.valueProperty().addListener(updateValueListener);
        this.minuteSegment.cellFactoryProperty().bind(picker.minuteCellFactoryProperty());
        for (int i = 0; i < 60; ++i) {
            this.minuteSegment.getItems().add((Object)i);
        }
        this.meridiemSegment = new Segment(picker);
        this.meridiemSegment.getItems().setAll((Object[])LocalTimePicker.Meridiem.values());
        this.meridiemSegment.getStyleClass().add((Object)"meridiem");
        this.meridiemSegment.valueProperty().addListener(updateValueListener);
        this.meridiemSegment.setWrapItems(false);
        this.meridiemSegment.setValue(LocalTimePicker.Meridiem.AM);
        this.meridiemSegment.cellFactoryProperty().bind(picker.meridiemCellFactoryProperty());
        this.colon = new Label();
        this.colon.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.colon.setText(":");
        this.colon.getStyleClass().add((Object)"colon");
        this.colon.setAlignment(Pos.CENTER);
        HBox.setHgrow(this.hourSegment, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.colon, (Priority)Priority.NEVER);
        HBox.setHgrow(this.minuteSegment, (Priority)Priority.ALWAYS);
        HBox.setHgrow(this.meridiemSegment, (Priority)Priority.ALWAYS);
        picker.timeFormatProperty().addListener(it -> {
            this.buildView();
            this.updateSegmentValues();
        });
        this.buildView();
        picker.valueProperty().addListener(it -> this.updateSegmentValues());
        this.updateSegmentValues();
        this.updateColon();
        picker.orientationProperty().addListener(it -> this.updateColon());
    }

    private void updateColon() {
        if (((LocalTimePicker)this.getSkinnable()).getOrientation().equals((Object)Orientation.VERTICAL)) {
            this.colon.setText(":");
        } else {
            this.colon.setText("");
        }
    }

    private void buildView() {
        this.clear();
        this.add(this.hourSegment);
        this.add((Node)new PickerSkinBase.SegmentSeparator());
        this.add((Node)this.colon);
        this.add((Node)new PickerSkinBase.SegmentSeparator());
        this.add(this.minuteSegment);
        if (((LocalTimePicker)this.getSkinnable()).getTimeFormat().equals((Object)TimeFormat.TWELVE_HOURS)) {
            this.hourSegment.getItems().setAll((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
            this.add((Node)new PickerSkinBase.SegmentSeparator());
            this.add(this.meridiemSegment);
        } else {
            this.hourSegment.getItems().setAll((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23});
        }
    }

    private void updateSegmentValues() {
        if (this.updatingValue) {
            return;
        }
        LocalTime time = (LocalTime)((LocalTimePicker)this.getSkinnable()).getValue();
        if (time != null) {
            if (((LocalTimePicker)this.getSkinnable()).getTimeFormat().equals((Object)TimeFormat.TWENTY_FOUR_HOURS)) {
                this.hourSegment.setValue(time.getHour());
            } else {
                this.hourSegment.setValue(time.getHour() % 12);
                if (time.getHour() >= 12) {
                    this.meridiemSegment.setValue(LocalTimePicker.Meridiem.PM);
                }
            }
            this.minuteSegment.setValue(time.getMinute());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        Integer hour = this.hourSegment.getValue();
        Integer minute = this.minuteSegment.getValue();
        if (hour != null && minute != null) {
            this.updatingValue = true;
            try {
                LocalTimePicker.Meridiem meridiem;
                LocalTime time = LocalTime.of(hour, minute);
                if (((LocalTimePicker)this.getSkinnable()).getTimeFormat().equals((Object)TimeFormat.TWELVE_HOURS) && (meridiem = this.meridiemSegment.getValue()) != null && meridiem.equals((Object)LocalTimePicker.Meridiem.PM) && time.getHour() < 12) {
                    time = time.plusHours(12L);
                }
                ((LocalTimePicker)this.getSkinnable()).setValue(time);
            }
            finally {
                this.updatingValue = false;
            }
        }
    }
}

