/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.HistoryButton;
import com.dlsc.gemsfx.util.HistoryManager;
import com.dlsc.gemsfx.util.UIUtil;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.textfield.CustomTextField;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class SearchTextField
extends CustomTextField {
    private static final boolean DEFAULT_ADDING_ITEM_TO_HISTORY_ON_ENTER = true;
    private static final boolean DEFAULT_ADDING_ITEM_TO_HISTORY_ON_FOCUS_LOST = true;
    private static final boolean DEFAULT_ROUND = false;
    private static final PseudoClass DISABLED_POPUP_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"disabled-popup");
    private final HistoryButton<String> historyButton;
    private ObjectProperty<Node> historyPlaceholder = new SimpleObjectProperty((Object)this, "historyPlaceholder");
    private BooleanProperty addingItemToHistoryOnEnter;
    private BooleanProperty addingItemToHistoryOnFocusLost;
    private BooleanProperty round;
    private ObjectProperty<HistoryManager<String>> historyManager;

    public SearchTextField() {
        this.getStyleClass().add((Object)"search-text-field");
        UIUtil.toggleClassBasedOnObservable((Styleable)this, "round", (ObservableValue<Boolean>)this.roundProperty());
        this.setPromptText("Search...");
        Label placeholder = new Label("No items.");
        placeholder.getStyleClass().add((Object)"default-placeholder");
        this.setHistoryPlaceholder((Node)placeholder);
        this.historyButton = this.createHistoryButton();
        this.setLeft((Node)this.historyButton);
        this.setRight((Node)this.createRightNode());
        this.addEventHandlers();
        this.focusedProperty().addListener(it -> {
            if (!this.isFocused()) {
                if (this.isAddingItemToHistoryOnFocusLost()) {
                    this.addToHistory();
                }
                this.historyButton.hidePopup();
            }
        });
    }

    private void addToHistory() {
        String text;
        HistoryManager<String> historyManager = this.getHistoryManager();
        if (historyManager != null && StringUtils.isNotBlank((CharSequence)(text = this.getText()))) {
            historyManager.add(text);
        }
    }

    private HistoryButton<String> createHistoryButton() {
        HistoryButton<String> historyButton = new HistoryButton<String>((Node)this);
        historyButton.placeholderProperty().bind(this.historyPlaceholderProperty());
        historyButton.historyManagerProperty().bind(this.historyManagerProperty());
        historyButton.setOnItemSelected(value -> {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.setText((String)value);
            }
            historyButton.hidePopup();
        });
        Region graphic = new Region();
        graphic.getStyleClass().add((Object)"icon");
        historyButton.setGraphic((Node)graphic);
        historyButton.setFocusTraversable(false);
        return historyButton;
    }

    private void addEventHandlers() {
        this.addEventHandler(ActionEvent.ANY, e -> {
            if (this.isAddingItemToHistoryOnEnter()) {
                this.addToHistory();
            }
        });
        this.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.UP || e.getCode() == KeyCode.DOWN) {
                e.consume();
            } else {
                this.historyButton.hidePopup();
            }
        });
    }

    private StackPane createRightNode() {
        FontIcon clearIcon = new FontIcon((Ikon)MaterialDesign.MDI_CLOSE);
        clearIcon.getStyleClass().add((Object)"clear-icon");
        clearIcon.setCursor(Cursor.DEFAULT);
        clearIcon.setOnMouseClicked(evt -> this.setText(""));
        clearIcon.visibleProperty().bind((ObservableValue)this.textProperty().isNotEmpty());
        clearIcon.managedProperty().bind((ObservableValue)this.textProperty().isNotEmpty());
        StackPane clearIconWrapper = new StackPane(new Node[]{clearIcon});
        clearIconWrapper.getStyleClass().addAll((Object[])new String[]{"wrapper", "clear-icon-wrapper"});
        return clearIconWrapper;
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(SearchTextField.class.getResource("search-text-field.css")).toExternalForm();
    }

    public final ObjectProperty<Node> historyPlaceholderProperty() {
        if (this.historyPlaceholder == null) {
            this.historyPlaceholder = new SimpleObjectProperty((Object)this, "historyPlaceholder");
        }
        return this.historyPlaceholder;
    }

    public final Node getHistoryPlaceholder() {
        return this.historyPlaceholder == null ? null : (Node)this.historyPlaceholder.get();
    }

    public final void setHistoryPlaceholder(Node historyPlaceholder) {
        this.historyPlaceholderProperty().set((Object)historyPlaceholder);
    }

    public final BooleanProperty addingItemToHistoryOnEnterProperty() {
        if (this.addingItemToHistoryOnEnter == null) {
            this.addingItemToHistoryOnEnter = new SimpleBooleanProperty((Object)this, "addingItemToHistoryOnEnter", true);
        }
        return this.addingItemToHistoryOnEnter;
    }

    public final boolean isAddingItemToHistoryOnEnter() {
        return this.addingItemToHistoryOnEnter == null ? true : this.addingItemToHistoryOnEnter.get();
    }

    public final void setAddingItemToHistoryOnEnter(boolean addingItemToHistoryOnEnter) {
        this.addingItemToHistoryOnEnterProperty().set(addingItemToHistoryOnEnter);
    }

    public final BooleanProperty addingItemToHistoryOnFocusLostProperty() {
        if (this.addingItemToHistoryOnFocusLost == null) {
            this.addingItemToHistoryOnFocusLost = new SimpleBooleanProperty((Object)this, "addingItemToHistoryOnFocusLost", true);
        }
        return this.addingItemToHistoryOnFocusLost;
    }

    public final boolean isAddingItemToHistoryOnFocusLost() {
        return this.addingItemToHistoryOnFocusLost == null ? true : this.addingItemToHistoryOnFocusLost.get();
    }

    public final void setAddingItemToHistoryOnFocusLost(boolean addingItemToHistoryOnFocusLost) {
        this.addingItemToHistoryOnFocusLostProperty().set(addingItemToHistoryOnFocusLost);
    }

    public final BooleanProperty roundProperty() {
        if (this.round == null) {
            this.round = new SimpleBooleanProperty((Object)this, "round", false);
        }
        return this.round;
    }

    public final boolean isRound() {
        return this.round == null ? false : this.round.get();
    }

    public final void setRound(boolean round) {
        this.roundProperty().set(round);
    }

    public final ObjectProperty<HistoryManager<String>> historyManagerProperty() {
        if (this.historyManager == null) {
            this.historyManager = new SimpleObjectProperty<HistoryManager<String>>((Object)this, "historyManager"){

                protected void invalidated() {
                    SearchTextField.this.pseudoClassStateChanged(DISABLED_POPUP_PSEUDO_CLASS, this.get() == null);
                }
            };
        }
        return this.historyManager;
    }

    public final HistoryManager<String> getHistoryManager() {
        return this.historyManager == null ? null : (HistoryManager)this.historyManager.get();
    }

    public final void setHistoryManager(HistoryManager<String> historyManager) {
        this.historyManagerProperty().set(historyManager);
    }
}

