/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.ArcProgressIndicator;
import javafx.animation.Animation;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.shape.Arc;
import javafx.scene.transform.Rotate;
import javafx.util.StringConverter;

public abstract class ArcProgressIndicatorSkin<T extends ArcProgressIndicator>
extends SkinBase<T> {
    private static final PseudoClass PSEUDO_CLASS_COMPLETED = PseudoClass.getPseudoClass((String)"completed");
    protected final Label progressLabel = new Label();
    protected final Arc trackArc = new Arc();
    protected final Arc progressArc = new Arc();
    protected final Rotate rotate = new Rotate();
    protected DoubleBinding radiusBinding;
    protected Timeline indeterminateAnimation;

    public ArcProgressIndicatorSkin(T control) {
        super(control);
        this.initComponents();
        this.registerListener();
        this.updateProgress();
    }

    protected void initComponents() {
        ArcProgressIndicator control = (ArcProgressIndicator)this.getSkinnable();
        this.progressLabel.getStyleClass().add((Object)"progress-label");
        this.progressLabel.setWrapText(true);
        this.progressLabel.graphicProperty().bind(control.graphicProperty());
        this.progressLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            double progress = control.getProgress();
            StringConverter<Double> converter = control.getConverter();
            return converter == null ? null : converter.toString((Object)progress);
        }, (Observable[])new Observable[]{control.progressProperty(), control.converterProperty()}));
        this.progressLabel.managedProperty().bind((ObservableValue)this.progressLabel.visibleProperty());
        this.progressLabel.visibleProperty().bind((ObservableValue)control.graphicProperty().isNotNull().or((ObservableBooleanValue)this.progressLabel.textProperty().isNotEmpty()));
        this.radiusBinding = this.getRadiusBinding(control);
        this.trackArc.getStyleClass().add((Object)"track-circle");
        this.trackArc.setManaged(false);
        this.trackArc.radiusXProperty().bind((ObservableValue)this.radiusBinding);
        this.trackArc.radiusYProperty().bind((ObservableValue)this.radiusBinding);
        this.trackArc.typeProperty().bind(control.trackArcTypeProperty());
        this.progressArc.getStyleClass().add((Object)"progress-arc");
        this.progressArc.setManaged(false);
        this.progressArc.setLength(360.0);
        this.progressArc.radiusXProperty().bind((ObservableValue)this.radiusBinding);
        this.progressArc.radiusYProperty().bind((ObservableValue)this.radiusBinding);
        this.progressArc.typeProperty().bind(control.progressArcTypeProperty());
        this.getChildren().addAll((Object[])new Node[]{this.trackArc, this.progressArc, this.progressLabel});
    }

    private void registerListener() {
        ArcProgressIndicator control = (ArcProgressIndicator)this.getSkinnable();
        this.registerChangeListener((ObservableValue)control.progressProperty(), it -> this.updateProgress());
        this.registerChangeListener((ObservableValue)control.visibleProperty(), it -> {
            if (control.isVisible() && control.getProgress() < 0.0) {
                this.playAnimation();
            } else {
                this.pauseAnimation();
            }
        });
    }

    private void updateProgress() {
        ArcProgressIndicator control;
        double progress = (control = (ArcProgressIndicator)this.getSkinnable()).getProgress();
        control.pseudoClassStateChanged(PSEUDO_CLASS_COMPLETED, progress == 1.0);
        if (progress < 0.0) {
            if (control.isVisible()) {
                this.playAnimation();
            } else {
                this.pauseAnimation();
            }
        } else {
            this.stopAnimation();
            this.progressArc.setLength(this.getProgressMaxLength() * progress);
        }
    }

    protected void stopAnimation() {
        this.progressArc.getTransforms().remove((Object)this.rotate);
        if (this.animationIsRunning()) {
            this.indeterminateAnimation.stop();
        }
    }

    private void pauseAnimation() {
        if (this.animationIsRunning()) {
            this.indeterminateAnimation.pause();
        }
    }

    private void playAnimation() {
        if (this.indeterminateAnimation == null) {
            this.indeterminateAnimation = this.initIndeterminateAnimation();
        }
        if (this.indeterminateAnimation.getStatus() != Animation.Status.RUNNING) {
            if (!this.progressArc.getTransforms().contains((Object)this.rotate)) {
                this.progressArc.getTransforms().add((Object)this.rotate);
            }
            this.indeterminateAnimation.play();
        }
    }

    private boolean animationIsRunning() {
        return this.indeterminateAnimation != null && this.indeterminateAnimation.getStatus() == Animation.Status.RUNNING;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double arcCenterX = this.computeAcrCenterX(contentX, contentWidth);
        double arcCenterY = this.computeArcCenterY(contentY, contentHeight);
        this.rotate.setPivotX(arcCenterX - this.progressArc.getLayoutX());
        this.rotate.setPivotY(arcCenterY - this.progressArc.getLayoutY());
        this.trackArc.setCenterX(arcCenterX);
        this.trackArc.setCenterY(arcCenterY);
        this.progressArc.setCenterX(arcCenterX);
        this.progressArc.setCenterY(arcCenterY);
        this.trackArc.resize(contentWidth, contentHeight);
        this.progressArc.resize(contentWidth, contentHeight);
        double maxStrokeWidth = Math.max(this.trackArc.getStrokeWidth(), this.progressArc.getStrokeWidth());
        double diameter = (this.radiusBinding.get() - maxStrokeWidth) * 2.0;
        double labelMaxWidth = this.computeLabelWidth(diameter);
        double labelMaxHeight = this.computeLabelHeight(diameter);
        this.progressLabel.setMaxWidth(labelMaxWidth);
        this.progressLabel.setMaxHeight(labelMaxHeight);
        this.progressLabel.setPrefWidth(labelMaxWidth);
        this.progressLabel.setPrefHeight(labelMaxHeight);
        double labelWidth = Math.min(this.progressLabel.prefWidth(diameter), diameter);
        double labelHeight = Math.min(this.progressLabel.prefHeight(labelWidth), diameter);
        double labelX = this.computeLabelX(arcCenterX, labelWidth);
        double labelY = this.computeLabelY(arcCenterY, labelHeight);
        this.progressLabel.resizeRelocate(labelX, labelY, labelWidth, labelHeight);
    }

    protected double computeLabelWidth(double diameter) {
        return diameter;
    }

    protected double computeAcrCenterX(double contentX, double contentWidth) {
        return contentX + contentWidth / 2.0;
    }

    protected double computeLabelX(double arcCenterX, double labelWidth) {
        return arcCenterX - labelWidth / 2.0;
    }

    protected abstract double computeLabelHeight(double var1);

    protected abstract double computeArcCenterY(double var1, double var3);

    protected abstract double computeLabelY(double var1, double var3);

    protected abstract Timeline initIndeterminateAnimation();

    protected abstract DoubleBinding getRadiusBinding(T var1);

    protected abstract double getProgressMaxLength();
}

