/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CustomPopupControl;
import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.skins.SearchFieldPopupSkin;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import org.apache.commons.lang3.StringUtils;

public class SearchFieldPopup<T>
extends CustomPopupControl {
    public static final String DEFAULT_STYLE_CLASS = "search-field-popup";
    private final ObservableList<T> suggestions = FXCollections.observableArrayList();
    private final SearchField<T> searchField;

    public SearchFieldPopup(SearchField<T> searchField) {
        this.searchField = Objects.requireNonNull(searchField);
        this.minWidthProperty().bind((ObservableValue)searchField.widthProperty());
        this.setAutoFix(true);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        MapChangeListener l = change -> {
            if (change.wasAdded() && (change.getKey().equals("committed") || change.getKey().equals("cancelled"))) {
                this.hide();
                searchField.getProperties().remove((Object)"committed");
                searchField.getProperties().remove((Object)"cancelled");
            }
        };
        searchField.getProperties().addListener(l);
        searchField.addEventHandler(SearchField.SearchEvent.SEARCH_FINISHED, evt -> {
            if ((!searchField.getSuggestions().isEmpty() || searchField.getPlaceholder() != null) && StringUtils.isNotBlank((CharSequence)searchField.getEditor().getText())) {
                boolean showIt = false;
                int suggestionsItemsSize = searchField.getSuggestions().size();
                if (suggestionsItemsSize == 0) {
                    if (!searchField.isHidePopupWithNoChoice()) {
                        showIt = true;
                    }
                } else if (suggestionsItemsSize == 1) {
                    if (!searchField.isHidePopupWithSingleChoice() || !searchField.getMatcher().apply(searchField.getSuggestions().get(0), evt.getText()).booleanValue()) {
                        showIt = true;
                    }
                } else {
                    showIt = true;
                }
                if (showIt) {
                    this.show((Node)searchField);
                    this.selectFirstSuggestion();
                } else {
                    this.hide();
                }
            } else {
                this.hide();
            }
        });
    }

    public SearchField<T> getSearchField() {
        return this.searchField;
    }

    public ObservableList<T> getSuggestions() {
        return this.suggestions;
    }

    private void selectFirstSuggestion() {
        SearchFieldPopupSkin skin = (SearchFieldPopupSkin)this.getSkin();
        ListView listView = (ListView)skin.getNode();
        if (listView.getItems() != null && !listView.getItems().isEmpty()) {
            listView.getSelectionModel().select(0);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new SearchFieldPopupSkin(this);
    }
}

