/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.TimePicker;
import com.dlsc.gemsfx.skins.DigitsField;
import com.dlsc.gemsfx.skins.TimePickerPopup;
import com.dlsc.gemsfx.skins.ToggleVisibilityComboBoxSkin;
import java.time.LocalTime;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.kordamp.ikonli.javafx.FontIcon;

public class TimePickerSkin
extends ToggleVisibilityComboBoxSkin<TimePicker> {
    private static final PseudoClass EMPTY_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"empty");
    private final HourField hourField;
    private final MinuteField minuteField;
    private final SecondField secondField;
    private final MillisecondField millisecondField;
    private final Button editButton = new Button();
    private final HBox fieldsBox = new HBox();
    private TimePickerPopup popup;
    private final Region spacer = new Region();
    private final HBox box;

    public TimePickerSkin(TimePicker picker) {
        super(picker);
        this.spacer.getStyleClass().add((Object)"spacer");
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.fieldsBox.setFillHeight(true);
        this.fieldsBox.setAlignment(Pos.CENTER_LEFT);
        this.fieldsBox.getStyleClass().add((Object)"fields-box");
        this.box = new HBox(){

            public String getUserAgentStylesheet() {
                return Objects.requireNonNull(TimePicker.class.getResource("time-picker.css")).toExternalForm();
            }
        };
        this.box.setFillHeight(true);
        this.box.getStyleClass().add((Object)"box");
        this.box.setAlignment(Pos.CENTER_LEFT);
        this.hourField = new HourField(picker);
        this.minuteField = new MinuteField(picker);
        this.secondField = new SecondField(picker);
        this.millisecondField = new MillisecondField(picker);
        this.hourField.setNextField(this.minuteField);
        this.minuteField.setNextField(this.secondField);
        this.minuteField.setPreviousField(this.hourField);
        this.secondField.setNextField(this.millisecondField);
        this.secondField.setPreviousField(this.minuteField);
        this.millisecondField.setPreviousField(this.secondField);
        this.editButton.getStyleClass().add((Object)"edit-button");
        this.editButton.addEventHandler(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        this.editButton.addEventHandler(MouseEvent.MOUSE_EXITED, this::mouseExited);
        this.editButton.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        this.editButton.setMaxHeight(Double.MAX_VALUE);
        this.editButton.setMaxWidth(Double.MAX_VALUE);
        this.editButton.setGraphic((Node)new FontIcon());
        this.editButton.setFocusTraversable(false);
        this.editButton.visibleProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        this.editButton.managedProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        this.minuteField.stepRateProperty().bind((ObservableValue)picker.stepRateInMinutesProperty());
        InvalidationListener updateFocusListener = it -> this.updateFocus();
        this.hourField.focusedProperty().addListener(updateFocusListener);
        this.minuteField.focusedProperty().addListener(updateFocusListener);
        this.secondField.focusedProperty().addListener(updateFocusListener);
        this.millisecondField.focusedProperty().addListener(updateFocusListener);
        this.editButton.focusedProperty().addListener(updateFocusListener);
        InvalidationListener buildViewListener = it -> this.buildView();
        picker.hoursSeparatorProperty().addListener(buildViewListener);
        picker.minutesSeparatorProperty().addListener(buildViewListener);
        picker.secondsSeparatorProperty().addListener(buildViewListener);
        this.registerChangeListener((ObservableValue)picker.buttonDisplayProperty(), it -> this.updateBox());
        this.buildView();
        picker.timeProperty().addListener(it -> this.updateFieldValues());
        this.updateFieldValues();
        picker.formatProperty().addListener(cl -> this.updateFormat());
        this.updateEmptyPseudoClass();
        this.updateFormat();
        picker.showingProperty().addListener(it -> {
            if (picker.isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        });
        this.getChildren().add((Object)this.box);
    }

    private void updateFormat() {
        TimePicker picker = (TimePicker)this.getSkinnable();
        if (null == picker.formatProperty().get()) {
            this.updateSecondsMillisecondsViewable(false, false);
        } else {
            switch ((TimePicker.Format)((Object)picker.formatProperty().get())) {
                case HOURS_MINUTES_SECONDS: {
                    this.updateSecondsMillisecondsViewable(true, false);
                    break;
                }
                case HOURS_MINUTES_SECONDS_MILLIS: {
                    this.updateSecondsMillisecondsViewable(true, true);
                    break;
                }
                default: {
                    this.updateSecondsMillisecondsViewable(false, false);
                }
            }
        }
    }

    @Override
    protected Node getPopupContent() {
        if (this.popup == null) {
            this.popup = new TimePickerPopup((TimePicker)this.getSkinnable());
        }
        return this.popup;
    }

    private void updateSecondsMillisecondsViewable(boolean secondsVisible, boolean millisecondsVisible) {
        TimePicker timePicker = (TimePicker)this.getSkinnable();
        Node minutesSeparator = timePicker.getMinutesSeparator();
        minutesSeparator.setVisible(secondsVisible);
        minutesSeparator.setManaged(secondsVisible);
        this.secondField.setVisible(secondsVisible);
        this.secondField.setManaged(secondsVisible);
        Node secondsSeparator = timePicker.getSecondsSeparator();
        secondsSeparator.setVisible(millisecondsVisible);
        secondsSeparator.setManaged(millisecondsVisible);
        this.millisecondField.setVisible(millisecondsVisible);
        this.millisecondField.setManaged(millisecondsVisible);
    }

    private void updateEmptyPseudoClass() {
        LocalTime time = ((TimePicker)this.getSkinnable()).getTime();
        this.hourField.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
        this.minuteField.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
        this.secondField.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
        this.millisecondField.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
        ((TimePicker)this.getSkinnable()).getHoursSeparator().pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
        ((TimePicker)this.getSkinnable()).getMinutesSeparator().pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
        ((TimePicker)this.getSkinnable()).getSecondsSeparator().pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, time == null);
    }

    private void updateFocus() {
        boolean wasFocused = ((TimePicker)this.getSkinnable()).getPseudoClassStates().stream().anyMatch(s -> s.getPseudoClassName().equals("focused"));
        if (!wasFocused) {
            ((TimePicker)this.getSkinnable()).getProperties().put((Object)"CLEAR_ADJUSTED_TIME", (Object)"CLEAR_ADJUSTED_TIME");
        }
        ((TimePicker)this.getSkinnable()).pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), this.minuteField.isFocused() || this.hourField.isFocused() || this.secondField.isFocused() || this.millisecondField.isFocused());
    }

    private void buildView() {
        Node hoursSeparator = ((TimePicker)this.getSkinnable()).getHoursSeparator();
        Node minutesSeparator = ((TimePicker)this.getSkinnable()).getMinutesSeparator();
        Node secondsSeparator = ((TimePicker)this.getSkinnable()).getSecondsSeparator();
        hoursSeparator.setOnMouseClicked(evt -> this.minuteField.requestFocus());
        minutesSeparator.setOnMouseClicked(evt -> this.secondField.requestFocus());
        secondsSeparator.setOnMouseClicked(evt -> this.millisecondField.requestFocus());
        this.fieldsBox.getChildren().setAll((Object[])new Node[]{this.hourField, hoursSeparator, this.minuteField, minutesSeparator, this.secondField, secondsSeparator, this.millisecondField});
        this.updateBox();
    }

    private void updateBox() {
        CustomComboBox.ButtonDisplay buttonDisplay = ((TimePicker)this.getSkinnable()).getButtonDisplay();
        switch (buttonDisplay) {
            case LEFT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton, this.spacer, this.fieldsBox});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case RIGHT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.fieldsBox, this.spacer, this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case BUTTON_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.ALWAYS);
                break;
            }
            case FIELD_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.fieldsBox});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
            }
        }
    }

    private void updateFieldValues() {
        TimePicker picker = (TimePicker)this.getSkinnable();
        LocalTime time = picker.getTime();
        if (time != null) {
            this.hourField.setValue(time.getHour());
            this.minuteField.setValue(time.getMinute());
            this.secondField.setValue(time.getSecond());
            this.millisecondField.setValue(time.getNano() / 1000000);
        } else {
            this.hourField.setValue(null);
            this.minuteField.setValue(null);
            this.secondField.setValue(null);
            this.millisecondField.setValue(null);
        }
        this.updateEmptyPseudoClass();
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        CustomComboBox.ButtonDisplay buttonDisplay = ((TimePicker)this.getSkinnable()).getButtonDisplay();
        if (buttonDisplay == CustomComboBox.ButtonDisplay.LEFT) {
            return this.editButton.prefWidth(height);
        }
        return super.computeMaxWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    private class HourField
    extends DigitsField {
        public HourField(TimePicker picker) {
            super(picker, false);
            this.getStyleClass().add((Object)"hour");
            this.minimumValueProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((TimePicker)TimePickerSkin.this.getSkinnable()).getEarliestTime().getHour(), (Observable[])new Observable[]{((TimePicker)TimePickerSkin.this.getSkinnable()).earliestTimeProperty()}));
            this.maximumValueProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((TimePicker)TimePickerSkin.this.getSkinnable()).getLatestTime().getHour(), (Observable[])new Observable[]{((TimePicker)TimePickerSkin.this.getSkinnable()).latestTimeProperty()}));
            this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.getCode().equals((Object)KeyCode.RIGHT)) {
                    TimePickerSkin.this.minuteField.requestFocus();
                    evt.consume();
                }
            });
            this.valueProperty().addListener(it -> {
                Integer value = this.getValue();
                if (value != null) {
                    value = Math.min(value, this.getMaximumValue());
                    LocalTime time = ((TimePicker)TimePickerSkin.this.getSkinnable()).getTime();
                    if (time != null) {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(value, time.getMinute(), time.getSecond(), time.getNano()));
                    } else {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(value, 0, 0, 0));
                    }
                }
            });
        }
    }

    private class MinuteField
    extends DigitsField {
        public MinuteField(TimePicker picker) {
            super(picker, true);
            this.getStyleClass().add((Object)"minute");
            this.setMaximumValue(59);
            this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.getCode().equals((Object)KeyCode.LEFT)) {
                    TimePickerSkin.this.hourField.requestFocus();
                    evt.consume();
                }
            });
            this.valueProperty().addListener(it -> {
                Integer value = this.getValue();
                if (value != null) {
                    value = Math.min(value, this.getMaximumValue());
                    LocalTime time = ((TimePicker)TimePickerSkin.this.getSkinnable()).getTime();
                    if (time != null) {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(time.getHour(), value, time.getSecond(), time.getNano()));
                    } else {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(0, value, 0, 0));
                    }
                }
            });
        }
    }

    private class SecondField
    extends DigitsField {
        public SecondField(TimePicker picker) {
            super(picker, true);
            this.getStyleClass().add((Object)"second");
            this.setMaximumValue(59);
            this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.getCode().equals((Object)KeyCode.LEFT)) {
                    TimePickerSkin.this.minuteField.requestFocus();
                    evt.consume();
                }
            });
            this.valueProperty().addListener(it -> {
                Integer value = this.getValue();
                if (value != null) {
                    value = Math.min(value, this.getMaximumValue());
                    LocalTime time = ((TimePicker)TimePickerSkin.this.getSkinnable()).getTime();
                    if (time != null) {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(time.getHour(), time.getMinute(), value, time.getNano()));
                    } else {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(0, 0, value, 0));
                    }
                }
            });
        }
    }

    private class MillisecondField
    extends DigitsField {
        public MillisecondField(TimePicker picker) {
            super(picker, true, 3);
            this.getStyleClass().add((Object)"millisecond");
            this.setMaximumValue(999);
            this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.getCode().equals((Object)KeyCode.LEFT)) {
                    TimePickerSkin.this.secondField.requestFocus();
                    evt.consume();
                }
            });
            this.valueProperty().addListener(it -> {
                Integer value = this.getValue();
                if (value != null) {
                    value = Math.min(value, this.getMaximumValue());
                    LocalTime time = ((TimePicker)TimePickerSkin.this.getSkinnable()).getTime();
                    if (time != null) {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(time.getHour(), time.getMinute(), time.getSecond(), value * 1000000));
                    } else {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(0, 0, 0, value));
                    }
                }
            });
        }
    }
}

