/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.gradle.internal.classpath.Instrumented;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.IntervalMap;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private final String sampleFrequency;
    private OptionSpec<String> optFrequency;

    public LinuxPerfAsmProfiler(String initLine) throws ProfilerException {
        super(initLine, "cycles");
        String[] senseCmd = new String[]{PerfSupport.PERF_EXEC, "stat", "--event", Utils.join(this.requestedEventNames, ","), "--log-fd", "2", "echo", "1"};
        Collection<String> failMsg = Utils.tryWith(senseCmd);
        if (!failMsg.isEmpty()) {
            throw new ProfilerException(failMsg.toString());
        }
        Collection<String> passMsg = Utils.runWith(senseCmd);
        for (String ev : this.requestedEventNames) {
            if (!PerfSupport.containsUnsupported(passMsg, ev)) continue;
            throw new ProfilerException("Unsupported event: " + ev);
        }
        try {
            this.sampleFrequency = (String)this.set.valueOf(this.optFrequency);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    protected void addMyOptions(OptionParser parser) {
        this.optFrequency = parser.accepts("frequency", "Sampling frequency, synonymous to perf record --freq #; use \"max\" for highest sampling rate possible on the system.").withRequiredArg().ofType(String.class).describedAs("freq").defaultsTo((Object)"1000", (Object[])new String[0]);
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Arrays.asList(PerfSupport.PERF_EXEC, "record", "--freq", String.valueOf(this.sampleFrequency), "--event", Utils.join(this.requestedEventNames, ","), "--output", this.perfBinData.getAbsolutePath());
    }

    @Override
    public String getDescription() {
        return "Linux perf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        try (FileOutputStream fos = new FileOutputStream(this.perfParsedData.file());){
            ProcessBuilder pb = new ProcessBuilder(PerfSupport.PERF_EXEC, "script", "--fields", "time,event,ip,sym,dso", "--input", this.perfBinData.getAbsolutePath());
            Process p = Instrumented.start((ProcessBuilder)pb, (String)"org.openjdk.jmh.profile.LinuxPerfAsmProfiler");
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static PerfLine parsePerfLine(String line) {
        long addr;
        int addrIdx;
        double time;
        if (line.startsWith("#")) {
            return null;
        }
        int lastLength = -1;
        while (line.length() != lastLength) {
            lastLength = line.length();
            line = line.replace("  ", " ");
        }
        int timeIdx = line.indexOf(": ");
        if (timeIdx == -1) {
            return null;
        }
        String strTime = line.substring(0, timeIdx);
        line = line.substring(timeIdx + 2);
        try {
            time = Double.parseDouble(strTime);
        }
        catch (NumberFormatException e) {
            return null;
        }
        int libIdx = line.lastIndexOf(" (");
        if (libIdx == -1) {
            return null;
        }
        String lib = line.substring(libIdx);
        lib = lib.substring(lib.lastIndexOf("/") + 1).replace("(", "").replace(")", "");
        int evIdx = (line = line.substring(0, libIdx)).indexOf(": ");
        if (evIdx == -1) {
            return null;
        }
        String evName = line.substring(0, evIdx);
        int tagIdx = evName.lastIndexOf(":");
        if (tagIdx != -1) {
            evName = evName.substring(0, tagIdx);
        }
        if ((addrIdx = (line = line.substring(evIdx + 2)).indexOf(" ")) == -1) {
            return null;
        }
        String strAddr = line.substring(0, addrIdx);
        line = line.substring(addrIdx + 1);
        try {
            addr = Long.parseLong(strAddr, 16);
        }
        catch (NumberFormatException e) {
            try {
                addr = new BigInteger(strAddr, 16).longValue();
                if (addr < 0L && lib.contains("unknown")) {
                    lib = "kernel";
                }
            }
            catch (NumberFormatException e1) {
                addr = 0L;
            }
        }
        String symbol = line;
        return new PerfLine(time, evName, addr, symbol, lib);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipMs, double lenMs) {
        double readFrom = skipMs / 1000.0;
        double readTo = (skipMs + lenMs) / 1000.0;
        List<String> evNames = this.stripEventNames(this.requestedEventNames);
        try (FileReader fr = new FileReader(this.perfParsedData.file());){
            AbstractPerfAsmProfiler.PerfEvents perfEvents;
            try (BufferedReader reader = new BufferedReader(fr);){
                String line;
                Deduplicator<AbstractPerfAsmProfiler.MethodDesc> dedup = new Deduplicator<AbstractPerfAsmProfiler.MethodDesc>();
                HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long> methods = new HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long>();
                LinkedHashMap<String, Multiset<Long>> events = new LinkedHashMap<String, Multiset<Long>>();
                for (String evName : evNames) {
                    events.put(evName, new TreeMultiset());
                }
                Double startTime = null;
                while ((line = reader.readLine()) != null) {
                    PerfLine perfline = LinuxPerfAsmProfiler.parsePerfLine(line);
                    if (perfline == null) continue;
                    if (startTime == null) {
                        startTime = perfline.time();
                    } else if (perfline.time() - startTime < readFrom || perfline.time() - startTime > readTo) continue;
                    Multiset evs = (Multiset)events.get(perfline.eventName());
                    if (evs == null) continue;
                    evs.add(perfline.addr());
                    AbstractPerfAsmProfiler.MethodDesc desc = dedup.dedup(AbstractPerfAsmProfiler.MethodDesc.nativeMethod(perfline.symbol(), perfline.lib()));
                    methods.put(desc, perfline.addr());
                }
                IntervalMap<AbstractPerfAsmProfiler.MethodDesc> methodMap = new IntervalMap<AbstractPerfAsmProfiler.MethodDesc>();
                for (AbstractPerfAsmProfiler.MethodDesc md : methods.keys()) {
                    Collection addrs = methods.get(md);
                    methodMap.add(md, (Long)Utils.min(addrs), (Long)Utils.max(addrs));
                }
                perfEvents = new AbstractPerfAsmProfiler.PerfEvents(evNames, events, methodMap);
            }
            return perfEvents;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String perfBinaryExtension() {
        return ".perfbin";
    }

    @Override
    protected List<String> stripEventNames(List<String> events) {
        return LinuxPerfAsmProfiler.stripPerfEventNames(events);
    }

    static List<String> stripPerfEventNames(List<String> events) {
        ArrayList<String> res = new ArrayList<String>();
        for (String ev : events) {
            int tagIdx = ev.indexOf(58);
            if (tagIdx != -1) {
                res.add(ev.substring(0, tagIdx));
                continue;
            }
            res.add(ev);
        }
        return res;
    }

    static class PerfLine {
        final double time;
        final String event;
        final long addr;
        final String symbol;
        final String lib;

        public PerfLine(double time, String event, long addr, String symbol, String lib) {
            this.time = time;
            this.event = event;
            this.addr = addr;
            this.symbol = symbol;
            this.lib = lib;
        }

        public double time() {
            return this.time;
        }

        public String eventName() {
            return this.event;
        }

        public long addr() {
            return this.addr;
        }

        public String symbol() {
            return this.symbol;
        }

        public String lib() {
            return this.lib;
        }
    }
}

