/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LxMetaData {
    private static final String DEFAULT_ES_ORA_LANGUAGE = "LATIN AMERICAN SPANISH";
    private static final int WIDTH_SIZE = 8;
    private static final short WIDTH_MASK = 255;
    public static final int ST_BADCODESET = 0;
    private static final Locale EN_LOCALE = new Locale("en", "US");
    private static Map ORACLE_LANG_2_ISO_A2_LANG = null;
    private static Map ORACLE_TERR_2_ISO_A2_TERR = null;
    private static Map ORACLE_LANG_2_TERR = null;
    private static Map ISO_A2_LANG_2_ORACLE_LANG = null;
    private static Map ISO_LANGUAGE_DEFAULT_TERRITORY = null;
    private static Map ISO_LOCALE_2_ORACLE_LOCALE = null;
    private static Map ISO_A2_TERR_2_ORACLE_TERR = null;
    private static Map CHARSET_RATIO = null;

    static Locale getJavaLocale(String string, String string2) {
        String string3;
        if (string == null) {
            return null;
        }
        String string4 = string;
        String string5 = EN_LOCALE.getLanguage();
        if (!"".equals(string4)) {
            if (ORACLE_LANG_2_ISO_A2_LANG == null) {
                ORACLE_LANG_2_ISO_A2_LANG = LxMetaData.getLang2IsoLangMap();
            }
            if ((string5 = (String)ORACLE_LANG_2_ISO_A2_LANG.get(string4.toUpperCase(Locale.US))) == null) {
                return null;
            }
        } else {
            string4 = "AMERICAN";
        }
        String string6 = null;
        if (string2 == null || (string6 = string2.toUpperCase(Locale.US)) == null || "".equals(string6)) {
            if (ORACLE_LANG_2_TERR == null) {
                ORACLE_LANG_2_TERR = LxMetaData.getLang2Terr();
            }
            string6 = (String)ORACLE_LANG_2_TERR.get(string4);
        }
        if (ORACLE_TERR_2_ISO_A2_TERR == null) {
            ORACLE_TERR_2_ISO_A2_TERR = LxMetaData.getTerr2IsoTerrMap();
        }
        if ((string3 = (String)ORACLE_TERR_2_ISO_A2_TERR.get(string6)) == null) {
            return null;
        }
        return new Locale(string5, string3);
    }

    public static String getNLSLanguage(Locale locale) {
        String string = LxMetaData.getOraLocale(locale);
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(95);
        return n2 < 0 ? string : string.substring(0, n2);
    }

    public static String getNLSTerritory(Locale locale) {
        String string = LxMetaData.getOraLocale(locale);
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(95);
        return n2 < 0 ? null : string.substring(n2 + 1);
    }

    private static String getOraLocale(Locale locale) {
        String string;
        String string2;
        String string3;
        String string4;
        if (locale == null) {
            return null;
        }
        String string5 = string4 = locale.getLanguage().equals("") ? EN_LOCALE.getLanguage() : locale.getLanguage();
        if (ISO_A2_LANG_2_ORACLE_LANG == null) {
            ISO_A2_LANG_2_ORACLE_LANG = LxMetaData.getIsoLangToOracleMap();
        }
        if ((string3 = (String)ISO_A2_LANG_2_ORACLE_LANG.get(string4)) == null) {
            return null;
        }
        String string6 = locale.getCountry();
        if (string6.equals("")) {
            if (ISO_LANGUAGE_DEFAULT_TERRITORY == null) {
                ISO_LANGUAGE_DEFAULT_TERRITORY = LxMetaData.getIsoLangDefaultTerrMap();
            }
            if ((string6 = (String)ISO_LANGUAGE_DEFAULT_TERRITORY.get(string4)) == null) {
                return null;
            }
        }
        Locale locale2 = new Locale(string4, string6);
        if (ISO_LOCALE_2_ORACLE_LOCALE == null) {
            ISO_LOCALE_2_ORACLE_LOCALE = LxMetaData.getIsoLocToOracleMap();
        }
        if ((string2 = (String)ISO_LOCALE_2_ORACLE_LOCALE.get(locale2.toString())) != null) {
            return string2;
        }
        if ("es".equals(string4)) {
            string3 = DEFAULT_ES_ORA_LANGUAGE;
        }
        if (ISO_A2_TERR_2_ORACLE_TERR == null) {
            ISO_A2_TERR_2_ORACLE_TERR = LxMetaData.getIsoTerrToOracleMap();
        }
        return (string = (String)ISO_A2_TERR_2_ORACLE_TERR.get(string6)) != null ? string3 + "_" + string : null;
    }

    public static int getRatio(int n2, int n3) {
        Object v2;
        if (n3 == n2) {
            return 1;
        }
        if (CHARSET_RATIO == null) {
            CHARSET_RATIO = LxMetaData.getCharsetRatio();
        }
        if ((v2 = CHARSET_RATIO.get(Integer.toString(n2))) == null) {
            return 0;
        }
        int n4 = Integer.parseInt((String)v2);
        v2 = CHARSET_RATIO.get(Integer.toString(n3));
        if (v2 == null) {
            return 0;
        }
        int n5 = Integer.parseInt((String)v2);
        int n6 = n4 & 0xFF;
        if (n6 == 1) {
            return 1;
        }
        if (n5 >>> 8 == 0) {
            return n6;
        }
        int n7 = n5 & 0xFF;
        int n8 = n6 / n7;
        if (n6 % n7 != 0) {
            ++n8;
        }
        return n8;
    }

    private static synchronized Map getLang2IsoLangMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ALBANIAN", "sq");
        hashMap.put("AMERICAN", "en");
        hashMap.put("AMHARIC", "am");
        hashMap.put("ARABIC", "ar");
        hashMap.put("ARMENIAN", "hy");
        hashMap.put("ASSAMESE", "as");
        hashMap.put("AZERBAIJANI", "az");
        hashMap.put("BANGLA", "bn");
        hashMap.put("BASQUE", "eu");
        hashMap.put("BELARUSIAN", "be");
        hashMap.put("BENGALI", "bn");
        hashMap.put("BRAZILIAN PORTUGUESE", "pt");
        hashMap.put("BULGARIAN", "bg");
        hashMap.put("CANADIAN FRENCH", "fr");
        hashMap.put("CATALAN", "ca");
        hashMap.put("CROATIAN", "hr");
        hashMap.put("CYRILLIC KAZAKH", "kk");
        hashMap.put("CYRILLIC SERBIAN", "sr");
        hashMap.put("CYRILLIC UZBEK", "uz");
        hashMap.put("CZECH", "cs");
        hashMap.put("DANISH", "da");
        hashMap.put("DARI", "pr");
        hashMap.put("DIVEHI", "dv");
        hashMap.put("DUTCH", "nl");
        hashMap.put("EGYPTIAN", "ar");
        hashMap.put("ENGLISH", "en");
        hashMap.put("ESTONIAN", "et");
        hashMap.put("FINNISH", "fi");
        hashMap.put("FRENCH", "fr");
        hashMap.put("GERMAN", "de");
        hashMap.put("GERMAN DIN", "de");
        hashMap.put("GREEK", "el");
        hashMap.put("GUJARATI", "gu");
        hashMap.put("HEBREW", "iw");
        hashMap.put("HINDI", "hi");
        hashMap.put("HUNGARIAN", "hu");
        hashMap.put("ICELANDIC", "is");
        hashMap.put("INDONESIAN", "in");
        hashMap.put("IRISH", "ga");
        hashMap.put("ITALIAN", "it");
        hashMap.put("JAPANESE", "ja");
        hashMap.put("KANNADA", "kn");
        hashMap.put("KHMER", "km");
        hashMap.put("KOREAN", "ko");
        hashMap.put("LAO", "lo");
        hashMap.put(DEFAULT_ES_ORA_LANGUAGE, "es");
        hashMap.put("LATIN BOSNIAN", "bs");
        hashMap.put("LATIN SERBIAN", "sh");
        hashMap.put("LATIN UZBEK", "uz");
        hashMap.put("LATVIAN", "lv");
        hashMap.put("LITHUANIAN", "lt");
        hashMap.put("MACEDONIAN", "mk");
        hashMap.put("MALAY", "ms");
        hashMap.put("MALAYALAM", "ml");
        hashMap.put("MALTESE", "mt");
        hashMap.put("MARATHI", "mr");
        hashMap.put("MEXICAN SPANISH", "es");
        hashMap.put("NEPALI", "ne");
        hashMap.put("NORWEGIAN", "no");
        hashMap.put("NUMERIC DATE LANGUAGE", "en");
        hashMap.put("ORIYA", "or");
        hashMap.put("PERSIAN", "fa");
        hashMap.put("POLISH", "pl");
        hashMap.put("PORTUGUESE", "pt");
        hashMap.put("PUNJABI", "pa");
        hashMap.put("ROMANIAN", "ro");
        hashMap.put("RUSSIAN", "ru");
        hashMap.put("SIMPLIFIED CHINESE", "zh");
        hashMap.put("SINHALA", "si");
        hashMap.put("SLOVAK", "sk");
        hashMap.put("SLOVENIAN", "sl");
        hashMap.put("SPANISH", "es");
        hashMap.put("SWAHILI", "sw");
        hashMap.put("SWEDISH", "sv");
        hashMap.put("TAMIL", "ta");
        hashMap.put("TELUGU", "te");
        hashMap.put("THAI", "th");
        hashMap.put("TRADITIONAL CHINESE", "zh");
        hashMap.put("TURKISH", "tr");
        hashMap.put("TURKMEN", "tk");
        hashMap.put("UKRAINIAN", "uk");
        hashMap.put("URDU", "ur");
        hashMap.put("VIETNAMESE", "vi");
        return hashMap;
    }

    private static synchronized Map getTerr2IsoTerrMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AFGHANISTAN", "AF");
        hashMap.put("ALBANIA", "AL");
        hashMap.put("ALGERIA", "DZ");
        hashMap.put("AMERICA", "US");
        hashMap.put("ANGOLA", "AO");
        hashMap.put("ANTIGUA AND BARBUDA", "AG");
        hashMap.put("ARGENTINA", "AR");
        hashMap.put("ARMENIA", "AM");
        hashMap.put("ARUBA", "AW");
        hashMap.put("AUSTRALIA", "AU");
        hashMap.put("AUSTRIA", "AT");
        hashMap.put("AZERBAIJAN", "AZ");
        hashMap.put("BAHAMAS", "BS");
        hashMap.put("BAHRAIN", "BH");
        hashMap.put("BANGLADESH", "BD");
        hashMap.put("BARBADOS", "BB");
        hashMap.put("BELARUS", "BY");
        hashMap.put("BELGIUM", "BE");
        hashMap.put("BELIZE", "BZ");
        hashMap.put("BERMUDA", "BM");
        hashMap.put("BOLIVIA", "BO");
        hashMap.put("BOSNIA AND HERZEGOVINA", "BA");
        hashMap.put("BOTSWANA", "BW");
        hashMap.put("BRAZIL", "BR");
        hashMap.put("BULGARIA", "BG");
        hashMap.put("CAMBODIA", "KH");
        hashMap.put("CAMEROON", "CM");
        hashMap.put("CANADA", "CA");
        hashMap.put("CATALONIA", "ES");
        hashMap.put("CAYMAN ISLANDS", "KY");
        hashMap.put("CHILE", "CL");
        hashMap.put("CHINA", "CN");
        hashMap.put("CIS", "RU");
        hashMap.put("COLOMBIA", "CO");
        hashMap.put("CONGO BRAZZAVILLE", "CG");
        hashMap.put("CONGO KINSHASA", "CD");
        hashMap.put("COSTA RICA", "CR");
        hashMap.put("CROATIA", "HR");
        hashMap.put("CURACAO", "CW");
        hashMap.put("CYPRUS", "CY");
        hashMap.put("CZECH REPUBLIC", "CZ");
        hashMap.put("CZECHOSLOVAKIA", "CZ");
        hashMap.put("DENMARK", "DK");
        hashMap.put("DJIBOUTI", "DJ");
        hashMap.put("DOMINICA", "DM");
        hashMap.put("DOMINICAN REPUBLIC", "DO");
        hashMap.put("ECUADOR", "EC");
        hashMap.put("EGYPT", "EG");
        hashMap.put("EL SALVADOR", "SV");
        hashMap.put("ESTONIA", "EE");
        hashMap.put("ETHIOPIA", "ET");
        hashMap.put("FINLAND", "FI");
        hashMap.put("FRANCE", "FR");
        hashMap.put("FYR MACEDONIA", "MK");
        hashMap.put("GABON", "GA");
        hashMap.put("GERMANY", "DE");
        hashMap.put("GHANA", "GH");
        hashMap.put("GREECE", "GR");
        hashMap.put("GRENADA", "GD");
        hashMap.put("GUATEMALA", "GT");
        hashMap.put("GUYANA", "GY");
        hashMap.put("HAITI", "HT");
        hashMap.put("HONDURAS", "HN");
        hashMap.put("HONG KONG", "HK");
        hashMap.put("HUNGARY", "HU");
        hashMap.put("ICELAND", "IS");
        hashMap.put("INDIA", "IN");
        hashMap.put("INDONESIA", "ID");
        hashMap.put("IRAN", "IR");
        hashMap.put("IRAQ", "IQ");
        hashMap.put("IRELAND", "IE");
        hashMap.put("ISRAEL", "IL");
        hashMap.put("ITALY", "IT");
        hashMap.put("IVORY COAST", "CI");
        hashMap.put("JAMAICA", "JM");
        hashMap.put("JAPAN", "JP");
        hashMap.put("JORDAN", "JO");
        hashMap.put("KAZAKHSTAN", "KZ");
        hashMap.put("KENYA", "KE");
        hashMap.put("KOREA", "KR");
        hashMap.put("KUWAIT", "KW");
        hashMap.put("LAOS", "LA");
        hashMap.put("LATVIA", "LV");
        hashMap.put("LEBANON", "LB");
        hashMap.put("LIBYA", "LY");
        hashMap.put("LIECHTENSTEIN", "LI");
        hashMap.put("LITHUANIA", "LT");
        hashMap.put("LUXEMBOURG", "LU");
        hashMap.put("MACAO", "MO");
        hashMap.put("MACEDONIA", "MK");
        hashMap.put("MALAWI", "MW");
        hashMap.put("MALAYSIA", "MY");
        hashMap.put("MALDIVES", "MV");
        hashMap.put("MALTA", "MT");
        hashMap.put("MAURITANIA", "MR");
        hashMap.put("MAURITIUS", "MU");
        hashMap.put("MEXICO", "MX");
        hashMap.put("MOLDOVA", "MD");
        hashMap.put("MONTENEGRO", "ME");
        hashMap.put("MOROCCO", "MA");
        hashMap.put("MOZAMBIQUE", "MZ");
        hashMap.put("NAMIBIA", "NA");
        hashMap.put("NEPAL", "NP");
        hashMap.put("NEW ZEALAND", "NZ");
        hashMap.put("NICARAGUA", "NI");
        hashMap.put("NIGERIA", "NG");
        hashMap.put("NORWAY", "NO");
        hashMap.put("OMAN", "OM");
        hashMap.put("PAKISTAN", "PK");
        hashMap.put("PANAMA", "PA");
        hashMap.put("PARAGUAY", "PY");
        hashMap.put("PERU", "PE");
        hashMap.put("PHILIPPINES", "PH");
        hashMap.put("POLAND", "PL");
        hashMap.put("PORTUGAL", "PT");
        hashMap.put("PUERTO RICO", "PR");
        hashMap.put("QATAR", "QA");
        hashMap.put("ROMANIA", "RO");
        hashMap.put("RUSSIA", "RU");
        hashMap.put("SAINT KITTS AND NEVIS", "KN");
        hashMap.put("SAINT LUCIA", "LC");
        hashMap.put("SAUDI ARABIA", "SA");
        hashMap.put("SENEGAL", "SN");
        hashMap.put("SERBIA", "RS");
        hashMap.put("SERBIA AND MONTENEGRO", "CS");
        hashMap.put("SIERRA LEONE", "SL");
        hashMap.put("SINGAPORE", "SG");
        hashMap.put("SLOVAKIA", "SK");
        hashMap.put("SLOVENIA", "SI");
        hashMap.put("SOMALIA", "SO");
        hashMap.put("SOUTH AFRICA", "ZA");
        hashMap.put("SOUTH SUDAN", "SS");
        hashMap.put("SPAIN", "ES");
        hashMap.put("SRI LANKA", "LK");
        hashMap.put("SUDAN", "SD");
        hashMap.put("SURINAME", "SR");
        hashMap.put("SWAZILAND", "SZ");
        hashMap.put("SWEDEN", "SE");
        hashMap.put("SWITZERLAND", "CH");
        hashMap.put("SYRIA", "SY");
        hashMap.put("TAIWAN", "TW");
        hashMap.put("TANZANIA", "TZ");
        hashMap.put("THAILAND", "TH");
        hashMap.put("THE NETHERLANDS", "NL");
        hashMap.put("TRINIDAD AND TOBAGO", "TT");
        hashMap.put("TUNISIA", "TN");
        hashMap.put("TURKEY", "TR");
        hashMap.put("TURKMENISTAN", "TM");
        hashMap.put("UGANDA", "UG");
        hashMap.put("UKRAINE", "UA");
        hashMap.put("UNITED ARAB EMIRATES", "AE");
        hashMap.put("UNITED KINGDOM", "GB");
        hashMap.put("URUGUAY", "UY");
        hashMap.put("UZBEKISTAN", "UZ");
        hashMap.put("VENEZUELA", "VE");
        hashMap.put("VIETNAM", "VN");
        hashMap.put("YEMEN", "YE");
        hashMap.put("YUGOSLAVIA", "YU");
        hashMap.put("ZAMBIA", "ZM");
        hashMap.put("ZIMBABWE", "ZW");
        return hashMap;
    }

    private static synchronized Map getLang2Terr() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ALBANIAN", "ALBANIA");
        hashMap.put("AMERICAN", "AMERICA");
        hashMap.put("AMHARIC", "ETHIOPIA");
        hashMap.put("ARABIC", "UNITED ARAB EMIRATES");
        hashMap.put("ARMENIAN", "ARMENIA");
        hashMap.put("ASSAMESE", "INDIA");
        hashMap.put("AZERBAIJANI", "AZERBAIJAN");
        hashMap.put("BANGLA", "INDIA");
        hashMap.put("BASQUE", "SPAIN");
        hashMap.put("BELARUSIAN", "BELARUS");
        hashMap.put("BRAZILIAN PORTUGUESE", "BRAZIL");
        hashMap.put("BULGARIAN", "BULGARIA");
        hashMap.put("CANADIAN FRENCH", "CANADA");
        hashMap.put("CATALAN", "CATALONIA");
        hashMap.put("CROATIAN", "CROATIA");
        hashMap.put("CYRILLIC KAZAKH", "KAZAKHSTAN");
        hashMap.put("CYRILLIC SERBIAN", "SERBIA");
        hashMap.put("CYRILLIC UZBEK", "UZBEKISTAN");
        hashMap.put("CZECH", "CZECH REPUBLIC");
        hashMap.put("DANISH", "DENMARK");
        hashMap.put("DARI", "AFGHANISTAN");
        hashMap.put("DIVEHI", "MALDIVES");
        hashMap.put("DUTCH", "THE NETHERLANDS");
        hashMap.put("EGYPTIAN", "EGYPT");
        hashMap.put("ENGLISH", "UNITED KINGDOM");
        hashMap.put("ESTONIAN", "ESTONIA");
        hashMap.put("FINNISH", "FINLAND");
        hashMap.put("FRENCH", "FRANCE");
        hashMap.put("GERMAN", "GERMANY");
        hashMap.put("GERMAN DIN", "GERMANY");
        hashMap.put("GREEK", "GREECE");
        hashMap.put("GUJARATI", "INDIA");
        hashMap.put("HEBREW", "ISRAEL");
        hashMap.put("HINDI", "INDIA");
        hashMap.put("HUNGARIAN", "HUNGARY");
        hashMap.put("ICELANDIC", "ICELAND");
        hashMap.put("INDONESIAN", "INDONESIA");
        hashMap.put("IRISH", "IRELAND");
        hashMap.put("ITALIAN", "ITALY");
        hashMap.put("JAPANESE", "JAPAN");
        hashMap.put("KANNADA", "INDIA");
        hashMap.put("KHMER", "CAMBODIA");
        hashMap.put("KOREAN", "KOREA");
        hashMap.put("LAO", "LAOS");
        hashMap.put(DEFAULT_ES_ORA_LANGUAGE, "AMERICA");
        hashMap.put("LATIN BOSNIAN", "BOSNIA AND HERZEGOVINA");
        hashMap.put("LATIN SERBIAN", "SERBIA");
        hashMap.put("LATIN UZBEK", "UZBEKISTAN");
        hashMap.put("LATVIAN", "LATVIA");
        hashMap.put("LITHUANIAN", "LITHUANIA");
        hashMap.put("MACEDONIAN", "FYR MACEDONIA");
        hashMap.put("MALAY", "MALAYSIA");
        hashMap.put("MALAYALAM", "INDIA");
        hashMap.put("MALTESE", "MALTA");
        hashMap.put("MARATHI", "INDIA");
        hashMap.put("MEXICAN SPANISH", "MEXICO");
        hashMap.put("NEPALI", "NEPAL");
        hashMap.put("NORWEGIAN", "NORWAY");
        hashMap.put("ORIYA", "INDIA");
        hashMap.put("PERSIAN", "IRAN");
        hashMap.put("POLISH", "POLAND");
        hashMap.put("PORTUGUESE", "PORTUGAL");
        hashMap.put("PUNJABI", "INDIA");
        hashMap.put("ROMANIAN", "ROMANIA");
        hashMap.put("RUSSIAN", "RUSSIA");
        hashMap.put("SIMPLIFIED CHINESE", "CHINA");
        hashMap.put("SINHALA", "SRI LANKA");
        hashMap.put("SLOVAK", "SLOVAKIA");
        hashMap.put("SLOVENIAN", "SLOVENIA");
        hashMap.put("SPANISH", "SPAIN");
        hashMap.put("SWAHILI", "KENYA");
        hashMap.put("SWEDISH", "SWEDEN");
        hashMap.put("TAMIL", "INDIA");
        hashMap.put("TELUGU", "INDIA");
        hashMap.put("THAI", "THAILAND");
        hashMap.put("TRADITIONAL CHINESE", "TAIWAN");
        hashMap.put("TURKISH", "TURKEY");
        hashMap.put("TURKMEN", "TURKMENISTAN");
        hashMap.put("UKRAINIAN", "UKRAINE");
        hashMap.put("URDU", "PAKISTAN");
        hashMap.put("VIETNAMESE", "VIETNAM");
        return hashMap;
    }

    private static synchronized Map getIsoLangToOracleMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("am", "AMHARIC");
        hashMap.put("ar", "ARABIC");
        hashMap.put("as", "ASSAMESE");
        hashMap.put("az", "AZERBAIJANI");
        hashMap.put("be", "BELARUSIAN");
        hashMap.put("bg", "BULGARIAN");
        hashMap.put("bn", "BANGLA");
        hashMap.put("bs", "LATIN BOSNIAN");
        hashMap.put("ca", "CATALAN");
        hashMap.put("cs", "CZECH");
        hashMap.put("da", "DANISH");
        hashMap.put("de", "GERMAN");
        hashMap.put("dv", "DIVEHI");
        hashMap.put("el", "GREEK");
        hashMap.put("en", "ENGLISH");
        hashMap.put("es", "SPANISH");
        hashMap.put("et", "ESTONIAN");
        hashMap.put("eu", "BASQUE");
        hashMap.put("fa", "PERSIAN");
        hashMap.put("fi", "FINNISH");
        hashMap.put("fr", "FRENCH");
        hashMap.put("ga", "IRISH");
        hashMap.put("gu", "GUJARATI");
        hashMap.put("he", "HEBREW");
        hashMap.put("hi", "HINDI");
        hashMap.put("hr", "CROATIAN");
        hashMap.put("hu", "HUNGARIAN");
        hashMap.put("hy", "ARMENIAN");
        hashMap.put("id", "INDONESIAN");
        hashMap.put("in", "INDONESIAN");
        hashMap.put("is", "ICELANDIC");
        hashMap.put("it", "ITALIAN");
        hashMap.put("iw", "HEBREW");
        hashMap.put("ja", "JAPANESE");
        hashMap.put("kk", "CYRILLIC KAZAKH");
        hashMap.put("km", "KHMER");
        hashMap.put("kn", "KANNADA");
        hashMap.put("ko", "KOREAN");
        hashMap.put("lo", "LAO");
        hashMap.put("lt", "LITHUANIAN");
        hashMap.put("lv", "LATVIAN");
        hashMap.put("mk", "MACEDONIAN");
        hashMap.put("ml", "MALAYALAM");
        hashMap.put("mr", "MARATHI");
        hashMap.put("ms", "MALAY");
        hashMap.put("mt", "MALTESE");
        hashMap.put("nb", "NORWEGIAN");
        hashMap.put("ne", "NEPALI");
        hashMap.put("nl", "DUTCH");
        hashMap.put("nn", "NORWEGIAN");
        hashMap.put("no", "NORWEGIAN");
        hashMap.put("or", "ORIYA");
        hashMap.put("pa", "PUNJABI");
        hashMap.put("pl", "POLISH");
        hashMap.put("pr", "DARI");
        hashMap.put("pt", "PORTUGUESE");
        hashMap.put("ro", "ROMANIAN");
        hashMap.put("ru", "RUSSIAN");
        hashMap.put("sh", "LATIN SERBIAN");
        hashMap.put("si", "SINHALA");
        hashMap.put("sk", "SLOVAK");
        hashMap.put("sl", "SLOVENIAN");
        hashMap.put("sq", "ALBANIAN");
        hashMap.put("sr", "CYRILLIC SERBIAN");
        hashMap.put("sv", "SWEDISH");
        hashMap.put("sw", "SWAHILI");
        hashMap.put("ta", "TAMIL");
        hashMap.put("te", "TELUGU");
        hashMap.put("th", "THAI");
        hashMap.put("tk", "TURKMEN");
        hashMap.put("tr", "TURKISH");
        hashMap.put("uk", "UKRAINIAN");
        hashMap.put("ur", "URDU");
        hashMap.put("uz", "LATIN UZBEK");
        hashMap.put("vi", "VIETNAMESE");
        hashMap.put("zh", "SIMPLIFIED CHINESE");
        return hashMap;
    }

    private static synchronized Map getIsoLangDefaultTerrMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("am", "ET");
        hashMap.put("ar", "AE");
        hashMap.put("as", "IN");
        hashMap.put("az", "AZ");
        hashMap.put("be", "BY");
        hashMap.put("bg", "BG");
        hashMap.put("bn", "BD");
        hashMap.put("bs", "BA");
        hashMap.put("ca", "ES");
        hashMap.put("cs", "CZ");
        hashMap.put("da", "DK");
        hashMap.put("de", "DE");
        hashMap.put("dv", "MV");
        hashMap.put("el", "GR");
        hashMap.put("en", "US");
        hashMap.put("es", "ES");
        hashMap.put("et", "EE");
        hashMap.put("eu", "ES");
        hashMap.put("fa", "IR");
        hashMap.put("fi", "FI");
        hashMap.put("fr", "FR");
        hashMap.put("ga", "IE");
        hashMap.put("gu", "IN");
        hashMap.put("he", "IL");
        hashMap.put("hi", "IN");
        hashMap.put("hr", "HR");
        hashMap.put("hu", "HU");
        hashMap.put("hy", "AM");
        hashMap.put("id", "ID");
        hashMap.put("in", "ID");
        hashMap.put("is", "IS");
        hashMap.put("it", "IT");
        hashMap.put("iw", "IL");
        hashMap.put("ja", "JP");
        hashMap.put("kk", "KZ");
        hashMap.put("km", "KH");
        hashMap.put("kn", "IN");
        hashMap.put("ko", "KR");
        hashMap.put("lo", "LA");
        hashMap.put("lt", "LT");
        hashMap.put("lv", "LV");
        hashMap.put("mk", "MK");
        hashMap.put("ml", "IN");
        hashMap.put("mr", "IN");
        hashMap.put("ms", "MY");
        hashMap.put("mt", "MT");
        hashMap.put("nb", "NO");
        hashMap.put("ne", "NP");
        hashMap.put("nl", "NL");
        hashMap.put("nn", "NO");
        hashMap.put("no", "NO");
        hashMap.put("or", "IN");
        hashMap.put("pa", "IN");
        hashMap.put("pl", "PL");
        hashMap.put("pr", "AF");
        hashMap.put("pt", "PT");
        hashMap.put("ro", "RO");
        hashMap.put("ru", "RU");
        hashMap.put("si", "LK");
        hashMap.put("sk", "SK");
        hashMap.put("sl", "SI");
        hashMap.put("sq", "AL");
        hashMap.put("sr", "RS");
        hashMap.put("sv", "SE");
        hashMap.put("ta", "IN");
        hashMap.put("te", "IN");
        hashMap.put("th", "TH");
        hashMap.put("tk", "TM");
        hashMap.put("tr", "TR");
        hashMap.put("uk", "UA");
        hashMap.put("ur", "PK");
        hashMap.put("uz", "UZ");
        hashMap.put("vi", "VN");
        hashMap.put("zh", "CN");
        return hashMap;
    }

    private static synchronized Map getIsoLocToOracleMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ar_EG", "EGYPTIAN_EGYPT");
        hashMap.put("ca_ES", "CATALAN_CATALONIA");
        hashMap.put("en_US", "AMERICAN_AMERICA");
        hashMap.put("es_ES", "SPANISH_SPAIN");
        hashMap.put("es_MX", "MEXICAN SPANISH_MEXICO");
        hashMap.put("fr_CA", "CANADIAN FRENCH_CANADA");
        hashMap.put("pt_BR", "BRAZILIAN PORTUGUESE_BRAZIL");
        hashMap.put("zh_HK", "TRADITIONAL CHINESE_HONG KONG");
        hashMap.put("zh_MO", "TRADITIONAL CHINESE_MACAO");
        hashMap.put("zh_TW", "TRADITIONAL CHINESE_TAIWAN");
        return hashMap;
    }

    private static synchronized Map getIsoTerrToOracleMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AE", "UNITED ARAB EMIRATES");
        hashMap.put("AF", "AFGHANISTAN");
        hashMap.put("AG", "ANTIGUA AND BARBUDA");
        hashMap.put("AL", "ALBANIA");
        hashMap.put("AM", "ARMENIA");
        hashMap.put("AO", "ANGOLA");
        hashMap.put("AR", "ARGENTINA");
        hashMap.put("AT", "AUSTRIA");
        hashMap.put("AU", "AUSTRALIA");
        hashMap.put("AW", "ARUBA");
        hashMap.put("AZ", "AZERBAIJAN");
        hashMap.put("BA", "BOSNIA AND HERZEGOVINA");
        hashMap.put("BB", "BARBADOS");
        hashMap.put("BD", "BANGLADESH");
        hashMap.put("BE", "BELGIUM");
        hashMap.put("BG", "BULGARIA");
        hashMap.put("BH", "BAHRAIN");
        hashMap.put("BM", "BERMUDA");
        hashMap.put("BO", "BOLIVIA");
        hashMap.put("BR", "BRAZIL");
        hashMap.put("BS", "BAHAMAS");
        hashMap.put("BW", "BOTSWANA");
        hashMap.put("BY", "BELARUS");
        hashMap.put("BZ", "BELIZE");
        hashMap.put("CA", "CANADA");
        hashMap.put("CD", "CONGO KINSHASA");
        hashMap.put("CG", "CONGO BRAZZAVILLE");
        hashMap.put("CH", "SWITZERLAND");
        hashMap.put("CI", "IVORY COAST");
        hashMap.put("CL", "CHILE");
        hashMap.put("CM", "CAMEROON");
        hashMap.put("CN", "CHINA");
        hashMap.put("CO", "COLOMBIA");
        hashMap.put("CR", "COSTA RICA");
        hashMap.put("CS", "SERBIA AND MONTENEGRO");
        hashMap.put("CW", "CURACAO");
        hashMap.put("CY", "CYPRUS");
        hashMap.put("CZ", "CZECH REPUBLIC");
        hashMap.put("DE", "GERMANY");
        hashMap.put("DJ", "DJIBOUTI");
        hashMap.put("DK", "DENMARK");
        hashMap.put("DM", "DOMINICA");
        hashMap.put("DO", "DOMINICAN REPUBLIC");
        hashMap.put("DZ", "ALGERIA");
        hashMap.put("EC", "ECUADOR");
        hashMap.put("EE", "ESTONIA");
        hashMap.put("EG", "EGYPT");
        hashMap.put("ES", "SPAIN");
        hashMap.put("ET", "ETHIOPIA");
        hashMap.put("FI", "FINLAND");
        hashMap.put("FR", "FRANCE");
        hashMap.put("GA", "GABON");
        hashMap.put("GB", "UNITED KINGDOM");
        hashMap.put("GD", "GRENADA");
        hashMap.put("GH", "GHANA");
        hashMap.put("GR", "GREECE");
        hashMap.put("GT", "GUATEMALA");
        hashMap.put("GY", "GUYANA");
        hashMap.put("HK", "HONG KONG");
        hashMap.put("HN", "HONDURAS");
        hashMap.put("HR", "CROATIA");
        hashMap.put("HT", "HAITI");
        hashMap.put("HU", "HUNGARY");
        hashMap.put("ID", "INDONESIA");
        hashMap.put("IE", "IRELAND");
        hashMap.put("IL", "ISRAEL");
        hashMap.put("IN", "INDIA");
        hashMap.put("IQ", "IRAQ");
        hashMap.put("IR", "IRAN");
        hashMap.put("IS", "ICELAND");
        hashMap.put("IT", "ITALY");
        hashMap.put("JM", "JAMAICA");
        hashMap.put("JO", "JORDAN");
        hashMap.put("JP", "JAPAN");
        hashMap.put("KE", "KENYA");
        hashMap.put("KH", "CAMBODIA");
        hashMap.put("KN", "SAINT KITTS AND NEVIS");
        hashMap.put("KR", "KOREA");
        hashMap.put("KW", "KUWAIT");
        hashMap.put("KY", "CAYMAN ISLANDS");
        hashMap.put("KZ", "KAZAKHSTAN");
        hashMap.put("LA", "LAOS");
        hashMap.put("LB", "LEBANON");
        hashMap.put("LC", "SAINT LUCIA");
        hashMap.put("LI", "LIECHTENSTEIN");
        hashMap.put("LK", "SRI LANKA");
        hashMap.put("LT", "LITHUANIA");
        hashMap.put("LU", "LUXEMBOURG");
        hashMap.put("LV", "LATVIA");
        hashMap.put("LY", "LIBYA");
        hashMap.put("MA", "MOROCCO");
        hashMap.put("MD", "MOLDOVA");
        hashMap.put("ME", "MONTENEGRO");
        hashMap.put("MK", "FYR MACEDONIA");
        hashMap.put("MO", "MACAO");
        hashMap.put("MR", "MAURITANIA");
        hashMap.put("MT", "MALTA");
        hashMap.put("MU", "MAURITIUS");
        hashMap.put("MV", "MALDIVES");
        hashMap.put("MW", "MALAWI");
        hashMap.put("MX", "MEXICO");
        hashMap.put("MY", "MALAYSIA");
        hashMap.put("MZ", "MOZAMBIQUE");
        hashMap.put("NA", "NAMIBIA");
        hashMap.put("NG", "NIGERIA");
        hashMap.put("NI", "NICARAGUA");
        hashMap.put("NL", "THE NETHERLANDS");
        hashMap.put("NO", "NORWAY");
        hashMap.put("NP", "NEPAL");
        hashMap.put("NZ", "NEW ZEALAND");
        hashMap.put("OM", "OMAN");
        hashMap.put("PA", "PANAMA");
        hashMap.put("PE", "PERU");
        hashMap.put("PH", "PHILIPPINES");
        hashMap.put("PK", "PAKISTAN");
        hashMap.put("PL", "POLAND");
        hashMap.put("PR", "PUERTO RICO");
        hashMap.put("PT", "PORTUGAL");
        hashMap.put("PY", "PARAGUAY");
        hashMap.put("QA", "QATAR");
        hashMap.put("RO", "ROMANIA");
        hashMap.put("RS", "SERBIA");
        hashMap.put("RU", "RUSSIA");
        hashMap.put("SA", "SAUDI ARABIA");
        hashMap.put("SD", "SUDAN");
        hashMap.put("SE", "SWEDEN");
        hashMap.put("SG", "SINGAPORE");
        hashMap.put("SI", "SLOVENIA");
        hashMap.put("SK", "SLOVAKIA");
        hashMap.put("SL", "SIERRA LEONE");
        hashMap.put("SN", "SENEGAL");
        hashMap.put("SO", "SOMALIA");
        hashMap.put("SR", "SURINAME");
        hashMap.put("SS", "SOUTH SUDAN");
        hashMap.put("SV", "EL SALVADOR");
        hashMap.put("SY", "SYRIA");
        hashMap.put("SZ", "SWAZILAND");
        hashMap.put("TH", "THAILAND");
        hashMap.put("TM", "TURKMENISTAN");
        hashMap.put("TN", "TUNISIA");
        hashMap.put("TR", "TURKEY");
        hashMap.put("TT", "TRINIDAD AND TOBAGO");
        hashMap.put("TW", "TAIWAN");
        hashMap.put("TZ", "TANZANIA");
        hashMap.put("UA", "UKRAINE");
        hashMap.put("UG", "UGANDA");
        hashMap.put("US", "AMERICA");
        hashMap.put("UY", "URUGUAY");
        hashMap.put("UZ", "UZBEKISTAN");
        hashMap.put("VE", "VENEZUELA");
        hashMap.put("VN", "VIETNAM");
        hashMap.put("YE", "YEMEN");
        hashMap.put("YU", "YUGOSLAVIA");
        hashMap.put("ZA", "SOUTH AFRICA");
        hashMap.put("ZM", "ZAMBIA");
        hashMap.put("ZW", "ZIMBABWE");
        return hashMap;
    }

    private static synchronized Map getCharsetRatio() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("2000", "258");
        hashMap.put("873", "4");
        hashMap.put("557", "1");
        hashMap.put("558", "1");
        hashMap.put("559", "1");
        hashMap.put("565", "1");
        hashMap.put("566", "1");
        hashMap.put("500", "1");
        hashMap.put("320", "1");
        hashMap.put("70", "1");
        hashMap.put("36", "1");
        hashMap.put("560", "1");
        hashMap.put("556", "1");
        hashMap.put("554", "1");
        hashMap.put("561", "1");
        hashMap.put("563", "1");
        hashMap.put("555", "1");
        hashMap.put("52", "1");
        hashMap.put("173", "1");
        hashMap.put("140", "1");
        hashMap.put("191", "1");
        hashMap.put("194", "1");
        hashMap.put("314", "1");
        hashMap.put("47", "1");
        hashMap.put("179", "1");
        hashMap.put("197", "1");
        hashMap.put("43", "1");
        hashMap.put("390", "1");
        hashMap.put("233", "1");
        hashMap.put("48", "1");
        hashMap.put("19", "1");
        hashMap.put("235", "1");
        hashMap.put("185", "1");
        hashMap.put("322", "1");
        hashMap.put("323", "1");
        hashMap.put("317", "1");
        hashMap.put("188", "1");
        hashMap.put("325", "1");
        hashMap.put("326", "1");
        hashMap.put("35", "1");
        hashMap.put("49", "1");
        hashMap.put("196", "1");
        hashMap.put("51", "1");
        hashMap.put("158", "1");
        hashMap.put("159", "1");
        hashMap.put("171", "1");
        hashMap.put("11", "1");
        hashMap.put("207", "1");
        hashMap.put("222", "1");
        hashMap.put("189", "1");
        hashMap.put("180", "1");
        hashMap.put("204", "1");
        hashMap.put("225", "1");
        hashMap.put("198", "1");
        hashMap.put("182", "1");
        hashMap.put("14", "1");
        hashMap.put("202", "1");
        hashMap.put("224", "1");
        hashMap.put("232", "1");
        hashMap.put("184", "1");
        hashMap.put("301", "1");
        hashMap.put("316", "1");
        hashMap.put("32", "1");
        hashMap.put("262", "1");
        hashMap.put("162", "1");
        hashMap.put("263", "1");
        hashMap.put("163", "1");
        hashMap.put("170", "1");
        hashMap.put("150", "1");
        hashMap.put("110", "1");
        hashMap.put("113", "1");
        hashMap.put("81", "1");
        hashMap.put("327", "1");
        hashMap.put("381", "1");
        hashMap.put("324", "1");
        hashMap.put("211", "1");
        hashMap.put("37", "1");
        hashMap.put("266", "1");
        hashMap.put("166", "1");
        hashMap.put("174", "1");
        hashMap.put("380", "1");
        hashMap.put("382", "1");
        hashMap.put("386", "1");
        hashMap.put("385", "1");
        hashMap.put("172", "1");
        hashMap.put("12", "1");
        hashMap.put("201", "1");
        hashMap.put("223", "1");
        hashMap.put("208", "1");
        hashMap.put("186", "1");
        hashMap.put("401", "1");
        hashMap.put("368", "1");
        hashMap.put("17", "1");
        hashMap.put("206", "1");
        hashMap.put("200", "1");
        hashMap.put("181", "1");
        hashMap.put("25", "1");
        hashMap.put("265", "1");
        hashMap.put("165", "1");
        hashMap.put("161", "1");
        hashMap.put("23", "1");
        hashMap.put("187", "1");
        hashMap.put("92", "1");
        hashMap.put("315", "1");
        hashMap.put("38", "1");
        hashMap.put("267", "1");
        hashMap.put("167", "1");
        hashMap.put("175", "1");
        hashMap.put("154", "1");
        hashMap.put("833", "2");
        hashMap.put("835", "2");
        hashMap.put("830", "3");
        hashMap.put("837", "3");
        hashMap.put("831", "3");
        hashMap.put("836", "2");
        hashMap.put("832", "2");
        hashMap.put("838", "2");
        hashMap.put("834", "2");
        hashMap.put("829", "2");
        hashMap.put("842", "2");
        hashMap.put("840", "2");
        hashMap.put("845", "2");
        hashMap.put("846", "2");
        hashMap.put("590", "1");
        hashMap.put("114", "1");
        hashMap.put("176", "1");
        hashMap.put("383", "1");
        hashMap.put("384", "1");
        hashMap.put("192", "1");
        hashMap.put("193", "1");
        hashMap.put("195", "1");
        hashMap.put("205", "1");
        hashMap.put("190", "1");
        hashMap.put("16", "1");
        hashMap.put("40", "1");
        hashMap.put("34", "1");
        hashMap.put("18", "1");
        hashMap.put("153", "1");
        hashMap.put("155", "1");
        hashMap.put("152", "1");
        hashMap.put("13", "1");
        hashMap.put("203", "1");
        hashMap.put("226", "1");
        hashMap.put("199", "1");
        hashMap.put("183", "1");
        hashMap.put("33", "1");
        hashMap.put("15", "1");
        hashMap.put("21", "1");
        hashMap.put("353", "1");
        hashMap.put("354", "1");
        hashMap.put("41", "1");
        hashMap.put("42", "1");
        hashMap.put("319", "1");
        hashMap.put("22", "1");
        hashMap.put("82", "1");
        hashMap.put("93", "1");
        hashMap.put("312", "1");
        hashMap.put("264", "1");
        hashMap.put("164", "1");
        hashMap.put("177", "1");
        hashMap.put("156", "1");
        hashMap.put("1", "1");
        hashMap.put("221", "1");
        hashMap.put("277", "1");
        hashMap.put("4", "1");
        hashMap.put("871", "3");
        hashMap.put("872", "4");
        hashMap.put("45", "1");
        hashMap.put("44", "1");
        hashMap.put("231", "1");
        hashMap.put("230", "1");
        hashMap.put("239", "1");
        hashMap.put("2", "1");
        hashMap.put("241", "1");
        hashMap.put("96", "1");
        hashMap.put("100", "1");
        hashMap.put("7", "1");
        hashMap.put("97", "1");
        hashMap.put("98", "1");
        hashMap.put("9", "1");
        hashMap.put("27", "1");
        hashMap.put("99", "1");
        hashMap.put("95", "1");
        hashMap.put("8", "1");
        hashMap.put("5", "1");
        hashMap.put("90", "1");
        hashMap.put("6", "1");
        hashMap.put("91", "1");
        hashMap.put("94", "1");
        hashMap.put("101", "1");
        hashMap.put("210", "1");
        hashMap.put("3", "1");
        hashMap.put("278", "1");
        hashMap.put("31", "1");
        hashMap.put("46", "1");
        hashMap.put("39", "1");
        hashMap.put("279", "1");
        hashMap.put("351", "1");
        hashMap.put("352", "1");
        hashMap.put("178", "1");
        hashMap.put("251", "1");
        hashMap.put("50", "1");
        hashMap.put("10", "1");
        hashMap.put("28", "1");
        hashMap.put("160", "1");
        hashMap.put("261", "1");
        hashMap.put("20", "1");
        hashMap.put("850", "2");
        hashMap.put("853", "2");
        hashMap.put("852", "2");
        hashMap.put("851", "2");
        hashMap.put("854", "260");
        hashMap.put("865", "2");
        hashMap.put("866", "2");
        hashMap.put("864", "2");
        hashMap.put("862", "1");
        hashMap.put("868", "2");
        hashMap.put("992", "2");
        hashMap.put("867", "2");
        hashMap.put("860", "4");
        hashMap.put("861", "2");
        hashMap.put("863", "4");
        return hashMap;
    }

    private LxMetaData() {
    }
}

