/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.dom.OnElement;

public class XmlDefine {
    private String m_name;
    private List<String> m_includes = Lists.newArrayList();

    public void setName(String string) {
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public String toXml(String string) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        boolean bl = CollectionUtils.hasElements(this.m_includes);
        if (bl) {
            xMLStringBuffer.push("define", "name", this.m_name);
        }
        for (String string2 : this.m_includes) {
            xMLStringBuffer.addEmptyElement("include", "name", string2);
        }
        if (bl) {
            xMLStringBuffer.pop("define");
        }
        return xMLStringBuffer.toXML();
    }

    @OnElement(tag="include", attributes={"name"})
    public void onElement(String string) {
        this.m_includes.add(string);
    }

    public List<String> getIncludes() {
        return this.m_includes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        XmlDefine xmlDefine = (XmlDefine)object;
        if (this.m_name != null ? !this.m_name.equals(xmlDefine.m_name) : xmlDefine.m_name != null) {
            return false;
        }
        return this.m_includes != null ? this.m_includes.equals(xmlDefine.m_includes) : xmlDefine.m_includes == null;
    }

    public int hashCode() {
        int n = this.m_name != null ? this.m_name.hashCode() : 0;
        n = 31 * n + (this.m_includes != null ? this.m_includes.hashCode() : 0);
        return n;
    }
}

