/*
 * Oracle Linux DTrace.
 * Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 * Licensed under the Universal Permissive License v 1.0 as shown at
 * http://oss.oracle.com/licenses/upl.
 */

/*
 * ASSERTION:  Integers are typecast correctly. (explicit)
 *	       The .r results file can be generated by copying this file
 *	       to a .c file and compiling the resulting C program.
 *
 * SECTION: Types, Operators, and Expressions/Arithmetic Operators
 */
/* @@runtest-opts: -qC -DUSE_AS_D_SCRIPT */

#ifndef USE_AS_D_SCRIPT
#include <stdio.h>
#endif

signed char c, c0;
short s, s0;
int i, i0;
long long l, l0;
unsigned char C, C0;
unsigned short S, S0;
unsigned int I, I0;
unsigned long long L, L0;

#ifdef USE_AS_D_SCRIPT
#define FMT "%d %d %d %d %d %d %d %d\n"
#else
#define FMT "%hhd %hd %d %lld %hhu %hu %u %llu\n"
#endif

#define TEST(x) \
	c = (signed char)(x); \
	s = (short)(x); \
	i = (int)(x); \
	l = (long long)(x); \
	C = (unsigned char)(x); \
	S = (unsigned short)(x); \
	I = (unsigned int)(x); \
	L = (unsigned long long)(x); \
	printf(FMT, c, s, i, l, C, S, I, L)

#ifdef USE_AS_D_SCRIPT
BEGIN
#else
int main(int c_unused, char **v_unused)
#endif
{
	/* from scalar */
	TEST(-2);
	TEST(0xfffffffffffffffe);
	TEST(0xfffffffe);
	TEST(0xfffe);
	TEST(0xfe);
	TEST(2);
	TEST(0x55);
	TEST(0x5555);
	TEST(0x55555555);
	TEST(0x5555555555555555);

	/* from signed char */
	c0 = -2; TEST(c0);
	c0 = 0xfe; TEST(c0);
	c0 = 2; TEST(c0);
	c0 = 0x55; TEST(c0);

	/* from short */
	s0 = -2; TEST(s0);
	s0 = 0xfffe; TEST(s0);
	s0 = 2; TEST(s0);
	s0 = 0x5555; TEST(s0);

	/* from int */
	i0 = -2; TEST(i0);
	i0 = 0xfffffffe; TEST(i0);
	i0 = 2; TEST(i0);
	i0 = 0x55555555; TEST(i0);

	/* from long long */
	l0 = -2; TEST(l0);
	l0 = 0xfffffffffffffffe; TEST(l0);
	l0 = 2; TEST(l0);
	l0 = 0x5555555555555555; TEST(l0);

	/* from unsigned char */
	C0 = -2; TEST(C0);
	C0 = 0xfe; TEST(C0);
	C0 = 2; TEST(C0);
	C0 = 0x55; TEST(C0);

	/* from unsigned short */
	S0 = -2; TEST(S0);
	S0 = 0xfffe; TEST(S0);
	S0 = 2; TEST(S0);
	S0 = 0x5555; TEST(S0);

	/* from unsigned int */
	I0 = -2; TEST(I0);
	I0 = 0xfffffffe; TEST(I0);
	I0 = 2; TEST(I0);
	I0 = 0x55555555; TEST(I0);

	/* from unsigned long long */
	L0 = -2; TEST(L0);
	L0 = 0xfffffffffffffffe; TEST(L0);
	L0 = 2; TEST(L0);
	L0 = 0x5555555555555555; TEST(L0);

	/* from other constant expressions */
	TEST((signed char)(-1));
	TEST((short)(-1));
	TEST((int)(-1));
	TEST((long long)(-1));
	TEST((unsigned char)(-1));
	TEST((unsigned short)(-1));
	TEST((unsigned int)(-1));
	TEST((unsigned long long)(-1));

	TEST((long long)(signed char)(-1));
	TEST((long long)(short)(-1));
	TEST((long long)(int)(-1));
	TEST((long long)(long long)(-1));
	TEST((long long)(unsigned char)(-1));
	TEST((long long)(unsigned short)(-1));
	TEST((long long)(unsigned int)(-1));
	TEST((long long)(unsigned long long)(-1));

	/* from other expressions */
	l0 = -1;
	TEST((signed char)l0);
	TEST((short)l0);
	TEST((int)l0);
	TEST((long long)l0);
	TEST((unsigned char)l0);
	TEST((unsigned short)l0);
	TEST((unsigned int)l0);
	TEST((unsigned long long)l0);

	TEST((long long)(signed char)l0);
	TEST((long long)(short)l0);
	TEST((long long)(int)l0);
	TEST((long long)(long long)l0);
	TEST((long long)(unsigned char)l0);
	TEST((long long)(unsigned short)l0);
	TEST((long long)(unsigned int)l0);
	TEST((long long)(unsigned long long)l0);

#ifdef USE_AS_D_SCRIPT
	exit (0);
#else
	return 0;
#endif
}
