/*
# <<BEGIN-copyright>>
# <<END-copyright>>
*/

/*
    This stuff is deprecated and should be removed soon (10-Apr-2013).
*/


#include <string.h>

#include "PoPs_mass.h"

#if defined __cplusplus
    namespace GIDI {
    using namespace GIDI;
#endif

#define e_Mass 5.4857990943e-4              /* electron mass in AMU */
#define Co58_Mass 5.7935752814e+01
#define Co58_e1Level_Mass 2.67205e-05       /* Co58 first nuclear level (24890 eV/c**2) in amu */

#define Ag110_Mass 1.09906107231e+02
#define Ag110_e2Level_Mass 1.2624e-04       /* Ag110 second nuclear level (117590 eV/c**2) in amu */
#define Cd115_Mass 1.14905430969e+02
#define Cd115_e1Level_Mass 1.9431e-04       /* Cd155 first nuclear level (1.81e5 eV/c**2) in amu */

#define Te127_Mass 1.26905226336e+02
#define Te127_e2Level_Mass 9.4751e-05       /* Te127 second nuclear level (88260 eV/c**2) in amu */
#define Te129_Mass 1.28906598238e+02
#define Te129_e1Level_Mass 1.1302e-04       /* Te129 second nuclear level (105280 eV/c**2) in amu */

#define Pm148_Mass 1.47917474618e+02
#define Pm148_e2Level_Mass 1.4804e-04       /* Pm148 second nuclear level (137900 eV/c**2) in amu */
#define Ho166_Mass 1.65932284162e+02
#define Ho166_e1Level_Mass 6.4252e-06       /* Ho166first nuclear level (5985 eV/c**2) in amu */


#define Am242_Mass 2.42059549159e+02
#define Am242_e2Level_Mass 5.153e-05        /* Am242's second nuclear level (48000 eV/c**2) in amu */
#define Am244_Mass 2.44064284847e+02
#define Am244_e1Level_Mass 9.4472e-05       /* Am244's second nuclear level (87999.9 eV/c**2) in amu */

#define Es254_Mass 2.54088022021e+02
#define Es254_e2Level_Mass 9.0392e-05       /* Es254 second nuclear level (84200 eV/c**2) in amu */

/*
Special symbols for undefined elements.
     Z   Symbol
    -----------
    113  Uut
    114  Uuq
    115  Uup
    116  Uuh
    117  Uus
    118  Uuo
*/

struct ZAMass {
    char const *symbol;
    double mass;
};

/* Most of the mass data from Ame2003 */

static struct ZAMass ZAMasses[] = {
    { "Tm180",      179.95792495 },         /* Needed by ENDF/B-VII.1 W186 but not in Wadi, et al. */
    { "Pt203",      202.976969588582 },     /* Needed by ENDF/B-VII.1 Hg204 but not in Wadi, et al. */
        { "Co58_e1",  Co58_Mass + Co58_e1Level_Mass },
        { "Ag110_e2", Ag110_Mass + Ag110_e2Level_Mass },
        { "Cd115_e1", Cd115_Mass + Cd115_e1Level_Mass },
        { "Te127_e2", Te127_Mass + Te127_e2Level_Mass },
        { "Te129_e1", Te129_Mass + Te129_e1Level_Mass },
        { "Pm148_e2", Pm148_Mass + Pm148_e2Level_Mass },
        { "Ho166_e1", Ho166_Mass + Ho166_e1Level_Mass },
        { "Am242_e2", Am242_Mass + Am242_e2Level_Mass },
        { "Am244_e1", Am244_Mass + Am244_e1Level_Mass },
        { "Es254_e2", Es254_Mass + Es254_e2Level_Mass },
        { "FissionProductENDL99120", 117.5 },
        { "FissionProductENDL99121", 116.546 },
        { "FissionProductENDL99122", 118.544 },
        { "FissionProductENDL99125", 117.5 },
        { "photon",     0. },
        { "e-",         e_Mass },             { "e+",         e_Mass },
        { "n",          1.00866491574e+00 },  { "p",         1.007276466812e+00 }, 
        { "h2",         2.01355321271e+00 },  { "h3",         3.015500713e+00 }, 
        { "he3",        3.01493223469e+00 },  { "he4",        4.0015061747e+00 }, 
        { "H_natural",  1.0079e+00 },         { "H1",         1.00782503207e+00 },  { "H2",         2.01410177785e+00 },
        { "H3",         3.01604927767e+00 },  { "H4",         4.027806424e+00 },    { "H5",         5.035311488e+00 },    { "H6",         6.044942594e+00 },
        { "H7",         7.052749e+00 },       { "He_natural", 4.0026e+00 },         { "He3",        3.01602931914e+00 },  { "He4",        4.00260325415e+00 },
        { "He5",        5.012223624e+00 },    { "He6",        6.018889124e+00 },    { "He7",        7.028020618e+00 },    { "He8",        8.033921897e+00 },
        { "He9",        9.043950286e+00 },    { "He10",       1.0052398837e+01 },   { "Li_natural", 6.941e+00 },          { "Li3",        3.030775e+00 },
        { "Li4",        4.027185558e+00 },    { "Li5",        5.0125378e+00 },      { "Li6",        6.015122794e+00 },    { "Li7",        7.016004548e+00 },
        { "Li8",        8.022487362e+00 },    { "Li9",        9.026789505e+00 },    { "Li10",       1.0035481259e+01 },   { "Li11",       1.1043797715e+01 },
        { "Li12",       1.205378e+01 },       { "Be_natural", 9.01218e+00 },        { "Be5",        5.04079e+00 },        { "Be6",        6.019726317e+00 },
        { "Be7",        7.016929828e+00 },    { "Be8",        8.005305103e+00 },    { "Be9",        9.012182201e+00 },    { "Be10",       1.0013533818e+01 },
        { "Be11",       1.1021657749e+01 },   { "Be12",       1.2026920737e+01 },   { "Be13",       1.3035693007e+01 },   { "Be14",       1.404289292e+01 },
        { "Be15",       1.505346e+01 },       { "Be16",       1.606192e+01 },       { "B_natural",  1.081e+01 },          { "B6",         6.04681e+00 },
        { "B7",         7.029917901e+00 },    { "B8",         8.024607233e+00 },    { "B9",         9.013328782e+00 },    { "B10",        1.0012936992e+01 },
        { "B11",        1.1009305406e+01 },   { "B12",        1.2014352104e+01 },   { "B13",        1.3017780217e+01 },   { "B14",        1.4025404009e+01 },
        { "B15",        1.5031103021e+01 },   { "B16",        1.6039808829e+01 },   { "B17",        1.7046989906e+01 },   { "B18",        1.805617e+01 },
        { "B19",        1.906373e+01 },       { "C_natural",  1.2011e+01 },         { "C8",         8.037675025e+00 },    { "C9",         9.031036689e+00 },
        { "C10",        1.0016853228e+01 },   { "C11",        1.1011433613e+01 },   { "C12",        1.2e+01 },            { "C13",        1.300335483778e+01 },
        { "C14",        1.40032419887e+01 },  { "C15",        1.5010599256e+01 },   { "C16",        1.6014701252e+01 },   { "C17",        1.7022586116e+01 },
        { "C18",        1.8026759354e+01 },   { "C19",        1.9034805018e+01 },   { "C20",        2.0040319754e+01 },   { "C21",        2.104934e+01 },
        { "C23",        2.20572e+01 },        { "N_natural",  1.40067e+01 },        { "N10",        1.0041653674e+01 },   { "N11",        1.1026090956e+01 },
        { "N12",        1.2018613197e+01 },   { "N13",        1.3005738609e+01 },   { "N14",        1.400307400478e+01 }, { "N15",        1.500010889823e+01 },
        { "N16",        1.6006101658e+01 },   { "N17",        1.7008450261e+01 },   { "N18",        1.8014078959e+01 },   { "N19",        1.9017028697e+01 },
        { "N20",        2.0023365807e+01 },   { "N21",        2.102710824e+01 },    { "N22",        2.2034394934e+01 },   { "N23",        2.304122e+01 },
        { "N24",        2.405104e+01 },       { "N25",        2.506066e+01 },       { "O_natural",  1.59994e+01 },        { "O12",        1.2034404895e+01 },
        { "O13",        1.3024812213e+01 },   { "O14",        1.400859625e+01 },    { "O15",        1.5003065617e+01 },   { "O16",        1.599491461956e+01 },
        { "O17",        1.6999131703e+01 },   { "O18",        1.7999161001e+01 },   { "O19",        1.900358013e+01 },    { "O20",        2.0004076742e+01 },
        { "O21",        2.1008655886e+01 },   { "O22",        2.2009966947e+01 },   { "O23",        2.3015687659e+01 },   { "O24",        2.4020472917e+01 },
        { "O25",        2.502946e+01 },       { "O26",        2.603834e+01 },       { "O27",        2.704826e+01 },       { "O28",        2.805781e+01 },
        { "F_natural",  1.8998403e+01 },      { "F14",        1.403506e+01 },       { "F15",        1.5018009103e+01 },   { "F16",        1.6011465724e+01 },
        { "F17",        1.7002095237e+01 },   { "F18",        1.8000937956e+01 },   { "F19",        1.8998403224e+01 },   { "F20",        1.9999981315e+01 },
        { "F21",        2.0999948951e+01 },   { "F22",        2.2002998815e+01 },   { "F23",        2.3003574631e+01 },   { "F24",        2.4008115485e+01 },
        { "F25",        2.5012101747e+01 },   { "F26",        2.6019615555e+01 },   { "F27",        2.7026760086e+01 },   { "F28",        2.803567e+01 },
        { "F29",        2.904326e+01 },       { "F30",        3.00525e+01 },        { "F31",        3.1060429e+01 },      { "Ne_natural", 2.0179e+01 },
        { "Ne16",       1.6025761262e+01 },   { "Ne17",       1.7017671504e+01 },   { "Ne18",       1.8005708213e+01 },   { "Ne19",       1.9001880248e+01 },
        { "Ne20",       1.999244017542e+01 }, { "Ne21",       2.0993846684e+01 },   { "Ne22",       2.1991385113e+01 },   { "Ne23",       2.2994466904e+01 },
        { "Ne24",       2.3993610779e+01 },   { "Ne25",       2.4997736888e+01 },   { "Ne26",       2.6000461206e+01 },   { "Ne27",       2.7007589903e+01 },
        { "Ne28",       2.8012071575e+01 },   { "Ne29",       2.9019385933e+01 },   { "Ne30",       3.0024801045e+01 },   { "Ne31",       3.103311e+01 },
        { "Ne32",       3.204002e+01 },       { "Ne33",       3.304938e+01 },       { "Ne34",       3.4057028e+01 },      { "Na_natural", 2.298977e+01 },
        { "Na18",       1.8025969e+01 },      { "Na19",       1.9013877499e+01 },   { "Na20",       2.0007351328e+01 },   { "Na21",       2.0997655206e+01 },
        { "Na22",       2.1994436425e+01 },   { "Na23",       2.298976928087e+01 }, { "Na24",       2.3990962782e+01 },   { "Na25",       2.4989953968e+01 },
        { "Na26",       2.5992633e+01 },      { "Na27",       2.6994076788e+01 },   { "Na28",       2.7998938e+01 },      { "Na29",       2.9002861e+01 },
        { "Na30",       3.0008976e+01 },      { "Na31",       3.1013585452e+01 },   { "Na32",       3.202046656e+01 },    { "Na33",       3.3026719756e+01 },
        { "Na34",       3.403517e+01 },       { "Na35",       3.5042493e+01 },      { "Na36",       3.605148e+01 },       { "Na37",       3.705934e+01 },
        { "Mg_natural", 2.4305e+01 },         { "Mg19",       1.903547e+01 },       { "Mg20",       2.0018862545e+01 },   { "Mg21",       2.101171291e+01 },
        { "Mg22",       2.1999573843e+01 },   { "Mg23",       2.2994123669e+01 },   { "Mg24",       2.3985041699e+01 },   { "Mg25",       2.4985836917e+01 },
        { "Mg26",       2.5982592929e+01 },   { "Mg27",       2.6984340585e+01 },   { "Mg28",       2.7983876825e+01 },   { "Mg29",       2.89886e+01 },
        { "Mg30",       2.9990434e+01 },      { "Mg31",       3.0996546e+01 },      { "Mg32",       3.1998975e+01 },      { "Mg33",       3.3005254e+01 },
        { "Mg34",       3.4009456424e+01 },   { "Mg35",       3.501734e+01 },       { "Mg36",       3.6023e+01 },         { "Mg37",       3.70314e+01 },
        { "Mg38",       3.803757e+01 },       { "Mg39",       3.9046772e+01 },      { "Mg40",       4.005393e+01 },       { "Al_natural", 2.698154e+01 },
        { "Al21",       2.102804e+01 },       { "Al22",       2.201952e+01 },       { "Al23",       2.3007267432e+01 },   { "Al24",       2.3999938865e+01 },
        { "Al25",       2.4990428095e+01 },   { "Al26",       2.5986891692e+01 },   { "Al27",       2.6981538627e+01 },   { "Al28",       2.7981910306e+01 },
        { "Al29",       2.8980445046e+01 },   { "Al30",       2.9982960256e+01 },   { "Al31",       3.0983946619e+01 },   { "Al32",       3.1988124489e+01 },
        { "Al33",       3.2990843336e+01 },   { "Al34",       3.3996851837e+01 },   { "Al35",       3.4999860235e+01 },   { "Al36",       3.6006207204e+01 },
        { "Al37",       3.701067782e+01 },    { "Al38",       3.8017231021e+01 },   { "Al39",       3.902297e+01 },       { "Al40",       4.003145e+01 },
        { "Al41",       4.103833e+01 },       { "Al42",       4.204689e+01 },       { "Si_natural", 2.80855e+01 },        { "Si22",       2.203453e+01 },
        { "Si23",       2.302552e+01 },       { "Si24",       2.4011545616e+01 },   { "Si25",       2.5004105574e+01 },   { "Si26",       2.5992329921e+01 },
        { "Si27",       2.6986704905e+01 },   { "Si28",       2.797692653246e+01 }, { "Si29",       2.89764947e+01 },     { "Si30",       2.9973770171e+01 },
        { "Si31",       3.0975363227e+01 },   { "Si32",       3.1974148082e+01 },   { "Si33",       3.297800022e+01 },    { "Si34",       3.3978575524e+01 },
        { "Si35",       3.4984583575e+01 },   { "Si36",       3.5986599477e+01 },   { "Si37",       3.699293608e+01 },    { "Si38",       3.7995633601e+01 },
        { "Si39",       3.9002070013e+01 },   { "Si40",       4.0005869121e+01 },   { "Si41",       4.101456e+01 },       { "Si42",       4.201979e+01 },
        { "Si43",       4.302866e+01 },       { "Si44",       4.403526e+01 },       { "P_natural",  3.097376e+01 },       { "P24",        2.403435e+01 },
        { "P25",        2.502026e+01 },       { "P26",        2.601178e+01 },       { "P27",        2.6999230236e+01 },   { "P28",        2.7992314761e+01 },
        { "P29",        2.8981800606e+01 },   { "P30",        2.9978313789e+01 },   { "P31",        3.0973761629e+01 },   { "P32",        3.1973907274e+01 },
        { "P33",        3.2971725543e+01 },   { "P34",        3.3973636257e+01 },   { "P35",        3.4973314117e+01 },   { "P36",        3.597825968e+01 },
        { "P37",        3.6979608946e+01 },   { "P38",        3.7984156827e+01 },   { "P39",        3.8986179475e+01 },   { "P40",        3.9991296951e+01 },
        { "P41",        4.0994335435e+01 },   { "P42",        4.2001007913e+01 },   { "P43",        4.300619e+01 },       { "P44",        4.401299e+01 },
        { "P45",        4.501922e+01 },       { "P46",        4.602738e+01 },       { "S_natural",  3.206e+01 },          { "S26",        2.602788e+01 },
        { "S27",        2.7018833e+01 },      { "S28",        2.8004372763e+01 },   { "S29",        2.8996608049e+01 },   { "S30",        2.9984903249e+01 },
        { "S31",        3.0979554728e+01 },   { "S32",        3.1972070999e+01 },   { "S33",        3.2971458759e+01 },   { "S34",        3.3967866902e+01 },
        { "S35",        3.4969032161e+01 },   { "S36",        3.596708076e+01 },    { "S37",        3.6971125567e+01 },   { "S38",        3.7971163317e+01 },
        { "S39",        3.8975134306e+01 },   { "S40",        3.9975451728e+01 },   { "S41",        4.0979582149e+01 },   { "S42",        4.1981022419e+01 },
        { "S43",        4.298715479e+01 },    { "S44",        4.399021339e+01 },    { "S45",        4.4996508112e+01 },   { "S46",        4.600075e+01 },
        { "S47",        4.700859e+01 },       { "S48",        4.801417e+01 },       { "S49",        4.9023619e+01 },      { "Cl_natural", 3.5453e+01 },
        { "Cl28",       2.802851e+01 },       { "Cl29",       2.901411e+01 },       { "Cl30",       3.000477e+01 },       { "Cl31",       3.0992413086e+01 },
        { "Cl32",       3.1985689901e+01 },   { "Cl33",       3.2977451887e+01 },   { "Cl34",       3.3973762819e+01 },   { "Cl35",       3.4968852682e+01 },
        { "Cl36",       3.5968306981e+01 },   { "Cl37",       3.6965902591e+01 },   { "Cl38",       3.7968010425e+01 },   { "Cl39",       3.8968008164e+01 },
        { "Cl40",       3.9970415472e+01 },   { "Cl41",       4.0970684525e+01 },   { "Cl42",       4.1973254804e+01 },   { "Cl43",       4.2974054403e+01 },
        { "Cl44",       4.3978281071e+01 },   { "Cl45",       4.4980286886e+01 },   { "Cl46",       4.598421004e+01 },    { "Cl47",       4.698871e+01 },
        { "Cl48",       4.799495e+01 },       { "Cl49",       4.900032e+01 },       { "Cl50",       5.000784e+01 },       { "Cl51",       5.101449e+01 },
        { "Ar_natural", 3.9948e+01 },         { "Ar30",       3.002156e+01 },       { "Ar31",       3.1012123e+01 },      { "Ar32",       3.1997637984e+01 },
        { "Ar33",       3.2989925709e+01 },   { "Ar34",       3.3980271244e+01 },   { "Ar35",       3.4975257585e+01 },   { "Ar36",       3.5967545105e+01 },
        { "Ar37",       3.696677632e+01 },    { "Ar38",       3.7962732394e+01 },   { "Ar39",       3.8964313231e+01 },   { "Ar40",       3.996238312251e+01 },
        { "Ar41",       4.0964500611e+01 },   { "Ar42",       4.1963045736e+01 },   { "Ar43",       4.2965636056e+01 },   { "Ar44",       4.3964924033e+01 },
        { "Ar45",       4.4968039956e+01 },   { "Ar46",       4.5968094129e+01 },   { "Ar47",       4.6972186792e+01 },   { "Ar48",       4.797454e+01 },
        { "Ar49",       4.898052e+01 },       { "Ar50",       4.998443e+01 },       { "Ar51",       5.099163e+01 },       { "Ar52",       5.199678e+01 },
        { "Ar53",       5.300494e+01 },       { "K_natural",  3.90983e+01 },        { "K32",        3.202192e+01 },       { "K33",        3.300726e+01 },
        { "K34",        3.399841e+01 },       { "K35",        3.4988009692e+01 },   { "K36",        3.5981292235e+01 },   { "K37",        3.6973375889e+01 },
        { "K38",        3.7969081184e+01 },   { "K39",        3.8963706679e+01 },   { "K40",        3.9963998475e+01 },   { "K41",        4.0961825762e+01 },
        { "K42",        4.196240281e+01 },    { "K43",        4.296071554e+01 },    { "K44",        4.3961556804e+01 },   { "K45",        4.4960699493e+01 },
        { "K46",        4.5961976864e+01 },   { "K47",        4.6961678473e+01 },   { "K48",        4.7965513535e+01 },   { "K49",        4.8967450928e+01 },
        { "K50",        4.9972783355e+01 },   { "K51",        5.097638e+01 },       { "K52",        5.198261e+01 },       { "K53",        5.298712e+01 },
        { "K54",        5.39942e+01 },        { "K55",        5.499971e+01 },       { "Ca_natural", 4.008e+01 },          { "Ca34",       3.401412e+01 },
        { "Ca35",       3.500494e+01 },       { "Ca36",       3.5993087063e+01 },   { "Ca37",       3.6985870269e+01 },   { "Ca38",       3.7976318452e+01 },
        { "Ca39",       3.8970719725e+01 },   { "Ca40",       3.9962590983e+01 },   { "Ca41",       4.0962278062e+01 },   { "Ca42",       4.1958618014e+01 },
        { "Ca43",       4.2958766628e+01 },   { "Ca44",       4.3955481754e+01 },   { "Ca45",       4.4956186566e+01 },   { "Ca46",       4.5953692587e+01 },
        { "Ca47",       4.6954546006e+01 },   { "Ca48",       4.7952534177e+01 },   { "Ca49",       4.8955674148e+01 },   { "Ca50",       4.9957518962e+01 },
        { "Ca51",       5.0961499214e+01 },   { "Ca52",       5.19651e+01 },        { "Ca53",       5.297005e+01 },       { "Ca54",       5.397435e+01 },
        { "Ca55",       5.498055e+01 },       { "Ca56",       5.598557e+01 },       { "Ca57",       5.6992356e+01 },      { "Sc_natural", 4.49559e+01 },
        { "Sc36",       3.601492e+01 },       { "Sc37",       3.700305e+01 },       { "Sc38",       3.79947e+01 },        { "Sc39",       3.8984790002e+01 },
        { "Sc40",       3.9977967407e+01 },   { "Sc41",       4.0969251125e+01 },   { "Sc42",       4.1965516429e+01 },   { "Sc43",       4.2961150658e+01 },
        { "Sc44",       4.3959402752e+01 },   { "Sc45",       4.4955911909e+01 },   { "Sc46",       4.595517189e+01 },    { "Sc47",       4.6952407508e+01 },
        { "Sc48",       4.7952231468e+01 },   { "Sc49",       4.8950023975e+01 },   { "Sc50",       4.9952187685e+01 },   { "Sc51",       5.0953603368e+01 },
        { "Sc52",       5.1956675468e+01 },   { "Sc53",       5.295961e+01 },       { "Sc54",       5.3963264561e+01 },   { "Sc55",       5.4968243949e+01 },
        { "Sc56",       5.597287e+01 },       { "Sc57",       5.697779e+01 },       { "Sc58",       5.798371e+01 },       { "Sc59",       5.898922e+01 },
        { "Sc60",       5.999571e+01 },       { "Ti_natural", 4.79e+01 },           { "Ti38",       3.800977e+01 },       { "Ti39",       3.900161e+01 },
        { "Ti40",       3.9990498838e+01 },   { "Ti41",       4.0983145e+01 },      { "Ti42",       4.1973030902e+01 },   { "Ti43",       4.2968522499e+01 },
        { "Ti44",       4.3959690069e+01 },   { "Ti45",       4.4958125616e+01 },   { "Ti46",       4.5952631555e+01 },   { "Ti47",       4.6951763088e+01 },
        { "Ti48",       4.7947946281e+01 },   { "Ti49",       4.8947869982e+01 },   { "Ti50",       4.9944791194e+01 },   { "Ti51",       5.0946614955e+01 },
        { "Ti52",       5.1946897311e+01 },   { "Ti53",       5.2949727171e+01 },   { "Ti54",       5.3951052401e+01 },   { "Ti55",       5.4955265056e+01 },
        { "Ti56",       5.5958199639e+01 },   { "Ti57",       5.6963989137e+01 },   { "Ti58",       5.796697e+01 },       { "Ti59",       5.897293e+01 },
        { "Ti60",       5.997676e+01 },       { "Ti61",       6.09832e+01 },        { "Ti62",       6.198749e+01 },       { "Ti63",       6.299442e+01 },
        { "V_natural",  5.09415e+01 },        { "V40",        4.001109e+01 },       { "V41",        4.099978e+01 },       { "V42",        4.199123e+01 },
        { "V43",        4.298065e+01 },       { "V44",        4.397411e+01 },       { "V45",        4.4965775808e+01 },   { "V46",        4.5960200481e+01 },
        { "V47",        4.695490894e+01 },    { "V48",        4.7952253707e+01 },   { "V49",        4.8948516101e+01 },   { "V50",        4.9947158485e+01 },
        { "V51",        5.0943959507e+01 },   { "V52",        5.1944775479e+01 },   { "V53",        5.2944337979e+01 },   { "V54",        5.3946439854e+01 },
        { "V55",        5.4947233701e+01 },   { "V56",        5.5950530966e+01 },   { "V57",        5.6952561432e+01 },   { "V58",        5.7956834136e+01 },
        { "V59",        5.8960207407e+01 },   { "V60",        5.9965026862e+01 },   { "V61",        6.096848e+01 },       { "V62",        6.197378e+01 },
        { "V63",        6.297755e+01 },       { "V64",        6.398347e+01 },       { "V65",        6.498792e+01 },       { "Cr_natural", 5.1996e+01 },
        { "Cr42",       4.200643e+01 },       { "Cr43",       4.299771e+01 },       { "Cr44",       4.3985549e+01 },      { "Cr45",       4.497964e+01 },
        { "Cr46",       4.5968358635e+01 },   { "Cr47",       4.6962900046e+01 },   { "Cr48",       4.7954031716e+01 },   { "Cr49",       4.8951335721e+01 },
        { "Cr50",       4.9946044205e+01 },   { "Cr51",       5.0944767431e+01 },   { "Cr52",       5.1940507472e+01 },   { "Cr53",       5.2940649386e+01 },
        { "Cr54",       5.3938880395e+01 },   { "Cr55",       5.4940839672e+01 },   { "Cr56",       5.5940653139e+01 },   { "Cr57",       5.6943613013e+01 },
        { "Cr58",       5.7944353129e+01 },   { "Cr59",       5.8948586367e+01 },   { "Cr60",       5.9950076033e+01 },   { "Cr61",       6.0954717204e+01 },
        { "Cr62",       6.195661319e+01 },    { "Cr63",       6.296186e+01 },       { "Cr64",       6.396441e+01 },       { "Cr65",       6.497016e+01 },
        { "Cr66",       6.597338e+01 },       { "Cr67",       6.697955e+01 },       { "Mn_natural", 5.4938e+01 },         { "Mn44",       4.400687e+01 },
        { "Mn45",       4.499451e+01 },       { "Mn46",       4.598672e+01 },       { "Mn47",       4.69761e+01 },        { "Mn48",       4.796852e+01 },
        { "Mn49",       4.8959618005e+01 },   { "Mn50",       4.995423823e+01 },    { "Mn51",       5.0948210787e+01 },   { "Mn52",       5.1945565464e+01 },
        { "Mn53",       5.2941290117e+01 },   { "Mn54",       5.3940358854e+01 },   { "Mn55",       5.4938045141e+01 },   { "Mn56",       5.593890491e+01 },
        { "Mn57",       5.6938285378e+01 },   { "Mn58",       5.7939981549e+01 },   { "Mn59",       5.8940440237e+01 },   { "Mn60",       5.9942911246e+01 },
        { "Mn61",       6.0944652638e+01 },   { "Mn62",       6.194842822e+01 },    { "Mn63",       6.295023999e+01 },    { "Mn64",       6.395424909e+01 },
        { "Mn65",       6.4956336065e+01 },   { "Mn66",       6.596108e+01 },       { "Mn67",       6.696414e+01 },       { "Mn68",       6.79693e+01 },
        { "Mn69",       6.897284e+01 },       { "Fe_natural", 5.5847e+01 },         { "Fe45",       4.5014578e+01 },      { "Fe46",       4.600081e+01 },
        { "Fe47",       4.699289e+01 },       { "Fe48",       4.7980504e+01 },      { "Fe49",       4.897361e+01 },       { "Fe50",       4.9962988982e+01 },
        { "Fe51",       5.0956819538e+01 },   { "Fe52",       5.1948113875e+01 },   { "Fe53",       5.2945307942e+01 },   { "Fe54",       5.3939610501e+01 },
        { "Fe55",       5.4938293357e+01 },   { "Fe56",       5.5934937475e+01 },   { "Fe57",       5.6935393969e+01 },   { "Fe58",       5.7933275558e+01 },
        { "Fe59",       5.8934875464e+01 },   { "Fe60",       5.9934071683e+01 },   { "Fe61",       6.0936745281e+01 },   { "Fe62",       6.1936767442e+01 },
        { "Fe63",       6.2940369091e+01 },   { "Fe64",       6.3941201265e+01 },   { "Fe65",       6.494538027e+01 },    { "Fe66",       6.5946780638e+01 },
        { "Fe67",       6.6950947244e+01 },   { "Fe68",       6.79537e+01 },        { "Fe69",       6.895878e+01 },       { "Fe70",       6.996146e+01 },
        { "Fe71",       7.096672e+01 },       { "Fe72",       7.196962e+01 },       { "Co_natural", 5.89332e+01 },        { "Co47",       4.701149e+01 },
        { "Co48",       4.800176e+01 },       { "Co49",       4.898972e+01 },       { "Co50",       4.998154e+01 },       { "Co51",       5.097072e+01 },
        { "Co52",       5.196359e+01 },       { "Co53",       5.2954218896e+01 },   { "Co54",       5.3948459635e+01 },   { "Co55",       5.4941999029e+01 },
        { "Co56",       5.5939839278e+01 },   { "Co57",       5.6936291373e+01 },   { "Co58",       Co58_Mass        },   { "Co59",       5.8933195048e+01 },
        { "Co60",       5.9933817059e+01 },   { "Co61",       6.0932475763e+01 },   { "Co62",       6.1934050563e+01 },   { "Co63",       6.2933611611e+01 },
        { "Co64",       6.3935809908e+01 },   { "Co65",       6.493647846e+01 },    { "Co66",       6.5939762004e+01 },   { "Co67",       6.6940889529e+01 },
        { "Co68",       6.7944873058e+01 },   { "Co69",       6.894632e+01 },       { "Co70",       6.9951e+01 },         { "Co71",       7.09529e+01 },
        { "Co72",       7.195781e+01 },       { "Co73",       7.296024e+01 },       { "Co74",       7.396538e+01 },       { "Co75",       7.496833e+01 },
        { "Ni_natural", 5.87e+01 },           { "Ni48",       4.801975e+01 },       { "Ni49",       4.900966e+01 },       { "Ni50",       4.999593e+01 },
        { "Ni51",       5.098772e+01 },       { "Ni52",       5.197568e+01 },       { "Ni53",       5.296847e+01 },       { "Ni54",       5.3957905495e+01 },
        { "Ni55",       5.4951330251e+01 },   { "Ni56",       5.5942132022e+01 },   { "Ni57",       5.6939793526e+01 },   { "Ni58",       5.7935342907e+01 },
        { "Ni59",       5.8934346705e+01 },   { "Ni60",       5.9930786372e+01 },   { "Ni61",       6.0931056033e+01 },   { "Ni62",       6.1928345115e+01 },
        { "Ni63",       6.2929669374e+01 },   { "Ni64",       6.3927965959e+01 },   { "Ni65",       6.4930084304e+01 },   { "Ni66",       6.5929139334e+01 },
        { "Ni67",       6.6931569414e+01 },   { "Ni68",       6.7931868789e+01 },   { "Ni69",       6.8935610269e+01 },   { "Ni70",       6.99365e+01 },
        { "Ni71",       7.0940736283e+01 },   { "Ni72",       7.1942092682e+01 },   { "Ni73",       7.294647e+01 },       { "Ni74",       7.394807e+01 },
        { "Ni75",       7.495287e+01 },       { "Ni76",       7.595533e+01 },       { "Ni77",       7.696055e+01 },       { "Ni78",       7.796318e+01 },
        { "Cu_natural", 6.3546e+01 },         { "Cu52",       5.199718e+01 },       { "Cu53",       5.298555e+01 },       { "Cu54",       5.397671e+01 },
        { "Cu55",       5.496605e+01 },       { "Cu56",       5.595856e+01 },       { "Cu57",       5.6949211078e+01 },   { "Cu58",       5.7944538499e+01 },
        { "Cu59",       5.8939498028e+01 },   { "Cu60",       5.993736503e+01 },    { "Cu61",       6.0933457821e+01 },   { "Cu62",       6.1932583745e+01 },
        { "Cu63",       6.2929597474e+01 },   { "Cu64",       6.3929764183e+01 },   { "Cu65",       6.4927789485e+01 },   { "Cu66",       6.592886881299999e+01 },
        { "Cu67",       6.6927730314e+01 },   { "Cu68",       6.7929610889e+01 },   { "Cu69",       6.8929429269e+01 },   { "Cu70",       6.9932392343e+01 },
        { "Cu71",       7.0932676833e+01 },   { "Cu72",       7.1935820307e+01 },   { "Cu73",       7.2936675282e+01 },   { "Cu74",       7.3939874862e+01 },
        { "Cu75",       7.49419e+01 },        { "Cu76",       7.5945275026e+01 },   { "Cu77",       7.694785e+01 },       { "Cu78",       7.795196e+01 },
        { "Cu79",       7.895456e+01 },       { "Cu80",       7.996087e+01 },       { "Zn_natural", 6.538e+01 },          { "Zn54",       5.399295e+01 },
        { "Zn55",       5.498398e+01 },       { "Zn56",       5.597238e+01 },       { "Zn57",       5.6964788e+01 },      { "Zn58",       5.7954591555e+01 },
        { "Zn59",       5.8949263764e+01 },   { "Zn60",       5.9941827035e+01 },   { "Zn61",       6.0939510635e+01 },   { "Zn62",       6.1934329764e+01 },
        { "Zn63",       6.2933211566e+01 },   { "Zn64",       6.3929142222e+01 },   { "Zn65",       6.4929240984e+01 },   { "Zn66",       6.5926033419e+01 },
        { "Zn67",       6.6927127345e+01 },   { "Zn68",       6.7924844154e+01 },   { "Zn69",       6.8926550281e+01 },   { "Zn70",       6.9925319274e+01 },
        { "Zn71",       7.0927721599e+01 },   { "Zn72",       7.1926857951e+01 },   { "Zn73",       7.2929779104e+01 },   { "Zn74",       7.392945860899999e+01 },
        { "Zn75",       7.4932936741e+01 },   { "Zn76",       7.593329357e+01 },    { "Zn77",       7.6936958967e+01 },   { "Zn78",       7.7938440216e+01 },
        { "Zn79",       7.8942652e+01 },      { "Zn80",       7.9944342348e+01 },   { "Zn81",       8.095048e+01 },       { "Zn82",       8.195442e+01 },
        { "Zn83",       8.296103e+01 },       { "Ga_natural", 6.972e+01 },          { "Ga56",       5.599491e+01 },       { "Ga57",       5.698293e+01 },
        { "Ga58",       5.797425e+01 },       { "Ga59",       5.896337e+01 },       { "Ga60",       5.995706e+01 },       { "Ga61",       6.0949446287e+01 },
        { "Ga62",       6.1944175238e+01 },   { "Ga63",       6.2939294196e+01 },   { "Ga64",       6.3936838747e+01 },   { "Ga65",       6.493273475399999e+01 },
        { "Ga66",       6.593158901e+01 },    { "Ga67",       6.6928201703e+01 },   { "Ga68",       6.7927980084e+01 },   { "Ga69",       6.8925573587e+01 },
        { "Ga70",       6.9926021972e+01 },   { "Ga71",       7.0924701349e+01 },   { "Ga72",       7.1926366268e+01 },   { "Ga73",       7.2925174682e+01 },
        { "Ga74",       7.3926945762e+01 },   { "Ga75",       7.4926500246e+01 },   { "Ga76",       7.5928827626e+01 },   { "Ga77",       7.69291543e+01 },
        { "Ga78",       7.793160818e+01 },    { "Ga79",       7.893289326e+01 },    { "Ga80",       7.9936515781e+01 },   { "Ga81",       8.0937752355e+01 },
        { "Ga82",       8.194299e+01 },       { "Ga83",       8.294698e+01 },       { "Ga84",       8.395265e+01 },       { "Ga85",       8.4957e+01 },
        { "Ga86",       8.596312e+01 },       { "Ge_natural", 7.259e+01 },          { "Ge58",       5.799101e+01 },       { "Ge59",       5.898175e+01 },
        { "Ge60",       5.997019e+01 },       { "Ge61",       6.096379e+01 },       { "Ge62",       6.195465e+01 },       { "Ge63",       6.294964e+01 },
        { "Ge64",       6.3941653e+01 },      { "Ge65",       6.4939436406e+01 },   { "Ge66",       6.5933843453e+01 },   { "Ge67",       6.693273407e+01 },
        { "Ge68",       6.792809424e+01 },    { "Ge69",       6.8927964533e+01 },   { "Ge70",       6.9924247381e+01 },   { "Ge71",       7.0924950954e+01 },
        { "Ge72",       7.1922075815e+01 },   { "Ge73",       7.2923458945e+01 },   { "Ge74",       7.3921177767e+01 },   { "Ge75",       7.4922858948e+01 },
        { "Ge76",       7.5921402557e+01 },   { "Ge77",       7.6923548591e+01 },   { "Ge78",       7.7922852739e+01 },   { "Ge79",       7.8925400995e+01 },
        { "Ge80",       7.9925372392e+01 },   { "Ge81",       8.0928820467e+01 },   { "Ge82",       8.1929549725e+01 },   { "Ge83",       8.293462e+01 },
        { "Ge84",       8.393747e+01 },       { "Ge85",       8.494303e+01 },       { "Ge86",       8.594649e+01 },       { "Ge87",       8.695251e+01 },
        { "Ge88",       8.795691e+01 },       { "Ge89",       8.896383e+01 },       { "As_natural", 7.49216e+01 },        { "As60",       5.999313e+01 },
        { "As61",       6.098062e+01 },       { "As62",       6.19732e+01 },        { "As63",       6.296369e+01 },       { "As64",       6.3957572e+01 },
        { "As65",       6.4949564e+01 },      { "As66",       6.594471e+01 },       { "As67",       6.6939186071e+01 },   { "As68",       6.793676906899999e+01 },
        { "As69",       6.8932273675e+01 },   { "As70",       6.9930924826e+01 },   { "As71",       7.0927112428e+01 },   { "As72",       7.1926752283e+01 },
        { "As73",       7.2923824844e+01 },   { "As74",       7.3923928692e+01 },   { "As75",       7.4921596478e+01 },   { "As76",       7.5922394021e+01 },
        { "As77",       7.6920647286e+01 },   { "As78",       7.7921827281e+01 },   { "As79",       7.8920947934e+01 },   { "As80",       7.9922533816e+01 },
        { "As81",       8.0922132287e+01 },   { "As82",       8.1924504067e+01 },   { "As83",       8.2924980024e+01 },   { "As84",       8.3929058e+01 },
        { "As85",       8.493202e+01 },       { "As86",       8.59365e+01 },        { "As87",       8.69399e+01 },        { "As88",       8.794494e+01 },
        { "As89",       8.894939e+01 },       { "As90",       8.99555e+01 },        { "As91",       9.096043e+01 },       { "As92",       9.19668e+01 },
        { "Se_natural", 7.896e+01 },          { "Se65",       6.496466e+01 },       { "Se66",       6.595521e+01 },       { "Se67",       6.695009e+01 },
        { "Se68",       6.7941798e+01 },      { "Se69",       6.8939557817e+01 },   { "Se70",       6.9933390644e+01 },   { "Se71",       7.093224182199999e+01 },
        { "Se72",       7.1927112352e+01 },   { "Se73",       7.2926765345e+01 },   { "Se74",       7.3922476436e+01 },   { "Se75",       7.4922523368e+01 },
        { "Se76",       7.5919213597e+01 },   { "Se77",       7.6919914038e+01 },   { "Se78",       7.791730909e+01 },    { "Se79",       7.8918499098e+01 },
        { "Se80",       7.9916521271e+01 },   { "Se81",       8.0917992474e+01 },   { "Se82",       8.1916699401e+01 },   { "Se83",       8.2919118473e+01 },
        { "Se84",       8.3918462354e+01 },   { "Se85",       8.4922245053e+01 },   { "Se86",       8.5924271579e+01 },   { "Se87",       8.6928521358e+01 },
        { "Se88",       8.7931423998e+01 },   { "Se89",       8.893645e+01 },       { "Se90",       8.993996e+01 },       { "Se91",       9.094596e+01 },
        { "Se92",       9.194992e+01 },       { "Se93",       9.295629e+01 },       { "Se94",       9.396049e+01 },       { "Br_natural", 7.9904e+01 },
        { "Br67",       6.696479e+01 },       { "Br68",       6.7958516e+01 },      { "Br69",       6.8950106e+01 },      { "Br70",       6.9944792e+01 },
        { "Br71",       7.093874e+01 },       { "Br72",       7.1936644572e+01 },   { "Br73",       7.2931691524e+01 },   { "Br74",       7.392989103399999e+01 },
        { "Br75",       7.4925776207e+01 },   { "Br76",       7.5924541469e+01 },   { "Br77",       7.6921379082e+01 },   { "Br78",       7.7921145706e+01 },
        { "Br79",       7.8918337087e+01 },   { "Br80",       7.9918529296e+01 },   { "Br81",       8.0916290563e+01 },   { "Br82",       8.1916804119e+01 },
        { "Br83",       8.2915180421e+01 },   { "Br84",       8.3916478974e+01 },   { "Br85",       8.4915608403e+01 },   { "Br86",       8.5918797577e+01 },
        { "Br87",       8.6920711324e+01 },   { "Br88",       8.7924065926e+01 },   { "Br89",       8.8926385334e+01 },   { "Br90",       8.993062773699999e+01 },
        { "Br91",       9.0933968095e+01 },   { "Br92",       9.1939258714e+01 },   { "Br93",       9.294305e+01 },       { "Br94",       9.394868e+01 },
        { "Br95",       9.495287e+01 },       { "Br96",       9.595853e+01 },       { "Br97",       9.69628e+01 },        { "Kr_natural", 8.38e+01 },
        { "Kr69",       6.896518e+01 },       { "Kr70",       6.9955259e+01 },      { "Kr71",       7.0949625738e+01 },   { "Kr72",       7.1942092038e+01 },
        { "Kr73",       7.2939289195e+01 },   { "Kr74",       7.3933084369e+01 },   { "Kr75",       7.4930945746e+01 },   { "Kr76",       7.5925910078e+01 },
        { "Kr77",       7.692467e+01 },       { "Kr78",       7.7920364783e+01 },   { "Kr79",       7.8920082431e+01 },   { "Kr80",       7.9916378965e+01 },
        { "Kr81",       8.0916592015e+01 },   { "Kr82",       8.19134836e+01 },     { "Kr83",       8.2914136099e+01 },   { "Kr84",       8.3911506687e+01 },
        { "Kr85",       8.4912527331e+01 },   { "Kr86",       8.5910610729e+01 },   { "Kr87",       8.6913354862e+01 },   { "Kr88",       8.7914446969e+01 },
        { "Kr89",       8.8917630581e+01 },   { "Kr90",       8.9919516555e+01 },   { "Kr91",       9.0923445215e+01 },   { "Kr92",       9.192615621e+01 },
        { "Kr93",       9.2931274357e+01 },   { "Kr94",       9.393436e+01 },       { "Kr95",       9.493984e+01 },       { "Kr96",       9.594307e+01 },
        { "Kr97",       9.694856e+01 },       { "Kr98",       9.795191e+01 },       { "Kr99",       9.89576e+01 },        { "Kr100",      9.996114e+01 },
        { "Rb_natural", 8.54678e+01 },        { "Rb71",       7.096532e+01 },       { "Rb72",       7.195908e+01 },       { "Rb73",       7.2950561e+01 },
        { "Rb74",       7.3944264751e+01 },   { "Rb75",       7.493857e+01 },       { "Rb76",       7.5935072226e+01 },   { "Rb77",       7.6930408e+01 },
        { "Rb78",       7.7928141e+01 },      { "Rb79",       7.892398946e+01 },    { "Rb80",       7.992251925e+01 },    { "Rb81",       8.0918995913e+01 },
        { "Rb82",       8.1918208598e+01 },   { "Rb83",       8.2915109701e+01 },   { "Rb84",       8.3914384821e+01 },   { "Rb85",       8.4911789737e+01 },
        { "Rb86",       8.5911167419e+01 },   { "Rb87",       8.6909180526e+01 },   { "Rb88",       8.7911315588e+01 },   { "Rb89",       8.8912278016e+01 },
        { "Rb90",       8.9914801694e+01 },   { "Rb91",       9.0916536958e+01 },   { "Rb92",       9.19197289e+01 },     { "Rb93",       9.292204187599999e+01 },
        { "Rb94",       9.3926404946e+01 },   { "Rb95",       9.4929302889e+01 },   { "Rb96",       9.5934272637e+01 },   { "Rb97",       9.6937351916e+01 },
        { "Rb98",       9.7941790668e+01 },   { "Rb99",       9.8945379283e+01 },   { "Rb100",      9.994987e+01 },       { "Rb101",      1.00953196445e+02 },
        { "Rb102",      1.0195887e+02 },      { "Sr_natural", 8.762e+01 },          { "Sr73",       7.296597e+01 },       { "Sr74",       7.395631e+01 },
        { "Sr75",       7.4949949568e+01 },   { "Sr76",       7.5941766782e+01 },   { "Sr77",       7.6937944782e+01 },   { "Sr78",       7.793218e+01 },
        { "Sr79",       7.8929708e+01 },      { "Sr80",       7.9924521013e+01 },   { "Sr81",       8.0923211846e+01 },   { "Sr82",       8.1918401639e+01 },
        { "Sr83",       8.2917556701e+01 },   { "Sr84",       8.3913425275e+01 },   { "Sr85",       8.4912932803e+01 },   { "Sr86",       8.5909260204e+01 },
        { "Sr87",       8.6908877124e+01 },   { "Sr88",       8.7905612124e+01 },   { "Sr89",       8.8907450675e+01 },   { "Sr90",       8.9907737888e+01 },
        { "Sr91",       9.0910203095e+01 },   { "Sr92",       9.1911037858e+01 },   { "Sr93",       9.2914025634e+01 },   { "Sr94",       9.3915361312e+01 },
        { "Sr95",       9.4919358766e+01 },   { "Sr96",       9.5921696802e+01 },   { "Sr97",       9.6926152923e+01 },   { "Sr98",       9.7928452934e+01 },
        { "Sr99",       9.8933240926e+01 },   { "Sr100",      9.9935351911e+01 },   { "Sr101",      1.00940517888e+02 },  { "Sr102",      1.01943018987e+02 },
        { "Sr103",      1.0294895e+02 },      { "Sr104",      1.0395233e+02 },      { "Sr105",      1.0495858e+02 },      { "Y_natural",  8.89059e+01 },
        { "Y76",        7.595845e+01 },       { "Y77",        7.6949645e+01 },      { "Y78",        7.794361e+01 },       { "Y79",        7.8937351634e+01 },
        { "Y80",        7.993428e+01 },       { "Y81",        8.0929127468e+01 },   { "Y82",        8.1926792451e+01 },   { "Y83",        8.2922354243e+01 },
        { "Y84",        8.3920388264e+01 },   { "Y85",        8.4916433039e+01 },   { "Y86",        8.5914885576e+01 },   { "Y87",        8.691087573e+01 },
        { "Y88",        8.7909501146e+01 },   { "Y89",        8.8905848295e+01 },   { "Y90",        8.9907151886e+01 },   { "Y91",        9.0907304791e+01 },
        { "Y92",        9.1908949143e+01 },   { "Y93",        9.2909582713e+01 },   { "Y94",        9.3911595245e+01 },   { "Y95",        9.491282062099999e+01 },
        { "Y96",        9.5915891343e+01 },   { "Y97",        9.6918133995e+01 },   { "Y98",        9.792220302e+01 },    { "Y99",        9.8924636204e+01 },
        { "Y100",       9.9927756586e+01 },   { "Y101",       1.0093031385e+02 },   { "Y102",       1.01933555695e+02 },  { "Y103",       1.0293673e+02 },
        { "Y104",       1.0394105e+02 },      { "Y105",       1.0494487e+02 },      { "Y106",       1.0594979e+02 },      { "Y107",       1.0695414e+02 },
        { "Y108",       1.0795948e+02 },      { "Zr_natural", 9.122e+01 },          { "Zr78",       7.795523e+01 },       { "Zr79",       7.894916e+01 },
        { "Zr80",       7.99404e+01 },        { "Zr81",       8.0937210026e+01 },   { "Zr82",       8.1931087e+01 },      { "Zr83",       8.2928653801e+01 },
        { "Zr84",       8.392325e+01 },       { "Zr85",       8.4921471182e+01 },   { "Zr86",       8.5916473591e+01 },   { "Zr87",       8.691481625199999e+01 },
        { "Zr88",       8.7910226904e+01 },   { "Zr89",       8.89088895e+01 },     { "Zr90",       8.9904704416e+01 },   { "Zr91",       9.0905645767e+01 },
        { "Zr92",       9.1905040847e+01 },   { "Zr93",       9.2906476006e+01 },   { "Zr94",       9.3906315192e+01 },   { "Zr95",       9.49080426e+01 },
        { "Zr96",       9.5908273386e+01 },   { "Zr97",       9.6910953109e+01 },   { "Zr98",       9.7912734892e+01 },   { "Zr99",       9.8916512106e+01 },
        { "Zr100",      9.9917761889e+01 },   { "Zr101",      1.00921140415e+02 },  { "Zr102",      1.01922981285e+02 },  { "Zr103",      1.02926599606e+02 },
        { "Zr104",      1.0392878e+02 },      { "Zr105",      1.0493305e+02 },      { "Zr106",      1.0593591e+02 },      { "Zr107",      1.0694075e+02 },
        { "Zr108",      1.0794396e+02 },      { "Zr109",      1.0894924e+02 },      { "Zr110",      1.0995287e+02 },      { "Nb_natural", 9.29064e+01 },
        { "Nb81",       8.094903e+01 },       { "Nb82",       8.194313e+01 },       { "Nb83",       8.2936705382e+01 },   { "Nb84",       8.393357e+01 },
        { "Nb85",       8.4927912447e+01 },   { "Nb86",       8.5925038326e+01 },   { "Nb87",       8.6920361108e+01 },   { "Nb88",       8.7918332163e+01 },
        { "Nb89",       8.8913418245e+01 },   { "Nb90",       8.9911264845e+01 },   { "Nb91",       9.0906996243e+01 },   { "Nb92",       9.190719388799999e+01 },
        { "Nb93",       9.2906378058e+01 },   { "Nb94",       9.3907283888e+01 },   { "Nb95",       9.4906835792e+01 },   { "Nb96",       9.5908100647e+01 },
        { "Nb97",       9.6908098556e+01 },   { "Nb98",       9.7910328412e+01 },   { "Nb99",       9.8911618375e+01 },   { "Nb100",      9.9914181619e+01 },
        { "Nb101",      1.00915252025e+02 },  { "Nb102",      1.01918037614e+02 },  { "Nb103",      1.02919143842e+02 },  { "Nb104",      1.03922464701e+02 },
        { "Nb105",      1.04923936545e+02 },  { "Nb106",      1.0592797e+02 },      { "Nb107",      1.0693031e+02 },      { "Nb108",      1.0793484e+02 },
        { "Nb109",      1.0893763e+02 },      { "Nb110",      1.0994244e+02 },      { "Nb111",      1.1094565e+02 },      { "Nb112",      1.1195083e+02 },
        { "Nb113",      1.129547e+02 },       { "Mo_natural", 9.594e+01 },          { "Mo83",       8.294874e+01 },       { "Mo84",       8.394009e+01 },
        { "Mo85",       8.493655e+01 },       { "Mo86",       8.5930695904e+01 },   { "Mo87",       8.6927326502e+01 },   { "Mo88",       8.7921953241e+01 },
        { "Mo89",       8.8919480009e+01 },   { "Mo90",       8.9913936896e+01 },   { "Mo91",       9.0911750194e+01 },   { "Mo92",       9.1906810991e+01 },
        { "Mo93",       9.290681261e+01 },    { "Mo94",       9.3905088269e+01 },   { "Mo95",       9.4905842129e+01 },   { "Mo96",       9.5904679477e+01 },
        { "Mo97",       9.6906021465e+01 },   { "Mo98",       9.7905408169e+01 },   { "Mo99",       9.890771187e+01 },    { "Mo100",      9.9907477336e+01 },
        { "Mo101",      1.00910347001e+02 },  { "Mo102",      1.0191029736e+02 },   { "Mo103",      1.02913207142e+02 },  { "Mo104",      1.03913763625e+02 },
        { "Mo105",      1.0491697461e+02 },   { "Mo106",      1.05918136802e+02 },  { "Mo107",      1.06921692604e+02 },  { "Mo108",      1.07923453e+02 },
        { "Mo109",      1.0892781e+02 },      { "Mo110",      1.0992973e+02 },      { "Mo111",      1.1093441e+02 },      { "Mo112",      1.1193684e+02 },
        { "Mo113",      1.1294188e+02 },      { "Mo114",      1.1394492e+02 },      { "Mo115",      1.1495029e+02 },      { "Tc_natural", 9.8e+01 },
        { "Tc85",       8.494883e+01 },       { "Tc86",       8.594288e+01 },       { "Tc87",       8.693653e+01 },       { "Tc88",       8.7932678e+01 },
        { "Tc89",       8.8927167e+01 },      { "Tc90",       8.9923556564e+01 },   { "Tc91",       9.0918427639e+01 },   { "Tc92",       9.1915260166e+01 },
        { "Tc93",       9.2910248984e+01 },   { "Tc94",       9.3909657002e+01 },   { "Tc95",       9.4907657084e+01 },   { "Tc96",       9.5907871383e+01 },
        { "Tc97",       9.6906365358e+01 },   { "Tc98",       9.7907215966e+01 },   { "Tc99",       9.8906254747e+01 },   { "Tc100",      9.990765778e+01 },
        { "Tc101",      1.00907314659e+02 },  { "Tc102",      1.01909215019e+02 },  { "Tc103",      1.02909181351e+02 },  { "Tc104",      1.03911447454e+02 },
        { "Tc105",      1.04911660566e+02 },  { "Tc106",      1.05914357927e+02 },  { "Tc107",      1.06915079572e+02 },  { "Tc108",      1.07918461226e+02 },
        { "Tc109",      1.08919982665e+02 },  { "Tc110",      1.09923820483e+02 },  { "Tc111",      1.1092569283e+02 },   { "Tc112",      1.11929146493e+02 },
        { "Tc113",      1.1293159e+02 },      { "Tc114",      1.1393588e+02 },      { "Tc115",      1.1493869e+02 },      { "Tc116",      1.1594337e+02 },
        { "Tc117",      1.1694648e+02 },      { "Tc118",      1.1795148e+02 },      { "Ru_natural", 1.0107e+02 },         { "Ru87",       8.694918e+01 },
        { "Ru88",       8.794026e+01 },       { "Ru89",       8.893611e+01 },       { "Ru90",       8.992989e+01 },       { "Ru91",       9.0926292e+01 },
        { "Ru92",       9.192012e+01 },       { "Ru93",       9.2917052034e+01 },   { "Ru94",       9.3911359711e+01 },   { "Ru95",       9.4910412929e+01 },
        { "Ru96",       9.5907597835e+01 },   { "Ru97",       9.69075547e+01 },     { "Ru98",       9.7905287132e+01 },   { "Ru99",       9.890593930199999e+01 },
        { "Ru100",      9.9904219476e+01 },   { "Ru101",      1.00905582087e+02 },  { "Ru102",      1.01904349312e+02 },  { "Ru103",      1.02906323847e+02 },
        { "Ru104",      1.03905432701e+02 },  { "Ru105",      1.04907752866e+02 },  { "Ru106",      1.05907329433e+02 },  { "Ru107",      1.06909905089e+02 },
        { "Ru108",      1.07910173465e+02 },  { "Ru109",      1.08913203233e+02 },  { "Ru110",      1.09914136041e+02 },  { "Ru111",      1.10917696e+02 },
        { "Ru112",      1.11918965e+02 },     { "Ru113",      1.12922487194e+02 },  { "Ru114",      1.13924281e+02 },     { "Ru115",      1.14928686173e+02 },
        { "Ru116",      1.1593081e+02 },      { "Ru117",      1.1693558e+02 },      { "Ru118",      1.1793782e+02 },      { "Ru119",      1.1894284e+02 },
        { "Ru120",      1.1994531e+02 },      { "Rh_natural", 1.029055e+02 },       { "Rh89",       8.8948837e+01 },      { "Rh90",       8.994287e+01 },
        { "Rh91",       9.093655e+01 },       { "Rh92",       9.193198e+01 },       { "Rh93",       9.292574e+01 },       { "Rh94",       9.3921698e+01 },
        { "Rh95",       9.491589874e+01 },    { "Rh96",       9.5914460631e+01 },   { "Rh97",       9.6911336797e+01 },   { "Rh98",       9.7910708158e+01 },
        { "Rh99",       9.8908132104e+01 },   { "Rh100",      9.990812155e+01 },    { "Rh101",      1.00906163625e+02 },  { "Rh102",      1.01906843196e+02 },
        { "Rh103",      1.02905504292e+02 },  { "Rh104",      1.03906655518e+02 },  { "Rh105",      1.04905693821e+02 },  { "Rh106",      1.05907287135e+02 },
        { "Rh107",      1.06906748423e+02 },  { "Rh108",      1.07908728018e+02 },  { "Rh109",      1.08908737289e+02 },  { "Rh110",      1.09911136411e+02 },
        { "Rh111",      1.10911585913e+02 },  { "Rh112",      1.11914394159e+02 },  { "Rh113",      1.12915530627e+02 },  { "Rh114",      1.13918806e+02 },
        { "Rh115",      1.14920334e+02 },     { "Rh116",      1.15924062e+02 },     { "Rh117",      1.1692598e+02 },      { "Rh118",      1.1793007e+02 },
        { "Rh119",      1.1893211e+02 },      { "Rh120",      1.1993641e+02 },      { "Rh121",      1.2093872e+02 },      { "Rh122",      1.2194321e+02 },
        { "Pd_natural", 1.064e+02 },          { "Pd91",       9.094911e+01 },       { "Pd92",       9.194042e+01 },       { "Pd93",       9.293591e+01 },
        { "Pd94",       9.392877e+01 },       { "Pd95",       9.492469e+01 },       { "Pd96",       9.5918164359e+01 },   { "Pd97",       9.6916479073e+01 },
        { "Pd98",       9.7912720902e+01 },   { "Pd99",       9.8911767833e+01 },   { "Pd100",      9.9908505886e+01 },   { "Pd101",      1.00908289242e+02 },
        { "Pd102",      1.01905608544e+02 },  { "Pd103",      1.02906087307e+02 },  { "Pd104",      1.03904035834e+02 },  { "Pd105",      1.0490508492e+02 },
        { "Pd106",      1.05903485715e+02 },  { "Pd107",      1.06905133481e+02 },  { "Pd108",      1.07903891701e+02 },  { "Pd109",      1.08905950451e+02 },
        { "Pd110",      1.09905153254e+02 },  { "Pd111",      1.10907670734e+02 },  { "Pd112",      1.11907314058e+02 },  { "Pd113",      1.12910152908e+02 },
        { "Pd114",      1.13910362638e+02 },  { "Pd115",      1.14913683824e+02 },  { "Pd116",      1.15914158662e+02 },  { "Pd117",      1.16917841338e+02 },
        { "Pd118",      1.179189843e+02 },    { "Pd119",      1.1892311e+02 },      { "Pd120",      1.19924691878e+02 },  { "Pd121",      1.2092887e+02 },
        { "Pd122",      1.2193055e+02 },      { "Pd123",      1.2293493e+02 },      { "Pd124",      1.2393688e+02 },      { "Ag_natural", 1.07868e+02 },
        { "Ag93",       9.294978e+01 },       { "Ag94",       9.394278e+01 },       { "Ag95",       9.493548e+01 },       { "Ag96",       9.593068e+01 },
        { "Ag97",       9.6923972412e+01 },   { "Ag98",       9.7921566201e+01 },   { "Ag99",       9.8917597178e+01 },   { "Ag100",      9.991610425499999e+01 },
        { "Ag101",      1.00912802233e+02 },  { "Ag102",      1.01911685e+02 },     { "Ag103",      1.0290897272e+02 },   { "Ag104",      1.03908629157e+02 },
        { "Ag105",      1.04906528661e+02 },  { "Ag106",      1.05906668921e+02 },  { "Ag107",      1.0690509682e+02 },   { "Ag108",      1.07905955556e+02 },
        { "Ag109",      1.08904752292e+02 },  { "Ag110",      Ag110_Mass },         { "Ag111",      1.10905291157e+02 },  { "Ag112",      1.11907004814e+02 },
        { "Ag113",      1.12906566579e+02 },  { "Ag114",      1.13908803704e+02 },  { "Ag115",      1.14908762698e+02 },  { "Ag116",      1.15911359933e+02 },
        { "Ag117",      1.16911684562e+02 },  { "Ag118",      1.17914582768e+02 },  { "Ag119",      1.18915665059e+02 },  { "Ag120",      1.19918787384e+02 },
        { "Ag121",      1.20919848046e+02 },  { "Ag122",      1.2192353e+02 },      { "Ag123",      1.229249e+02 },       { "Ag124",      1.2392864e+02 },
        { "Ag125",      1.2493043e+02 },      { "Ag126",      1.259345e+02 },       { "Ag127",      1.2693677e+02 },      { "Ag128",      1.2794117e+02 },
        { "Ag129",      1.2894369e+02 },      { "Ag130",      1.29950448e+02 },     { "Cd_natural", 1.1241e+02 },         { "Cd95",       9.494987e+01 },
        { "Cd96",       9.593977e+01 },       { "Cd97",       9.693494e+01 },       { "Cd98",       9.7927395546e+01 },   { "Cd99",       9.892501e+01 },
        { "Cd100",      9.9920289525e+01 },   { "Cd101",      1.00918681538e+02 },  { "Cd102",      1.01914462258e+02 },  { "Cd103",      1.02913419246e+02 },
        { "Cd104",      1.03909849475e+02 },  { "Cd105",      1.04909467905e+02 },  { "Cd106",      1.0590645941e+02 },   { "Cd107",      1.06906617928e+02 },
        { "Cd108",      1.07904183683e+02 },  { "Cd109",      1.08904982293e+02 },  { "Cd110",      1.0990300207e+02 },   { "Cd111",      1.10904178107e+02 },
        { "Cd112",      1.11902757809e+02 },  { "Cd113",      1.12904401662e+02 },  { "Cd114",      1.1390335854e+02 },   { "Cd115",      Cd115_Mass },
        { "Cd116",      1.15904755809e+02 },  { "Cd117",      1.16907218618e+02 },  { "Cd118",      1.1790691453e+02 },   { "Cd119",      1.18909921597e+02 },
        { "Cd120",      1.19909850129e+02 },  { "Cd121",      1.20912977363e+02 },  { "Cd122",      1.21913332432e+02 },  { "Cd123",      1.22917002999e+02 },
        { "Cd124",      1.23917647616e+02 },  { "Cd125",      1.2492124637e+02 },   { "Cd126",      1.25922353321e+02 },  { "Cd127",      1.26926443864e+02 },
        { "Cd128",      1.27927762285e+02 },  { "Cd129",      1.2893215e+02 },      { "Cd130",      1.29933901937e+02 },  { "Cd131",      1.3094067e+02 },
        { "Cd132",      1.3194555e+02 },      { "In_natural", 1.1482e+02 },         { "In97",       9.694954e+01 },       { "In98",       9.794214e+01 },
        { "In99",       9.893422e+01 },       { "In100",      9.9931110851e+01 },   { "In101",      1.0092634e+02 },      { "In102",      1.01924090238e+02 },
        { "In103",      1.02919914188e+02 },  { "In104",      1.03918296171e+02 },  { "In105",      1.0491467354e+02 },   { "In106",      1.05913465411e+02 },
        { "In107",      1.069102951e+02 },    { "In108",      1.0790969818e+02 },   { "In109",      1.08907150507e+02 },  { "In110",      1.09907165274e+02 },
        { "In111",      1.10905103278e+02 },  { "In112",      1.11905532331e+02 },  { "In113",      1.12904057761e+02 },  { "In114",      1.13904913876e+02 },
        { "In115",      1.14903878484e+02 },  { "In116",      1.15905259703e+02 },  { "In117",      1.16904513564e+02 },  { "In118",      1.17906354367e+02 },
        { "In119",      1.1890584535e+02 },   { "In120",      1.19907959608e+02 },  { "In121",      1.20907845822e+02 },  { "In122",      1.2191027601e+02 },
        { "In123",      1.22910438276e+02 },  { "In124",      1.23913175231e+02 },  { "In125",      1.24913600588e+02 },  { "In126",      1.25916463857e+02 },
        { "In127",      1.26917353091e+02 },  { "In128",      1.27920172328e+02 },  { "In129",      1.2892169698e+02 },   { "In130",      1.29924970049e+02 },
        { "In131",      1.30926851767e+02 },  { "In132",      1.3193299026e+02 },   { "In133",      1.3293781e+02 },      { "In134",      1.3394415e+02 },
        { "In135",      1.3494933e+02 },      { "Sn_natural", 1.1869e+02 },         { "Sn99",       9.894933e+01 },       { "Sn100",      9.9939044343e+01 },
        { "Sn101",      1.0093606e+02 },      { "Sn102",      1.01930295324e+02 },  { "Sn103",      1.029281e+02 },       { "Sn104",      1.03923143223e+02 },
        { "Sn105",      1.04921349437e+02 },  { "Sn106",      1.0591688062e+02 },   { "Sn107",      1.06915644329e+02 },  { "Sn108",      1.07911925378e+02 },
        { "Sn109",      1.08911283214e+02 },  { "Sn110",      1.09907842791e+02 },  { "Sn111",      1.1090773446e+02 },   { "Sn112",      1.11904818207e+02 },
        { "Sn113",      1.12905170577e+02 },  { "Sn114",      1.13902778869e+02 },  { "Sn115",      1.14903342397e+02 },  { "Sn116",      1.1590174053e+02 },
        { "Sn117",      1.16902951656e+02 },  { "Sn118",      1.17901603167e+02 },  { "Sn119",      1.1890330763e+02 },   { "Sn120",      1.19902194676e+02 },
        { "Sn121",      1.2090423548e+02 },   { "Sn122",      1.21903439046e+02 },  { "Sn123",      1.22905720838e+02 },  { "Sn124",      1.23905273946e+02 },
        { "Sn125",      1.24907784125e+02 },  { "Sn126",      1.2590765328e+02 },   { "Sn127",      1.26910360024e+02 },  { "Sn128",      1.27910536624e+02 },
        { "Sn129",      1.28913479e+02 },     { "Sn130",      1.29913967295e+02 },  { "Sn131",      1.30916999769e+02 },  { "Sn132",      1.31917815713e+02 },
        { "Sn133",      1.32923829249e+02 },  { "Sn134",      1.33928291765e+02 },  { "Sn135",      1.3493473e+02 },      { "Sn136",      1.3593934e+02 },
        { "Sn137",      1.3694599e+02 },      { "Sb_natural", 1.2175e+02 },         { "Sb103",      1.0293969e+02 },      { "Sb104",      1.03936472e+02 },
        { "Sb105",      1.04931486348e+02 },  { "Sb106",      1.05928791e+02 },     { "Sb107",      1.0692415e+02 },      { "Sb108",      1.0792216e+02 },
        { "Sb109",      1.08918132426e+02 },  { "Sb110",      1.09916753e+02 },     { "Sb111",      1.10913163e+02 },     { "Sb112",      1.11912398009e+02 },
        { "Sb113",      1.12909371672e+02 },  { "Sb114",      1.13909269e+02 },     { "Sb115",      1.14906598e+02 },     { "Sb116",      1.15906793629e+02 },
        { "Sb117",      1.16904835941e+02 },  { "Sb118",      1.17905528731e+02 },  { "Sb119",      1.18903942009e+02 },  { "Sb120",      1.19905072427e+02 },
        { "Sb121",      1.20903815686e+02 },  { "Sb122",      1.21905173651e+02 },  { "Sb123",      1.2290421397e+02 },   { "Sb124",      1.23905935743e+02 },
        { "Sb125",      1.24905253818e+02 },  { "Sb126",      1.2590724748e+02 },   { "Sb127",      1.26906923609e+02 },  { "Sb128",      1.27909169001e+02 },
        { "Sb129",      1.28909148442e+02 },  { "Sb130",      1.29911656324e+02 },  { "Sb131",      1.30911982275e+02 },  { "Sb132",      1.31914466896e+02 },
        { "Sb133",      1.3291525163e+02 },   { "Sb134",      1.33920379744e+02 },  { "Sb135",      1.34925165771e+02 },  { "Sb136",      1.3593035e+02 },
        { "Sb137",      1.3693531e+02 },      { "Sb138",      1.3794079e+02 },      { "Sb139",      1.3894598e+02 },      { "Te_natural", 1.276e+02 },
        { "Te105",      1.0494364e+02 },      { "Te106",      1.05937504237e+02 },  { "Te107",      1.06935006e+02 },     { "Te108",      1.07929444597e+02 },
        { "Te109",      1.08927415515e+02 },  { "Te110",      1.09922407316e+02 },  { "Te111",      1.10921110692e+02 },  { "Te112",      1.11917013672e+02 },
        { "Te113",      1.12915891e+02 },     { "Te114",      1.13912089e+02 },     { "Te115",      1.14911902e+02 },     { "Te116",      1.1590846e+02 },
        { "Te117",      1.16908644719e+02 },  { "Te118",      1.17905827581e+02 },  { "Te119",      1.18906403645e+02 },  { "Te120",      1.19904020222e+02 },
        { "Te121",      1.20904936424e+02 },  { "Te122",      1.21903043898e+02 },  { "Te123",      1.22904270029e+02 },  { "Te124",      1.23902817896e+02 },
        { "Te125",      1.24904430731e+02 },  { "Te126",      1.25903311696e+02 },  { "Te127",      Te127_Mass },         { "Te128",      1.27904463056e+02 },
        { "Te129",      Te129_Mass },         { "Te130",      1.29906224399e+02 },  { "Te131",      1.30908523864e+02 },  { "Te132",      1.3190855316e+02 },
        { "Te133",      1.32910955306e+02 },  { "Te134",      1.33911368737e+02 },  { "Te135",      1.34916448592e+02 },  { "Te136",      1.35920101246e+02 },
        { "Te137",      1.36925322954e+02 },  { "Te138",      1.3792922e+02 },      { "Te139",      1.3893473e+02 },      { "Te140",      1.3993885e+02 },
        { "Te141",      1.4094465e+02 },      { "Te142",      1.4194908e+02 },      { "I_natural",  1.269045e+02 },       { "I108",       1.07943475e+02 },
        { "I109",       1.08938149417e+02 },  { "I110",       1.09935242e+02 },     { "I111",       1.10930276e+02 },     { "I112",       1.1192797e+02 },
        { "I113",       1.12923640583e+02 },  { "I114",       1.1392185e+02 },      { "I115",       1.14918048e+02 },     { "I116",       1.15916808633e+02 },
        { "I117",       1.1691365e+02 },      { "I118",       1.17913074e+02 },     { "I119",       1.18910074e+02 },     { "I120",       1.19910048173e+02 },
        { "I121",       1.20907366811e+02 },  { "I122",       1.21907589284e+02 },  { "I123",       1.22905588965e+02 },  { "I124",       1.23906209852e+02 },
        { "I125",       1.24904630164e+02 },  { "I126",       1.25905624153e+02 },  { "I127",       1.26904472681e+02 },  { "I128",       1.27905809443e+02 },
        { "I129",       1.28904987722e+02 },  { "I130",       1.29906674247e+02 },  { "I131",       1.30906124609e+02 },  { "I132",       1.31907997381e+02 },
        { "I133",       1.32907796939e+02 },  { "I134",       1.33909744465e+02 },  { "I135",       1.34910048121e+02 },  { "I136",       1.35914653993e+02 },
        { "I137",       1.3691787084e+02 },   { "I138",       1.37922349591e+02 },  { "I139",       1.38926099478e+02 },  { "I140",       1.39931e+02 },
        { "I141",       1.4093503e+02 },      { "I142",       1.4194018e+02 },      { "I143",       1.4294456e+02 },      { "I144",       1.4394999e+02 },
        { "Xe_natural", 1.313e+02 },          { "Xe110",      1.09944278068e+02 },  { "Xe111",      1.10941602e+02 },     { "Xe112",      1.11935623112e+02 },
        { "Xe113",      1.12933341174e+02 },  { "Xe114",      1.13927980306e+02 },  { "Xe115",      1.1492629392e+02 },   { "Xe116",      1.15921581087e+02 },
        { "Xe117",      1.16920358735e+02 },  { "Xe118",      1.17916178655e+02 },  { "Xe119",      1.18915410688e+02 },  { "Xe120",      1.19911784244e+02 },
        { "Xe121",      1.20911461829e+02 },  { "Xe122",      1.21908367632e+02 },  { "Xe123",      1.2290848191e+02 },   { "Xe124",      1.23905893003e+02 },
        { "Xe125",      1.24906395464e+02 },  { "Xe126",      1.25904273634e+02 },  { "Xe127",      1.26905183723e+02 },  { "Xe128",      1.27903531275e+02 },
        { "Xe129",      1.28904779435e+02 },  { "Xe130",      1.29903508007e+02 },  { "Xe131",      1.30905082362e+02 },  { "Xe132",      1.31904153457e+02 },
        { "Xe133",      1.32905910722e+02 },  { "Xe134",      1.33905394464e+02 },  { "Xe135",      1.34907227495e+02 },  { "Xe136",      1.35907218794e+02 },
        { "Xe137",      1.36911562125e+02 },  { "Xe138",      1.37913954475e+02 },  { "Xe139",      1.38918792936e+02 },  { "Xe140",      1.39921640943e+02 },
        { "Xe141",      1.40926648049e+02 },  { "Xe142",      1.4192970959e+02 },   { "Xe143",      1.4293511e+02 },      { "Xe144",      1.4393851e+02 },
        { "Xe145",      1.4494407e+02 },      { "Xe146",      1.4594775e+02 },      { "Xe147",      1.4695356e+02 },      { "Cs_natural", 1.329054e+02 },
        { "Cs112",      1.11950301e+02 },     { "Cs113",      1.12944493274e+02 },  { "Cs114",      1.1394145e+02 },      { "Cs115",      1.1493591e+02 },
        { "Cs116",      1.15933367e+02 },     { "Cs117",      1.16928670701e+02 },  { "Cs118",      1.17926559494e+02 },  { "Cs119",      1.18922377304e+02 },
        { "Cs120",      1.19920677253e+02 },  { "Cs121",      1.20917229209e+02 },  { "Cs122",      1.21916113434e+02 },  { "Cs123",      1.22912996036e+02 },
        { "Cs124",      1.23912257798e+02 },  { "Cs125",      1.2490972827e+02 },   { "Cs126",      1.25909451977e+02 },  { "Cs127",      1.26907417525e+02 },
        { "Cs128",      1.27907748866e+02 },  { "Cs129",      1.28906064426e+02 },  { "Cs130",      1.29906708552e+02 },  { "Cs131",      1.30905463926e+02 },
        { "Cs132",      1.3190643426e+02 },   { "Cs133",      1.32905451932e+02 },  { "Cs134",      1.33906718475e+02 },  { "Cs135",      1.34905977008e+02 },
        { "Cs136",      1.35907311576e+02 },  { "Cs137",      1.36907089473e+02 },  { "Cs138",      1.37911016704e+02 },  { "Cs139",      1.38913363999e+02 },
        { "Cs140",      1.39917282354e+02 },  { "Cs141",      1.40920045752e+02 },  { "Cs142",      1.41924298927e+02 },  { "Cs143",      1.4292735175e+02 },
        { "Cs144",      1.43932076914e+02 },  { "Cs145",      1.4493552617e+02 },   { "Cs146",      1.45940289423e+02 },  { "Cs147",      1.46944155008e+02 },
        { "Cs148",      1.47949218153e+02 },  { "Cs149",      1.4895293e+02 },      { "Cs150",      1.4995817e+02 },      { "Cs151",      1.5096219e+02 },
        { "Ba_natural", 1.3733e+02 },         { "Ba114",      1.13950675405e+02 },  { "Ba115",      1.1494737e+02 },      { "Ba116",      1.1594138e+02 },
        { "Ba117",      1.16938499e+02 },     { "Ba118",      1.1793304e+02 },      { "Ba119",      1.18930659661e+02 },  { "Ba120",      1.19926044974e+02 },
        { "Ba121",      1.20924054499e+02 },  { "Ba122",      1.21919904e+02 },     { "Ba123",      1.22918781036e+02 },  { "Ba124",      1.23915093603e+02 },
        { "Ba125",      1.24914472912e+02 },  { "Ba126",      1.25911250177e+02 },  { "Ba127",      1.26911093797e+02 },  { "Ba128",      1.27908317698e+02 },
        { "Ba129",      1.28908679439e+02 },  { "Ba130",      1.29906320811e+02 },  { "Ba131",      1.30906941118e+02 },  { "Ba132",      1.31905061288e+02 },
        { "Ba133",      1.3290600749e+02 },   { "Ba134",      1.33904508383e+02 },  { "Ba135",      1.34905688591e+02 },  { "Ba136",      1.35904575945e+02 },
        { "Ba137",      1.36905827384e+02 },  { "Ba138",      1.37905247237e+02 },  { "Ba139",      1.38908841341e+02 },  { "Ba140",      1.39910604505e+02 },
        { "Ba141",      1.40914411009e+02 },  { "Ba142",      1.4191645341e+02 },   { "Ba143",      1.42920626719e+02 },  { "Ba144",      1.43922952853e+02 },
        { "Ba145",      1.44927627032e+02 },  { "Ba146",      1.45930219572e+02 },  { "Ba147",      1.46934945e+02 },     { "Ba148",      1.47937720047e+02 },
        { "Ba149",      1.4894258e+02 },      { "Ba150",      1.4994568e+02 },      { "Ba151",      1.5095081e+02 },      { "Ba152",      1.5195427e+02 },
        { "Ba153",      1.5295961e+02 },      { "La_natural", 1.389055e+02 },       { "La117",      1.16950068e+02 },     { "La118",      1.1794673e+02 },
        { "La119",      1.1894099e+02 },      { "La120",      1.1993807e+02 },      { "La121",      1.2093301e+02 },      { "La122",      1.2193071e+02 },
        { "La123",      1.2292624e+02 },      { "La124",      1.23924574275e+02 },  { "La125",      1.24920816034e+02 },  { "La126",      1.25919512667e+02 },
        { "La127",      1.26916375448e+02 },  { "La128",      1.27915585177e+02 },  { "La129",      1.28912692815e+02 },  { "La130",      1.29912368724e+02 },
        { "La131",      1.3091007e+02 },      { "La132",      1.31910101145e+02 },  { "La133",      1.32908218e+02 },     { "La134",      1.33908514011e+02 },
        { "La135",      1.34906976844e+02 },  { "La136",      1.35907635536e+02 },  { "La137",      1.36906493598e+02 },  { "La138",      1.3790711193e+02 },
        { "La139",      1.38906353267e+02 },  { "La140",      1.39909477645e+02 },  { "La141",      1.40910962152e+02 },  { "La142",      1.4191407913e+02 },
        { "La143",      1.4291606272e+02 },   { "La144",      1.43919599647e+02 },  { "La145",      1.44921645401e+02 },  { "La146",      1.4592579346e+02 },
        { "La147",      1.46928235284e+02 },  { "La148",      1.47932228868e+02 },  { "La149",      1.48934734e+02 },     { "La150",      1.4993877e+02 },
        { "La151",      1.5094172e+02 },      { "La152",      1.5194625e+02 },      { "La153",      1.5294962e+02 },      { "La154",      1.539545e+02 },
        { "La155",      1.5495835e+02 },      { "Ce_natural", 1.4012e+02 },         { "Ce119",      1.1895276e+02 },      { "Ce120",      1.1994664e+02 },
        { "Ce121",      1.2094342e+02 },      { "Ce122",      1.2193791e+02 },      { "Ce123",      1.229354e+02 },       { "Ce124",      1.2393041e+02 },
        { "Ce125",      1.2492844e+02 },      { "Ce126",      1.25923971e+02 },     { "Ce127",      1.26922731e+02 },     { "Ce128",      1.27918911e+02 },
        { "Ce129",      1.28918102e+02 },     { "Ce130",      1.29914736e+02 },     { "Ce131",      1.30914422e+02 },     { "Ce132",      1.31911460487e+02 },
        { "Ce133",      1.3291151502e+02 },   { "Ce134",      1.33908924821e+02 },  { "Ce135",      1.34909151396e+02 },  { "Ce136",      1.35907172422e+02 },
        { "Ce137",      1.36907805577e+02 },  { "Ce138",      1.37905991321e+02 },  { "Ce139",      1.38906652651e+02 },  { "Ce140",      1.39905438706e+02 },
        { "Ce141",      1.4090827627e+02 },   { "Ce142",      1.41909244205e+02 },  { "Ce143",      1.4291238591e+02 },   { "Ce144",      1.43913647336e+02 },
        { "Ce145",      1.44917233135e+02 },  { "Ce146",      1.45918759009e+02 },  { "Ce147",      1.46922673954e+02 },  { "Ce148",      1.4792443241e+02 },
        { "Ce149",      1.48928399883e+02 },  { "Ce150",      1.49930408931e+02 },  { "Ce151",      1.50933976196e+02 },  { "Ce152",      1.5193654e+02 },
        { "Ce153",      1.5294058e+02 },      { "Ce154",      1.5394342e+02 },      { "Ce155",      1.5494804e+02 },      { "Ce156",      1.5595126e+02 },
        { "Ce157",      1.5695634e+02 },      { "Pr_natural", 1.409077e+02 },       { "Pr121",      1.20955364e+02 },     { "Pr122",      1.2195181e+02 },
        { "Pr123",      1.2294596e+02 },      { "Pr124",      1.2394296e+02 },      { "Pr125",      1.2493783e+02 },      { "Pr126",      1.2593531e+02 },
        { "Pr127",      1.2693083e+02 },      { "Pr128",      1.27928791e+02 },     { "Pr129",      1.28925095e+02 },     { "Pr130",      1.2992359e+02 },
        { "Pr131",      1.30920259e+02 },     { "Pr132",      1.31919255e+02 },     { "Pr133",      1.32916330532e+02 },  { "Pr134",      1.33915711737e+02 },
        { "Pr135",      1.34913111745e+02 },  { "Pr136",      1.35912691611e+02 },  { "Pr137",      1.36910705455e+02 },  { "Pr138",      1.37910754636e+02 },
        { "Pr139",      1.38908938399e+02 },  { "Pr140",      1.39909075874e+02 },  { "Pr141",      1.40907652769e+02 },  { "Pr142",      1.41910044806e+02 },
        { "Pr143",      1.42910816926e+02 },  { "Pr144",      1.43913305245e+02 },  { "Pr145",      1.449145117e+02 },    { "Pr146",      1.45917644336e+02 },
        { "Pr147",      1.46918995992e+02 },  { "Pr148",      1.47922135026e+02 },  { "Pr149",      1.48923717651e+02 },  { "Pr150",      1.49926672997e+02 },
        { "Pr151",      1.50928318618e+02 },  { "Pr152",      1.51931499225e+02 },  { "Pr153",      1.52933838905e+02 },  { "Pr154",      1.53937518153e+02 },
        { "Pr155",      1.5494012e+02 },      { "Pr156",      1.5594427e+02 },      { "Pr157",      1.5694743e+02 },      { "Pr158",      1.5795198e+02 },
        { "Pr159",      1.589555e+02 },       { "Nd_natural", 1.4424e+02 },         { "Nd124",      1.2395223e+02 },      { "Nd125",      1.2494888e+02 },
        { "Nd126",      1.2594322e+02 },      { "Nd127",      1.269405e+02 },       { "Nd128",      1.2793539e+02 },      { "Nd129",      1.28933188e+02 },
        { "Nd130",      1.29928506e+02 },     { "Nd131",      1.30927247e+02 },     { "Nd132",      1.31923321237e+02 },  { "Nd133",      1.32922348e+02 },
        { "Nd134",      1.33918790181e+02 },  { "Nd135",      1.3491818116e+02 },   { "Nd136",      1.35914976035e+02 },  { "Nd137",      1.36914567137e+02 },
        { "Nd138",      1.37911949961e+02 },  { "Nd139",      1.38911978288e+02 },  { "Nd140",      1.39909552e+02 },     { "Nd141",      1.40909609854e+02 },
        { "Nd142",      1.41907723297e+02 },  { "Nd143",      1.4290981429e+02 },   { "Nd144",      1.43910087274e+02 },  { "Nd145",      1.44912573636e+02 },
        { "Nd146",      1.45913116939e+02 },  { "Nd147",      1.46916100441e+02 },  { "Nd148",      1.47916893288e+02 },  { "Nd149",      1.48920148842e+02 },
        { "Nd150",      1.49920890888e+02 },  { "Nd151",      1.50923828929e+02 },  { "Nd152",      1.51924682219e+02 },  { "Nd153",      1.52927698232e+02 },
        { "Nd154",      1.53929477307e+02 },  { "Nd155",      1.54932932e+02 },     { "Nd156",      1.55935018114e+02 },  { "Nd157",      1.5693903e+02 },
        { "Nd158",      1.579416e+02 },       { "Nd159",      1.5894609e+02 },      { "Nd160",      1.5994909e+02 },      { "Nd161",      1.6095388e+02 },
        { "Pm_natural", 1.45e+02 },           { "Pm126",      1.2595752e+02 },      { "Pm127",      1.2695163e+02 },      { "Pm128",      1.2794842e+02 },
        { "Pm129",      1.2894316e+02 },      { "Pm130",      1.2994045e+02 },      { "Pm131",      1.3093587e+02 },      { "Pm132",      1.3193375e+02 },
        { "Pm133",      1.32929782e+02 },     { "Pm134",      1.33928353e+02 },     { "Pm135",      1.34924876e+02 },     { "Pm136",      1.35923565829e+02 },
        { "Pm137",      1.36920479493e+02 },  { "Pm138",      1.37919548281e+02 },  { "Pm139",      1.38916804082e+02 },  { "Pm140",      1.39916041789e+02 },
        { "Pm141",      1.40913555054e+02 },  { "Pm142",      1.41912874471e+02 },  { "Pm143",      1.42910932616e+02 },  { "Pm144",      1.43912590843e+02 },
        { "Pm145",      1.44912749023e+02 },  { "Pm146",      1.45914696305e+02 },  { "Pm147",      1.46915138545e+02 },  { "Pm148",      Pm148_Mass },
        { "Pm149",      1.48918334155e+02 },  { "Pm150",      1.49920983561e+02 },  { "Pm151",      1.50921206973e+02 },  { "Pm152",      1.51923496795e+02 },
        { "Pm153",      1.52924116889e+02 },  { "Pm154",      1.53926463943e+02 },  { "Pm155",      1.54928101267e+02 },  { "Pm156",      1.55931056736e+02 },
        { "Pm157",      1.56933039369e+02 },  { "Pm158",      1.57936561407e+02 },  { "Pm159",      1.5893897e+02 },      { "Pm160",      1.5994299e+02 },
        { "Pm161",      1.6094586e+02 },      { "Pm162",      1.6195029e+02 },      { "Pm163",      1.6295368e+02 },      { "Sm_natural", 1.504e+02 },
        { "Sm128",      1.2795808e+02 },      { "Sm129",      1.2895464e+02 },      { "Sm130",      1.2994892e+02 },      { "Sm131",      1.3094611e+02 },
        { "Sm132",      1.3194069e+02 },      { "Sm133",      1.3293867e+02 },      { "Sm134",      1.3393397e+02 },      { "Sm135",      1.3493252e+02 },
        { "Sm136",      1.35928275527e+02 },  { "Sm137",      1.36926971746e+02 },  { "Sm138",      1.37923243961e+02 },  { "Sm139",      1.38922296605e+02 },
        { "Sm140",      1.39918994687e+02 },  { "Sm141",      1.40918476488e+02 },  { "Sm142",      1.41915197641e+02 },  { "Sm143",      1.42914628338e+02 },
        { "Sm144",      1.43911999478e+02 },  { "Sm145",      1.44913410353e+02 },  { "Sm146",      1.459130409e+02 },    { "Sm147",      1.46914897923e+02 },
        { "Sm148",      1.47914822674e+02 },  { "Sm149",      1.48917184735e+02 },  { "Sm150",      1.49917275539e+02 },  { "Sm151",      1.50919932409e+02 },
        { "Sm152",      1.51919732425e+02 },  { "Sm153",      1.52922097356e+02 },  { "Sm154",      1.53922209273e+02 },  { "Sm155",      1.54924640161e+02 },
        { "Sm156",      1.55925527887e+02 },  { "Sm157",      1.56928358717e+02 },  { "Sm158",      1.57929991317e+02 },  { "Sm159",      1.58933211271e+02 },
        { "Sm160",      1.5993514e+02 },      { "Sm161",      1.6093883e+02 },      { "Sm162",      1.6194122e+02 },      { "Sm163",      1.6294536e+02 },
        { "Sm164",      1.6394828e+02 },      { "Sm165",      1.6495298e+02 },      { "Eu_natural", 1.5196e+02 },         { "Eu130",      1.29963569e+02 },
        { "Eu131",      1.30957753e+02 },     { "Eu132",      1.3195437e+02 },      { "Eu133",      1.3294924e+02 },      { "Eu134",      1.3394651e+02 },
        { "Eu135",      1.3494182e+02 },      { "Eu136",      1.359396e+02 },       { "Eu137",      1.3693557e+02 },      { "Eu138",      1.37933709e+02 },
        { "Eu139",      1.3892979228e+02 },   { "Eu140",      1.39928087607e+02 },  { "Eu141",      1.4092493072e+02 },   { "Eu142",      1.41923434945e+02 },
        { "Eu143",      1.42920297509e+02 },  { "Eu144",      1.43918816823e+02 },  { "Eu145",      1.44916265237e+02 },  { "Eu146",      1.45917205817e+02 },
        { "Eu147",      1.46916746111e+02 },  { "Eu148",      1.47918085895e+02 },  { "Eu149",      1.48917931238e+02 },  { "Eu150",      1.49919701819e+02 },
        { "Eu151",      1.50919850161e+02 },  { "Eu152",      1.51921744534e+02 },  { "Eu153",      1.52921230339e+02 },  { "Eu154",      1.53922979237e+02 },
        { "Eu155",      1.5492289326e+02 },   { "Eu156",      1.55924752249e+02 },  { "Eu157",      1.56925423647e+02 },  { "Eu158",      1.57927845302e+02 },
        { "Eu159",      1.58929088861e+02 },  { "Eu160",      1.59931971e+02 },     { "Eu161",      1.6093368e+02 },      { "Eu162",      1.6193704e+02 },
        { "Eu163",      1.6293921e+02 },      { "Eu164",      1.6394299e+02 },      { "Eu165",      1.6494572e+02 },      { "Eu166",      1.6594997e+02 },
        { "Eu167",      1.6695321e+02 },      { "Gd_natural", 1.5725e+02 },         { "Gd134",      1.3395537e+02 },      { "Gd135",      1.3495257e+02 },
        { "Gd136",      1.3594734e+02 },      { "Gd137",      1.3694502e+02 },      { "Gd138",      1.3794012e+02 },      { "Gd139",      1.3893824e+02 },
        { "Gd140",      1.39933674e+02 },     { "Gd141",      1.40932126e+02 },     { "Gd142",      1.41928116e+02 },     { "Gd143",      1.4292674951e+02 },
        { "Gd144",      1.43922963e+02 },     { "Gd145",      1.44921709252e+02 },  { "Gd146",      1.45918310608e+02 },  { "Gd147",      1.4691909442e+02 },
        { "Gd148",      1.47918114524e+02 },  { "Gd149",      1.48919340915e+02 },  { "Gd150",      1.49918658876e+02 },  { "Gd151",      1.50920348482e+02 },
        { "Gd152",      1.51919790996e+02 },  { "Gd153",      1.52921749543e+02 },  { "Gd154",      1.53920865598e+02 },  { "Gd155",      1.54922622022e+02 },
        { "Gd156",      1.55922122743e+02 },  { "Gd157",      1.56923960135e+02 },  { "Gd158",      1.57924103912e+02 },  { "Gd159",      1.58926388658e+02 },
        { "Gd160",      1.59927054146e+02 },  { "Gd161",      1.60929669211e+02 },  { "Gd162",      1.61930984751e+02 },  { "Gd163",      1.6293399e+02 },
        { "Gd164",      1.6393586e+02 },      { "Gd165",      1.6493938e+02 },      { "Gd166",      1.659416e+02 },       { "Gd167",      1.6694557e+02 },
        { "Gd168",      1.6794836e+02 },      { "Gd169",      1.6895287e+02 },      { "Tb_natural", 1.589254e+02 },       { "Tb136",      1.3596138e+02 },
        { "Tb137",      1.3695598e+02 },      { "Tb138",      1.3795316e+02 },      { "Tb139",      1.3894829e+02 },      { "Tb140",      1.39945805049e+02 },
        { "Tb141",      1.40941448e+02 },     { "Tb142",      1.41938744e+02 },     { "Tb143",      1.42935121e+02 },     { "Tb144",      1.43933045e+02 },
        { "Tb145",      1.44929274e+02 },     { "Tb146",      1.45927246584e+02 },  { "Tb147",      1.46924044585e+02 },  { "Tb148",      1.47924271701e+02 },
        { "Tb149",      1.48923245909e+02 },  { "Tb150",      1.49923659686e+02 },  { "Tb151",      1.50923102543e+02 },  { "Tb152",      1.51924074438e+02 },
        { "Tb153",      1.52923434588e+02 },  { "Tb154",      1.53924678019e+02 },  { "Tb155",      1.54923505236e+02 },  { "Tb156",      1.55924747213e+02 },
        { "Tb157",      1.56924024604e+02 },  { "Tb158",      1.57925413137e+02 },  { "Tb159",      1.58925346757e+02 },  { "Tb160",      1.59927167606e+02 },
        { "Tb161",      1.60927569919e+02 },  { "Tb162",      1.61929488234e+02 },  { "Tb163",      1.62930647536e+02 },  { "Tb164",      1.63933350838e+02 },
        { "Tb165",      1.6493488e+02 },      { "Tb166",      1.65937991959e+02 },  { "Tb167",      1.6694005e+02 },      { "Tb168",      1.6794364e+02 },
        { "Tb169",      1.6894622e+02 },      { "Tb170",      1.6995025e+02 },      { "Tb171",      1.709533e+02 },       { "Dy_natural", 1.625e+02 },
        { "Dy138",      1.3796249e+02 },      { "Dy139",      1.3895954e+02 },      { "Dy140",      1.3995401e+02 },      { "Dy141",      1.4095135e+02 },
        { "Dy142",      1.41946366e+02 },     { "Dy143",      1.4294383e+02 },      { "Dy144",      1.43939254e+02 },     { "Dy145",      1.44937425e+02 },
        { "Dy146",      1.45932845369e+02 },  { "Dy147",      1.469310915e+02 },    { "Dy148",      1.47927149831e+02 },  { "Dy149",      1.48927304787e+02 },
        { "Dy150",      1.49925585184e+02 },  { "Dy151",      1.50926184601e+02 },  { "Dy152",      1.519247183e+02 },    { "Dy153",      1.5292576467e+02 },
        { "Dy154",      1.53924424457e+02 },  { "Dy155",      1.54925753775e+02 },  { "Dy156",      1.5592428311e+02 },   { "Dy157",      1.56925466095e+02 },
        { "Dy158",      1.57924409487e+02 },  { "Dy159",      1.58925739214e+02 },  { "Dy160",      1.59925197517e+02 },  { "Dy161",      1.60926933364e+02 },
        { "Dy162",      1.61926798447e+02 },  { "Dy163",      1.62928731159e+02 },  { "Dy164",      1.63929174751e+02 },  { "Dy165",      1.64931703333e+02 },
        { "Dy166",      1.65932806741e+02 },  { "Dy167",      1.66935655462e+02 },  { "Dy168",      1.67937128769e+02 },  { "Dy169",      1.68940307614e+02 },
        { "Dy170",      1.6994239e+02 },      { "Dy171",      1.709462e+02 },       { "Dy172",      1.7194876e+02 },      { "Dy173",      1.72953e+02 },
        { "Ho_natural", 1.649304e+02 },       { "Ho140",      1.39968539e+02 },     { "Ho141",      1.40963098e+02 },     { "Ho142",      1.4195977e+02 },
        { "Ho143",      1.4295461e+02 },      { "Ho144",      1.4395148e+02 },      { "Ho145",      1.449472e+02 },       { "Ho146",      1.4594464e+02 },
        { "Ho147",      1.46940056e+02 },     { "Ho148",      1.47937718e+02 },     { "Ho149",      1.48933774771e+02 },  { "Ho150",      1.49933496182e+02 },
        { "Ho151",      1.50931688142e+02 },  { "Ho152",      1.51931713714e+02 },  { "Ho153",      1.52930198789e+02 },  { "Ho154",      1.53930601579e+02 },
        { "Ho155",      1.54929103491e+02 },  { "Ho156",      1.55929839e+02 },     { "Ho157",      1.56928256188e+02 },  { "Ho158",      1.57928941007e+02 },
        { "Ho159",      1.58927711959e+02 },  { "Ho160",      1.59928729478e+02 },  { "Ho161",      1.60927854776e+02 },  { "Ho162",      1.61929095504e+02 },
        { "Ho163",      1.62928733903e+02 },  { "Ho164",      1.63930233507e+02 },  { "Ho165",      1.6493032207e+02 },   { "Ho166",      Ho166_Mass },
        { "Ho167",      1.66933132633e+02 },  { "Ho168",      1.67935515708e+02 },  { "Ho169",      1.68936872273e+02 },  { "Ho170",      1.69939618929e+02 },
        { "Ho171",      1.7094146515e+02 },   { "Ho172",      1.7194482e+02 },      { "Ho173",      1.7294729e+02 },      { "Ho174",      1.7395115e+02 },
        { "Ho175",      1.7495405e+02 },      { "Er_natural", 1.6726e+02 },         { "Er143",      1.4296634e+02 },      { "Er144",      1.4396038e+02 },
        { "Er145",      1.4495739e+02 },      { "Er146",      1.45952e+02 },        { "Er147",      1.4694949e+02 },      { "Er148",      1.4794455e+02 },
        { "Er149",      1.48942306e+02 },     { "Er150",      1.49937913839e+02 },  { "Er151",      1.50937448903e+02 },  { "Er152",      1.51935050389e+02 },
        { "Er153",      1.52935063492e+02 },  { "Er154",      1.53932783081e+02 },  { "Er155",      1.54933208949e+02 },  { "Er156",      1.55931064698e+02 },
        { "Er157",      1.56931916e+02 },     { "Er158",      1.57929893474e+02 },  { "Er159",      1.58930684066e+02 },  { "Er160",      1.59929083292e+02 },
        { "Er161",      1.60929995309e+02 },  { "Er162",      1.61928778264e+02 },  { "Er163",      1.62930032749e+02 },  { "Er164",      1.63929200229e+02 },
        { "Er165",      1.64930726003e+02 },  { "Er166",      1.65930293061e+02 },  { "Er167",      1.66932048159e+02 },  { "Er168",      1.67932370224e+02 },
        { "Er169",      1.68934590364e+02 },  { "Er170",      1.69935464312e+02 },  { "Er171",      1.70938029808e+02 },  { "Er172",      1.71939356113e+02 },
        { "Er173",      1.729424e+02 },       { "Er174",      1.7394423e+02 },      { "Er175",      1.7494777e+02 },      { "Er176",      1.7595008e+02 },
        { "Er177",      1.7695405e+02 },      { "Tm_natural", 1.689342e+02 },       { "Tm145",      1.44970073e+02 },     { "Tm146",      1.45966425e+02 },
        { "Tm147",      1.46960961e+02 },     { "Tm148",      1.4795784e+02 },      { "Tm149",      1.4895272e+02 },      { "Tm150",      1.4994996e+02 },
        { "Tm151",      1.5094548349e+02 },   { "Tm152",      1.51944422e+02 },     { "Tm153",      1.52942012112e+02 },  { "Tm154",      1.53941567808e+02 },
        { "Tm155",      1.54939199459e+02 },  { "Tm156",      1.55938979933e+02 },  { "Tm157",      1.56936973e+02 },     { "Tm158",      1.57936979525e+02 },
        { "Tm159",      1.58934975e+02 },     { "Tm160",      1.59935262801e+02 },  { "Tm161",      1.60933549e+02 },     { "Tm162",      1.61933994682e+02 },
        { "Tm163",      1.62932651124e+02 },  { "Tm164",      1.6393356e+02 },      { "Tm165",      1.64932435492e+02 },  { "Tm166",      1.65933554131e+02 },
        { "Tm167",      1.66932851622e+02 },  { "Tm168",      1.67934172776e+02 },  { "Tm169",      1.6893421325e+02 },   { "Tm170",      1.69935801397e+02 },
        { "Tm171",      1.7093642944e+02 },   { "Tm172",      1.71938400044e+02 },  { "Tm173",      1.72939603607e+02 },  { "Tm174",      1.73942168605e+02 },
        { "Tm175",      1.74943836853e+02 },  { "Tm176",      1.75946994685e+02 },  { "Tm177",      1.7694904e+02 },      { "Tm178",      1.7795264e+02 },
        { "Tm179",      1.7895534e+02 },      { "Yb_natural", 1.7304e+02 },         { "Yb148",      1.4796742e+02 },      { "Yb149",      1.4896404e+02 },
        { "Yb150",      1.4995842e+02 },      { "Yb151",      1.50955400769e+02 },  { "Yb152",      1.51950288919e+02 },  { "Yb153",      1.5294948e+02 },
        { "Yb154",      1.53946393928e+02 },  { "Yb155",      1.54945782332e+02 },  { "Yb156",      1.55942818215e+02 },  { "Yb157",      1.56942627848e+02 },
        { "Yb158",      1.57939865617e+02 },  { "Yb159",      1.58940050099e+02 },  { "Yb160",      1.59937552344e+02 },  { "Yb161",      1.60937901678e+02 },
        { "Yb162",      1.6193576821e+02 },   { "Yb163",      1.62936334305e+02 },  { "Yb164",      1.63934489416e+02 },  { "Yb165",      1.64935279e+02 },
        { "Yb166",      1.65933882042e+02 },  { "Yb167",      1.66934949605e+02 },  { "Yb168",      1.67933896895e+02 },  { "Yb169",      1.68935189802e+02 },
        { "Yb170",      1.69934761837e+02 },  { "Yb171",      1.70936325799e+02 },  { "Yb172",      1.71936381469e+02 },  { "Yb173",      1.72938210787e+02 },
        { "Yb174",      1.73938862089e+02 },  { "Yb175",      1.7494127645e+02 },   { "Yb176",      1.75942571683e+02 },  { "Yb177",      1.76945260822e+02 },
        { "Yb178",      1.7794664668e+02 },   { "Yb179",      1.7895017e+02 },      { "Yb180",      1.7995233e+02 },      { "Yb181",      1.8095615e+02 },
        { "Lu_natural", 1.74967e+02 },        { "Lu150",      1.49973228e+02 },     { "Lu151",      1.50967577e+02 },     { "Lu152",      1.5196412e+02 },
        { "Lu153",      1.52958767331e+02 },  { "Lu154",      1.53957522e+02 },     { "Lu155",      1.54954316216e+02 },  { "Lu156",      1.55953032523e+02 },
        { "Lu157",      1.569500983e+02 },    { "Lu158",      1.57949313283e+02 },  { "Lu159",      1.58946628776e+02 },  { "Lu160",      1.59946033e+02 },
        { "Lu161",      1.60943572e+02 },     { "Lu162",      1.61943277288e+02 },  { "Lu163",      1.62941179e+02 },     { "Lu164",      1.63941339e+02 },
        { "Lu165",      1.64939406724e+02 },  { "Lu166",      1.65939859e+02 },     { "Lu167",      1.6693827e+02 },      { "Lu168",      1.67938739111e+02 },
        { "Lu169",      1.68937651439e+02 },  { "Lu170",      1.69938474968e+02 },  { "Lu171",      1.70937913136e+02 },  { "Lu172",      1.71939085669e+02 },
        { "Lu173",      1.72938930602e+02 },  { "Lu174",      1.7394033748e+02 },   { "Lu175",      1.74940771819e+02 },  { "Lu176",      1.7594268631e+02 },
        { "Lu177",      1.76943758055e+02 },  { "Lu178",      1.77945954559e+02 },  { "Lu179",      1.78947327443e+02 },  { "Lu180",      1.7994988116e+02 },
        { "Lu181",      1.8095197e+02 },      { "Lu182",      1.8195504e+02 },      { "Lu183",      1.8295757e+02 },      { "Lu184",      1.8396091e+02 },
        { "Hf_natural", 1.7849e+02 },         { "Hf153",      1.5297069e+02 },      { "Hf154",      1.5396486e+02 },      { "Hf155",      1.5496339e+02 },
        { "Hf156",      1.55959364025e+02 },  { "Hf157",      1.56958396e+02 },     { "Hf158",      1.57954799366e+02 },  { "Hf159",      1.5895399487e+02 },
        { "Hf160",      1.59950684379e+02 },  { "Hf161",      1.60950274844e+02 },  { "Hf162",      1.61947210498e+02 },  { "Hf163",      1.62947089e+02 },
        { "Hf164",      1.63944367284e+02 },  { "Hf165",      1.64944567e+02 },     { "Hf166",      1.6594218e+02 },      { "Hf167",      1.669426e+02 },
        { "Hf168",      1.67940568e+02 },     { "Hf169",      1.68941259e+02 },     { "Hf170",      1.69939609e+02 },     { "Hf171",      1.70940492e+02 },
        { "Hf172",      1.71939448301e+02 },  { "Hf173",      1.72940513e+02 },     { "Hf174",      1.73940046178e+02 },  { "Hf175",      1.74941509181e+02 },
        { "Hf176",      1.75941408631e+02 },  { "Hf177",      1.76943220651e+02 },  { "Hf178",      1.77943698766e+02 },  { "Hf179",      1.78945816145e+02 },
        { "Hf180",      1.79946549953e+02 },  { "Hf181",      1.80949101246e+02 },  { "Hf182",      1.81950554096e+02 },  { "Hf183",      1.82953530439e+02 },
        { "Hf184",      1.83955446515e+02 },  { "Hf185",      1.8495882e+02 },      { "Hf186",      1.8596089e+02 },      { "Hf187",      1.8696459e+02 },
        { "Hf188",      1.8796685e+02 },      { "Ta_natural", 1.809479e+02 },       { "Ta155",      1.54974592e+02 },     { "Ta156",      1.55972303e+02 },
        { "Ta157",      1.56968192445e+02 },  { "Ta158",      1.57966699e+02 },     { "Ta159",      1.58963018173e+02 },  { "Ta160",      1.59961486056e+02 },
        { "Ta161",      1.60958417e+02 },     { "Ta162",      1.61957291859e+02 },  { "Ta163",      1.62954330271e+02 },  { "Ta164",      1.63953534e+02 },
        { "Ta165",      1.64950772514e+02 },  { "Ta166",      1.65950512e+02 },     { "Ta167",      1.66948093e+02 },     { "Ta168",      1.67948047e+02 },
        { "Ta169",      1.68946011e+02 },     { "Ta170",      1.69946175e+02 },     { "Ta171",      1.70944476e+02 },     { "Ta172",      1.71944895e+02 },
        { "Ta173",      1.7294375e+02 },      { "Ta174",      1.73944454e+02 },     { "Ta175",      1.74943737e+02 },     { "Ta176",      1.75944857e+02 },
        { "Ta177",      1.76944472403e+02 },  { "Ta178",      1.77945778221e+02 },  { "Ta179",      1.78945929535e+02 },  { "Ta180",      1.79947464831e+02 },
        { "Ta181",      1.80947995763e+02 },  { "Ta182",      1.81950151849e+02 },  { "Ta183",      1.82951372616e+02 },  { "Ta184",      1.83954007966e+02 },
        { "Ta185",      1.84955559375e+02 },  { "Ta186",      1.85958552023e+02 },  { "Ta187",      1.8696053e+02 },      { "Ta188",      1.879637e+02 },
        { "Ta189",      1.8896583e+02 },      { "Ta190",      1.8996923e+02 },      { "W_natural",  1.8385e+02 },         { "W158",       1.57974562e+02 },
        { "W159",       1.58972918e+02 },     { "W160",       1.59968478805e+02 },  { "W161",       1.60967357e+02 },     { "W162",       1.61963497417e+02 },
        { "W163",       1.62962523542e+02 },  { "W164",       1.63958954382e+02 },  { "W165",       1.64958279949e+02 },  { "W166",       1.65955027253e+02 },
        { "W167",       1.66954816014e+02 },  { "W168",       1.67951808394e+02 },  { "W169",       1.6895177879e+02 },   { "W170",       1.69949228482e+02 },
        { "W171",       1.70949451e+02 },     { "W172",       1.71947292e+02 },     { "W173",       1.72947689e+02 },     { "W174",       1.73946079e+02 },
        { "W175",       1.74946717e+02 },     { "W176",       1.75945634e+02 },     { "W177",       1.76946643e+02 },     { "W178",       1.77945876236e+02 },
        { "W179",       1.78947070447e+02 },  { "W180",       1.79946704459e+02 },  { "W181",       1.80948197248e+02 },  { "W182",       1.81948204156e+02 },
        { "W183",       1.82950222951e+02 },  { "W184",       1.83950931188e+02 },  { "W185",       1.84953419264e+02 },  { "W186",       1.85954364127e+02 },
        { "W187",       1.86957160466e+02 },  { "W188",       1.87958489105e+02 },  { "W189",       1.88961912868e+02 },  { "W190",       1.89963181378e+02 },
        { "W191",       1.909666e+02 },       { "W192",       1.9196817e+02 },      { "Re_natural", 1.86207e+02 },        { "Re160",      1.59982115e+02 },
        { "Re161",      1.60977589119e+02 },  { "Re162",      1.61976002e+02 },     { "Re163",      1.62972080535e+02 },  { "Re164",      1.63970323e+02 },
        { "Re165",      1.64967088557e+02 },  { "Re166",      1.65965808e+02 },     { "Re167",      1.66962601e+02 },     { "Re168",      1.67961572608e+02 },
        { "Re169",      1.68958791096e+02 },  { "Re170",      1.69958220071e+02 },  { "Re171",      1.70955716e+02 },     { "Re172",      1.71955422961e+02 },
        { "Re173",      1.72953243e+02 },     { "Re174",      1.73953115e+02 },     { "Re175",      1.74951381e+02 },     { "Re176",      1.75951623e+02 },
        { "Re177",      1.76950328e+02 },     { "Re178",      1.77950989e+02 },     { "Re179",      1.78949987641e+02 },  { "Re180",      1.79950789084e+02 },
        { "Re181",      1.80950067916e+02 },  { "Re182",      1.8195121008e+02 },   { "Re183",      1.82950819841e+02 },  { "Re184",      1.83952520756e+02 },
        { "Re185",      1.84952954982e+02 },  { "Re186",      1.85954986084e+02 },  { "Re187",      1.86955753109e+02 },  { "Re188",      1.87958114438e+02 },
        { "Re189",      1.88959229007e+02 },  { "Re190",      1.89961817977e+02 },  { "Re191",      1.90963125242e+02 },  { "Re192",      1.9196596e+02 },
        { "Re193",      1.9296747e+02 },      { "Re194",      1.9397042e+02 },      { "Os_natural", 1.902e+02 },          { "Os162",      1.61984431e+02 },
        { "Os163",      1.6298269e+02 },      { "Os164",      1.63978035649e+02 },  { "Os165",      1.64976762e+02 },     { "Os166",      1.65972690753e+02 },
        { "Os167",      1.66971547969e+02 },  { "Os168",      1.67967803678e+02 },  { "Os169",      1.6896701927e+02 },   { "Os170",      1.69963577028e+02 },
        { "Os171",      1.70963184819e+02 },  { "Os172",      1.71960023303e+02 },  { "Os173",      1.72959808409e+02 },  { "Os174",      1.73957062202e+02 },
        { "Os175",      1.74956945835e+02 },  { "Os176",      1.75954806e+02 },     { "Os177",      1.76954965324e+02 },  { "Os178",      1.77953251241e+02 },
        { "Os179",      1.78953816017e+02 },  { "Os180",      1.79952378803e+02 },  { "Os181",      1.80953244e+02 },     { "Os182",      1.81952110186e+02 },
        { "Os183",      1.82953126102e+02 },  { "Os184",      1.83952489071e+02 },  { "Os185",      1.84954042265e+02 },  { "Os186",      1.85953838158e+02 },
        { "Os187",      1.86955750458e+02 },  { "Os188",      1.87955838228e+02 },  { "Os189",      1.8895814747e+02 },   { "Os190",      1.89958447048e+02 },
        { "Os191",      1.90960929718e+02 },  { "Os192",      1.9196148069e+02 },   { "Os193",      1.92964151563e+02 },  { "Os194",      1.93965182083e+02 },
        { "Os195",      1.94968126661e+02 },  { "Os196",      1.95969639333e+02 },  { "Ir_natural", 1.9222e+02 },         { "Ir164",      1.63992201e+02 },
        { "Ir165",      1.6498752e+02 },      { "Ir166",      1.65985824e+02 },     { "Ir167",      1.66981665156e+02 },  { "Ir168",      1.67979881e+02 },
        { "Ir169",      1.68976294942e+02 },  { "Ir170",      1.69974965e+02 },     { "Ir171",      1.70971626042e+02 },  { "Ir172",      1.71970456e+02 },
        { "Ir173",      1.72967501739e+02 },  { "Ir174",      1.73966861045e+02 },  { "Ir175",      1.74964112895e+02 },  { "Ir176",      1.75963648688e+02 },
        { "Ir177",      1.769613015e+02 },    { "Ir178",      1.77961082e+02 },     { "Ir179",      1.78959122266e+02 },  { "Ir180",      1.79959229446e+02 },
        { "Ir181",      1.80957625297e+02 },  { "Ir182",      1.81958076296e+02 },  { "Ir183",      1.82956846458e+02 },  { "Ir184",      1.83957476e+02 },
        { "Ir185",      1.84956698e+02 },     { "Ir186",      1.85957946104e+02 },  { "Ir187",      1.86957363361e+02 },  { "Ir188",      1.87958853121e+02 },
        { "Ir189",      1.88958718935e+02 },  { "Ir190",      1.89960545968e+02 },  { "Ir191",      1.90960594046e+02 },  { "Ir192",      1.91962605012e+02 },
        { "Ir193",      1.9296292643e+02 },   { "Ir194",      1.93965078378e+02 },  { "Ir195",      1.94965979573e+02 },  { "Ir196",      1.95968396542e+02 },
        { "Ir197",      1.96969653285e+02 },  { "Ir198",      1.9797228e+02 },      { "Ir199",      1.98973804583e+02 },  { "Pt_natural", 1.9509e+02 },
        { "Pt166",      1.65994855e+02 },     { "Pt167",      1.66992979e+02 },     { "Pt168",      1.67988150742e+02 },  { "Pt169",      1.68986715e+02 },
        { "Pt170",      1.69982495289e+02 },  { "Pt171",      1.70981244542e+02 },  { "Pt172",      1.71977347128e+02 },  { "Pt173",      1.72976444754e+02 },
        { "Pt174",      1.73972818767e+02 },  { "Pt175",      1.74972420552e+02 },  { "Pt176",      1.75968944622e+02 },  { "Pt177",      1.76968469481e+02 },
        { "Pt178",      1.77965648724e+02 },  { "Pt179",      1.78965363404e+02 },  { "Pt180",      1.79963031477e+02 },  { "Pt181",      1.80963097285e+02 },
        { "Pt182",      1.81961170656e+02 },  { "Pt183",      1.82961596703e+02 },  { "Pt184",      1.83959922251e+02 },  { "Pt185",      1.84960619e+02 },
        { "Pt186",      1.85959350813e+02 },  { "Pt187",      1.86960587e+02 },     { "Pt188",      1.87959395391e+02 },  { "Pt189",      1.88960833686e+02 },
        { "Pt190",      1.89959931655e+02 },  { "Pt191",      1.90961676661e+02 },  { "Pt192",      1.91961038005e+02 },  { "Pt193",      1.92962987401e+02 },
        { "Pt194",      1.93962680253e+02 },  { "Pt195",      1.94964791134e+02 },  { "Pt196",      1.95964951521e+02 },  { "Pt197",      1.96967340182e+02 },
        { "Pt198",      1.9796789279e+02 },   { "Pt199",      1.98970593094e+02 },  { "Pt200",      1.99971440677e+02 },  { "Pt201",      2.00974512868e+02 },
        { "Pt202",      2.0197574e+02 },      { "Au_natural", 1.969665e+02 },       { "Au169",      1.6899808e+02 },      { "Au170",      1.69996122e+02 },
        { "Au171",      1.70991878881e+02 },  { "Au172",      1.71990035e+02 },     { "Au173",      1.7298623738e+02 },   { "Au174",      1.73984761e+02 },
        { "Au175",      1.74981274107e+02 },  { "Au176",      1.75980099e+02 },     { "Au177",      1.76976864908e+02 },  { "Au178",      1.7797603192e+02 },
        { "Au179",      1.78973212812e+02 },  { "Au180",      1.79972521124e+02 },  { "Au181",      1.80970079048e+02 },  { "Au182",      1.81969617874e+02 },
        { "Au183",      1.82967593034e+02 },  { "Au184",      1.83967451524e+02 },  { "Au185",      1.84965789411e+02 },  { "Au186",      1.85965952703e+02 },
        { "Au187",      1.86964567541e+02 },  { "Au188",      1.87965323661e+02 },  { "Au189",      1.88963948286e+02 },  { "Au190",      1.89964700339e+02 },
        { "Au191",      1.90963704225e+02 },  { "Au192",      1.91964812953e+02 },  { "Au193",      1.92964149715e+02 },  { "Au194",      1.9396536525e+02 },
        { "Au195",      1.9496503464e+02 },   { "Au196",      1.95966569813e+02 },  { "Au197",      1.96966568662e+02 },  { "Au198",      1.97968242303e+02 },
        { "Au199",      1.98968765193e+02 },  { "Au200",      1.99970725647e+02 },  { "Au201",      2.0097165724e+02 },   { "Au202",      2.01973805838e+02 },
        { "Au203",      2.02975154542e+02 },  { "Au204",      2.03977724e+02 },     { "Au205",      2.0497987e+02 },      { "Hg_natural", 2.0059e+02 },
        { "Hg171",      1.7100376e+02 },      { "Hg172",      1.71998832686e+02 },  { "Hg173",      1.72997242e+02 },     { "Hg174",      1.73992863695e+02 },
        { "Hg175",      1.7499142327e+02 },   { "Hg176",      1.7598735458e+02 },   { "Hg177",      1.76986279158e+02 },  { "Hg178",      1.77982483143e+02 },
        { "Hg179",      1.78981833861e+02 },  { "Hg180",      1.79978266394e+02 },  { "Hg181",      1.80977819311e+02 },  { "Hg182",      1.81974689964e+02 },
        { "Hg183",      1.82974449841e+02 },  { "Hg184",      1.83971713051e+02 },  { "Hg185",      1.84971899086e+02 },  { "Hg186",      1.8596936179e+02 },
        { "Hg187",      1.86969814236e+02 },  { "Hg188",      1.87967577049e+02 },  { "Hg189",      1.88968190034e+02 },  { "Hg190",      1.89966322449e+02 },
        { "Hg191",      1.90967157105e+02 },  { "Hg192",      1.91965634327e+02 },  { "Hg193",      1.92966665421e+02 },  { "Hg194",      1.93965439409e+02 },
        { "Hg195",      1.94966720113e+02 },  { "Hg196",      1.95965832649e+02 },  { "Hg197",      1.96967212908e+02 },  { "Hg198",      1.97966769032e+02 },
        { "Hg199",      1.98968279932e+02 },  { "Hg200",      1.99968326004e+02 },  { "Hg201",      2.00970302268e+02 },  { "Hg202",      2.01970643011e+02 },
        { "Hg203",      2.02972872484e+02 },  { "Hg204",      2.03973493933e+02 },  { "Hg205",      2.04976073386e+02 },  { "Hg206",      2.05977514066e+02 },
        { "Hg207",      2.06982588545e+02 },  { "Hg208",      2.0798594e+02 },      { "Hg209",      2.0899104e+02 },      { "Hg210",      2.0999451e+02 },
        { "Tl_natural", 2.0437e+02 },         { "Tl176",      1.7600059e+02 },      { "Tl177",      1.76996427286e+02 },  { "Tl178",      1.77994897e+02 },
        { "Tl179",      1.78991089082e+02 },  { "Tl180",      1.79989906e+02 },     { "Tl181",      1.80986257447e+02 },  { "Tl182",      1.81985667104e+02 },
        { "Tl183",      1.82982192802e+02 },  { "Tl184",      1.83981873122e+02 },  { "Tl185",      1.84978791305e+02 },  { "Tl186",      1.85978325e+02 },
        { "Tl187",      1.86975905897e+02 },  { "Tl188",      1.87976009782e+02 },  { "Tl189",      1.88973588428e+02 },  { "Tl190",      1.89973877149e+02 },
        { "Tl191",      1.90971786154e+02 },  { "Tl192",      1.91972225e+02 },     { "Tl193",      1.92970672e+02 },     { "Tl194",      1.939712e+02 },
        { "Tl195",      1.94969774335e+02 },  { "Tl196",      1.95970481151e+02 },  { "Tl197",      1.96969574511e+02 },  { "Tl198",      1.97970483495e+02 },
        { "Tl199",      1.98969877e+02 },     { "Tl200",      1.99970962672e+02 },  { "Tl201",      2.00970818891e+02 },  { "Tl202",      2.01972105808e+02 },
        { "Tl203",      2.0297234422e+02 },   { "Tl204",      2.03973863522e+02 },  { "Tl205",      2.04974427541e+02 },  { "Tl206",      2.0597611032e+02 },
        { "Tl207",      2.06977419429e+02 },  { "Tl208",      2.079820187e+02 },    { "Tl209",      2.08985358952e+02 },  { "Tl210",      2.09990073689e+02 },
        { "Tl211",      2.10993477e+02 },     { "Tl212",      2.11998228e+02 },     { "Pb_natural", 2.072e+02 },          { "Pb178",      1.78003830191e+02 },
        { "Pb179",      1.7900215e+02 },      { "Pb180",      1.79997918173e+02 },  { "Pb181",      1.80996623958e+02 },  { "Pb182",      1.81992671842e+02 },
        { "Pb183",      1.82991874629e+02 },  { "Pb184",      1.83988142339e+02 },  { "Pb185",      1.84987609944e+02 },  { "Pb186",      1.85984238945e+02 },
        { "Pb187",      1.8698391837e+02 },   { "Pb188",      1.87980874338e+02 },  { "Pb189",      1.88980807e+02 },     { "Pb190",      1.89978081517e+02 },
        { "Pb191",      1.90978265e+02 },     { "Pb192",      1.91975785171e+02 },  { "Pb193",      1.92976173234e+02 },  { "Pb194",      1.9397401207e+02 },
        { "Pb195",      1.9497454205e+02 },   { "Pb196",      1.95972774109e+02 },  { "Pb197",      1.96973431124e+02 },  { "Pb198",      1.97972033959e+02 },
        { "Pb199",      1.9897291665e+02 },   { "Pb200",      1.99971826675e+02 },  { "Pb201",      2.00972884511e+02 },  { "Pb202",      2.01972159133e+02 },
        { "Pb203",      2.02973390521e+02 },  { "Pb204",      2.03973043589e+02 },  { "Pb205",      2.04974481755e+02 },  { "Pb206",      2.05974465278e+02 },
        { "Pb207",      2.06975896887e+02 },  { "Pb208",      2.07976652071e+02 },  { "Pb209",      2.0898109012e+02 },   { "Pb210",      2.09984188527e+02 },
        { "Pb211",      2.10988736964e+02 },  { "Pb212",      2.11991897543e+02 },  { "Pb213",      2.12996581499e+02 },  { "Pb214",      2.13999805408e+02 },
        { "Pb215",      2.15004807e+02 },     { "Bi_natural", 2.089804e+02 },       { "Bi184",      1.84001124e+02 },     { "Bi185",      1.84997625e+02 },
        { "Bi186",      1.85996597625e+02 },  { "Bi187",      1.86993157835e+02 },  { "Bi188",      1.87992265154e+02 },  { "Bi189",      1.88989199012e+02 },
        { "Bi190",      1.89988295129e+02 },  { "Bi191",      1.90985786119e+02 },  { "Bi192",      1.91985457954e+02 },  { "Bi193",      1.92982959771e+02 },
        { "Bi194",      1.9398283396e+02 },   { "Bi195",      1.94980650737e+02 },  { "Bi196",      1.95980666509e+02 },  { "Bi197",      1.96978864454e+02 },
        { "Bi198",      1.97979206e+02 },     { "Bi199",      1.98977671961e+02 },  { "Bi200",      1.99978131829e+02 },  { "Bi201",      2.00977009036e+02 },
        { "Bi202",      2.01977742324e+02 },  { "Bi203",      2.02976876001e+02 },  { "Bi204",      2.03977812736e+02 },  { "Bi205",      2.04977389366e+02 },
        { "Bi206",      2.0597849913e+02 },   { "Bi207",      2.06978470679e+02 },  { "Bi208",      2.07979742196e+02 },  { "Bi209",      2.08980398734e+02 },
        { "Bi210",      2.09984120371e+02 },  { "Bi211",      2.1098726946e+02 },   { "Bi212",      2.11991285724e+02 },  { "Bi213",      2.12994384666e+02 },
        { "Bi214",      2.13998711539e+02 },  { "Bi215",      2.15001769776e+02 },  { "Bi216",      2.16006305943e+02 },  { "Bi217",      2.1700947e+02 },
        { "Bi218",      2.18014316e+02 },     { "Po_natural", 2.09e+02 },           { "Po188",      1.87999422048e+02 },  { "Po189",      1.88998480562e+02 },
        { "Po190",      1.89995101185e+02 },  { "Po191",      1.90994574485e+02 },  { "Po192",      1.91991335149e+02 },  { "Po193",      1.92991025275e+02 },
        { "Po194",      1.93988185606e+02 },  { "Po195",      1.94988110728e+02 },  { "Po196",      1.9598553458e+02 },   { "Po197",      1.9698565963e+02 },
        { "Po198",      1.97983388616e+02 },  { "Po199",      1.98983666063e+02 },  { "Po200",      1.99981798604e+02 },  { "Po201",      2.00982259764e+02 },
        { "Po202",      2.01980757541e+02 },  { "Po203",      2.02981420103e+02 },  { "Po204",      2.03980318121e+02 },  { "Po205",      2.04981203322e+02 },
        { "Po206",      2.05980481099e+02 },  { "Po207",      2.06981593173e+02 },  { "Po208",      2.07981245702e+02 },  { "Po209",      2.08982430435e+02 },
        { "Po210",      2.09982873673e+02 },  { "Po211",      2.10986653154e+02 },  { "Po212",      2.11988867969e+02 },  { "Po213",      2.1299285728e+02 },
        { "Po214",      2.1399520135e+02 },   { "Po215",      2.14999419988e+02 },  { "Po216",      2.16001915035e+02 },  { "Po217",      2.17006334796e+02 },
        { "Po218",      2.18008973037e+02 },  { "Po219",      2.19013744e+02 },     { "Po220",      2.20016602e+02 },     { "At_natural", 2.1e+02 },
        { "At193",      1.92999843112e+02 },  { "At194",      1.93998725085e+02 },  { "At195",      1.94996268098e+02 },  { "At196",      1.95995788077e+02 },
        { "At197",      1.96993189215e+02 },  { "At198",      1.97992837202e+02 },  { "At199",      1.98990532254e+02 },  { "At200",      1.99990351264e+02 },
        { "At201",      2.00988416999e+02 },  { "At202",      2.01988630236e+02 },  { "At203",      2.02986941984e+02 },  { "At204",      2.03987251326e+02 },
        { "At205",      2.04986074483e+02 },  { "At206",      2.05986667036e+02 },  { "At207",      2.06985783502e+02 },  { "At208",      2.07986589977e+02 },
        { "At209",      2.08986173143e+02 },  { "At210",      2.0998714771e+02 },   { "At211",      2.10987496271e+02 },  { "At212",      2.11990744771e+02 },
        { "At213",      2.12992936646e+02 },  { "At214",      2.13996371733e+02 },  { "At215",      2.1499865257e+02 },   { "At216",      2.16002423257e+02 },
        { "At217",      2.17004718822e+02 },  { "At218",      2.18008694336e+02 },  { "At219",      2.19011161691e+02 },  { "At220",      2.20015407682e+02 },
        { "At221",      2.2101805e+02 },      { "At222",      2.2202233e+02 },      { "At223",      2.2302519e+02 },      { "Rn_natural", 2.22e+02 },
        { "Rn195",      1.95005437696e+02 },  { "Rn196",      1.96002115223e+02 },  { "Rn197",      1.97001584351e+02 },  { "Rn198",      1.97998678663e+02 },
        { "Rn199",      1.98998370297e+02 },  { "Rn200",      1.999956993e+02 },    { "Rn201",      2.00995628335e+02 },  { "Rn202",      2.01993263492e+02 },
        { "Rn203",      2.02993386687e+02 },  { "Rn204",      2.0399142874e+02 },   { "Rn205",      2.04991718799e+02 },  { "Rn206",      2.05990214104e+02 },
        { "Rn207",      2.06990734225e+02 },  { "Rn208",      2.0798964247e+02 },   { "Rn209",      2.08990414742e+02 },  { "Rn210",      2.09989696216e+02 },
        { "Rn211",      2.10990600523e+02 },  { "Rn212",      2.11990703529e+02 },  { "Rn213",      2.12993882668e+02 },  { "Rn214",      2.13995362554e+02 },
        { "Rn215",      2.14998745483e+02 },  { "Rn216",      2.1600027437e+02 },   { "Rn217",      2.17003927675e+02 },  { "Rn218",      2.18005601256e+02 },
        { "Rn219",      2.19009480204e+02 },  { "Rn220",      2.20011393981e+02 },  { "Rn221",      2.21015536782e+02 },  { "Rn222",      2.22017577738e+02 },
        { "Rn223",      2.2302179e+02 },      { "Rn224",      2.2402409e+02 },      { "Rn225",      2.2502844e+02 },      { "Rn226",      2.2603089e+02 },
        { "Rn227",      2.27035407e+02 },     { "Rn228",      2.28037986e+02 },     { "Fr_natural", 2.23e+02 },           { "Fr199",      1.99007258147e+02 },
        { "Fr200",      2.0000657249e+02 },             { "Fr201",      2.01003860867e+02 },  { "Fr202",      2.02003372847e+02 },  { "Fr203",      2.03000924647e+02 },
        { "Fr204",      2.04000653204e+02 },  { "Fr205",      2.0499859396e+02 },   { "Fr206",      2.05998666066e+02 },  { "Fr207",      2.06996949414e+02 },
        { "Fr208",      2.07997138783e+02 },  { "Fr209",      2.08995953555e+02 },  { "Fr210",      2.09996407738e+02 },  { "Fr211",      2.10995536544e+02 },
        { "Fr212",      2.11996202244e+02 },  { "Fr213",      2.12996189081e+02 },  { "Fr214",      2.13998971145e+02 },  { "Fr215",      2.15000341497e+02 },
        { "Fr216",      2.1600319799e+02 },   { "Fr217",      2.17004631951e+02 },  { "Fr218",      2.18007578322e+02 },  { "Fr219",      2.19009252149e+02 },
        { "Fr220",      2.20012327405e+02 },  { "Fr221",      2.21014254762e+02 },  { "Fr222",      2.2201755173e+02 },   { "Fr223",      2.23019735857e+02 },
        { "Fr224",      2.24023249951e+02 },  { "Fr225",      2.25025565414e+02 },  { "Fr226",      2.26029386231e+02 },  { "Fr227",      2.27031835938e+02 },
        { "Fr228",      2.28035729e+02 },     { "Fr229",      2.29038450228e+02 },  { "Fr230",      2.3004251e+02 },      { "Fr231",      2.3104544e+02 },
        { "Fr232",      2.32049772e+02 },     { "Ra_natural", 2.26e+02 },           { "Ra202",      2.02009890686e+02 },  { "Ra203",      2.03009271619e+02 },
        { "Ra204",      2.04006499668e+02 },  { "Ra205",      2.0500626857e+02 },   { "Ra206",      2.0600382727e+02 },   { "Ra207",      2.07003798105e+02 },
        { "Ra208",      2.0800183994e+02 },   { "Ra209",      2.09001991373e+02 },  { "Ra210",      2.10000494978e+02 },  { "Ra211",      2.11000897987e+02 },
        { "Ra212",      2.11999794499e+02 },  { "Ra213",      2.13000383959e+02 },  { "Ra214",      2.14000107894e+02 },  { "Ra215",      2.15002719834e+02 },
        { "Ra216",      2.16003533035e+02 },  { "Ra217",      2.17006320327e+02 },  { "Ra218",      2.1800714023e+02 },   { "Ra219",      2.19010085078e+02 },
        { "Ra220",      2.20011028384e+02 },  { "Ra221",      2.21013917338e+02 },  { "Ra222",      2.2201537453e+02 },   { "Ra223",      2.23018502171e+02 },
        { "Ra224",      2.24020211821e+02 },  { "Ra225",      2.25023611564e+02 },  { "Ra226",      2.26025409823e+02 },  { "Ra227",      2.27029177842e+02 },
        { "Ra228",      2.28031070292e+02 },  { "Ra229",      2.29034957577e+02 },  { "Ra230",      2.30037056394e+02 },  { "Ra231",      2.3104122e+02 },
        { "Ra232",      2.32043638e+02 },     { "Ra233",      2.3304806e+02 },      { "Ra234",      2.34050704e+02 },     { "Ac_natural", 2.27e+02 },
        { "Ac206",      2.0601450498e+02 },   { "Ac207",      2.07011949748e+02 },  { "Ac208",      2.08011551551e+02 },  { "Ac209",      2.09009494863e+02 },
        { "Ac210",      2.10009435986e+02 },  { "Ac211",      2.11007734835e+02 },  { "Ac212",      2.12007813822e+02 },  { "Ac213",      2.13006607643e+02 },
        { "Ac214",      2.14006901798e+02 },  { "Ac215",      2.15006453625e+02 },  { "Ac216",      2.16008720075e+02 },  { "Ac217",      2.17009346914e+02 },
        { "Ac218",      2.18011641453e+02 },  { "Ac219",      2.19012420389e+02 },  { "Ac220",      2.20014762979e+02 },  { "Ac221",      2.21015591248e+02 },
        { "Ac222",      2.22017843851e+02 },  { "Ac223",      2.23019137468e+02 },  { "Ac224",      2.24021722866e+02 },  { "Ac225",      2.25023229585e+02 },
        { "Ac226",      2.26026098089e+02 },  { "Ac227",      2.27027752127e+02 },  { "Ac228",      2.28031021112e+02 },  { "Ac229",      2.29033015243e+02 },
        { "Ac230",      2.30036294178e+02 },  { "Ac231",      2.31038558786e+02 },  { "Ac232",      2.32042027438e+02 },  { "Ac233",      2.3304455e+02 },
        { "Ac234",      2.3404842e+02 },      { "Ac235",      2.35051232e+02 },     { "Ac236",      2.36055296e+02 },     { "Th_natural", 2.320381e+02 },
        { "Th209",      2.09017715682e+02 },  { "Th210",      2.10015075342e+02 },  { "Th211",      2.11014928413e+02 },  { "Th212",      2.12012980288e+02 },
        { "Th213",      2.1301301014e+02 },   { "Th214",      2.1401149977e+02 },   { "Th215",      2.1501173033e+02 },   { "Th216",      2.16011062115e+02 },
        { "Th217",      2.17013114328e+02 },  { "Th218",      2.18013284499e+02 },  { "Th219",      2.19015536895e+02 },  { "Th220",      2.20015747762e+02 },
        { "Th221",      2.21018183674e+02 },  { "Th222",      2.22018468121e+02 },  { "Th223",      2.23020811448e+02 },  { "Th224",      2.24021466895e+02 },
        { "Th225",      2.25023951021e+02 },  { "Th226",      2.26024903069e+02 },  { "Th227",      2.2702770407e+02 },   { "Th228",      2.28028741127e+02 },
        { "Th229",      2.2903176243e+02 },   { "Th230",      2.30033133843e+02 },  { "Th231",      2.31036304343e+02 },  { "Th232",      2.32038055325e+02 },
        { "Th233",      2.33041581843e+02 },  { "Th234",      2.3404360123e+02 },   { "Th235",      2.35047510074e+02 },  { "Th236",      2.3604987e+02 },
        { "Th237",      2.37053894e+02 },     { "Th238",      2.38056496e+02 },     { "Pa_natural", 2.31e+02 },           { "Pa212",      2.12023204138e+02 },
        { "Pa213",      2.1302110934e+02 },   { "Pa214",      2.14020918417e+02 },  { "Pa215",      2.15019185865e+02 },  { "Pa216",      2.16019109564e+02 },
        { "Pa217",      2.17018323986e+02 },  { "Pa218",      2.18020041889e+02 },  { "Pa219",      2.19019883143e+02 },  { "Pa220",      2.20021875303e+02 },
        { "Pa221",      2.21021877983e+02 },  { "Pa222",      2.22023742e+02 },     { "Pa223",      2.23023962273e+02 },  { "Pa224",      2.24025625738e+02 },
        { "Pa225",      2.25026130678e+02 },  { "Pa226",      2.26027947753e+02 },  { "Pa227",      2.27028805072e+02 },  { "Pa228",      2.28031051376e+02 },
        { "Pa229",      2.29032096793e+02 },  { "Pa230",      2.30034540754e+02 },  { "Pa231",      2.3103588399e+02 },   { "Pa232",      2.32038591592e+02 },
        { "Pa233",      2.33040247277e+02 },  { "Pa234",      2.34043308058e+02 },  { "Pa235",      2.35045443615e+02 },  { "Pa236",      2.36048681284e+02 },
        { "Pa237",      2.37051145659e+02 },  { "Pa238",      2.3805450271e+02 },   { "Pa239",      2.3905726e+02 },      { "Pa240",      2.4006098e+02 },
        { "U_natural",  2.38029e+02 },        { "U217",       2.17024368791e+02 },  { "U218",       2.18023535671e+02 },  { "U219",       2.1902491916e+02 },
        { "U220",       2.20024723e+02 },     { "U221",       2.21026399e+02 },     { "U222",       2.22026086e+02 },     { "U223",       2.230277386e+02 },
        { "U224",       2.24027604778e+02 },  { "U225",       2.25029390717e+02 },  { "U226",       2.26029338702e+02 },  { "U227",       2.27031156367e+02 },
        { "U228",       2.28031374006e+02 },  { "U229",       2.29033505939e+02 },  { "U230",       2.30033939784e+02 },  { "U231",       2.31036293704e+02 },
        { "U232",       2.32037156152e+02 },  { "U233",       2.33039635207e+02 },  { "U234",       2.34040952088e+02 },  { "U235",       2.35043929918e+02 },
        { "U236",       2.36045568006e+02 },  { "U237",       2.37048730184e+02 },  { "U238",       2.38050788247e+02 },  { "U239",       2.39054293299e+02 },
        { "U240",       2.40056591988e+02 },  { "U241",       2.4106033e+02 },      { "U242",       2.42062931e+02 },     { "Np_natural", 2.37e+02 },
        { "Np225",      2.25033913933e+02 },  { "Np226",      2.26035145e+02 },     { "Np227",      2.27034956789e+02 },  { "Np228",      2.2803618e+02 },
        { "Np229",      2.29036263808e+02 },  { "Np230",      2.30037827597e+02 },  { "Np231",      2.31038245085e+02 },  { "Np232",      2.32040108e+02 },
        { "Np233",      2.33040740546e+02 },  { "Np234",      2.34042895038e+02 },  { "Np235",      2.35044063267e+02 },  { "Np236",      2.360465696e+02 },
        { "Np237",      2.37048173444e+02 },  { "Np238",      2.38050946405e+02 },  { "Np239",      2.39052939025e+02 },  { "Np240",      2.40056162182e+02 },
        { "Np241",      2.41058252431e+02 },  { "Np242",      2.4206164118e+02 },   { "Np243",      2.43064279e+02 },     { "Np244",      2.4406785e+02 },
        { "Pu_natural", 2.44e+02 },           { "Pu228",      2.28038742328e+02 },  { "Pu229",      2.29040150212e+02 },  { "Pu230",      2.30039649886e+02 },
        { "Pu231",      2.31041101107e+02 },  { "Pu232",      2.32041187097e+02 },  { "Pu233",      2.33042997375e+02 },  { "Pu234",      2.34043317076e+02 },
        { "Pu235",      2.3504528605e+02 },   { "Pu236",      2.36046057964e+02 },  { "Pu237",      2.37048409658e+02 },  { "Pu238",      2.38049559894e+02 },
        { "Pu239",      2.39052163381e+02 },  { "Pu240",      2.40053813545e+02 },  { "Pu241",      2.41056851456e+02 },  { "Pu242",      2.42058742611e+02 },
        { "Pu243",      2.43062003092e+02 },  { "Pu244",      2.44064203907e+02 },  { "Pu245",      2.45067747154e+02 },  { "Pu246",      2.46070204627e+02 },
        { "Pu247",      2.4707407e+02 },      { "Am_natural", 2.43e+02 },           { "Am231",      2.3104556e+02 },      { "Am232",      2.3204659e+02 },
        { "Am233",      2.33046348e+02 },     { "Am234",      2.34047809e+02 },     { "Am235",      2.35047946e+02 },     { "Am236",      2.36049579e+02 },
        { "Am237",      2.37049996e+02 },     { "Am238",      2.38051984324e+02 },  { "Am239",      2.39053024479e+02 },  { "Am240",      2.40055300179e+02 },
        { "Am241",      2.41056829144e+02 },  { "Am242",      Am242_Mass },         { "Am243",      2.4306138108e+02 },   { "Am244",      Am244_Mass },
        { "Am245",      2.45066452114e+02 },  { "Am246",      2.46069774619e+02 },  { "Am247",      2.47072093e+02 },     { "Am248",      2.48075752e+02 },
        { "Am249",      2.4907848e+02 },      { "Cm_natural", 2.47e+02 },           { "Cm233",      2.33050771232e+02 },  { "Cm234",      2.34050159841e+02 },
        { "Cm235",      2.35051434e+02 },     { "Cm236",      2.36051413e+02 },     { "Cm237",      2.37052901e+02 },     { "Cm238",      2.38053028697e+02 },
        { "Cm239",      2.39054957e+02 },     { "Cm240",      2.40055529539e+02 },  { "Cm241",      2.41057653001e+02 },  { "Cm242",      2.42058835824e+02 },
        { "Cm243",      2.43061389114e+02 },  { "Cm244",      2.44062752578e+02 },  { "Cm245",      2.45065491249e+02 },  { "Cm246",      2.46067223662e+02 },
        { "Cm247",      2.4707035354e+02 },   { "Cm248",      2.48072348508e+02 },  { "Cm249",      2.49075953413e+02 },  { "Cm250",      2.50078356959e+02 },
        { "Cm251",      2.51082284605e+02 },  { "Cm252",      2.5208487e+02 },      { "Bk_natural", 2.47e+02 },           { "Bk235",      2.3505658e+02 },
        { "Bk236",      2.3605733e+02 },      { "Bk237",      2.37057003e+02 },     { "Bk238",      2.38058281e+02 },     { "Bk239",      2.39058279e+02 },
        { "Bk240",      2.40059759e+02 },     { "Bk241",      2.4106023e+02 },      { "Bk242",      2.42061981e+02 },     { "Bk243",      2.43063007572e+02 },
        { "Bk244",      2.44065180774e+02 },  { "Bk245",      2.45066361616e+02 },  { "Bk246",      2.46068672947e+02 },  { "Bk247",      2.4707030708e+02 },
        { "Bk248",      2.48073086e+02 },     { "Bk249",      2.49074986657e+02 },  { "Bk250",      2.5007831652e+02 },   { "Bk251",      2.51080760172e+02 },
        { "Bk252",      2.5208431e+02 },      { "Bk253",      2.5308688e+02 },      { "Bk254",      2.540906e+02 },       { "Cf_natural", 2.51e+02 },
        { "Cf237",      2.3706207e+02 },      { "Cf238",      2.3806141e+02 },      { "Cf239",      2.39062422e+02 },     { "Cf240",      2.40062302e+02 },
        { "Cf241",      2.41063726e+02 },     { "Cf242",      2.42063701552e+02 },  { "Cf243",      2.43065427e+02 },     { "Cf244",      2.44066000689e+02 },
        { "Cf245",      2.45068048612e+02 },  { "Cf246",      2.46068805309e+02 },  { "Cf247",      2.47071000589e+02 },  { "Cf248",      2.48072184861e+02 },
        { "Cf249",      2.49074853537e+02 },  { "Cf250",      2.50076406066e+02 },  { "Cf251",      2.51079586788e+02 },  { "Cf252",      2.52081625846e+02 },
        { "Cf253",      2.53085133145e+02 },  { "Cf254",      2.54087322909e+02 },  { "Cf255",      2.55091046e+02 },     { "Cf256",      2.5609344e+02 },
        { "Es_natural", 2.52e+02 },           { "Es120",      1.175e+02 },          { "Es121",      1.16546e+02 },        { "Es122",      1.18544e+02 },
        { "Es125",      1.175e+02 },          { "Es240",      2.4006892e+02 },      { "Es241",      2.41068538e+02 },     { "Es242",      2.42069745e+02 },
        { "Es243",      2.43069548e+02 },     { "Es244",      2.44070883e+02 },     { "Es245",      2.45071324e+02 },     { "Es246",      2.46072896e+02 },
        { "Es247",      2.47073656e+02 },     { "Es248",      2.48075471e+02 },     { "Es249",      2.49076411e+02 },     { "Es250",      2.50078612e+02 },
        { "Es251",      2.51079992142e+02 },  { "Es252",      2.52082978512e+02 },  { "Es253",      2.53084824697e+02 },  { "Es254",      Es254_Mass },
        { "Es255",      2.55090273122e+02 },  { "Es256",      2.56093598e+02 },     { "Es257",      2.57095979e+02 },     { "Es258",      2.5809952e+02 },
        { "Fm_natural", 2.57e+02 },           { "Fm242",      2.4207343e+02 },      { "Fm243",      2.43074353e+02 },     { "Fm244",      2.44074084e+02 },
        { "Fm245",      2.45075385e+02 },     { "Fm246",      2.46075299023e+02 },  { "Fm247",      2.47076847e+02 },     { "Fm248",      2.48077194714e+02 },
        { "Fm249",      2.49079034e+02 },     { "Fm250",      2.50079521264e+02 },  { "Fm251",      2.51081575017e+02 },  { "Fm252",      2.52082466855e+02 },
        { "Fm253",      2.53085185236e+02 },  { "Fm254",      2.5408685422e+02 },   { "Fm255",      2.55089962202e+02 },  { "Fm256",      2.56091773117e+02 },
        { "Fm257",      2.57095104724e+02 },  { "Fm258",      2.58097076e+02 },     { "Fm259",      2.59100595e+02 },     { "Fm260",      2.60102678e+02 },
        { "Md_natural", 2.58e+02 },           { "Md245",      2.45080829e+02 },     { "Md246",      2.46081886e+02 },     { "Md247",      2.47081635e+02 },
        { "Md248",      2.48082823e+02 },     { "Md249",      2.49083013e+02 },     { "Md250",      2.5008442e+02 },      { "Md251",      2.51084839e+02 },
        { "Md252",      2.5208656e+02 },      { "Md253",      2.5308728e+02 },      { "Md254",      2.54089656e+02 },     { "Md255",      2.55091082705e+02 },
        { "Md256",      2.56094059025e+02 },  { "Md257",      2.57095541368e+02 },  { "Md258",      2.58098431319e+02 },  { "Md259",      2.59100509e+02 },
        { "Md260",      2.60103652e+02 },     { "Md261",      2.61105721e+02 },     { "Md262",      2.62108865e+02 },     { "No_natural", 2.59e+02 },
        { "No248",      2.48086596e+02 },     { "No249",      2.49087833e+02 },     { "No250",      2.5008751e+02 },      { "No251",      2.51089012e+02 },
        { "No252",      2.52088976521e+02 },  { "No253",      2.53090678e+02 },     { "No254",      2.54090955253e+02 },  { "No255",      2.55093241131e+02 },
        { "No256",      2.56094282666e+02 },  { "No257",      2.5709687719e+02 },   { "No258",      2.58098207e+02 },     { "No259",      2.59101031e+02 },
        { "No260",      2.60102643e+02 },     { "No261",      2.61105749e+02 },     { "No262",      2.62107301e+02 },     { "No263",      2.63110552e+02 },
        { "No264",      2.64112345e+02 },     { "Lr_natural", 2.6e+02 },            { "Lr251",      2.5109436e+02 },      { "Lr252",      2.52095371e+02 },
        { "Lr253",      2.5309521e+02 },      { "Lr254",      2.54096454e+02 },     { "Lr255",      2.55096681e+02 },     { "Lr256",      2.56098629e+02 },
        { "Lr257",      2.57099555e+02 },     { "Lr258",      2.58101814e+02 },     { "Lr259",      2.59102901e+02 },     { "Lr260",      2.60105504e+02 },
        { "Lr261",      2.61106883e+02 },     { "Lr262",      2.62109634e+02 },     { "Lr263",      2.63111293e+02 },     { "Lr264",      2.64114038e+02 },
        { "Lr265",      2.65115839e+02 },     { "Lr266",      2.66119305e+02 },     { "Rf_natural", 2.61e+02 },           { "Rf253",      2.53100689e+02 },
        { "Rf254",      2.54100184e+02 },     { "Rf255",      2.5510134e+02 },      { "Rf256",      2.56101166194e+02 },  { "Rf257",      2.5710299e+02 },
        { "Rf258",      2.58103489e+02 },     { "Rf259",      2.59105637e+02 },     { "Rf260",      2.6010644e+02 },      { "Rf261",      2.61108766556e+02 },
        { "Rf262",      2.62109925e+02 },     { "Rf263",      2.63112547e+02 },     { "Rf264",      2.64113985e+02 },     { "Rf265",      2.65116704e+02 },
        { "Rf266",      2.66117956e+02 },     { "Rf267",      2.67121529e+02 },     { "Rf268",      2.68123644e+02 },     { "Db_natural", 2.62e+02 },
        { "Db255",      2.55107398e+02 },     { "Db256",      2.56108127e+02 },     { "Db257",      2.57107722e+02 },     { "Db258",      2.58109231e+02 },
        { "Db259",      2.5910961e+02 },      { "Db260",      2.601113e+02 },       { "Db261",      2.61112056e+02 },     { "Db262",      2.62114084e+02 },
        { "Db263",      2.63114988e+02 },     { "Db264",      2.64117404e+02 },     { "Db265",      2.65118601e+02 },     { "Db266",      2.66121029e+02 },
        { "Db267",      2.67122377e+02 },     { "Db268",      2.68125445e+02 },     { "Db269",      2.6912746e+02 },      { "Db270",      2.70130712e+02 },
        { "Sg_natural", 2.63e+02 },           { "Sg258",      2.58113168e+02 },     { "Sg259",      2.591145e+02 },       { "Sg260",      2.60114422071e+02 },
        { "Sg261",      2.61116117e+02 },     { "Sg262",      2.62116398e+02 },     { "Sg263",      2.63118322e+02 },     { "Sg264",      2.64118931e+02 },
        { "Sg265",      2.65121114693e+02 },  { "Sg266",      2.66122065e+02 },     { "Sg267",      2.67124425e+02 },     { "Sg268",      2.68125606e+02 },
        { "Sg269",      2.69128755e+02 },     { "Sg270",      2.70130329e+02 },     { "Sg271",      2.71133472e+02 },     { "Sg272",      2.72135158e+02 },
        { "Sg273",      2.7313822e+02 },      { "Bh260",      2.6012197e+02 },      { "Bh261",      2.61121664e+02 },     { "Bh262",      2.62122892e+02 },
        { "Bh263",      2.63123035e+02 },     { "Bh264",      2.64124604e+02 },     { "Bh265",      2.65125147e+02 },     { "Bh266",      2.66126942e+02 },
        { "Bh267",      2.6712765e+02 },      { "Bh268",      2.68129755e+02 },     { "Bh269",      2.69130694e+02 },     { "Bh270",      2.70133616e+02 },
        { "Bh271",      2.71135179e+02 },     { "Bh272",      2.72138032e+02 },     { "Bh273",      2.73139618e+02 },     { "Bh274",      2.7414244e+02 },
        { "Bh275",      2.7514425e+02 },      { "Hs263",      2.63128558e+02 },     { "Hs264",      2.64128394885e+02 },  { "Hs265",      2.65130085e+02 },
        { "Hs266",      2.66130097e+02 },     { "Hs267",      2.67131789e+02 },     { "Hs268",      2.68132162e+02 },     { "Hs269",      2.69134056e+02 },
        { "Hs270",      2.7013465e+02 },      { "Hs271",      2.71137657e+02 },     { "Hs272",      2.72139052e+02 },     { "Hs273",      2.73141986e+02 },
        { "Hs274",      2.74143131e+02 },     { "Hs275",      2.75145952e+02 },     { "Hs276",      2.76147208e+02 },     { "Hs277",      2.77149841e+02 },
        { "Mt265",      2.65136151e+02 },     { "Mt266",      2.66137299e+02 },     { "Mt267",      2.67137307e+02 },     { "Mt268",      2.68138728e+02 },
        { "Mt269",      2.69139055e+02 },     { "Mt270",      2.70140657e+02 },     { "Mt271",      2.71141139e+02 },     { "Mt272",      2.72143738e+02 },
        { "Mt273",      2.73144913e+02 },     { "Mt274",      2.74147492e+02 },     { "Mt275",      2.75148647e+02 },     { "Mt276",      2.76151156e+02 },
        { "Mt277",      2.7715242e+02 },      { "Mt278",      2.78154812e+02 },     { "Mt279",      2.79156193e+02 },     { "Uun267",     2.67144341e+02 },
        { "Uun268",     2.68143795e+02 },     { "Uun269",     2.69145124e+02 },     { "Uun270",     2.7014472e+02 },      { "Uun271",     2.71146062e+02 },
        { "Uun272",     2.72146317e+02 },     { "Uun273",     2.73148863e+02 },     { "Uun274",     2.74149492e+02 },     { "Uun275",     2.75152176e+02 },
        { "Uun276",     2.76153034e+02 },     { "Uun277",     2.77155647e+02 },     { "Uun278",     2.78156469e+02 },     { "Uun279",     2.79158861e+02 },
        { "Uun280",     2.80159795e+02 },     { "Uun281",     2.81162061e+02 },     { "Uuu272",     2.72153615e+02 },     { "Uuu273",     2.73153682e+02 },
        { "Uuu274",     2.74155713e+02 },     { "Uuu275",     2.75156142e+02 },     { "Uuu276",     2.76158493e+02 },     { "Uuu277",     2.77159519e+02 },
        { "Uuu278",     2.78161604e+02 },     { "Uuu279",     2.79162468e+02 },     { "Uuu280",     2.80164473e+02 },     { "Uuu281",     2.81165372e+02 },
        { "Uuu282",     2.82167486e+02 },     { "Uuu283",     2.83168415e+02 },     { "Uub277",     2.77163943e+02 },     { "Uub278",     2.78164312e+02 },
        { "Uub279",     2.79166546e+02 },     { "Uub280",     2.80167039e+02 },     { "Uub281",     2.81169286e+02 },     { "Uub282",     2.82169765e+02 },
        { "Uub283",     2.83171792e+02 },     { "Uub284",     2.84172384e+02 },     { "Uub285",     2.85174105e+02 },     { "Uut283",     2.83176451e+02 },
        { "Uut284",     2.8417808e+02 },      { "Uut285",     2.85178732e+02 },     { "Uut286",     2.86180481e+02 },     { "Uut287",     2.87181045e+02 },
        { "Uuq285",     2.85183698e+02 },     { "Uuq286",     2.86183855e+02 },     { "Uuq287",     2.87185599e+02 },     { "Uuq288",     2.88185689e+02 },
        { "Uuq289",     2.89187279e+02 },     { "Uup287",     2.87191186e+02 },     { "Uup288",     2.88192492e+02 },     { "Uup289",     2.89192715e+02 },
        { "Uup290",     2.90194141e+02 },     { "Uup291",     2.91194384e+02 },     { "Uuh289",     2.89198862e+02 },     { "Uuh290",     2.9019859e+02 },
        { "Uuh291",     2.91200011e+02 },     { "Uuh292",     2.92199786e+02 },     { "Uus291",     2.91206564e+02 },     { "Uus292",     2.92207549e+02 },
        { "Uuo293",     2.9321467e+02 } };
/*
========================================================================
*/
double PoPs_particleMass_AMU( statusMessageReporting *smr, const char *name ) {

    int i, n = sizeof( ZAMasses ) / sizeof( ZAMasses[0] );
    double mass = -1.;

    for( i = 0; i < n; i++ ) {
        if( !strcmp( ZAMasses[i].symbol, name ) ) {
            mass = ZAMasses[i].mass;
            break;
        }
    }
    if( mass == -1. ) smr_setReportError2( smr, smr_unknownID, 1, "particle %s not in mass table", name );
    return( mass );
}

#if defined __cplusplus
}
#endif
