// The initial version of this file was autogenerated from the official AS3 reference at
// https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/AccelerometerEvent.html
// by https://github.com/golfinq/ActionScript_Event_Builder
// It won't be regenerated in the future, so feel free to edit and/or fix
package flash.events
{

    public class AccelerometerEvent extends Event
    {
        // Defines the value of the type property of a AccelerometerEvent event object.
        public static const UPDATE:String = "update";

        // The number of milliseconds at the time of the event since the runtime was initialized.
        public var timestamp:Number;

        // Acceleration along the x-axis, measured in Gs.
        public var accelerationX:Number;

        // Acceleration along the y-axis, measured in Gs.
        public var accelerationY:Number;
        
        // Acceleration along the z-axis, measured in Gs.
        public var accelerationZ:Number;

        public function AccelerometerEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, timestamp:Number = 0,
            accelerationX:Number = 0, accelerationY:Number = 0, accelerationZ:Number = 0)
        {
            super(type, bubbles, cancelable);
            this.timestamp = timestamp;
            this.accelerationX = accelerationX;
            this.accelerationY = accelerationY;
            this.accelerationZ = accelerationZ;
        }

        // Creates a copy of an AccelerometerEvent object and sets the value of each property to match that of the original.
        override public function clone():Event
        {
            return new AccelerometerEvent(this.type, this.bubbles, this.cancelable, this.timestamp, this.accelerationX, this.accelerationY, this.accelerationZ);
        }

        // Returns a string that contains all the properties of the AccelerometerEvent object.
        override public function toString():String
        {
            return this.formatToString("AccelerometerEvent", "type", "bubbles", "cancelable", "eventPhase", "timestamp", "accelerationX", "accelerationY", "accelerationZ");
        }
    }
}



