#!/usr/bin/env python

import os
import sys
import unicodedata


if sys.hexversion >= 0x3000000:
    # noinspection PyShadowingBuiltins
    unichr = chr

CHARACTER_COUNT = 65536
CHARACTER_PER_LINE = 128
CHARACTER_PER_BYTE = 8

self_path = os.path.dirname(os.path.abspath(__file__)) + os.sep
output_path = self_path + os.pardir + os.sep + os.pardir + os.sep + 'src/gamedata/fonts/myiswalpha.h'

with open(output_path, 'w') as f:
    version = '%i.%i.%i' % (sys.version_info.major, sys.version_info.minor, sys.version_info.micro)
    f.write('''// Generated by Python %s

#pragma once

static const uint8_t MYISWALPHA_DATA[] =
{
''' % version)

    for i in range(0, CHARACTER_COUNT, CHARACTER_PER_LINE):
        s = ''

        for j in range(0, CHARACTER_PER_LINE, CHARACTER_PER_BYTE):
            b = 0

            for k in range(CHARACTER_PER_BYTE):
                # noinspection PyUnboundLocalVariable
                category = unicodedata.category(unichr(i + j + k))

                if category[0] == 'L':
                    b |= 1 << k

            s += '0x%02X, ' % b

        s += '// %04X..%04X\n' % (i, i + CHARACTER_PER_LINE - 1)
        f.write(s)

    f.write('''};

inline int myiswalpha(wint_t ch)
{
    return MYISWALPHA_DATA[ch / 8] & (1 << (ch & 7));
}
''')
