/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Leg {
    /// Transport mode for this leg
    #[serde(rename = "mode")]
    pub mode: models::Mode,
    #[serde(rename = "from")]
    pub from: Box<models::Place>,
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// Leg duration in seconds  If leg is footpath:   The footpath duration is derived from the default footpath   duration using the query parameters `transferTimeFactor` and   `additionalTransferTime` as follows:   `leg.duration = defaultDuration * transferTimeFactor + additionalTransferTime.`   In case the defaultDuration is needed, it can be calculated by   `defaultDuration = (leg.duration - additionalTransferTime) / transferTimeFactor`.   Note that the default values are `transferTimeFactor = 1` and   `additionalTransferTime = 0` in case they are not explicitly   provided in the query. 
    #[serde(rename = "duration")]
    pub duration: i32,
    /// leg departure time
    #[serde(rename = "startTime")]
    pub start_time: String,
    /// leg arrival time
    #[serde(rename = "endTime")]
    pub end_time: String,
    /// scheduled leg departure time
    #[serde(rename = "scheduledStartTime")]
    pub scheduled_start_time: String,
    /// scheduled leg arrival time
    #[serde(rename = "scheduledEndTime")]
    pub scheduled_end_time: String,
    /// Whether there is real-time data about this leg
    #[serde(rename = "realTime")]
    pub real_time: bool,
    /// For non-transit legs the distance traveled while traversing this leg in meters.
    #[serde(rename = "distance", skip_serializing_if = "Option::is_none")]
    pub distance: Option<f64>,
    /// For transit legs, if the rider should stay on the vehicle as it changes route names.
    #[serde(rename = "interlineWithPreviousLeg", skip_serializing_if = "Option::is_none")]
    pub interline_with_previous_leg: Option<bool>,
    /// For transit legs, the headsign of the bus or train being used. For non-transit legs, null 
    #[serde(rename = "headsign", skip_serializing_if = "Option::is_none")]
    pub headsign: Option<String>,
    #[serde(rename = "routeColor", skip_serializing_if = "Option::is_none")]
    pub route_color: Option<String>,
    #[serde(rename = "routeTextColor", skip_serializing_if = "Option::is_none")]
    pub route_text_color: Option<String>,
    #[serde(rename = "routeType", skip_serializing_if = "Option::is_none")]
    pub route_type: Option<String>,
    #[serde(rename = "agencyName", skip_serializing_if = "Option::is_none")]
    pub agency_name: Option<String>,
    #[serde(rename = "agencyUrl", skip_serializing_if = "Option::is_none")]
    pub agency_url: Option<String>,
    #[serde(rename = "agencyId", skip_serializing_if = "Option::is_none")]
    pub agency_id: Option<String>,
    #[serde(rename = "tripId", skip_serializing_if = "Option::is_none")]
    pub trip_id: Option<String>,
    #[serde(rename = "routeShortName", skip_serializing_if = "Option::is_none")]
    pub route_short_name: Option<String>,
    /// Filename and line number where this trip is from
    #[serde(rename = "source", skip_serializing_if = "Option::is_none")]
    pub source: Option<String>,
    /// For transit legs, intermediate stops between the Place where the leg originates and the Place where the leg ends. For non-transit legs, null. 
    #[serde(rename = "intermediateStops", skip_serializing_if = "Option::is_none")]
    pub intermediate_stops: Option<Vec<models::Place>>,
    #[serde(rename = "legGeometry")]
    pub leg_geometry: Box<models::EncodedPolyline>,
    /// A series of turn by turn instructions used for walking, biking and driving. 
    #[serde(rename = "steps", skip_serializing_if = "Option::is_none")]
    pub steps: Option<Vec<models::StepInstruction>>,
    #[serde(rename = "rental", skip_serializing_if = "Option::is_none")]
    pub rental: Option<Box<models::Rental>>,
}

impl Leg {
    pub fn new(mode: models::Mode, from: models::Place, to: models::Place, duration: i32, start_time: String, end_time: String, scheduled_start_time: String, scheduled_end_time: String, real_time: bool, leg_geometry: models::EncodedPolyline) -> Leg {
        Leg {
            mode,
            from: Box::new(from),
            to: Box::new(to),
            duration,
            start_time,
            end_time,
            scheduled_start_time,
            scheduled_end_time,
            real_time,
            distance: None,
            interline_with_previous_leg: None,
            headsign: None,
            route_color: None,
            route_text_color: None,
            route_type: None,
            agency_name: None,
            agency_url: None,
            agency_id: None,
            trip_id: None,
            route_short_name: None,
            source: None,
            intermediate_stops: None,
            leg_geometry: Box::new(leg_geometry),
            steps: None,
            rental: None,
        }
    }
}

