/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import martin.tempest.gui.scale.LogScale;

public class AutoScaleVisualizer
extends JPanel {
    private static final double FONT_SPACING_COEFF = 1.5;
    private static final double LOWEST_DB = -50.7;
    private static final double HIGHEST_DB = 0.6;
    private static final double FONT_SIZE_COEFF = 0.8;
    private static final long serialVersionUID = 6629300250729955406L;
    private int nwidth = 1;
    private int nheight = 1;
    private int fontsize = 12;
    private volatile double min = 0.0;
    private volatile double max = 0.0;
    private volatile double span = 1.0;
    private boolean font_set = false;
    private Font font;
    private static final Color background = new Color(150, 170, 130);
    private static final Color default_txt_colour_background = Color.DARK_GRAY;
    private static final Color[] colour_map = new Color[256];
    private final LogScale scale_y;
    private final Object locker;

    public AutoScaleVisualizer() {
        for (int i = 0; i < 256; ++i) {
            AutoScaleVisualizer.colour_map[i] = new Color(i, i, i);
        }
        this.scale_y = new LogScale(default_txt_colour_background, 1.5, -50.7, 0.6);
        this.locker = new Object();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.nwidth = n3;
        this.nheight = n4;
        this.scale_y.setDimentions(this.nwidth, this.nheight);
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.nwidth = rectangle.width;
        this.nheight = rectangle.height;
        this.scale_y.setDimentions(this.nwidth, this.nheight);
        super.setBounds(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(double d, double d2) {
        Object object = this.locker;
        synchronized (object) {
            this.min = d;
            this.max = d2;
            this.span = d2 - d;
        }
        this.repaint();
    }

    private int pxtocol(int n) {
        double d = this.scale_y.pxtoval(n);
        int n2 = (int)(255.0 * (d - this.min) / this.span);
        return n2 < 0 ? 0 : (n2 > 255 ? 255 : n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Object object = this.locker;
        synchronized (object) {
            int n;
            int n2 = this.nwidth;
            int n3 = this.nheight;
            int n4 = this.scale_y.valtopx(this.min);
            int n5 = this.scale_y.valtopx(this.max);
            if (!this.font_set) {
                Font font = graphics.getFont();
                this.font = new Font(font.getFontName(), 0, (int)((double)font.getSize() * 0.8));
                graphics.setFont(this.font);
                this.font_set = true;
                this.fontsize = graphics.getFont().getSize();
            } else {
                graphics.setFont(this.font);
            }
            graphics.setColor(background);
            graphics.fillRect(0, 0, n2, n3);
            this.scale_y.paintScale(graphics);
            int n6 = Math.min(n4, this.nheight);
            int n7 = n = n5 < 0 ? 0 : n5;
            while (n < n6) {
                graphics.setColor(colour_map[this.pxtocol(n)]);
                graphics.drawLine(0, n, this.nwidth, n);
                ++n;
            }
            if (this.min >= this.scale_y.getLowestValue() && this.min <= this.scale_y.getHighestValue()) {
                double d = this.scale_y.valtodb(this.min);
                graphics.setColor(Color.lightGray);
                graphics.drawString(String.format("%.2f", d), 0, n4 - this.fontsize / 2);
            }
            if (this.max >= this.scale_y.getLowestValue() && this.max <= this.scale_y.getHighestValue()) {
                double d = this.scale_y.valtodb(this.max);
                graphics.setColor(Color.DARK_GRAY);
                graphics.drawString(String.format("%.1f", d), 0, n5 + this.fontsize);
            }
        }
    }
}

