# How to contribute to tmux-xpanes

First off, thanks for taking the time to contribute! :smile:

### Did you find a bug?

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/greymd/tmux-xpanes/issues).
  * Refer to [wiki > Known Bugs](https://github.com/greymd/tmux-xpanes/wiki/Known-Bugs) as well.
* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/greymd/tmux-xpanes/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

### Did you write a patch that fixes a bug, or make a purely cosmetic patch?

* Please run [testing](https://github.com/greymd/tmux-xpanes#testing) in advance.
  * It is **better** to ensure smoke tests are passed on your local environment before sending a pull request.
* Open a new pull request with the patch.
* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

### Do you intend to add a new feature or change an existing one?

* Open an issue to suggest your change.
* Collect positive feedback about the change and start writing code.

### Do you have questions about the source code?

* Open an issue to ask your question.

### Do you want to contribute to the documentation?

#### Markdown

* Open a new pull request with the change.

#### Wiki

* Please refer to [wiki](https://github.com/greymd/tmux-xpanes/wiki).

* * *
This document is created with reference to [rails/CONTRIBUTING](https://github.com/rails/rails/blob/master/CONTRIBUTING.md)
