/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Distributions {
    protected Distributions() {
        throw new RuntimeException("Non instantiable");
    }

    public static double geometricPdf(int n, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return d2 * Math.pow(1.0 - d2, n);
    }

    public static double nextBurr1(double d2, int n, RandomElement randomElement) {
        double d3 = Math.exp(Math.log(randomElement.raw()) / d2);
        switch (n) {
            case 2: {
                return -Math.log(1.0 / d3 - 1.0);
            }
            case 7: {
                return Math.log(2.0 * d3 / (2.0 - 2.0 * d3)) / 2.0;
            }
            case 8: {
                return Math.log(Math.tan(d3 * Math.PI / 2.0));
            }
            case 10: {
                return Math.sqrt(-Math.log(1.0 - d3));
            }
        }
        return 0.0;
    }

    public static double nextBurr2(double d2, double d3, int n, RandomElement randomElement) {
        double d4 = randomElement.raw();
        double d5 = Math.exp(-Math.log(d4) / d2) - 1.0;
        switch (n) {
            case 3: {
                return Math.exp(-Math.log(d5) / d3);
            }
            case 4: {
                d5 = Math.exp(d3 * Math.log(d5)) + 1.0;
                d5 = d3 / d5;
                return d5;
            }
            case 5: {
                d5 = Math.atan(-Math.log(d5 / d3));
                return d5;
            }
            case 6: {
                d5 = -Math.log(d5 / d3) / d2;
                d5 = Math.log(d5 + Math.sqrt(d5 * d5 + 1.0));
                return d5;
            }
            case 9: {
                d5 = 1.0 + 2.0 * d4 / (d3 * (1.0 - d4));
                d5 = Math.exp(Math.log(d5) / d2) - 1.0;
                return Math.log(d5);
            }
            case 12: {
                return Math.exp(Math.log(d5) / d3);
            }
        }
        return 0.0;
    }

    public static double nextCauchy(RandomElement randomElement) {
        return Math.tan(Math.PI * randomElement.raw());
    }

    public static double nextErlang(double d2, double d3, RandomElement randomElement) {
        int n = (int)(d3 * d3 / d2 + 0.5);
        n = n > 0 ? n : 1;
        double d4 = (double)n / d3;
        double d5 = 1.0;
        int n2 = 0;
        while (n2 < n) {
            d5 *= randomElement.raw();
            ++n2;
        }
        return -Math.log(d5) / d4;
    }

    public static int nextGeometric(double d2, RandomElement randomElement) {
        double d3 = randomElement.raw();
        return (int)(Math.log(d3) / Math.log(1.0 - d2));
    }

    public static double nextLambda(double d2, double d3, RandomElement randomElement) {
        double d4 = d2 < 0.0 || d3 < 0.0 ? -1.0 : 1.0;
        double d5 = randomElement.raw();
        double d6 = d4 * (Math.exp(Math.log(d5) * d2) - Math.exp(Math.log(1.0 - d5) * d3));
        return d6;
    }

    public static double nextLaplace(RandomElement randomElement) {
        double d2 = randomElement.raw();
        if ((d2 = d2 + d2 - 1.0) > 0.0) {
            return -Math.log(1.0 - d2);
        }
        return Math.log(1.0 + d2);
    }

    public static double nextLogistic(RandomElement randomElement) {
        double d2 = randomElement.raw();
        return -Math.log(1.0 / d2 - 1.0);
    }

    public static double nextPowLaw(double d2, double d3, RandomElement randomElement) {
        return randomElement.powlaw(d2, d3);
    }

    public static double nextTriangular(RandomElement randomElement) {
        double d2 = randomElement.raw();
        if (d2 <= 0.5) {
            return Math.sqrt(2.0 * d2) - 1.0;
        }
        return 1.0 - Math.sqrt(2.0 * (1.0 - d2));
    }

    public static double nextWeibull(double d2, double d3, RandomElement randomElement) {
        return Math.pow(d3 * -Math.log(1.0 - randomElement.raw()), 1.0 / d2);
    }

    public static int nextZipfInt(double d2, RandomElement randomElement) {
        double d3;
        double d4;
        double d5;
        double d6 = Math.pow(2.0, d2 - 1.0);
        double d7 = -1.0 / (d2 - 1.0);
        int n = 0;
        do {
            d4 = randomElement.raw();
        } while (!((d5 = randomElement.raw()) * (double)(n = (int)Math.floor(Math.pow(d4, d7))) * ((d3 = Math.pow(1.0 + 1.0 / (double)n, d2 - 1.0)) - 1.0) / (d6 - 1.0) <= d3 / d6));
        return n;
    }
}

