/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class VonMises
extends AbstractContinousDistribution {
    protected double my_k;
    private double k_set = -1.0;
    private double tau;
    private double rho;
    private double r;
    protected static VonMises shared = new VonMises(1.0, AbstractDistribution.makeDefaultGenerator());

    public VonMises(double d2, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.my_k);
    }

    public double nextDouble(double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.k_set != d2) {
            this.tau = 1.0 + Math.sqrt(1.0 + 4.0 * d2 * d2);
            this.rho = (this.tau - Math.sqrt(2.0 * this.tau)) / (2.0 * d2);
            this.r = (1.0 + this.rho * this.rho) / (2.0 * this.rho);
            this.k_set = d2;
        }
        do {
            d4 = this.randomGenerator.raw();
            d3 = this.randomGenerator.raw();
        } while ((d7 = d2 * (this.r - (d6 = (1.0 + this.r * (d5 = Math.cos(Math.PI * d4))) / (this.r + d5)))) * (2.0 - d7) < d3 && Math.log(d7 / d3) + 1.0 < d7);
        return this.randomGenerator.raw() > 0.5 ? Math.acos(d6) : -Math.acos(d6);
    }

    public void setState(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.my_k = d2;
    }

    public static double staticNextDouble(double d2) {
        VonMises vonMises = shared;
        synchronized (vonMises) {
            double d3 = shared.nextDouble(d2);
            return d3;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.my_k + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        VonMises vonMises = shared;
        synchronized (vonMises) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

