/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public abstract class AbstractPoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final MLogger logger = MLog.getLogger(AbstractPoolBackedDataSource.class);
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    protected AbstractPoolBackedDataSource(boolean autoregister) {
        super(autoregister);
        this.setUpPropertyEvents();
    }

    protected AbstractPoolBackedDataSource(String configName) {
        this(true);
        this.initializeNamedConfig(configName);
    }

    private void setUpPropertyEvents() {
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractPoolBackedDataSource.this.resetPoolManager();
            }
        };
        this.addPropertyChangeListener(l);
    }

    protected void initializeNamedConfig(String configName) {
        block4: {
            try {
                if (configName != null) {
                    C3P0Config.bindNamedConfigToBean(this, configName);
                    if (this.getDataSourceName().equals(this.getIdentityToken())) {
                        this.setDataSourceName(configName);
                    }
                }
            }
            catch (Exception e2) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Error binding PoolBackedDataSource to named-config '" + configName + "'. Some default-config values may be used.", e2);
            }
        }
    }

    public String getDataSourceName() {
        String out = super.getDataSourceName();
        if (out == null) {
            out = this.getIdentityToken();
        }
        return out;
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool().checkoutPooledConnection();
        return pc.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool(username, password).checkoutPooledConnection();
        return pc.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.assertCpds().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.assertCpds().setLoginTimeout(seconds);
    }

    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumUnclosedOrphanedConnections();
    }

    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.getNumConnections();
    }

    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.getNumIdleConnections();
    }

    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.getNumUnclosedOrphanedConnections();
    }

    public int getStatementCacheNumStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumStatements();
    }

    public int getStatementCacheNumCheckedOutDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumConnectionsWithCachedStatements();
    }

    public float getEffectivePropertyCycleDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getEffectivePropertyCycle();
    }

    public long getStartTimeMillisDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStartTime();
    }

    public long getUpTimeMillisDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getUpTime();
    }

    public long getNumFailedCheckinsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedCheckins();
    }

    public long getNumFailedCheckoutsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedCheckouts();
    }

    public long getNumFailedIdleTestsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedIdleTests();
    }

    public int getNumThreadsAwaitingCheckoutDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumThreadsAwaitingCheckout();
    }

    public int getThreadPoolSize() throws SQLException {
        return this.getPoolManager().getThreadPoolSize();
    }

    public int getThreadPoolNumActiveThreads() throws SQLException {
        return this.getPoolManager().getThreadPoolNumActiveThreads();
    }

    public int getThreadPoolNumIdleThreads() throws SQLException {
        return this.getPoolManager().getThreadPoolNumIdleThreads();
    }

    public int getThreadPoolNumTasksPending() throws SQLException {
        return this.getPoolManager().getThreadPoolNumTasksPending();
    }

    public String sampleThreadPoolStackTraces() throws SQLException {
        return this.getPoolManager().getThreadPoolStackTraces();
    }

    public String sampleThreadPoolStatus() throws SQLException {
        return this.getPoolManager().getThreadPoolStatus();
    }

    public String sampleStatementCacheStatusDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().dumpStatementCacheStatus();
    }

    public String sampleStatementCacheStatus(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).dumpStatementCacheStatus();
    }

    public Throwable getLastAcquisitionFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastAcquisitionFailure();
    }

    public Throwable getLastCheckinFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastCheckinFailure();
    }

    public Throwable getLastCheckoutFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastCheckoutFailure();
    }

    public Throwable getLastIdleTestFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastIdleTestFailure();
    }

    public Throwable getLastConnectionTestFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastConnectionTestFailure();
    }

    public Throwable getLastAcquisitionFailure(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getLastAcquisitionFailure();
    }

    public Throwable getLastCheckinFailure(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getLastCheckinFailure();
    }

    public Throwable getLastCheckoutFailure(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getLastCheckoutFailure();
    }

    public Throwable getLastIdleTestFailure(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getLastIdleTestFailure();
    }

    public Throwable getLastConnectionTestFailure(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getLastConnectionTestFailure();
    }

    public int getNumThreadsAwaitingCheckout(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumThreadsAwaitingCheckout();
    }

    public String sampleLastAcquisitionFailureStackTraceDefaultUser() throws SQLException {
        Throwable t = this.getLastAcquisitionFailureDefaultUser();
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastCheckinFailureStackTraceDefaultUser() throws SQLException {
        Throwable t = this.getLastCheckinFailureDefaultUser();
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastCheckoutFailureStackTraceDefaultUser() throws SQLException {
        Throwable t = this.getLastCheckoutFailureDefaultUser();
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastIdleTestFailureStackTraceDefaultUser() throws SQLException {
        Throwable t = this.getLastIdleTestFailureDefaultUser();
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastConnectionTestFailureStackTraceDefaultUser() throws SQLException {
        Throwable t = this.getLastConnectionTestFailureDefaultUser();
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastAcquisitionFailureStackTrace(String username, String password) throws SQLException {
        Throwable t = this.getLastAcquisitionFailure(username, password);
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastCheckinFailureStackTrace(String username, String password) throws SQLException {
        Throwable t = this.getLastCheckinFailure(username, password);
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastCheckoutFailureStackTrace(String username, String password) throws SQLException {
        Throwable t = this.getLastCheckoutFailure(username, password);
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastIdleTestFailureStackTrace(String username, String password) throws SQLException {
        Throwable t = this.getLastIdleTestFailure(username, password);
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public String sampleLastConnectionTestFailureStackTrace(String username, String password) throws SQLException {
        Throwable t = this.getLastConnectionTestFailure(username, password);
        return t == null ? null : ThrowableUtils.extractStackTrace(t);
    }

    public void softResetDefaultUser() throws SQLException {
        this.getPoolManager().getPool().reset();
    }

    public int getNumConnections(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumConnections();
    }

    public int getNumIdleConnections(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumIdleConnections();
    }

    public int getNumBusyConnections(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumUnclosedOrphanedConnections();
    }

    public int getStatementCacheNumStatements(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getStatementCacheNumStatements();
    }

    public int getStatementCacheNumCheckedOut(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getStatementCacheNumCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getStatementCacheNumConnectionsWithCachedStatements();
    }

    public float getEffectivePropertyCycle(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getEffectivePropertyCycle();
    }

    public long getStartTimeMillis(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getStartTime();
    }

    public long getUpTimeMillis(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getUpTime();
    }

    public long getNumFailedCheckins(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumFailedCheckins();
    }

    public long getNumFailedCheckouts(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumFailedCheckouts();
    }

    public long getNumFailedIdleTests(String username, String password) throws SQLException {
        return this.assertAuthPool(username, password).getNumFailedIdleTests();
    }

    public void softReset(String username, String password) throws SQLException {
        this.assertAuthPool(username, password).reset();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumBusyConnectionsAllAuths();
    }

    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumIdleConnectionsAllAuths();
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumUnclosedOrphanedConnectionsAllAuths();
    }

    public int getStatementCacheNumStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumStatementsAllUsers();
    }

    public int getStatementCacheNumCheckedOutStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumCheckedOutStatementsAllUsers();
    }

    public synchronized int getStatementCacheNumConnectionsWithCachedStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumConnectionsWithCachedStatementsAllUsers();
    }

    public void softResetAllUsers() throws SQLException {
        this.getPoolManager().softResetAllAuths();
    }

    public int getNumUserPools() throws SQLException {
        return this.getPoolManager().getNumManagedAuths();
    }

    public Collection getAllUsers() throws SQLException {
        LinkedList<String> out = new LinkedList<String>();
        Set auths = this.getPoolManager().getManagedAuths();
        Iterator ii = auths.iterator();
        while (ii.hasNext()) {
            out.add(((DbAuth)ii.next()).getUser());
        }
        return Collections.unmodifiableList(out);
    }

    public synchronized void hardReset() {
        this.resetPoolManager();
    }

    public synchronized void close() {
        this.resetPoolManager();
        this.is_closed = true;
        C3P0Registry.markClosed(this);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " has been closed. ", new Exception("DEBUG STACK TRACE for PoolBackedDataSource.close()."));
        }
    }

    public void close(boolean force_destroy) {
        this.close();
    }

    public synchronized void resetPoolManager() {
        this.resetPoolManager(true);
    }

    public synchronized void resetPoolManager(boolean close_checked_out_connections) {
        if (this.poolManager != null) {
            this.poolManager.close(close_checked_out_connections);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource out = this.getConnectionPoolDataSource();
        if (out == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return out;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            ConnectionPoolDataSource cpds = this.assertCpds();
            this.poolManager = new C3P0PooledConnectionPoolManager(cpds, null, null, this.getNumHelperThreads(), this.getIdentityToken());
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0 pool... " + this.toString());
            }
        }
        return this.poolManager;
    }

    private C3P0PooledConnectionPool assertAuthPool(String username, String password) throws SQLException {
        C3P0PooledConnectionPool authPool = this.getPoolManager().getPool(username, password, false);
        if (authPool == null) {
            throw new SQLException("No pool has been yet been established for Connections authenticated by user '" + username + "' with the password provided. [Use getConnection( username, password ) " + "to initialize such a pool.]");
        }
        return authPool;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeShort(1);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        short version = ois.readShort();
        switch (version) {
            case 1: {
                this.setUpPropertyEvents();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + version);
            }
        }
    }
}

