/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.eso.cpl.Recipe;

public class RecipeDisplay
extends JPanel {
    private Recipe recipe_;
    private JPanel stack_ = new JPanel(new GridBagLayout());
    private int nrow;
    private final JTextField authorLabel_ = RecipeDisplay.makeLineField();
    private final JTextArea copyrightLabel_ = RecipeDisplay.makeMultiLineField();
    private final JTextField emailLabel_ = RecipeDisplay.makeLineField();
    private final JTextField libraryLabel_ = RecipeDisplay.makeLineField();
    private final JTextField nameLabel_ = RecipeDisplay.makeLineField();
    private final JTextField synopsisLabel_ = RecipeDisplay.makeLineField();
    private final JTextField versionLabel_ = RecipeDisplay.makeLineField();
    private final JTextArea descriptionArea_ = RecipeDisplay.makeMultiLineField();

    public RecipeDisplay() {
        this.setLayout(new BoxLayout(this, 0));
        this.addLineItem("Library", this.libraryLabel_);
        this.addLineItem("Name", this.nameLabel_);
        this.addLineItem("Synopsis", this.synopsisLabel_);
        this.addLineItem("Version", this.versionLabel_);
        this.addLineItem("Author", this.authorLabel_);
        this.addLineItem("Email", this.emailLabel_);
        this.addLargeItem("Copyright", RecipeDisplay.wrapInScroller(this.copyrightLabel_));
        this.addLargeItem("Description", RecipeDisplay.wrapInScroller(this.descriptionArea_));
        this.add(this.stack_);
    }

    public void setRecipe(Recipe recipe) {
        boolean isNull = recipe == null;
        String author = null;
        String copyright = null;
        String email = null;
        String library = null;
        String name = null;
        String synopsis = null;
        String version = null;
        String description = null;
        if (recipe != null) {
            author = recipe.getAuthor();
            copyright = recipe.getCopyright();
            description = recipe.getDescription();
            email = recipe.getEmail();
            library = recipe.getLibrary().getName();
            name = recipe.getName();
            synopsis = recipe.getSynopsis();
            version = Long.toString(recipe.getVersion());
        }
        String blank = " ";
        this.authorLabel_.setText(author == null ? blank : author);
        this.copyrightLabel_.setText(copyright == null ? blank : copyright);
        this.descriptionArea_.setText(description == null ? blank : description);
        this.emailLabel_.setText(email == null ? blank : email);
        this.libraryLabel_.setText(library == null ? blank : library);
        this.nameLabel_.setText(name == null ? blank : name);
        this.synopsisLabel_.setText(synopsis == null ? blank : synopsis);
        this.versionLabel_.setText(version == null ? blank : version);
        this.descriptionArea_.setCaretPosition(0);
        int fontDefaultSize = this.descriptionArea_.getFont().getSize();
        this.descriptionArea_.setFont(new Font("Monospaced", 0, fontDefaultSize));
    }

    private void addLineItem(String name, Component label) {
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridy = this.nrow++;
        c2.weighty = 0.0;
        c2.gridx = 1;
        c2.ipadx = 4;
        c2.ipady = 2;
        c2.anchor = 17;
        c2.weightx = 0.0;
        this.addWithConstraints(new JLabel(" " + name + ":"), c2);
        c2.gridx = 3;
        c2.anchor = 17;
        c2.weightx = 1.0;
        c2.fill = 2;
        this.addWithConstraints(label, c2);
    }

    private void addLargeItem(String name, Component item) {
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridy = this.nrow++;
        c2.gridx = 1;
        c2.ipadx = 4;
        c2.ipady = 2;
        c2.anchor = 18;
        c2.weightx = 0.0;
        this.addWithConstraints(new JLabel(" " + name + ":"), c2);
        c2.gridx = 3;
        c2.anchor = 18;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.fill = 1;
        this.addWithConstraints(item, c2);
    }

    private void addWithConstraints(Component comp, GridBagConstraints cons) {
        ((GridBagLayout)this.stack_.getLayout()).setConstraints(comp, cons);
        this.stack_.add(comp);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
    }

    private static JTextField makeLineField() {
        JTextField lab = new JTextField(35);
        lab.setText(" ");
        Color fg = lab.getForeground();
        Color bg = lab.getBackground();
        lab.setEditable(false);
        lab.setForeground(fg);
        lab.setBackground(bg);
        return lab;
    }

    private static JTextArea makeMultiLineField() {
        JTextArea lab = new JTextArea();
        lab.setLineWrap(true);
        lab.setWrapStyleWord(true);
        lab.setText(" ");
        lab.setOpaque(true);
        lab.setEditable(false);
        return lab;
    }

    private static JScrollPane wrapInScroller(JTextArea lab) {
        JScrollPane dscroller = new JScrollPane(lab);
        dscroller.setPreferredSize(new Dimension(500, 128));
        return dscroller;
    }
}

