/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;

public class RecipeTree
extends JTree {
    private final DefaultTreeModel model_ = (DefaultTreeModel)this.getModel();
    private final MutableTreeNode root_ = (MutableTreeNode)this.model_.getRoot();

    public RecipeTree() {
        super(new DefaultTreeModel(new DefaultMutableTreeNode(), true));
        this.setCellRenderer(new RecipeCellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public void addLibrary(RecipeLibrary lib) {
        DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(lib, true);
        Recipe[] recipes = lib.getRecipes();
        for (int i = 0; i < recipes.length; ++i) {
            libNode.add(new DefaultMutableTreeNode(recipes[i], false));
        }
        Object[] others = lib.getOtherItems();
        if (others != null) {
            for (int i = 0; i < others.length; ++i) {
                libNode.add(new DefaultMutableTreeNode(others[i], false));
            }
        }
        this.model_.insertNodeInto(libNode, this.root_, this.root_.getChildCount());
        this.expandPath(new TreePath(libNode.getPath()));
    }

    public Object getUserObject(Object node) {
        return node instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)node).getUserObject() : null;
    }

    private boolean isDuff(Object node) {
        Object uo = this.getUserObject(node);
        return !(uo instanceof RecipeLibrary) && !(uo instanceof Recipe);
    }

    private class RecipeCellRenderer
    extends DefaultTreeCellRenderer {
        Color color0;
        Color color1;

        private RecipeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
            Object uo = RecipeTree.this.getUserObject(node);
            if (node != null) {
                if (uo instanceof RecipeLibrary) {
                    RecipeLibrary lib = (RecipeLibrary)uo;
                    this.setText(lib.getName());
                } else if (uo instanceof Recipe) {
                    Recipe rec = (Recipe)uo;
                    this.setText(rec.getName());
                }
            }
            if (this.color1 == null) {
                this.color1 = this.getForeground();
                this.color0 = new Color(this.color1.getColorSpace(), this.color1.getColorComponents(null), 0.5f);
            }
            this.setForeground(RecipeTree.this.isDuff(node) ? this.color0 : this.color1);
            return this;
        }
    }
}

