/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.jni;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eso.cpl.CPLException;
import org.eso.cpl.jni.CPLControl;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.PluginLibrary;

public class LibraryLoader {
    private boolean isRegistered_;
    private List searchPath_ = new ArrayList();

    public LibraryLoader() throws LTDLException {
        this.register();
        this.isRegistered_ = true;
    }

    public void setPath(List path) {
        this.searchPath_ = path;
    }

    public List getPath() {
        return this.searchPath_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginLibrary getLibrary(String libName) throws LTDLException, CPLException {
        String libLoc = null;
        if (new File(libName).isAbsolute()) {
            libLoc = libName;
        }
        Iterator it = this.searchPath_.iterator();
        while (libLoc == null && it.hasNext()) {
            File dir = new File(it.next().toString());
            File fqfile = new File(dir, libName);
            if (!fqfile.exists()) continue;
            libLoc = fqfile.getAbsolutePath();
        }
        if (libLoc == null) {
            libLoc = libName;
        }
        Object object = CPLControl.LOCK;
        synchronized (object) {
            return LibraryLoader.nativeMakeLibrary(libLoc, "");
        }
    }

    public void close() throws LTDLException {
        if (!this.isRegistered_) {
            this.deregister();
            this.isRegistered_ = false;
        }
    }

    public boolean isClosed() throws LTDLException {
        return !this.isRegistered_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register() throws LTDLException {
        Object object = CPLControl.LOCK;
        synchronized (object) {
            LibraryLoader.nativeLTDLInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister() throws LTDLException {
        Object object = CPLControl.LOCK;
        synchronized (object) {
            LibraryLoader.nativeLTDLExit();
        }
    }

    private static native void nativeLTDLInit() throws LTDLException;

    private static native void nativeLTDLExit() throws LTDLException;

    private static native PluginLibrary nativeMakeLibrary(String var0, String var1) throws LTDLException, CPLException;

    static {
        CPLControl.ensureSetup();
    }
}

