/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.eso.gasgano.DBTreeTable;
import org.eso.gasgano.GasganoDisplay;
import org.eso.gasgano.gui.DBTreeTableModel;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.gui.JTreeTable;
import org.eso.gasgano.gui.TreeModelIterator;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;

public class DBTreeControlPanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private JComboBox groupSelector = null;
    private JButton expandTree = null;
    private JButton collapseTree = null;
    private JTextField findEntry = null;
    private JButton findButton = null;
    private JTreeTable treeTable = null;
    private DBTreeTableModel model = null;
    private Object endSearchNode = null;
    private static final String groupByProgLabel = "Default grouping";
    private static final String groupByTelLabel = "Group by Telescope";
    private static final String findLabel = "find";
    private JLabel selectedNumber = null;
    private JComboBox periodSelector = null;
    private JComboBox instrumentSelector = null;
    private JComboBox searchType = null;
    private boolean userPeriodSelection = false;
    private boolean userInstrumentSelection = false;
    private GasganoDisplay mainDisplay = null;

    public DBTreeControlPanel(JTreeTable t, DBTreeTableModel m, GasganoDisplay gd) {
        this.treeTable = t;
        this.model = m;
        this.mainDisplay = gd;
        this.init();
    }

    private void init() {
        int z;
        Vector<String> items = new Vector<String>(2);
        this.setLayout(new BorderLayout());
        items.addElement(groupByProgLabel);
        items.addElement(groupByTelLabel);
        this.groupSelector = new JComboBox(items);
        this.groupSelector.addActionListener(this);
        items = new Vector(GasProp.periodMax - GasProp.periodMin + 1);
        items.addElement("All");
        for (z = GasProp.periodMin; z <= GasProp.periodMax; ++z) {
            items.addElement(String.valueOf(z));
        }
        this.periodSelector = new JComboBox(items);
        this.periodSelector.addActionListener(this);
        this.periodSelector.setSelectedItem(PropertyDB.getInstance().getProperty("DBOBS_PERIOD"));
        items = new Vector(GasProp.getProperties().dbInstruments.size() + 1);
        items.addElement("All");
        for (z = 0; z < GasProp.getProperties().dbInstruments.size(); ++z) {
            items.addElement((String)GasProp.getProperties().dbInstruments.elementAt(z));
        }
        this.instrumentSelector = new JComboBox(items);
        this.instrumentSelector.addActionListener(this);
        if (GasProp.getProperties().dbInstruments.contains(PropertyDB.getInstance().getProperty("DBOBS_INSTRUMENT"))) {
            this.instrumentSelector.setSelectedItem(PropertyDB.getInstance().getProperty("DBOBS_INSTRUMENT"));
        }
        items = new Vector(2);
        items.addElement("Find entry:");
        items.addElement("Add program:");
        this.searchType = new JComboBox(items);
        JLabel serverIdLabel = new JLabel(PropertyDB.getInstance().getProperty("DBOBS_SERVER_ID"));
        serverIdLabel.setFont(new Font("Dialog", 0, 18));
        serverIdLabel.setForeground(GUIUtils.dataBaseColor);
        serverIdLabel.setBorder(new EmptyBorder(3, 14, 3, 6));
        JPanel searchPanel = new JPanel();
        this.findEntry = new JTextField(20);
        this.findEntry.addActionListener(this);
        searchPanel.add(this.searchType);
        searchPanel.add(this.findEntry);
        searchPanel.setBorder(new LineBorder(Color.black, 1));
        JPanel centerPanel = new JPanel();
        centerPanel.add(this.groupSelector);
        centerPanel.add(new JLabel("Instrument "));
        centerPanel.add(this.instrumentSelector);
        centerPanel.add(new JLabel("Period "));
        centerPanel.add(this.periodSelector);
        centerPanel.add(searchPanel);
        this.add((Component)centerPanel, "Center");
        JPanel eastPanel = new JPanel(new BorderLayout());
        this.selectedNumber = new JLabel("0");
        this.selectedNumber.setBorder(new EmptyBorder(3, 1, 10, 6));
        this.treeTable.getTree().addTreeSelectionListener(this);
        eastPanel.add((Component)this.selectedNumber, "West");
        ToolTipManager.sharedInstance().setInitialDelay(50);
        this.add((Component)serverIdLabel, "West");
        this.add((Component)eastPanel, "East");
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getSource() == this.groupSelector) {
            String item = this.groupSelector.getSelectedItem().toString();
            if (item == groupByProgLabel) {
                this.groupBy(0);
            }
            if (item == groupByTelLabel) {
                this.groupBy(2);
            }
        }
        if (a2.getSource() == this.findEntry) {
            if (this.searchType.getSelectedIndex() == 0 && !this.searchTree(this.findEntry.getText())) {
                this.userMessage("'" + this.findEntry.getText() + "' not located.");
            }
            if (this.searchType.getSelectedIndex() == 1) {
                this.model.addSingleProgram(this.findEntry.getText());
                this.findEntry.setText("");
            }
        }
        if (a2.getSource() == this.periodSelector) {
            if (this.userPeriodSelection) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String item = DBTreeControlPanel.this.periodSelector.getSelectedItem().toString();
                        GasProp.getProperties().put("DBOBS_PERIOD", item);
                        DBTreeControlPanel.this.mainDisplay.setDatabasePanelEnabled(false);
                        if (DBTreeControlPanel.this.model.periodSelectionChanged()) {
                            DBTreeControlPanel.this.mainDisplay.setDatabasePanelEnabled(true);
                        }
                        DBTreeControlPanel.this.model.updateTree();
                        GasProp.getProperties().saveProperties();
                    }
                }).start();
            }
            this.userPeriodSelection = true;
        }
        if (a2.getSource() == this.instrumentSelector) {
            if (this.userInstrumentSelection) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String item = DBTreeControlPanel.this.instrumentSelector.getSelectedItem().toString();
                        GasProp.getProperties().put("DBOBS_INSTRUMENT", item);
                        DBTreeControlPanel.this.mainDisplay.setDatabasePanelEnabled(false);
                        if (DBTreeControlPanel.this.model.periodSelectionChanged()) {
                            DBTreeControlPanel.this.mainDisplay.setDatabasePanelEnabled(true);
                        }
                        DBTreeControlPanel.this.model.updateTree();
                        GasProp.getProperties().saveProperties();
                    }
                }).start();
            }
            this.userInstrumentSelection = true;
        }
    }

    public boolean searchTree(String findString) {
        Object currentNode;
        boolean rc = false;
        TreePath selPath = this.treeTable.getTree().getLeadSelectionPath();
        boolean found = false;
        TreeModelIterator iterator = null;
        int columnCount = this.model.getColumnCount();
        findString = findString.toUpperCase();
        this.endSearchNode = selPath != null ? selPath.getLastPathComponent() : this.model.getRoot();
        iterator = new TreeModelIterator(this.model, selPath);
        do {
            iterator.iteratePath();
            currentNode = iterator.getCurrentPath().lastElement();
            for (int i = 0; i < columnCount && !found; ++i) {
                String nodeVal;
                Object cellValue = this.model.getValueAt(currentNode, i);
                if (cellValue == null || (nodeVal = cellValue.toString().toUpperCase()).indexOf(findString) == -1) continue;
                found = true;
            }
        } while (currentNode != this.endSearchNode && !found);
        if (found) {
            Vector pathVector = iterator.getCurrentPath();
            Object[] path = new Object[pathVector.size()];
            for (int i = 0; i < path.length; ++i) {
                path[i] = pathVector.elementAt(i);
            }
            TreePath tp = new TreePath(path);
            this.treeTable.getTree().setSelectionPath(tp);
            Rectangle r = this.treeTable.getCellRect(this.treeTable.getSelectedRow(), 0, true);
            this.treeTable.scrollRectToVisible(r);
        }
        return found;
    }

    public void userMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    public void groupBy(int gbLevel) {
        if (this.model instanceof DBTreeTableModel) {
            this.model.setGroupDataByLevel(gbLevel);
        }
    }

    public Component getFindEntryComponent() {
        return this.findEntry;
    }

    private int runCommand(String command) {
        int rc = -1;
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(command);
            try {
                p.waitFor();
                rc = p.exitValue();
            }
            catch (InterruptedException ie) {
                System.out.println("Interrupted while executing: " + ie.toString());
            }
            catch (IllegalThreadStateException ie) {
                System.out.println("Interrupted while executing: " + ie.toString());
            }
        }
        catch (IOException e2) {
            System.out.println("Error executing command: " + e2.toString());
        }
        return rc;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        Vector files = ((DBTreeTable)this.treeTable).getSelectedOBComponents();
        if (files == null) {
            this.selectedNumber.setText("0");
        } else {
            this.selectedNumber.setText(String.valueOf(files.size()));
        }
    }
}

