/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import jal.String.Sorting;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.eso.cpl.CPLException;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.gui.CPLFrame;
import org.eso.cpl.gui.RecipeSelector;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.PluginLibrary;
import org.eso.dfs.datatransfer.FileListEvent;
import org.eso.dfs.datatransfer.FileListImportListener;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.dfs.services.gui.FileImageDisplayService;
import org.eso.gasgano.DBTreeControlPanel;
import org.eso.gasgano.DBTreeTable;
import org.eso.gasgano.GasPropEditor;
import org.eso.gasgano.ResultsTreeTable;
import org.eso.gasgano.ScriptDirBoard;
import org.eso.gasgano.TreeControlPanel;
import org.eso.gasgano.cpl.RecipePanelList;
import org.eso.gasgano.datamodel.BasicFileDescription;
import org.eso.gasgano.datamodel.NotFoundOBComponent;
import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.datamodel.ReductionBlockCommon;
import org.eso.gasgano.datamodel.ResultsModel;
import org.eso.gasgano.datamodel.database.DBDataModel;
import org.eso.gasgano.datamodel.database.FileDownloader;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.filesystem.DirectoryFileSelectionModel;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.filesystem.FitsFileReport;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.datamodel.gui.ReductionBlockOBComponent;
import org.eso.gasgano.datamodel.gui.ResultsComponent;
import org.eso.gasgano.datamodel.gui.VirtualReductionBlockOBComponent;
import org.eso.gasgano.dfspipeline.DFSPipelineEnvironment;
import org.eso.gasgano.dfspipeline.InfrastructureWatch;
import org.eso.gasgano.gui.ClassificationRuleFileEditor;
import org.eso.gasgano.gui.DBTreeTableModel;
import org.eso.gasgano.gui.DFSFileTreeTable;
import org.eso.gasgano.gui.DFSFileTreeTableModel;
import org.eso.gasgano.gui.DataModelBuilder;
import org.eso.gasgano.gui.FileListChooser;
import org.eso.gasgano.gui.FileListModel;
import org.eso.gasgano.gui.FileListPane;
import org.eso.gasgano.gui.FilterBuilder;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.gui.KeywordListEditorFrame;
import org.eso.gasgano.gui.KeywordListLoader;
import org.eso.gasgano.gui.ReportViewer;
import org.eso.gasgano.gui.ResultsTreeTableModel;
import org.eso.gasgano.keyword.ExpressionTable;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.GasPropListener;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.DirUtils;
import org.eso.gasgano.tools.PasswordSource;
import org.eso.oca.parser.ParseException;

public class GasganoDisplay
extends JFrame
implements ActionListener,
ChangeListener,
GasPropListener {
    private DFSFileTreeTable fsTree;
    private DFSFileTreeTableModel fsTreeModel;
    private DBTreeTable dbTree;
    private DBTreeTableModel dbTreeModel;
    private TreeControlPanel treeControlPanel;
    private DBTreeControlPanel dbTreeControlPanel;
    private DFSDataModel dataModel;
    private TreeControlPanel resTreeControlPanel;
    private ResultsModel resDataModel;
    private ResultsTreeTableModel resTreeModel;
    private ResultsTreeTable resTree;
    private DBDataModel dbDataModel;
    private DirectoryFileSelectionModel fileSelections;
    private DirectoryFileSelectionModel backupFileSelections;
    private JSplitPane splitPane;
    private JSplitPane lowerSplitPane;
    private FileListPane fileListPane;
    private FileListChooser fileListChooser;
    private JFileChooser fileChooser;
    private JPanel blankDetail;
    private FilterBuilder fltBuilder;
    private KeywordListEditorFrame kwListEditor;
    private KeywordListLoader kwListLoader;
    private ScriptDirBoard scriptBoard;
    private DisplayOrganizer displayOrganizer;
    private GasPropEditor propertyEditor;
    private GasProp backupPrefs;
    private JTabbedPane tabbedPane;
    private JPanel fsTreePanel;
    private JPanel dbTreePanel;
    private JPanel resTreePanel;
    private JScrollPane fsTreeView;
    private JScrollPane dbTreeView;
    private JScrollPane resTreeView;
    private JPopupMenu selectedFilesPopupMenu;
    private RecipePanelList recipePanels = new RecipePanelList();
    private JFileChooser retrieveFileChooser;
    private boolean fsSelected = true;
    private boolean dbSelected = false;
    private boolean resSelected = false;
    private static final String addRmFileLabel = "Add/Remove Files...";
    private static final String reclassifyLabel = "Reclassify";
    private static final String refreshLabel = "Refresh";
    private static final String editPreferencesLabel = "Preferences...";
    private static final String mvFileLabel = "Move...";
    private static final String externalViewerLabel = "Display...";
    private static final String toRecipeLabel = "To Recipe";
    private static final String toQueueLabel = "To Recipe Request Pool";
    private static final String openRecipeLabel = "Load Recipe";
    private static final String cpFileLabel = "Copy...";
    private static final String tarFileLabel = "Tar...";
    private static final String reportFileLabel = "Report...";
    private static final String appFileLabel = "Run...";
    private static final String classBldrLabel = "Classification Rules...";
    private static final String kwListEditorLabel = "Edit Keyword Lists...";
    private static final String scriptBoardLabel = "Script Board";
    private static final String recipePanelLabel = "Recipe Panel";
    private static final String whoIsGasganoLabel = "Who is Gasgano";
    private static final String overviewLabel = "Overview";
    private static final String userInputLabel = "User Input";
    private static final String initialSetupLabel = "Setup";
    private static final String preferencesLabel = "Preferences ";
    private static final String associationLabel = "Association";
    private static final String externalCommandsLabel = "External Commands";
    private static final String addFilterLabel = "Filter Files";
    private static final String rmFilterLabel = "Unfilter files";
    private static final String quitLabel = "Quit";
    private LibraryLoader loader;
    private static final String helpDir = "help/";
    static final int[] menuZeroList = new int[]{0, 1, 2, 3, 4};
    static final int[] menuOneList = new int[]{1, 2, 3, 4};
    private boolean dataBaseOn = false;
    private boolean safeEnvironment = false;
    private final Cursor waitCursor = new Cursor(3);
    private JMenuItem dualFilterItem = null;
    private int debugLevel = 0;
    private int inDFSPipeEnv = -1;
    private boolean showFileLists = true;
    private static final String[] tabLabels = new String[]{"Raw Files", "Master Calib. Files", "Reduction Block Files", "Product Files"};
    private static final String[] emptyListLabels = new String[]{"No associated raw files", "No associated master calibration files", "No associated reduction block files", "No associated product files"};
    private Timer updateTimer = null;

    public GasganoDisplay(String title, DFSDataModel m, DBDataModel dbm, ResultsModel resm) {
        super(title);
        this.dataModel = m;
        this.dbDataModel = dbm;
        this.resDataModel = resm;
        this.displayOrganizer = new DisplayOrganizer();
        if (PropertyDB.getInstance().getProperty("DBOBS_REQUIRED").equals("true")) {
            this.dataBaseOn = true;
        }
        this.safeEnvironment = GasProp.isEnvironmentSafe();
        this.setupFileSystemArea();
        if (this.safeEnvironment) {
            this.setupDatabaseArea();
        }
        this.setupResultsArea();
        this.resTreePanel.add((Component)this.resTreeControlPanel, "North");
        this.resTreePanel.add((Component)this.resTreeView, "Center");
        this.fsTreePanel.add((Component)this.treeControlPanel, "North");
        this.fsTreePanel.add((Component)this.fsTreeView, "Center");
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.setFont(new Font("DialogInput", 0, 10));
        this.tabbedPane.addChangeListener(this);
        if (this.safeEnvironment) {
            this.setDatabasePanelEnabled(false);
        }
        this.fsTreePanel.setPreferredSize(new Dimension(300, 300));
        this.fsTreePanel.setMinimumSize(new Dimension(300, 110));
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.lowerSplitPane = new JSplitPane(0);
        this.lowerSplitPane.setOneTouchExpandable(true);
        this.setupFileListPane();
        this.lowerSplitPane.setTopComponent(this.fileListPane);
        this.splitPane.setBottomComponent(this.lowerSplitPane);
        this.showBlankDetail(true);
        this.getContentPane().add(this.splitPane);
        this.setShowFileLists(this.isDFSPipelineEnvironment());
        try {
            this.fileSelections = new DirectoryFileSelectionModel(new String[0]);
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage().length() > 500 ? ioe.getMessage().substring(0, 500) + "[...]" : ioe.getMessage();
            GUIUtils.userMessage(this, "One or more errors found while initializing DirectoryFileSelectionModel" + errMsg);
        }
        this.fileListChooser = new FileListChooser();
        this.addMenu();
        this.splitPane.setTopComponent(this.fsTreePanel);
        this.pack();
        if (this.safeEnvironment) {
            if (this.dataBaseOn) {
                this.setDatabaseEnabled(true);
            } else {
                this.setDatabaseEnabled(false);
            }
        }
        int updateMinutes = 0;
        this.updateTimer = new Timer(0, this);
        try {
            updateMinutes = Integer.parseInt(PropertyDB.getInstance().getProperty("UPDATE_TIMER"));
            if (updateMinutes != 0) {
                this.updateTimer.setDelay(updateMinutes * 60000);
                this.updateTimer.setInitialDelay(updateMinutes * 60000);
                this.updateTimer.start();
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to create/start the update timer.");
            ex.printStackTrace();
        }
        if (this.isDFSPipelineEnvironment()) {
            InfrastructureWatch infraWatch = new InfrastructureWatch();
            infraWatch.addDFSPipelineStatusListener(this.treeControlPanel);
            infraWatch.start();
        }
        this.registerKeyboard();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        Rectangle rec = GUIUtils.stringToRect(PropertyDB.getInstance().getProperty("FRAME_BOUNDS"));
        if (rec == null) {
            PropertyDB.getInstance().setProperty("FRAME_BOUNDS", "8,100,920,650");
        }
        rec = GUIUtils.stringToRect(PropertyDB.getInstance().getProperty("FRAME_BOUNDS"));
        this.setBounds(rec);
        this.setVisible(true);
        this.fsTree.registerColumnListener();
        this.fsTree.setColumnWidths();
        this.selectFirstFileFilter();
    }

    private JSplitPane getDetailPanelContainer() {
        return this.isShowFileLists() ? this.lowerSplitPane : this.splitPane;
    }

    public boolean isDFSPipelineEnvironment() {
        return DFSPipelineEnvironment.getInstance().isPipelineEnvironment();
    }

    protected void setupResultsArea() {
        this.resTreeModel = new ResultsTreeTableModel(this.resDataModel);
        this.resTree = new ResultsTreeTable(this.resTreeModel, this);
        this.resTreeView = new JScrollPane(this.resTree);
        this.resTreePanel = new JPanel(new BorderLayout());
        this.resTreeControlPanel = new TreeControlPanel(this.resTree, this.resTreeModel, this);
    }

    protected void setupDatabaseArea() {
        this.dbTreeModel = new DBTreeTableModel(this.dbDataModel);
        this.dbTree = new DBTreeTable(this.dbTreeModel, this);
        this.dbTreeView = new JScrollPane(this.dbTree);
        this.dbTree.getTree().addTreeSelectionListener(this.displayOrganizer);
        this.dbTreePanel = new JPanel(new BorderLayout());
        this.dbTreeControlPanel = new DBTreeControlPanel(this.dbTree, this.dbTreeModel, this);
    }

    protected void setupFileSystemArea() {
        this.fsTreeModel = new DFSFileTreeTableModel(this.dataModel);
        this.fsTree = new DFSFileTreeTable(this.fsTreeModel);
        this.fsTree.addFileListImportListener(new FileListImportListener(){

            @Override
            public void importFileListEvent(FileListEvent event) {
                String[] dirs = new String[event.getFileList().size()];
                Iterator i = event.getFileList().iterator();
                int idx = 0;
                while (i.hasNext()) {
                    dirs[idx] = ((File)i.next()).getPath();
                    ++idx;
                }
                GasganoDisplay.this.updateFileSelectionAndRefresh(dirs, false);
            }
        });
        this.fsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                this.processEvent(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                this.processEvent(e2);
            }

            private void processEvent(MouseEvent e2) {
                int row;
                if (e2.isPopupTrigger() && (row = GasganoDisplay.this.fsTree.rowAtPoint(new Point(e2.getX(), e2.getY()))) >= 0 && GasganoDisplay.this.fsTree.isRowSelected(row)) {
                    GasganoDisplay.this.selectedFilesPopupMenu.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }
        });
        this.fsTreeView = new JScrollPane(this.fsTree, 22, 31);
        this.fsTree.getTree().addTreeSelectionListener(this.displayOrganizer);
        this.fsTreePanel = new JPanel(new BorderLayout());
        this.treeControlPanel = new TreeControlPanel(this.fsTree, this.fsTreeModel, this);
        FileImageDisplayService.getInstance().addFileImageDisplayHandler(this.treeControlPanel);
    }

    public void setDatabaseEnabled(boolean b2) {
        if (b2) {
            if (this.splitPane.getTopComponent() != null) {
                this.splitPane.remove(this.splitPane.getTopComponent());
            }
            this.tabbedPane.removeAll();
            this.tabbedPane.add("Filesystem", this.fsTreePanel);
            this.tabbedPane.add("Database", this.dbTreePanel);
            this.tabbedPane.repaint();
            this.splitPane.setTopComponent(this.tabbedPane);
            this.dbDataModel.setPasswordSource(this.getPasswordSource());
        } else {
            if (this.splitPane.getTopComponent() != null) {
                this.splitPane.remove(this.splitPane.getTopComponent());
            }
            this.tabbedPane.remove(this.fsTreePanel);
            this.splitPane.setTopComponent(this.fsTreePanel);
            this.setDatabasePanelEnabled(false);
            this.dbDataModel.cleanup();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        if (e2.getSource() == this.tabbedPane) {
            int i;
            if (this.tabbedPane.getSelectedComponent() == this.dbTreePanel) {
                if (this.dbTreePanel.getComponent(0) == GUIUtils.gasgLabel3 && !this.dbDataModel.isUpdating()) {
                    this.initDb();
                }
                this.fsSelected = false;
                this.dbSelected = true;
                this.resSelected = false;
                for (i = 0; i < menuZeroList.length; ++i) {
                    this.getJMenuBar().getMenu(0).getMenuComponent(menuZeroList[i]).setEnabled(false);
                }
                for (i = 0; i < menuOneList.length; ++i) {
                    this.getJMenuBar().getMenu(1).getMenuComponent(menuOneList[i]).setEnabled(false);
                }
            }
            if (this.tabbedPane.getSelectedComponent() == this.fsTreePanel) {
                this.fsSelected = true;
                this.dbSelected = false;
                this.resSelected = false;
                for (i = 0; i < menuZeroList.length; ++i) {
                    this.getJMenuBar().getMenu(0).getMenuComponent(menuZeroList[i]).setEnabled(true);
                }
                for (i = 0; i < menuOneList.length; ++i) {
                    this.getJMenuBar().getMenu(1).getMenuComponent(menuOneList[i]).setEnabled(true);
                }
            }
            if (this.tabbedPane.getSelectedComponent() == this.resTreePanel) {
                int i2;
                this.resDataModel.cleanup();
                SwingFileChooser tpfc = new SwingFileChooser();
                tpfc.setMultiSelectionEnabled(false);
                if (tpfc.showOpenDialog(this) == 0 && tpfc.getSelectedFile() != null) {
                    this.resDataModel.init(this.resDataModel.tmpAssessTiraPackInfo(tpfc.getSelectedFile().getPath()));
                    this.resTreeModel.updateTree();
                }
                this.fsSelected = false;
                this.dbSelected = false;
                this.resSelected = true;
                for (i2 = 0; i2 < menuZeroList.length; ++i2) {
                    this.getJMenuBar().getMenu(0).getMenuComponent(menuZeroList[i2]).setEnabled(false);
                }
                for (i2 = 0; i2 < menuOneList.length; ++i2) {
                    this.getJMenuBar().getMenu(1).getMenuComponent(menuOneList[i2]).setEnabled(false);
                }
            }
            this.getLayeredPane().repaint();
        }
    }

    public void setDatabasePanelEnabled(boolean b2) {
        if (b2) {
            this.tabbedPane.setForeground(Color.magenta);
            this.dbTreePanel.remove(GUIUtils.gasgLabel3);
            this.dbTreePanel.add((Component)this.dbTreeControlPanel, "North");
            this.dbTreePanel.add((Component)this.dbTreeView, "Center");
            this.dbTreePanel.validate();
            this.dbTreePanel.repaint();
        } else {
            this.tabbedPane.setForeground(Color.black);
            this.dbTreePanel.removeAll();
            this.dbTreePanel.add(GUIUtils.gasgLabel3);
            this.dbTreePanel.validate();
            this.dbTreePanel.repaint();
        }
    }

    private void initDb() {
        final Cursor cursorBack = this.getCursor();
        new Thread(new Runnable(){

            @Override
            public void run() {
                GasganoDisplay.this.dbTreePanel.validate();
                GasganoDisplay.this.setCursor(GasganoDisplay.this.waitCursor);
                if (!GasganoDisplay.this.dbDataModel.init()) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    GasganoDisplay.this.setCursor(cursorBack);
                    toolkit.beep();
                    GasganoDisplay.this.tabbedPane.setSelectedComponent(GasganoDisplay.this.fsTreePanel);
                    return;
                }
                GasganoDisplay.this.dbTreeModel.updateTree();
                GasganoDisplay.this.setDatabasePanelEnabled(true);
                GasganoDisplay.this.setCursor(cursorBack);
            }
        }).start();
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getSource() == this.updateTimer) {
            Cursor c2 = this.getCursor();
            this.getJMenuBar().getMenu(0).getItem(5).setEnabled(false);
            this.setCursor(this.waitCursor);
            this.refreshModelWithoutWindow();
            this.getJMenuBar().getMenu(0).getItem(5).setEnabled(true);
            this.setCursor(c2);
        }
        if (a2.getActionCommand() == quitLabel) {
            System.exit(0);
        } else if (a2.getActionCommand() == addRmFileLabel) {
            this.addFile();
        } else if (a2.getActionCommand() == addFilterLabel) {
            this.showExpressionBuilder();
        } else if (a2.getActionCommand() == rmFilterLabel) {
            this.setFilter(null);
        } else if (a2.getActionCommand() == reclassifyLabel) {
            String ruleFile = PropertyDB.getInstance().getProperty("CLASSRULE_FILE");
            if (this.loadAndUpdateClassifier(ruleFile)) {
                this.reclassifyModel();
            }
        } else if (a2.getActionCommand() == refreshLabel) {
            this.refreshModel();
        } else if (a2.getActionCommand() == editPreferencesLabel) {
            this.backupPrefs = new GasProp(GasProp.getProperties());
            if (this.propertyEditor == null) {
                this.propertyEditor = new GasPropEditor();
                this.propertyEditor.setReclassificationListener(new GasPropEditor.ReclassificationListener(){

                    @Override
                    public void reclassifyNow() {
                        String ruleFile = PropertyDB.getInstance().getProperty("CLASSRULE_FILE");
                        if (GasganoDisplay.this.loadAndUpdateClassifier(ruleFile)) {
                            GasganoDisplay.this.reclassifyModel();
                        }
                    }
                });
            } else {
                this.propertyEditor.loadProperties();
            }
            this.propertyEditor.startEditing();
        } else if (a2.getActionCommand() == classBldrLabel) {
            this.showClassificationRuleFileEditor();
        } else if (a2.getActionCommand() == kwListEditorLabel) {
            this.showKeywordListEditor();
        } else if (a2.getActionCommand() == scriptBoardLabel) {
            this.toggleScriptBoard();
        } else if (a2.getActionCommand() == recipePanelLabel) {
            this.showRecipePanel();
        } else if (a2.getActionCommand() == whoIsGasganoLabel) {
            this.showGasgano();
        } else if (a2.getActionCommand() == overviewLabel) {
            this.showHelp("Overview.html");
        } else if (a2.getActionCommand() == userInputLabel) {
            this.showHelp("UserInput.html");
        } else if (a2.getActionCommand() == initialSetupLabel) {
            this.showHelp("InitialSetup.html");
        } else if (a2.getActionCommand() == preferencesLabel) {
            this.showHelp("Preferences.html");
        } else if (a2.getActionCommand() == associationLabel) {
            this.showHelp("Association.html");
        } else if (a2.getActionCommand() == externalCommandsLabel) {
            this.showHelp("External.html");
        }
    }

    private void showHelp(String htmlPage) {
        JEditorPane html = null;
        URL url = null;
        url = GasganoDisplay.class.getResource(helpDir + htmlPage);
        if (url != null) {
            try {
                html = new JEditorPane(url);
                html.setPreferredSize(new Dimension(400, 600));
                html.setMinimumSize(new Dimension(400, 600));
                JScrollPane jsp = new JScrollPane(html);
                html.setEditable(false);
                jsp.setMinimumSize(new Dimension(470, 750));
                jsp.setPreferredSize(new Dimension(470, 750));
                GUIUtils.userMessage(this, jsp);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        } else {
            System.err.println("URL null");
            GUIUtils.userMessage(this, "Help page could not be displayed.\nURL for " + htmlPage + " is empty!");
        }
    }

    private void showGasgano() {
        String gasganoText = new String("Although the 24-fingered Xexto\nhas never beaten Sebulba, Gasgano\nis a popular favorite in the Boonta Eve\nPodrace. Racing on behalf of Gardulla\nthe Hutt, Gasgano is the subject of\nfrenzied betting between Gardulla\nand Jabba.");
        JPanel gasganoIcon = new JPanel();
        JTextArea desc = new JTextArea(gasganoText);
        desc.setEditable(false);
        gasganoIcon.add((Component)desc, "Center");
        gasganoIcon.add((Component)GUIUtils.gasgLabel1, "East");
        GUIUtils.userMessage(this, gasganoIcon);
    }

    private boolean showClassificationRuleFileEditor() {
        File file = new File(PropertyDB.getInstance().getProperty("CLASSRULE_FILE"));
        String ruleFile = "[unknown]";
        try {
            ruleFile = file.getCanonicalPath();
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    GUIUtils.userError(this, "Unable to create rules file [" + ruleFile + "].\n" + "Parent directory doesn't exist [" + file.getParentFile().getAbsolutePath() + "].\n");
                    return false;
                }
                try {
                    if (!file.createNewFile()) {
                        GUIUtils.userError(this, "Unable to create rules file [" + ruleFile + "].\n");
                        return false;
                    }
                    GUIUtils.userMessage(this, "Successfully created empty rules file [" + ruleFile + "].\n");
                }
                catch (IOException e3) {
                    GUIUtils.userError(this, "Unable to create rules file [" + ruleFile + "].\n" + e3.getMessage());
                    return false;
                }
            }
            ClassificationRuleFileEditor editor = new ClassificationRuleFileEditor(ruleFile);
            editor.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            editor.setLocationRelativeTo(this);
            editor.setVisible(true);
            if (editor.isRuleFileChanged()) {
                this.dataModel.setClassifier(DFSDataModel.createClassifier(new FileInputStream(ruleFile)));
                this.reclassifyModel();
            }
        }
        catch (Exception e4) {
            GUIUtils.userMessage(this, "Unexpected exception while accessing rules file [" + ruleFile + "].\n" + e4.getMessage());
        }
        catch (Error e5) {
            GUIUtils.userMessage(this, "Unexpected error while accessing rules file [" + ruleFile + "].\n" + e5.getMessage());
        }
        return false;
    }

    private void showKeywordListEditor() {
        if (this.kwListEditor == null) {
            this.kwListEditor = new KeywordListEditorFrame();
            this.kwListEditor.pack();
            this.kwListEditor.setLocation(200, 400);
        }
        this.kwListEditor.setVisible(true);
    }

    public void toggleScriptBoard() {
        if (this.scriptBoard != null && this.scriptBoard.isVisible()) {
            this.scriptBoard.hideBoard();
        } else {
            if (this.scriptBoard == null) {
                String scriptDir = null;
                String scriptPrefs = new String(PropertyDB.getInstance().getProperty("SCRIPTS_DIR"));
                scriptDir = DirUtils.convertAbsoluteDir(scriptPrefs);
                if (!new File(scriptDir).isDirectory()) {
                    GUIUtils.userMessage(this, "The Scripts directory either does not exist\nor is not a directory\nCheck your preferences!");
                    return;
                }
                this.scriptBoard = new ScriptDirBoard(scriptDir, this, this.fsTree);
                this.scriptBoard.setLocation(200, 400);
                DefaultTreeSelectionModel selectionModel = (DefaultTreeSelectionModel)this.fsTree.getTree().getSelectionModel();
                selectionModel.addTreeSelectionListener(this.scriptBoard);
            }
            this.scriptBoard.pack();
            this.scriptBoard.showBoard();
        }
    }

    public void showRecipePanel(String recipeName) {
        Recipe rc = null;
        PluginLibrary lib = null;
        Cursor origCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.loader == null) {
                this.loader = new LibraryLoader();
            }
            Iterator libNameIter = GasProp.getProperties().getRecipeLibraryNames();
            while (lib == null && libNameIter.hasNext()) {
                String libName = (String)libNameIter.next();
                List recipeNames = GasProp.getProperties().getRecipesForLibrary(libName);
                if (recipeNames == null) continue;
                Iterator recNameIter = recipeNames.iterator();
                while (lib == null && recNameIter.hasNext()) {
                    String recName = (String)recNameIter.next();
                    if (!recName.equals(recipeName)) continue;
                    try {
                        lib = this.loader.getLibrary(libName);
                    }
                    catch (CPLException cplEx) {
                        GUIUtils.userMessage(this, "Cannot load library " + libName + "\n" + cplEx.getMessage());
                    }
                }
            }
            if (lib != null) {
                Recipe[] recipes = lib.getRecipes();
                for (int r = 0; r < recipes.length; ++r) {
                    if (!recipes[r].getName().equals(recipeName)) continue;
                    rc = recipes[r];
                    break;
                }
            }
            if (lib == null) {
                if (origCursor != null) {
                    this.setCursor(origCursor);
                    origCursor = null;
                }
                GUIUtils.userMessage(this, "No library found containing recipe: " + recipeName);
            } else if (rc == null) {
                if (origCursor != null) {
                    this.setCursor(origCursor);
                    origCursor = null;
                }
                GUIUtils.userMessage(this, "Recipe " + recipeName + " not found in library " + lib.getName());
            }
        }
        catch (LTDLException e2) {
            if (origCursor != null) {
                this.setCursor(origCursor);
                origCursor = null;
            }
            GUIUtils.userMessage(this, e2.getMessage());
        }
        catch (Error e3) {
            e3.printStackTrace();
            GUIUtils.userMessage(this, "Fatal Error", e3.getMessage());
            System.exit(-1);
        }
        if (rc != null) {
            this.recipePanels.addRecipePanel(rc, this.fsTree.getSelectedOBComponents(), this.loader);
        }
        if (origCursor != null) {
            this.setCursor(origCursor);
            origCursor = null;
        }
    }

    private void addSelectedFilesToRecipePanel(String panelName, boolean queue) {
        if (this.recipePanels.getRecipePanel(panelName) != null) {
            this.recipePanels.addInputFramesToRecipePanel(panelName, this.fsTree.getSelectedOBComponents(), queue);
        } else {
            GUIUtils.userMessage(this, "Recipe panel " + panelName + " not found");
        }
    }

    private void showRecipePanel() {
        final JFrame frame = new JFrame();
        ArrayList<PluginLibrary> plugins = new ArrayList<PluginLibrary>();
        RecipeLibrary[] libs = null;
        try {
            if (this.loader == null) {
                this.loader = new LibraryLoader();
            }
            Iterator i = GasProp.getProperties().getRecipeLibraryNames();
            while (i.hasNext()) {
                String libName = (String)i.next();
                List recipes = GasProp.getProperties().getRecipesForLibrary(libName);
                if (recipes == null) continue;
                Iterator rec = recipes.iterator();
                while (rec.hasNext()) {
                    PluginLibrary lib = null;
                    try {
                        lib = this.loader.getLibrary((String)rec.next());
                    }
                    catch (CPLException cplEx) {
                        GUIUtils.userMessage(this, "Cannot load library " + rec + "\n" + cplEx.getMessage());
                    }
                    if (lib == null) continue;
                    plugins.add(lib);
                }
            }
        }
        catch (LTDLException e2) {
            GUIUtils.userMessage(this, e2.getMessage());
        }
        catch (Error e3) {
            e3.printStackTrace();
            GUIUtils.userMessage(this, "Fatal Error", e3.getMessage());
            System.exit(-1);
        }
        libs = new RecipeLibrary[plugins.size()];
        plugins.toArray(libs);
        RecipeSelector rsel = new RecipeSelector(libs){

            @Override
            protected void approveSelection() {
                Recipe recipe = this.getSelectedRecipe();
                frame.dispose();
                GasganoDisplay.this.recipePanels.addRecipePanel(recipe, GasganoDisplay.this.fsTree.getSelectedOBComponents(), GasganoDisplay.this.loader);
            }

            @Override
            protected void cancelSelection() {
                frame.dispose();
            }
        };
        frame.getContentPane().add(rsel);
        frame.pack();
        GUIUtils.center(this, frame);
        frame.setVisible(true);
    }

    private void selectFirstFileFilter() {
        this.initfltBuilder(false);
        if (this.fltBuilder == null) {
            return;
        }
        this.fltBuilder.selectFirstFilter();
        if (this.fltBuilder.getSelectedFilter() != null) {
            this.setFilter(this.fltBuilder.getSelectedFilter());
        }
    }

    private void initfltBuilder(boolean initAlways) {
        if (this.fltBuilder == null) {
            String tablePath = null;
            ExpressionTable rt = null;
            tablePath = DirUtils.convertAbsoluteDir(PropertyDB.getInstance().getProperty("FILTER_FILE"));
            if (tablePath != null) {
                rt = ExpressionTable.readFile(tablePath);
            }
            if (rt == null) {
                if (initAlways) {
                    if (PropertyDB.getInstance().isDebug(7)) {
                        System.out.println("Failed to read/locate: " + tablePath + " starting with an empty table.");
                    }
                } else {
                    return;
                }
                rt = new ExpressionTable(tablePath);
            }
            this.fltBuilder = new FilterBuilder((Frame)this, "Filter Builder :" + tablePath, true, rt);
            this.fltBuilder.pack();
        }
    }

    private void showExpressionBuilder() {
        this.initfltBuilder(true);
        Point p = this.getLocation();
        Dimension d2 = this.getSize();
        p.move(p.x + 100, p.y + d2.height / 4);
        this.fltBuilder.setLocation(p);
        this.fltBuilder.setVisible(true);
        if (this.fltBuilder.getSelectedFilter() != null) {
            this.setFilter(this.fltBuilder.getSelectedFilter());
        }
    }

    private void setFilter(OBComponentFilter filter) {
        OBComponentFilter currentFilter = this.dataModel.getFileFilter();
        if (currentFilter != filter) {
            this.dataModel.setFileFilter(filter);
            if (currentFilter != null) {
                this.refreshModel();
            }
            if (filter != null) {
                Cursor c2 = this.getCursor();
                this.setCursor(this.waitCursor);
                this.ensureModelUpdatesComplete();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GasganoDisplay.this.dataModel.applyFilter();
                    }
                }).start();
                this.setCursor(c2);
            }
            this.fsTreeModel.setRootLabel(null);
            this.fsTreeModel.updateTree();
            this.showBlankDetail(true);
            this.fsTree.getTree().expandRow(0);
        }
    }

    private void setupFileListPane() {
        this.fileListPane = new FileListPane();
        this.fileListPane.addListSelectionListener(this.displayOrganizer);
        for (int i = 0; i < tabLabels.length; ++i) {
            FileListModel lm = new FileListModel(null, tabLabels[i], emptyListLabels[i]);
            this.fileListPane.addList(lm);
        }
    }

    private void registerKeyboard() {
        KeyStroke AltA = KeyStroke.getKeyStroke(65, 2, false);
        KeyStroke AltQ = KeyStroke.getKeyStroke(81, 2, false);
        KeyStroke AltS = KeyStroke.getKeyStroke(83, 2, false);
        KeyStroke AltR = KeyStroke.getKeyStroke(82, 2, false);
        KeyStroke AltF = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke AltG = KeyStroke.getKeyStroke(71, 2, false);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        }, AltQ, 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GasganoDisplay.this.toggleScriptBoard();
            }
        }, AltS, 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GasganoDisplay.this.generateReport();
            }
        }, AltR, 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (GasganoDisplay.this.dataModel.getFileFilter() == null) {
                    GasganoDisplay.this.showExpressionBuilder();
                } else {
                    GasganoDisplay.this.setFilter(null);
                }
            }
        }, AltF, 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GasganoDisplay.this.addFile();
            }
        }, AltA, 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GasganoDisplay.internalStatusReport();
                GasganoDisplay.this.validate();
            }
        }, AltG, 2);
    }

    private void addMenu() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem mi = null;
        mi = new JMenuItem(addRmFileLabel);
        mi.addActionListener(this);
        menu.add(mi);
        final JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Show Frame Assoc.");
        cbmi.setSelected(this.isShowFileLists());
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.setShowFileLists(cbmi.isSelected());
            }
        });
        menu.add(cbmi);
        mi = new JMenuItem(addFilterLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(rmFilterLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(reclassifyLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(refreshLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(editPreferencesLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(quitLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mb.add(menu);
        mb.add(this.getSelectedFilesMenu());
        menu = new JMenu("Tools");
        mi = new JMenuItem(classBldrLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(kwListEditorLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(scriptBoardLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mb.add(menu);
        menu = new JMenu("Help");
        mi = new JMenuItem(overviewLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(initialSetupLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(userInputLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(preferencesLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(associationLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mi = new JMenuItem(externalCommandsLabel);
        mi.addActionListener(this);
        menu.add(mi);
        mb.add(menu);
        this.setJMenuBar(mb);
    }

    private void setupRecipePanelMenus(final JMenu recipeMenu, final JMenu queueMenu) {
        ActionListener loadRecipeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.showRecipePanel(e2.getActionCommand());
            }
        };
        final JMenu openRecipeMenu = new JMenu(openRecipeLabel);
        ArrayList<String> recipeNames = new ArrayList<String>();
        Iterator i = GasProp.getProperties().getRecipeLibraryNames();
        while (i.hasNext()) {
            String libName = (String)i.next();
            List recipes = GasProp.getProperties().getRecipesForLibrary(libName);
            if (recipes == null) continue;
            for (String name : recipes) {
                recipeNames.add(name);
            }
        }
        Collections.sort(recipeNames);
        for (String name : recipeNames) {
            JMenuItem recMi = new JMenuItem(name);
            recMi.addActionListener(loadRecipeAction);
            openRecipeMenu.add(recMi);
        }
        openRecipeMenu.setEnabled(openRecipeMenu.getItemCount() > 0);
        final ActionListener addFramesToRecipeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.addSelectedFilesToRecipePanel(e2.getActionCommand(), false);
            }
        };
        final ActionListener addFramesToQueueAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.addSelectedFilesToRecipePanel(e2.getActionCommand(), true);
            }
        };
        recipeMenu.add(openRecipeMenu);
        recipeMenu.setEnabled(recipeMenu.isEnabled());
        queueMenu.setEnabled(false);
        this.recipePanels.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.rebuildMenu(recipeMenu, addFramesToRecipeAction);
                this.rebuildMenu(queueMenu, addFramesToQueueAction);
                recipeMenu.add(openRecipeMenu);
                recipeMenu.setEnabled(openRecipeMenu.isEnabled() || recipeMenu.getMenuComponentCount() > 1);
                queueMenu.setEnabled(queueMenu.getMenuComponentCount() > 0);
            }

            private void rebuildMenu(JMenu menu, ActionListener listener) {
                while (menu.getMenuComponentCount() > 0) {
                    menu.remove(0);
                }
                Iterator i = GasganoDisplay.this.recipePanels.getRecipePanelNames();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    CPLFrame recipePanel = GasganoDisplay.this.recipePanels.getRecipePanel(name);
                    JMenuItem panelMItem = new JMenuItem(name);
                    panelMItem.addActionListener(listener);
                    menu.add(panelMItem);
                }
            }
        });
    }

    private JMenu getSelectedFilesMenu() {
        JMenu selectedFilesMenu = new JMenu("Selected files");
        this.selectedFilesPopupMenu = new JPopupMenu();
        AbstractAction action = new AbstractAction(externalViewerLabel){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.treeControlPanel.callExternalViewer();
            }
        };
        selectedFilesMenu.add(new JMenuItem(action));
        this.selectedFilesPopupMenu.add(new JMenuItem(action));
        JMenu recipePanelMenu = new JMenu(toRecipeLabel);
        JMenu queuePanelMenu = new JMenu(toQueueLabel);
        this.setupRecipePanelMenus(recipePanelMenu, queuePanelMenu);
        selectedFilesMenu.add(recipePanelMenu);
        selectedFilesMenu.add(queuePanelMenu);
        JMenu recipePanelPopupMenu = new JMenu(toRecipeLabel);
        JMenu queuePanelPopupMenu = new JMenu(toQueueLabel);
        this.setupRecipePanelMenus(recipePanelPopupMenu, queuePanelPopupMenu);
        this.selectedFilesPopupMenu.add(recipePanelPopupMenu);
        this.selectedFilesPopupMenu.add(queuePanelPopupMenu);
        action = new AbstractAction(reportFileLabel){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.generateReport();
            }
        };
        selectedFilesMenu.add(new JMenuItem(action));
        this.selectedFilesPopupMenu.add(new JMenuItem(action));
        action = new AbstractAction(mvFileLabel){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.copySelectedFiles(true);
            }
        };
        selectedFilesMenu.add(new JMenuItem(action));
        this.selectedFilesPopupMenu.add(new JMenuItem(action));
        action = new AbstractAction(cpFileLabel){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.copySelectedFiles(false);
            }
        };
        selectedFilesMenu.add(new JMenuItem(action));
        this.selectedFilesPopupMenu.add(new JMenuItem(action));
        action = new AbstractAction(tarFileLabel){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.tarSelectedFiles();
            }
        };
        selectedFilesMenu.add(new JMenuItem(action));
        this.selectedFilesPopupMenu.add(new JMenuItem(action));
        action = new AbstractAction(appFileLabel){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GasganoDisplay.this.selectedFilesToCommand(null, true, false, false);
            }
        };
        selectedFilesMenu.add(new JMenuItem(action));
        this.selectedFilesPopupMenu.add(new JMenuItem(action));
        return selectedFilesMenu;
    }

    private boolean loadAndUpdateClassifier(String ruleFile) {
        boolean retVal = false;
        try {
            this.dataModel.setClassifier(DFSDataModel.createClassifier(new FileInputStream(ruleFile)));
            retVal = true;
        }
        catch (FileNotFoundException e2) {
            GUIUtils.userMessage(this, "Unable to access rules file [" + ruleFile + "].\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            GUIUtils.userError(this, "The rule file contains errors: \n\n" + e3.getMessage());
        }
        catch (Exception e4) {
            GUIUtils.userMessage(this, "Unexpected exception while accessing rules file [" + ruleFile + "].\n" + e4.getMessage());
        }
        catch (Error e5) {
            GUIUtils.userMessage(this, "Unexpected error while accessing rules file [" + ruleFile + "].\n" + e5.getMessage());
        }
        return retVal;
    }

    private void reclassifyModel() {
        Cursor c2 = this.getCursor();
        this.setCursor(this.waitCursor);
        this.dataModel.reclassify();
        this.setCursor(c2);
        this.fsTreeModel.updateTree();
        this.showBlankDetail(true);
    }

    private void ensureModelUpdatesComplete() {
        while (this.dataModel.isUpdating()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void refreshModelWithoutWindow() {
        if (!this.dataModel.isUpdating()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    GasganoDisplay.this.dataModel.update(GasganoDisplay.this.dataModel.getFileSet());
                }
            }).start();
        }
    }

    private void refreshModel() {
        this.refreshModel(true);
    }

    private void refreshModel(boolean visible) {
        Point topLeft = this.getLocation();
        Dimension size = this.getSize();
        if (!this.dataModel.isUpdating()) {
            DataModelBuilder updater = new DataModelBuilder(this.dataModel, this, "Updating data from disk", true);
            topLeft.move(topLeft.x + size.width / 2 - 150, topLeft.y + size.height / 3);
            updater.setLocation(topLeft);
            updater.initTask();
            updater.pack();
            if (visible) {
                updater.setSize(300, 250);
            } else {
                updater.setSize(0, 0);
            }
            updater.setVisible(true);
            this.showBlankDetail(true);
            this.fsTree.getTree().expandRow(0);
        }
    }

    public void showBlankDetail(boolean clearSelection) {
        if (this.blankDetail == null) {
            this.blankDetail = new JPanel();
        }
        this.fileListPane.emptyLists();
        this.setDetailComponent(this.blankDetail);
        if (clearSelection) {
            this.displayOrganizer.clearTreeSelection();
        }
    }

    private void addFile() {
        int i;
        boolean timerOn = false;
        Vector currentSelection = new Vector();
        String[] dirs = this.fileSelections.getDirs();
        if (this.updateTimer.isRunning()) {
            timerOn = true;
            this.updateTimer.stop();
        }
        for (i = 0; i < dirs.length; ++i) {
            currentSelection.addElement(dirs[i]);
        }
        if (this.fileListChooser == null) {
            this.fileListChooser = new FileListChooser();
        }
        this.fileListChooser.setFileList(currentSelection);
        if (JOptionPane.showConfirmDialog(this, this.fileListChooser, "Edit directory set" + (timerOn ? " / Timer suspended" : ""), 2, -1) == 0) {
            currentSelection = this.fileListChooser.getFileList();
            dirs = new String[currentSelection.size()];
            for (i = 0; i < currentSelection.size(); ++i) {
                dirs[i] = (String)currentSelection.elementAt(i);
            }
            this.ensureModelUpdatesComplete();
            this.updateFileSelectionAndRefresh(dirs, true);
        }
        if (timerOn) {
            this.updateTimer.restart();
        }
    }

    private void updateFileSelectionAndRefreshQuietly(String[] dirs, boolean replace) {
        this.updateFileSelection(dirs, replace);
        this.refreshModel(false);
    }

    private void updateFileSelectionAndRefresh(String[] dirs, boolean replace) {
        this.updateFileSelection(dirs, replace);
        this.refreshModel();
    }

    private void replaceFileSelection(String[] dirs) {
        this.updateFileSelection(dirs, true);
    }

    private void updateFileSelection(String[] dirs, boolean replace) {
        Vector existingDirs = replace ? new Vector() : this.fileSelections.getFileList();
        String[] newDirs = new String[dirs.length + existingDirs.size()];
        int newDirIdx = 0;
        try {
            int i = 0;
            while (i < existingDirs.size()) {
                newDirs[newDirIdx] = (String)existingDirs.elementAt(i);
                ++i;
                ++newDirIdx;
            }
            i = 0;
            while (i < dirs.length) {
                newDirs[newDirIdx] = dirs[i];
                ++i;
                ++newDirIdx;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.dataModel.removeFileSelectionModel(this.fileSelections);
        try {
            this.fileSelections = new DirectoryFileSelectionModel(newDirs);
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage().length() > 500 ? ioe.getMessage().substring(0, 500) + "[...]" : ioe.getMessage();
            GUIUtils.userMessage(this, "One or more errors found while initializing DirectoryFileSelectionModel: " + errMsg);
        }
        this.dataModel.addFileSelectionModel(this.fileSelections);
    }

    private JFileChooser getFileChooser(int selectionType, int dialogType, String textMsg, String approveMsg) {
        if (this.fileChooser == null) {
            String scriptDir = new String(System.getProperties().getProperty("user.home") + File.separator + PropertyDB.getInstance().getProperty("SCRIPTS_DIR"));
            this.fileChooser = new SwingFileChooser(new File(scriptDir));
        } else {
            this.fileChooser.rescanCurrentDirectory();
        }
        this.fileChooser.setFileSelectionMode(selectionType);
        this.fileChooser.setDialogType(dialogType);
        this.fileChooser.setDialogTitle(textMsg);
        this.fileChooser.setApproveButtonText(approveMsg);
        this.fileChooser.setMultiSelectionEnabled(false);
        return this.fileChooser;
    }

    public void selectedFilesToCommand(String filePath, boolean confirm, boolean classSupply, boolean backGround) {
        Vector files = this.fsTree.getSelectedFiles();
        String selectedDir = this.fsTree.getSelectedDir();
        String selectedExe = null;
        if (files.size() == 0 && selectedDir == null) {
            GUIUtils.userMessage(this, "No files have been selected.");
            return;
        }
        if (filePath == null) {
            JFileChooser exeChooser = this.getFileChooser(0, 0, "Select application to run", "OK");
            if (exeChooser.showOpenDialog(this) == 0 && exeChooser.getSelectedFile() != null) {
                selectedExe = exeChooser.getSelectedFile().getPath();
            }
        } else {
            selectedExe = filePath;
        }
        int maxFileNamesToDisplay = 15;
        if (selectedExe != null) {
            StringBuffer command = new StringBuffer();
            StringBuffer displayCommand = new StringBuffer();
            if (backGround) {
                command.append("/usr/bin/sh -e '( ");
            }
            command.append(selectedExe);
            displayCommand.append(command.toString());
            if (files.size() == 0) {
                command.append(" " + selectedDir);
                displayCommand.append(" " + selectedDir + "\n");
            } else {
                int i;
                String[] fileNames = new String[files.size()];
                for (i = 0; i < files.size(); ++i) {
                    fileNames[i] = files.elementAt(i).toString();
                }
                Sorting.sort(fileNames, 0, fileNames.length);
                for (i = 0; i < files.size(); ++i) {
                    command.append(" " + fileNames[i]);
                    if (i < maxFileNamesToDisplay) {
                        displayCommand.append("\n" + fileNames[i]);
                    } else if (i == maxFileNamesToDisplay) {
                        displayCommand.append("\n...(total " + files.size() + " files).");
                    }
                    if (!classSupply) continue;
                    String comp = fileNames[i];
                    String classification = this.dataModel.getClassificationForName(comp);
                    command.append(" " + classification);
                    displayCommand.append(" " + classification);
                }
            }
            if (backGround) {
                command.append(" )' &");
                displayCommand.append(" )' &");
            }
            if (confirm) {
                if (JOptionPane.showConfirmDialog(this, displayCommand.toString(), "Run the following command?", 0) == 0) {
                    GUIUtils.runCommandInGui(this, command.toString(), 0);
                }
            } else {
                GUIUtils.runCommandInGui(this, command.toString(), 0);
            }
        }
    }

    private void addFileToSelection(String filePath) {
        if (!this.fileSelectionExists(filePath)) {
            int numDirs = this.fileSelections.getDirs().length;
            String[] dirs = new String[numDirs + 1];
            System.arraycopy(this.fileSelections.getDirs(), 0, dirs, 0, numDirs);
            dirs[numDirs] = filePath;
            this.replaceFileSelection(dirs);
        }
    }

    public PasswordSource getPasswordSource() {
        return new PasswordPrompt(this);
    }

    private boolean fileSelectionExists(String file) {
        boolean rc = false;
        String[] dirs = this.fileSelections.getDirs();
        for (int i = 0; i < dirs.length && !rc; ++i) {
            if (!dirs[i].equals(file)) continue;
            rc = true;
        }
        return rc;
    }

    private void tarSelectedFiles() {
        String selectedTarFile = null;
        JFileChooser tarChooser = this.getFileChooser(0, 0, "Enter destination TAR file", "tar");
        Vector files = this.fsTree.getSelectedFiles();
        if (files.size() == 0) {
            GUIUtils.userMessage(this, "No files have been selected.");
            return;
        }
        if (tarChooser.showOpenDialog(this) == 0 && tarChooser.getSelectedFile() != null) {
            selectedTarFile = tarChooser.getSelectedFile().getPath();
            StringBuffer command = new StringBuffer();
            if (System.getProperties().getProperty("os.name").equals("HP-UX")) {
                command.append("tar -cbf 20 " + selectedTarFile + " ");
            } else {
                command.append("tar -cf " + selectedTarFile + " ");
            }
            for (int i = 0; i < files.size(); ++i) {
                File file = new File(files.elementAt(i).toString());
                command.append(" -C " + file.getParent() + " " + file.getName());
            }
            GUIUtils.runCommandInGui(this, command.toString(), 0);
        }
    }

    private void copySelectedFiles(boolean move) {
        JFileChooser cpMvChooser = null;
        String selectedDir = null;
        Vector files = this.fsTree.getSelectedFiles();
        if (files.size() == 0) {
            GUIUtils.userMessage(this, "No files have been selected.");
            return;
        }
        cpMvChooser = move ? this.getFileChooser(1, 0, "Select target directory for move.", "Move") : this.getFileChooser(1, 0, "Select target directory for copy.", "Copy");
        if (cpMvChooser.showOpenDialog(this) == 0 && cpMvChooser.getSelectedFile() != null) {
            File tmpFile = cpMvChooser.getSelectedFile();
            if (!tmpFile.canWrite()) {
                GUIUtils.userMessage(this, "The directory " + tmpFile.getPath() + "\nis not writable");
                return;
            }
            selectedDir = cpMvChooser.getSelectedFile().getPath();
            StringBuffer command = new StringBuffer();
            if (move) {
                command.append("mv");
            } else {
                command.append("cp");
            }
            for (int i = 0; i < files.size(); ++i) {
                command.append(" " + files.elementAt(i).toString());
            }
            command.append(" " + selectedDir);
            if (files.size() == 0) {
                GUIUtils.userMessage(this, "No files selected");
            } else if (selectedDir.length() == 0) {
                GUIUtils.userMessage(this, "No target directory selected");
            } else {
                GUIUtils.runCommandInGui(this, command.toString(), 0);
                if (move) {
                    this.addFileToSelection(selectedDir);
                    this.refreshModel();
                }
            }
        }
    }

    public void generateReport() {
        int i;
        Vector files = null;
        Vector keywords = null;
        Vector columns = null;
        Object myEnum = null;
        Cursor currentCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        files = this.fsSelected ? this.fsTree.getSelectedOBComponents() : this.dbTree.getSelectedOBComponents();
        for (i = files.size() - 1; i >= 0; --i) {
            if (files.elementAt(i) instanceof DBOBComponent) continue;
            OBComponent obc = (OBComponent)files.elementAt(i);
            if (!(obc instanceof KeywordContainerOBComponent)) {
                files.removeElementAt(i);
                continue;
            }
            files.setElementAt(obc.getSourceFile(), i);
        }
        if (files.size() == 0) {
            GUIUtils.userMessage(this, "No FITS files have been selected.");
            this.setCursor(currentCursor);
            return;
        }
        if (this.kwListLoader == null) {
            this.kwListLoader = new KeywordListLoader();
        }
        if (JOptionPane.showConfirmDialog(this, this.kwListLoader, "Load keyword list", 2, -1) == 0) {
            keywords = this.kwListLoader.getKeywordTable().getKeywordList();
            columns = this.kwListLoader.getKeywordTable().getKeywordLabelList();
            for (i = 0; i < keywords.size(); ++i) {
                String colName = (String)columns.elementAt(i);
                if (colName != null && colName.length() != 0) continue;
                columns.setElementAt(keywords.elementAt(i), i);
            }
        }
        if (keywords != null) {
            FitsFileReport rep = new FitsFileReport(files, keywords, columns);
            ReportViewer viewer = new ReportViewer("Report of selected selected files", rep);
            viewer.pack();
            viewer.setSize(1100, 500);
            viewer.setLocation(100, 300);
            viewer.setVisible(true);
        }
        this.setCursor(currentCursor);
    }

    public void unLoadAll() {
        try {
            this.backupFileSelections = new DirectoryFileSelectionModel(this.fileSelections.getDirs());
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage().length() > 500 ? ioe.getMessage().substring(0, 500) + "[...]" : ioe.getMessage();
            GUIUtils.userMessage(this, "One or more errors found while initializing DirectoryFileSelectionModel: " + errMsg);
        }
        this.updateFileSelectionAndRefreshQuietly(new String[0], true);
        this.ensureModelUpdatesComplete();
    }

    public void reLoadPrevious() {
        this.dataModel.addFileSelectionModel(this.backupFileSelections);
        this.fileSelections = this.backupFileSelections;
        this.refreshModel();
    }

    @Override
    public void newProperties(boolean shutdown) {
        Keyword[] cols;
        Vector displayCols;
        int i;
        int debugLev = 0;
        int updateMinutes = 0;
        boolean refresh = false;
        boolean refreshTable = false;
        String tmpString = null;
        Cursor c2 = this.getCursor();
        Vector desiredSel = null;
        if (shutdown) {
            this.unLoadAll();
        }
        if (shutdown) {
            this.reLoadPrevious();
        }
        GasProp newInstance = GasProp.getProperties();
        newInstance.put("FRAME_BOUNDS", GUIUtils.rectToString(this.getBounds()));
        if (!newInstance.saveProperties()) {
            GUIUtils.userMessage(this, "Failed to save preferences file: " + newInstance.getSourceFile() + ".");
        }
        this.setCursor(this.waitCursor);
        desiredSel = GasProp.stringScanner(newInstance.getProperty("DATA_FILES"), ';');
        if (!(desiredSel == null || this.backupPrefs.getProperty("DATA_FILES") != null && newInstance.getProperty("DATA_FILES").equals(this.backupPrefs.getProperty("DATA_FILES")))) {
            Vector currentSel = new Vector();
            for (int i2 = 0; i2 < desiredSel.size(); ++i2) {
                File tmpF = new File((String)desiredSel.elementAt(i2));
                try {
                    desiredSel.setElementAt(tmpF.getCanonicalPath(), i2);
                    continue;
                }
                catch (IOException ioe) {
                    desiredSel.removeElementAt(i2);
                }
            }
            String[] dirs = this.fileSelections.getDirs();
            for (i = 0; i < dirs.length; ++i) {
                currentSel.addElement(dirs[i]);
            }
            if (!desiredSel.toString().equals(currentSel.toString())) {
                currentSel = desiredSel;
                dirs = new String[currentSel.size()];
                for (i = 0; i < currentSel.size(); ++i) {
                    dirs[i] = (String)currentSel.elementAt(i);
                    this.replaceFileSelection(dirs);
                    refresh = true;
                }
            }
        }
        if (!PropertyDB.getInstance().getProperty("DISPLAY_COLUMNS").equals(this.backupPrefs.getProperty("DISPLAY_COLUMNS"))) {
            displayCols = GasProp.getProperties().fsDisplayColumns;
            cols = new Keyword[displayCols.size()];
            for (i = 0; i < cols.length; ++i) {
                cols[i] = new Keyword((String)displayCols.elementAt(i), null);
            }
            this.dataModel.setDefaultFileDescription(new BasicFileDescription(cols));
            this.dataModel.resetDescription();
            refresh = true;
            refreshTable = true;
        }
        if (!PropertyDB.getInstance().getProperty("DBOBS_DISPLAY_COLUMNS").equals(this.backupPrefs.getProperty("DBOBS_DISPLAY_COLUMNS")) && this.safeEnvironment) {
            displayCols = GasProp.getProperties().dbDisplayColumns;
            cols = new Keyword[displayCols.size()];
            for (i = 0; i < cols.length; ++i) {
                cols[i] = new Keyword((String)displayCols.elementAt(i), null);
            }
            this.dbDataModel.setDefaultFileDescription(new BasicFileDescription(cols));
            this.setDatabasePanelEnabled(false);
            this.dbTreeModel.toggleColumn();
            if (this.dbTreeModel.periodSelectionChanged()) {
                this.setDatabasePanelEnabled(true);
            }
            this.dbTreeModel.updateTree();
            ((AbstractTableModel)this.dbTree.getModel()).fireTableStructureChanged();
            this.dbTree.setColumnWidths();
        }
        tmpString = PropertyDB.getInstance().getProperty("CLASSRULE_FILE");
        if (!this.backupPrefs.getProperty("CLASSRULE_FILE").toString().equals(tmpString) && tmpString != null) {
            this.loadAndUpdateClassifier(tmpString);
        }
        tmpString = PropertyDB.getInstance().getProperty("FILTER_FILE");
        if (!this.backupPrefs.getProperty("FILTER_FILE").toString().equals(tmpString) && tmpString != null) {
            this.fltBuilder = null;
            this.initfltBuilder(true);
        }
        if ((tmpString = PropertyDB.getInstance().getProperty("VERBOSE_LEVEL")) != null) {
            debugLev = Integer.parseInt(tmpString);
            PropertyDB.getInstance().setDebugLevel(debugLev);
        }
        if ((tmpString = PropertyDB.getInstance().getProperty("UPDATE_TIMER")) != null) {
            updateMinutes = Integer.parseInt(tmpString);
            if (this.updateTimer.getDelay() != updateMinutes * 60000) {
                this.updateTimer.stop();
                this.updateTimer.setDelay(updateMinutes * 60000);
                if (updateMinutes != 0) {
                    this.updateTimer.restart();
                }
            }
        }
        tmpString = PropertyDB.getInstance().getProperty("SHORT_FILENAME");
        if (!this.backupPrefs.getProperty("SHORT_FILENAME").toString().equals(tmpString)) {
            if (tmpString.equals("true")) {
                OBComponent.setShortName(true);
            } else {
                OBComponent.setShortName(false);
            }
            this.fsTreeModel.updateTree();
            refresh = true;
            refreshTable = true;
        }
        tmpString = PropertyDB.getInstance().getProperty("RADEC_CONVERSION");
        if (!this.backupPrefs.getProperty("RADEC_CONVERSION").toString().equals(tmpString)) {
            if (tmpString.equals("true")) {
                FitsFile.setRadecConversion(true);
            } else {
                FitsFile.setRadecConversion(false);
            }
            this.dataModel.resetDescription();
            this.fsTreeModel.updateTree();
            refresh = true;
            refreshTable = true;
        }
        tmpString = PropertyDB.getInstance().getProperty("OB_STATUS_FROM_DB_REQUIRED");
        if (!this.backupPrefs.getProperty("OB_STATUS_FROM_DB_REQUIRED").toString().equals(tmpString)) {
            GUIUtils.userMessage(this, "You will have to restart the application for the OB STATUS change to take place");
        }
        if (this.safeEnvironment) {
            tmpString = PropertyDB.getInstance().getProperty("DBOBS_REQUIRED");
            if (!this.backupPrefs.getProperty("DBOBS_REQUIRED").equals(tmpString)) {
                if (tmpString.equals("true")) {
                    this.setDatabaseEnabled(true);
                } else {
                    this.setDatabaseEnabled(false);
                }
            }
        }
        if (refresh) {
            this.refreshModel();
        }
        if (refreshTable) {
            this.fsTreeModel.toggleColumn();
            AbstractTableModel tModel = (AbstractTableModel)this.fsTree.getModel();
            tModel.fireTableStructureChanged();
            this.fsTree.setColumnWidths();
        }
        this.setCursor(c2);
        this.backupPrefs = null;
    }

    public void initializeFileSelections() {
        String dirsString = new String();
        Vector dirsVector = null;
        dirsString = PropertyDB.getInstance().getProperty("DATA_FILES");
        if (dirsString == null) {
            return;
        }
        dirsVector = GasProp.stringScanner(dirsString, ';');
        if (dirsVector.size() == 0) {
            return;
        }
        for (int i = 0; i < dirsVector.size(); ++i) {
            File tmpF = new File((String)dirsVector.elementAt(i));
            if (!(tmpF.exists() && tmpF.isDirectory() && tmpF.isAbsolute() && tmpF.canRead())) {
                dirsVector.removeElementAt(i);
                continue;
            }
            try {
                dirsVector.setElementAt(tmpF.getCanonicalPath(), i);
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        String[] dirs = new String[dirsVector.size()];
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i] = (String)dirsVector.elementAt(i);
        }
        this.updateFileSelectionAndRefresh(dirs, true);
    }

    public void retrieveFilesFromDb(final Enumeration ee) {
        if (this.retrieveFileChooser == null) {
            this.retrieveFileChooser = this.getFileChooser(1, 0, "Select  Destination Directory ", "Retrieve");
        }
        if (this.retrieveFileChooser.showOpenDialog(this) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int rc = FileDownloader.retrieveFilesFromDb(ee, GasganoDisplay.this.retrieveFileChooser.getSelectedFile().getPath());
                    if (rc != 0) {
                        GUIUtils.userMessage(GasganoDisplay.this, "Retrieve failed!");
                    }
                }
            }).start();
        }
    }

    public boolean isModelEmpty() {
        return this.dataModel.isModelEmpty();
    }

    public static void internalStatusReport() {
        Runtime r = Runtime.getRuntime();
        System.out.print("Memory: Total/Free " + r.totalMemory() + " / " + r.freeMemory());
        DFSDataModel.getDataModel().displayHashtableSizes();
        System.out.println("Header Read " + FitsFile.readHeaderNumber + " in Avg: " + (double)FitsFile.readHeaderTime / (double)FitsFile.readHeaderNumber + "ms");
        System.out.println("Overall read " + KeywordContainerOBComponent.initNumber + " in Avg: " + (double)KeywordContainerOBComponent.initTime / (double)KeywordContainerOBComponent.initNumber + " ms");
        System.out.println("");
    }

    private void setDetailComponent(JComponent detail) {
        Cursor c2 = this.getCursor();
        this.setCursor(this.waitCursor);
        JSplitPane spane = this.getDetailPanelContainer();
        int currentLoc = spane.getDividerLocation();
        if (spane.getBottomComponent() != null) {
            spane.remove(spane.getBottomComponent());
        }
        detail.setPreferredSize(new Dimension(100, 100));
        spane.setBottomComponent(detail);
        spane.setDividerLocation(currentLoc);
        this.setCursor(c2);
    }

    private void setHideFileListPanel(boolean hide) {
    }

    public boolean isShowFileLists() {
        return this.showFileLists;
    }

    private void setShowFileLists(boolean b2) {
        if (this.showFileLists != b2) {
            this.showFileLists = b2;
            this.organizePanels();
        }
    }

    private void organizePanels() {
        if (this.isShowFileLists()) {
            Component detail = this.splitPane.getBottomComponent();
            this.splitPane.remove(detail);
            this.splitPane.setBottomComponent(this.lowerSplitPane);
            this.lowerSplitPane.setBottomComponent(detail);
        } else {
            Component detail = this.lowerSplitPane.getBottomComponent();
            this.lowerSplitPane.remove(detail);
            this.splitPane.remove(this.lowerSplitPane);
            this.splitPane.setBottomComponent(detail);
        }
    }

    class DisplayOrganizer
    implements TreeSelectionListener,
    ListSelectionListener {
        private Vector[] lists = new Vector[4];
        private Vector rawFileList = new Vector();
        private Vector masterCalibFileList = null;
        private Vector rbFileList = null;
        private Vector productFileList = null;
        private TreePath lastSelectedPath = null;
        private DBOBComponent selectedDbComponent = null;
        private boolean noProcess = false;

        public DisplayOrganizer() {
            this.lists[0] = this.rawFileList;
            this.masterCalibFileList = new Vector();
            this.lists[1] = this.masterCalibFileList;
            this.rbFileList = new Vector();
            this.lists[2] = this.rbFileList;
            this.productFileList = new Vector();
            this.lists[3] = this.productFileList;
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            Object node = null;
            OBComponent obc = null;
            DBOBComponent dbobc = null;
            ResultsComponent resobc = null;
            TreePath tp = null;
            if (GasganoDisplay.this.fsSelected) {
                if (this.noProcess) {
                    this.noProcess = false;
                    return;
                }
                tp = GasganoDisplay.this.fsTree.getTree().getSelectionPath();
            }
            if (GasganoDisplay.this.dbSelected) {
                tp = GasganoDisplay.this.dbTree.getTree().getSelectionPath();
            }
            if (GasganoDisplay.this.resSelected) {
                tp = GasganoDisplay.this.resTree.getTree().getSelectionPath();
            }
            if (!(tp == null || this.lastSelectedPath != null && tp.equals(this.lastSelectedPath))) {
                node = tp.getLastPathComponent();
                this.lastSelectedPath = tp;
            }
            if (node == null || !(node instanceof OBComponent) && GasganoDisplay.this.fsSelected || !(node instanceof DBOBComponent) && GasganoDisplay.this.dbSelected || !(node instanceof ResultsComponent) && GasganoDisplay.this.resSelected) {
                return;
            }
            this.rawFileList.removeAllElements();
            this.masterCalibFileList.removeAllElements();
            this.rbFileList.removeAllElements();
            this.productFileList.removeAllElements();
            if (this.selectedDbComponent != null) {
                this.selectedDbComponent.freeHeaderMemory();
            }
            if (GasganoDisplay.this.fsSelected) {
                Vector[] boldFaceFonts = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector()};
                obc = (OBComponent)node;
                GasganoDisplay.this.dataModel.getAssociatedFiles(obc, this.rawFileList, this.masterCalibFileList, this.rbFileList, this.productFileList);
                GasganoDisplay.this.fileListPane.setActiveElements(boldFaceFonts);
                this.displayLists();
                this.showComponentDetail(obc);
                this.selectedDbComponent = null;
            }
            if (GasganoDisplay.this.dbSelected) {
                dbobc = (DBOBComponent)node;
                this.showComponentDetail(dbobc);
                this.selectedDbComponent = dbobc;
            }
            if (GasganoDisplay.this.resSelected) {
                resobc = (ResultsComponent)node;
                this.showComponentDetail(resobc);
            }
        }

        private void displayLists() {
            for (int i = 0; i < tabLabels.length; ++i) {
                FileListModel lm = new FileListModel(this.lists[i], tabLabels[i], emptyListLabels[i]);
                GasganoDisplay.this.fileListPane.setListModel(lm, i);
            }
        }

        public void clearTreeSelection() {
            GasganoDisplay.this.fsTree.clearSelection();
            this.lastSelectedPath = null;
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            ReductionBlockCommon rbSelected = null;
            Vector[] boldFaceFonts = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector()};
            if (!evt.getValueIsAdjusting()) {
                int index;
                int listSize = 0;
                JList selectedList = (JList)evt.getSource();
                if (selectedList.isSelectedIndex(index = selectedList.getLeadSelectionIndex())) {
                    OBComponent obc = null;
                    String fileSelected = (String)selectedList.getModel().getElementAt(index);
                    listSize = selectedList.getModel().getSize();
                    obc = GasganoDisplay.this.dataModel.getObComponentByArcname(fileSelected);
                    if (obc == null) {
                        obc = new NotFoundOBComponent(fileSelected);
                        if (fileSelected.startsWith("Virtual Reduction Block")) {
                            String triggerName = null;
                            VirtualReductionBlockOBComponent vrbobc = null;
                            try {
                                triggerName = fileSelected.substring(fileSelected.indexOf("(") + 1, fileSelected.lastIndexOf(")"));
                                vrbobc = GasganoDisplay.this.dataModel.getAssociatedVRB(triggerName);
                                if (vrbobc != null) {
                                    obc = vrbobc;
                                }
                                rbSelected = vrbobc;
                            }
                            catch (StringIndexOutOfBoundsException e2) {}
                        }
                    } else {
                        this.noProcess = true;
                        GasganoDisplay.this.treeControlPanel.searchTree(DFSFile.getFileName(obc.getId()));
                        if (obc instanceof ReductionBlockOBComponent) {
                            rbSelected = (ReductionBlockCommon)((Object)obc);
                        }
                    }
                    if (rbSelected != null && listSize > 1) {
                        Enumeration e3 = null;
                        e3 = rbSelected.getProductFileNames().elements();
                        while (e3.hasMoreElements()) {
                            boldFaceFonts[3].addElement(e3.nextElement());
                        }
                        e3 = rbSelected.getMasterCalibFileNames().elements();
                        while (e3.hasMoreElements()) {
                            boldFaceFonts[1].addElement(e3.nextElement());
                        }
                        e3 = rbSelected.getInputFileNames().elements();
                        while (e3.hasMoreElements()) {
                            boldFaceFonts[0].addElement(e3.nextElement());
                        }
                    }
                    this.showComponentDetail(obc);
                    GasganoDisplay.this.fileListPane.setActiveElements(boldFaceFonts);
                }
            }
        }

        public void showComponentDetail(OBComponent obc) {
            GasganoDisplay.this.setDetailComponent(obc.getDisplayComponent());
        }

        public void showComponentDetail(DBOBComponent dbobc) {
            GasganoDisplay.this.dbDataModel.selectSingleFrame(dbobc);
            GasganoDisplay.this.setDetailComponent(dbobc.getDisplayComponent());
        }

        public void showComponentDetail(ResultsComponent resobc) {
            GasganoDisplay.this.setDetailComponent(resobc.getDisplayComponent());
        }
    }

    class PasswordPrompt
    implements PasswordSource {
        private String password = null;
        private Component dialogParent = null;

        PasswordPrompt(Component comp) {
            this.dialogParent = comp;
        }

        @Override
        public String getPassword(String userInfo, String message, String prop) {
            if (this.password != null) {
                return this.password;
            }
            this.password = this.popupPasswordPrompt(userInfo, message, prop);
            return this.password;
        }

        @Override
        public String popupPasswordPrompt(String userInfo, String message, String prop) {
            String tmpPassword = null;
            if (this.dialogParent != null) {
                JPanel panel = new JPanel(new BorderLayout());
                JPasswordField passwordField = new JPasswordField(25);
                panel.add((Component)new JLabel("user: " + userInfo), "North");
                panel.add((Component)passwordField, "South");
                if (JOptionPane.showConfirmDialog(this.dialogParent, panel, message, 2) == 0) {
                    tmpPassword = new String(passwordField.getPassword());
                }
            }
            if (tmpPassword == null) {
                tmpPassword = new String("");
                GasProp.getProperties().put(prop, "false");
            }
            return tmpPassword;
        }
    }
}

