/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import org.eso.gasgano.datamodel.gui.ResultsComponent;
import org.eso.gasgano.datamodel.gui.ResultsContainer;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.SortedHashtable;

public class ResultsModel {
    private SortedHashtable references = new SortedHashtable();
    private int refCounter = 0;
    private String referenceLabel = "[REFERENCES]";

    public ResultsModel(BufferedReader br) {
        this.init(br);
    }

    public ResultsModel() {
    }

    public void init(BufferedReader buffRead) {
        int linesCount = 0;
        boolean debug = false;
        String tmpString = "";
        ResultsContainer tmp2Label = null;
        if (PropertyDB.getInstance().isDebug(1)) {
            debug = true;
        }
        try {
            tmpString = buffRead.readLine();
            while (buffRead.ready()) {
                if (!tmpString.startsWith(this.referenceLabel)) continue;
                String refName = "Ref " + String.valueOf(this.refCounter);
                tmpString = "";
                ResultsContainer tmpRef = this.addReference(refName);
                if (debug) {
                    System.out.println("Added Reference: << " + tmpRef + ">>");
                }
                do {
                    tmpString = buffRead.readLine();
                    tmpString.trim();
                    ++linesCount;
                    if (tmpString.equals("")) continue;
                    while (buffRead.ready() && tmpString.startsWith("\t")) {
                        if (!tmpString.startsWith("\t[")) continue;
                        ResultsContainer tmpLabel = tmpRef.addLabel(tmpString);
                        if (debug) {
                            System.out.println("Added Label " + tmpString + " to " + tmpRef);
                        }
                        tmpString = buffRead.readLine();
                        tmpString.trim();
                        ++linesCount;
                        while (tmpString.startsWith("\t") && !tmpString.startsWith("\t[") && !tmpString.startsWith("\t\t[")) {
                            if (!tmpString.equals("")) {
                                tmpLabel.addFrame(tmpString);
                                if (debug) {
                                    System.out.println("Adding " + tmpString + " to " + tmpLabel);
                                }
                            }
                            tmpString = buffRead.readLine();
                            tmpString.trim();
                            ++linesCount;
                        }
                        while (buffRead.ready() && tmpString.startsWith("\t\t")) {
                            if (!tmpString.startsWith("\t\t[")) continue;
                            tmp2Label = tmpLabel.addLabel(tmpString);
                            if (debug) {
                                System.out.println("Adding " + tmp2Label + " to " + tmpLabel);
                            }
                            do {
                                tmpString = buffRead.readLine();
                                tmpString.trim();
                                ++linesCount;
                                if (tmpString.equals("") || !tmpString.startsWith("\t\t") || tmpString.startsWith("\t\t[")) continue;
                                tmp2Label.addFrame(tmpString);
                                if (!debug) continue;
                                System.out.println("Adding " + tmpString + " to " + tmp2Label);
                            } while (buffRead.ready() && tmpString.startsWith("\t\t") && !tmpString.startsWith("\t\t["));
                        }
                    }
                    if (tmpString.startsWith(this.referenceLabel)) continue;
                    tmpRef.addFrame(tmpString);
                    if (!debug) continue;
                    System.out.println("Adding " + tmpString + " to " + tmpRef);
                } while (!tmpString.startsWith(this.referenceLabel) && buffRead.ready());
            }
        }
        catch (IOException ioe) {
            System.err.println("gasgano: problem with reading results buffer");
        }
    }

    public void init2(BufferedReader buffRead) {
        int linesCount = 0;
        String tmpString = "";
        try {
            tmpString = buffRead.readLine();
            while (buffRead.ready()) {
                if (!tmpString.startsWith(this.referenceLabel)) continue;
                String refName = "Ref " + String.valueOf(this.refCounter);
                ResultsContainer tmpRef = this.addReference(refName);
                ResultsContainer tmpLabel = null;
                tmpString = "";
                do {
                    tmpString = buffRead.readLine();
                    ++linesCount;
                    if (tmpString.equals("")) continue;
                    if (tmpString.startsWith("[")) {
                        if (tmpString.startsWith(this.referenceLabel)) continue;
                        tmpLabel = tmpRef.addLabel(tmpString);
                        tmpString = buffRead.readLine();
                        while (!tmpString.startsWith("[")) {
                            if (!tmpString.equals("")) {
                                tmpLabel.addFrame(tmpString);
                            }
                            tmpString = buffRead.readLine();
                        }
                    } else {
                        tmpRef.addFrame(tmpString);
                    }
                } while (!tmpString.startsWith(this.referenceLabel) && buffRead.ready());
            }
        }
        catch (IOException ioe) {
            System.err.println("gasgano: problem with reading results buffer");
        }
    }

    public BufferedReader tmpAssessTiraPackInfo(String fileName) {
        BufferedReader buffRead = null;
        FileReader readerFile = null;
        File infoFile = null;
        String tmpString = "PACK.66.A-0597D.info";
        tmpString = "PACK.66.A-0307A.info";
        if (fileName != null) {
            tmpString = fileName;
        }
        if (!(infoFile = new File(tmpString)).exists() || !infoFile.canRead()) {
            System.out.println("File non existent or not readable");
            System.exit(-1);
        }
        try {
            readerFile = new FileReader(tmpString);
            buffRead = new BufferedReader(readerFile);
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        return buffRead;
    }

    public void displayModel() {
        System.out.println("References: " + this.getReferenceCount());
        Enumeration e2 = this.references.elements();
        while (e2.hasMoreElements()) {
            ResultsContainer tmpCont = (ResultsContainer)e2.nextElement();
            System.out.println(tmpCont);
            Enumeration ee = tmpCont.getFramesSet().elements();
            while (ee.hasMoreElements()) {
                ResultsComponent tmpFrame = (ResultsComponent)ee.nextElement();
                System.out.println("   " + tmpFrame);
            }
            ee = tmpCont.getLabelsSet().elements();
            while (ee.hasMoreElements()) {
                ResultsContainer tmpLabel = (ResultsContainer)ee.nextElement();
                System.out.println("       " + tmpLabel);
                Enumeration eee = tmpLabel.getFramesSet().elements();
                while (eee.hasMoreElements()) {
                    ResultsComponent tmpFrame = (ResultsComponent)eee.nextElement();
                    System.out.println("              " + tmpFrame);
                }
            }
        }
    }

    public void cleanup() {
        this.refCounter = 0;
        this.references.clear();
    }

    public ResultsContainer findReference(String id) {
        return null;
    }

    public ResultsContainer findReference(SortedHashtable progSet, String id) {
        return (ResultsContainer)progSet.get(id);
    }

    public int getReferenceCount() {
        return this.references.size();
    }

    public ResultsContainer getReferenceAt(int i) {
        return (ResultsContainer)this.references.elementAt(i);
    }

    public int getIndexOfReference(ResultsContainer ref) {
        return this.references.indexOf(ref);
    }

    public SortedHashtable getReferenceSet() {
        return this.references;
    }

    public ResultsContainer addReference(String id) {
        return this.addReference(this.references, id);
    }

    private ResultsContainer addReference(SortedHashtable progSet, String id) {
        ResultsContainer rc = this.findReference(progSet, id);
        if (rc == null) {
            rc = new ResultsContainer('r', id);
            progSet.put(id, rc);
            ++this.refCounter;
        }
        return rc;
    }

    public static void main(String[] args) {
        File infoFile = null;
        FileReader readerFile = null;
        BufferedReader buffRead = null;
        ResultsModel resMod = null;
        if (args.length == 1) {
            System.out.println(args[0]);
            infoFile = new File(args[0]);
            if (!infoFile.exists() || !infoFile.canRead()) {
                System.out.println("File non existent or not readable");
                System.exit(-1);
            }
            try {
                readerFile = new FileReader(args[0]);
                System.out.println("File opened");
                buffRead = new BufferedReader(readerFile);
            }
            catch (Exception e2) {
                System.err.println(e2);
            }
            resMod = new ResultsModel(buffRead);
            resMod.displayModel();
        }
    }
}

