/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eso.gasgano.datamodel.filesystem.DFSFile;

public class DFSTextFile
extends DFSFile {
    String dataAddress = null;
    String data = null;

    public DFSTextFile(String a2) {
        this.dataAddress = a2;
        this.readData();
    }

    public String toString() {
        return this.getFileName();
    }

    @Override
    public int readData() {
        this.dataRefreshed();
        int rc = this.readFile();
        this.data = null;
        return rc;
    }

    public int readFile() {
        this.setStatus(3);
        File theFile = new File(this.dataAddress);
        FileReader dataSource = null;
        try {
            dataSource = new FileReader(this.dataAddress);
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: " + this.dataAddress);
            this.setStatus(1);
            return this.getStatus();
        }
        if (dataSource == null) {
            this.setStatus(2);
            return this.getStatus();
        }
        StringBuffer buff = new StringBuffer();
        BufferedReader br = new BufferedReader(dataSource);
        try {
            String s;
            while ((s = br.readLine()) != null) {
                buff.append(s + "\n");
            }
        }
        catch (IOException e2) {
            this.setStatus(2);
        }
        try {
            dataSource.close();
        }
        catch (IOException e3) {
            // empty catch block
        }
        this.data = buff.toString();
        return this.getStatus();
    }

    public String getData() {
        return this.data;
    }

    public void freeData() {
        this.data = null;
    }

    @Override
    public File getPath() {
        return new File(this.dataAddress);
    }

    public String getAddress() {
        return this.dataAddress;
    }

    public void setData(String data) {
        this.data = data;
    }
}

