/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eso.dfs.util.FitsTokenizer;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.filesystem.FitsExtKeywordBlock;
import org.eso.gasgano.datamodel.filesystem.FitsFileKeywordListener;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordBlock;
import org.eso.gasgano.keyword.KeywordSet;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.oca.fits.OCAFile;
import org.eso.oca.fits.OCAFileFactory;
import org.eso.oca.fits.OCAFileFilter;
import org.eso.oca.parser.ASTStart;
import org.eso.oca.parser.InterpretationException;

public class FitsFile
extends DFSFile
implements KeywordSet {
    private Vector keywordArray = null;
    private Hashtable hTable = null;
    private List extensions = null;
    private String dataAddress = null;
    private String classification = null;
    private String instrument = null;
    private String telescope = null;
    private String signature = null;
    private String mjdObs = null;
    private boolean isPipeProduct = false;
    private boolean isCompressed = false;
    private boolean hasRbInfo = false;
    private static Vector keywordFilter;
    public static long classificationTime;
    public static long readHeaderTime;
    public static int classificationNumber;
    public static int readHeaderNumber;
    private static boolean radecConvert;
    private String groupingValue = null;
    private boolean calibFrame = false;
    public static final int FITS_REC_LENGTH = 80;
    public static final int BOUNDARY = 2880;
    public static final int DATE_LENGTH = 10;
    public static final String endToken = "END";

    public FitsFile(String address, Keyword[] requestedData) {
        this.init(address, requestedData);
    }

    public FitsFile(String a2) {
        this.init(a2, null);
    }

    private void init(String a2, Keyword[] requestedData) {
        this.dataAddress = a2;
        this.readFitsHeader();
        if (this.getStatus() == 3) {
            this.classify(DFSDataModel.getDataModel().getClassifier());
            this.addMetaKeywords();
            this.determineInstrument();
            this.determineTelescope();
            this.determineGrouping();
            this.determineIsCalib();
            this.determineSignature();
            this.determineRbInfo();
            this.determineMjdObs();
            if (requestedData != null) {
                for (int i = 0; i < requestedData.length; ++i) {
                    Keyword k = this.getKeyword(requestedData[i].getName());
                    if (k == null) continue;
                    requestedData[i].setValue(k.getValue());
                }
            }
        }
        this.freeHeaderMemory();
    }

    public static void setRadecConversion(boolean t) {
        radecConvert = t;
    }

    public static boolean getRadecConversion() {
        return radecConvert;
    }

    public static void setKeywordFilter(Vector kwv) {
        keywordFilter = kwv;
    }

    public static Vector getKeywordFilter() {
        return keywordFilter;
    }

    public void updateKeywords(Keyword[] requestedData) {
        if (!this.headerInMemory()) {
            this.readFitsHeader();
        }
        this.addMetaKeywords();
        if (requestedData != null) {
            for (int i = 0; i < requestedData.length; ++i) {
                Keyword k = this.getKeyword(requestedData[i].getName());
                if (k == null) continue;
                requestedData[i].setValue(k.getValue());
            }
        }
        this.freeHeaderMemory();
    }

    public boolean headerInMemory() {
        return this.hTable != null && this.keywordArray != null;
    }

    public boolean extensionsInMemory() {
        return this.extensions != null;
    }

    private void determineSignature() {
        Keyword tmpKey = this.getKeyword("DATAMD5");
        this.signature = tmpKey == null ? new String("") : new String(tmpKey.getValue());
    }

    private void determineInstrument() {
        Keyword tmpKey = this.getKeyword("INSTRUME");
        this.instrument = tmpKey == null ? new String("") : new String(tmpKey.getValue());
    }

    private void determineTelescope() {
        Keyword tmpKey = this.getKeyword("TELESCOP");
        this.telescope = tmpKey == null ? new String("") : new String(tmpKey.getValue());
    }

    private void determineGrouping() {
        this.groupingValue = null;
        StringBuffer gValue = new StringBuffer();
        Keyword resKey = null;
        Keyword[] groupKey = GasProp.getProperties().getInstrumentGrouping(this.getInstrument());
        if (groupKey == null) {
            return;
        }
        for (int i = 0; i < groupKey.length; ++i) {
            resKey = this.getKeyword(groupKey[i].getName());
            if (resKey == null) continue;
            if (gValue.length() > 0) {
                gValue.append(", ");
            }
            gValue.append(groupKey[i].getName() + " = " + resKey.getValue());
        }
        this.groupingValue = gValue.toString();
    }

    private void determineRbInfo() {
        String keyName = "PRO.REC1.RAW1.NAME";
        if (this.isPipeProduct && this.getKeyword(keyName) != null) {
            this.hasRbInfo = true;
        }
    }

    private void determineMjdObs() {
        Keyword tmpKey = this.getKeyword("MJD-OBS");
        if (tmpKey != null) {
            this.mjdObs = tmpKey.getValue();
            if (this.mjdObs == null) {
                this.mjdObs = "";
            }
        } else {
            this.mjdObs = "";
        }
    }

    private void determineIsCalib() {
        Keyword tmpKey;
        this.calibFrame = false;
        if (this.isPipeProduct && (tmpKey = this.getKeyword("DPR.CATG")) != null && tmpKey.getValue() != null && tmpKey.getValue().equals("CALIB")) {
            this.calibFrame = true;
        }
    }

    public void freeHeaderMemory() {
        this.hTable = null;
        this.keywordArray = null;
        this.extensions = null;
    }

    public void classify(ASTStart classifier) {
        if (classifier == null) {
            this.classification = "UNCLASSIFIED";
            return;
        }
        long startTime = 0L;
        boolean freeMemory = true;
        if (this.headerInMemory()) {
            freeMemory = false;
        } else {
            this.readFitsHeader();
        }
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        this.classification = null;
        ArrayList<OCAFile> validOCAFiles = new ArrayList<OCAFile>();
        ArrayList<File> skippedFiles = new ArrayList<File>();
        OCAFileFactory rawFileFactory = new OCAFileFactory(this.dataAddress);
        class GasganoOCAFileFilter
        implements OCAFileFilter {
            GasganoOCAFileFilter() {
            }

            @Override
            public boolean filter(OCAFile file) {
                return true;
            }
        }
        GasganoOCAFileFilter filter = new GasganoOCAFileFilter();
        ArrayList<String> keywords = new ArrayList<String>(Arrays.asList(classifier.getRequestedData()));
        keywords.add("PRO.CATG");
        rawFileFactory.createOCAFiles(0, keywords.toArray(new String[keywords.size()]), filter, validOCAFiles, skippedFiles);
        OCAFile[] ocaFiles = new OCAFile[]{validOCAFiles.get(0)};
        try {
            classifier.classify(ocaFiles);
        }
        catch (InterpretationException e2) {
            System.out.println("Error during classification: " + e2.getMessage() + "\nCause: " + e2.getCause());
        }
        try {
            this.classification = ocaFiles[0].getKeywordValue("DO.CATG");
            if (this.classification == null || this.classification.length() == 0) {
                this.classification = ocaFiles[0].getKeywordValue("PRO.CATG");
            }
        }
        catch (Exception e3) {
            try {
                this.classification = ocaFiles[0].getKeywordValue("PRO.CATG");
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (this.classification == null || this.classification.length() == 0) {
            this.classification = "UNCLASSIFIED";
        }
        if (freeMemory) {
            this.freeHeaderMemory();
        }
        if (PropertyDB.getInstance().isDebug(5)) {
            classificationTime += System.currentTimeMillis() - startTime;
            ++classificationNumber;
        }
    }

    public boolean isPipelineProduct() {
        return this.isPipeProduct;
    }

    public String getClassification() {
        return this.classification;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getTelescope() {
        return this.telescope;
    }

    private Hashtable getTable() {
        return this.hTable;
    }

    private Vector getVector() {
        return this.keywordArray;
    }

    @Override
    public int readData() {
        int rc = this.readFitsHeader();
        this.freeHeaderMemory();
        return rc;
    }

    public int readFitsHeader() {
        return this.readFitsHeaderAndExtensions(false);
    }

    public int readFitsHeaderAndExtensions(boolean readExtensions) {
        long startTime = 0L;
        Object br = null;
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        Object metaKeyword = null;
        this.dataRefreshed();
        this.setStatus(3);
        boolean endParsed = false;
        this.freeHeaderMemory();
        this.hTable = new Hashtable();
        this.keywordArray = new Vector();
        FitsTokenizer ft = new FitsTokenizer(this.dataAddress, readExtensions);
        FitsFileKeywordListener kwl = new FitsFileKeywordListener(this);
        ft.addKeywordListener(kwl);
        try {
            ft.read();
            for (int i = 0; i < this.getExtensionCount(); ++i) {
                this.setExtensionName(i);
            }
        }
        catch (IOException e2) {
            this.setStatus(2);
            System.out.println("Error reading file: " + this.getFileName() + ", read not completed. " + e2.toString());
        }
        Keyword k = this.getKeyword("PRO.CATG");
        if (k != null) {
            this.isPipeProduct = true;
        }
        if (PropertyDB.getInstance().isDebug(5)) {
            readHeaderTime += System.currentTimeMillis() - startTime;
            ++readHeaderNumber;
        }
        return this.getStatus();
    }

    private void setExtensionName(int ext) {
        FitsExtKeywordBlock kwb = this.getExtension(ext);
        String name = FitsExtKeywordBlock.generateExtensionName(kwb, ext);
        kwb.setName(name);
    }

    public boolean addMetaKeywords() {
        boolean rc = true;
        if (this.headerInMemory()) {
            Keyword metaKeyword = new Keyword("CLASSIFICATION", this.classification);
            this.addKeyword(metaKeyword);
            metaKeyword = new Keyword("FILE_PATH", this.getPathString());
            this.addKeyword(metaKeyword);
            metaKeyword = new Keyword("PIPE_PRODUCT", null);
            if (this.isPipelineProduct()) {
                metaKeyword.setValue("T");
            } else {
                metaKeyword.setValue("F");
            }
            this.addKeyword(metaKeyword);
        } else {
            rc = false;
        }
        return rc;
    }

    @Override
    public File getPath() {
        return new File(this.dataAddress);
    }

    public String getAddress() {
        return this.dataAddress;
    }

    @Override
    public Keyword getKeyword(String name) {
        Keyword rc = null;
        if (this.hTable == null) {
            this.readFitsHeader();
        }
        rc = (Keyword)this.hTable.get(name);
        return rc;
    }

    @Override
    public void addKeyword(Keyword k) {
        if (k != null) {
            try {
                this.hTable.put(k.getName(), k);
            }
            catch (NullPointerException ex) {
                System.out.println("error:" + ex.toString());
            }
            this.keywordArray.addElement(k);
        }
    }

    @Override
    public void removeKeyword(String k) {
    }

    @Override
    public void replaceKeyword(Keyword k) {
    }

    public void printKeyword(String key) {
        Keyword v = this.getKeyword(key);
        if (v != null) {
            System.out.println(v.getName() + ":\t\t\t" + v.getValue());
        } else {
            System.out.println(key + ":\t\t\tundefined");
        }
    }

    public String getIntermediateGrouping() {
        return this.groupingValue;
    }

    public boolean isCalibFrame() {
        return this.calibFrame;
    }

    public void addExtension() {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        FitsExtKeywordBlock b2 = new FitsExtKeywordBlock();
        int extNum = this.getExtensionCount() + 1;
        this.extensions.add(b2);
    }

    public KeywordBlock getHeaderKeywordBlock() {
        return new KeywordBlock(this.keywordArray, this.hTable);
    }

    public int getExtensionCount() {
        return this.extensions == null ? -1 : this.extensions.size();
    }

    public FitsExtKeywordBlock getExtension(int ext) {
        FitsExtKeywordBlock rc = this.extensions == null || ext < 0 || ext >= this.extensions.size() ? null : (FitsExtKeywordBlock)this.extensions.get(ext);
        return rc;
    }

    public void addKeywordToExtension(int ext, Keyword k) {
        if (k == null || this.extensions == null || ext < 0 || ext >= this.extensions.size()) {
            return;
        }
        KeywordBlock kwb = (KeywordBlock)this.extensions.get(ext);
        kwb.addKeyword(k);
    }

    public String getSignature() {
        return this.signature;
    }

    public String getMjdObs() {
        return this.mjdObs;
    }

    public boolean containsRbInfo() {
        return this.hasRbInfo;
    }

    public static boolean isUseMemoryMapping() {
        return FitsTokenizer.isUseMemoryMapping();
    }

    public static void main(String[] args) {
        boolean summaryOnly = false;
        boolean headerOnly = false;
        if (args.length == 0) {
            System.out.println("Please list fits files on command line.\n -summary for summary.\n -headeronly to avoid reading extensions.\n -memmap for memory mapped files.\n");
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-summary")) {
                    summaryOnly = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-memmap")) {
                    FitsTokenizer.setMemoryMappingEnabled(true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-headeronly")) {
                    headerOnly = true;
                    continue;
                }
                Date start = new Date();
                FitsFile f = new FitsFile(args[i]);
                if (f.getStatus() == 3) {
                    System.out.println(f.getFileName() + ": " + f.getStringStatus());
                    System.out.println("Read header in " + (new Date().getTime() - start.getTime()) + " ms.");
                    start = new Date();
                    f.readFitsHeaderAndExtensions(!headerOnly);
                    System.out.println("Read header" + (headerOnly ? "" : "+extensions") + " in " + (new Date().getTime() - start.getTime()) + " ms.");
                    if (summaryOnly) {
                        System.out.println("Found " + f.getExtensionCount() + " extensions.");
                        continue;
                    }
                    Vector header = f.getVector();
                    if (header == null) {
                        System.out.println("Header not read in.");
                    } else {
                        Enumeration e2 = header.elements();
                        while (e2.hasMoreElements()) {
                            Keyword kw = (Keyword)e2.nextElement();
                            System.out.println("" + kw.getName() + "\t\t\t" + kw.getValue());
                        }
                    }
                    if (headerOnly || f.getExtensionCount() < 0) {
                        System.out.println("Extensions not read in.");
                        continue;
                    }
                    for (int x = 0; x < f.getExtensionCount(); ++x) {
                        System.out.println("Extension " + (x + 1));
                        FitsExtKeywordBlock kwb = f.getExtension(x);
                        List kws = kwb.getList();
                        for (Keyword kw : kws) {
                            System.out.println("" + kw.getName() + "\t\t\t" + kw.getValue());
                        }
                    }
                    continue;
                }
                System.out.println(f.getFileName() + ": " + f.getStringStatus());
            }
        }
    }

    static {
        classificationTime = 0L;
        readHeaderTime = 0L;
        classificationNumber = 0;
        readHeaderNumber = 0;
        radecConvert = true;
    }
}

