/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class FitsFileOBComponent
extends KeywordContainerOBComponent {
    private static JLabel rawLabel = new JLabel(new ImageIcon(Object.class.getResource("/org/eso/gasgano/gui/icons/rawfits.gif")), 0);
    private static JLabel redLabel = new JLabel(new ImageIcon(Object.class.getResource("/org/eso/gasgano/gui/icons/redfits.gif")), 0);

    public FitsFileOBComponent(String address) {
        super(address);
        long startTime = 0L;
        if (PropertyDB.getInstance().isDebug(5)) {
            startTime = System.currentTimeMillis();
        }
        if (this.getStatus() == 3) {
            this.addToDataModel(defaultKeywordQuery[0].getValue(), defaultKeywordQuery[1].getValue(), this.myFile.getTelescope());
            if (PropertyDB.getInstance().isDebug(5)) {
                initTime += System.currentTimeMillis() - startTime;
                ++initNumber;
            }
        }
    }

    @Override
    public void addToDataModel(String progId, String obId, String telescopeId) {
        DFSDataModel dm = DFSDataModel.getDataModel();
        if (!dm.passFilter(this)) {
            this.myFile.setStatus(4);
            return;
        }
        if (progId == null) {
            progId = "Unknown Program";
        }
        if (obId == null) {
            obId = "Unknown Observation";
        }
        if (telescopeId == null) {
            telescopeId = "Unknown Telescope";
        }
        String dir = this.myFile.getPath().getParent();
        dm.addObComponent(progId, obId, dir, telescopeId, this);
    }

    @Override
    public JComponent getTreeCellComponent() {
        JLabel cell = null;
        Color foreGround = null;
        if (this.isPipeProduct()) {
            cell = redLabel;
            foreGround = Color.red;
        } else {
            cell = rawLabel;
            foreGround = Color.blue;
        }
        cell.setText(this.toString());
        cell.setForeground(foreGround);
        cell.setFont(this.getLabelFont());
        return cell;
    }

    @Override
    public String getArcfile() {
        if (this.isPipeProduct()) {
            return new String("");
        }
        return this.arcFile;
    }

    @Override
    public void classify() {
        this.myFile.classify(DFSDataModel.getDataModel().getClassifier());
        if (FitsFileOBComponent.getDefaultFileDescription() != null) {
            FitsFileOBComponent.getDefaultFileDescription().classificationChanged(this);
        }
    }
}

