/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.InterContainer;
import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.datamodel.Observation;
import org.eso.gasgano.datamodel.Program;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.gui.AbstractTreeTableModel;
import org.eso.gasgano.gui.TreeTableModel;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.SortedHashtable;

public class DFSFileTreeTableModel
extends AbstractTreeTableModel
implements DataModelChangeListener {
    private Vector treeListeners = null;
    private DFSDataModel dm = null;
    private RootNode root = new RootNode();
    private Vector displayCols = null;
    private int groupDataByLevel = 0;
    protected Vector allTheLeaves = new Vector();

    public DFSFileTreeTableModel(DFSDataModel d2) {
        this.init(d2);
    }

    private void init(DFSDataModel d2) {
        this.dm = d2;
        this.treeListeners = new Vector();
        this.setRootLabel(null);
        this.dm.addDataModelChangeListener(this);
        this.displayCols = GasProp.getProperties().fsDisplayColumns;
    }

    public int getGroupDataByLevel() {
        return this.groupDataByLevel;
    }

    public void setGroupDataByLevel(int gbLevel) {
        if (this.groupDataByLevel != gbLevel) {
            this.groupDataByLevel = gbLevel;
            this.setRootLabel(null);
            this.updateTree();
        }
    }

    public void setRootLabel(String name) {
        if (name == null) {
            String suffix = null;
            String filterStr = null;
            OBComponentFilter filter = this.dm.getFileFilter();
            filterStr = filter != null ? new String("Filter: " + filter.getDescription()) : new String("Unfiltered");
            if (this.groupDataByLevel == 0) {
                suffix = new String("");
            }
            if (this.groupDataByLevel == 1) {
                suffix = new String(" grouped by directory.");
            }
            if (this.groupDataByLevel == 2) {
                suffix = new String(" grouped by telescope.");
            }
            name = new String("Displaying " + this.dm.getFilesByName().size() + " files" + suffix + " " + filterStr + ".");
        }
        this.root.setLabel(name);
    }

    public String getRootLabel() {
        String rc = null;
        if (this.root != null) {
            this.root.getLabel();
        }
        return rc;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object rc = null;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getProgramAt(index);
            }
            if (this.groupDataByLevel == 1) {
                rc = this.dm.getDirectoryAt(index);
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().elementAt(index);
            }
        } else if (parent instanceof Program) {
            Program prog = (Program)parent;
            rc = prog.getObservationAt(index);
        } else if (parent instanceof Observation) {
            Observation obs = (Observation)parent;
            int ic = obs.getIntermediateCount();
            rc = index >= ic ? obs.getComponentAt(index - ic) : obs.getIntermediateAt(index);
        } else if (parent instanceof InterContainer) {
            InterContainer inter = (InterContainer)parent;
            rc = inter.getComponentAt(index);
        } else if (parent instanceof SortedHashtable) {
            SortedHashtable dir = (SortedHashtable)parent;
            rc = dir.elementAt(index);
        } else {
            rc = null;
        }
        return rc;
    }

    @Override
    public int getChildCount(Object parent) {
        int rc = 0;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getProgramCount();
            }
            if (this.groupDataByLevel == 1) {
                rc = this.dm.getDirectoryCount();
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().size();
            }
        } else if (parent instanceof Program) {
            Program prog = (Program)parent;
            rc = prog.getObservationCount();
        } else if (parent instanceof InterContainer) {
            InterContainer inter = (InterContainer)parent;
            rc = inter.getComponentCount();
        } else if (parent instanceof Observation) {
            Observation obs = (Observation)parent;
            rc = obs.getComponentCount() + obs.getIntermediateCount();
        } else if (parent instanceof SortedHashtable) {
            SortedHashtable dir = (SortedHashtable)parent;
            rc = dir.size();
        } else if (parent instanceof OBComponent) {
            rc = 0;
        }
        return rc;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int rc = -1;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getIndexOfProgram((Program)child);
            }
            if (this.groupDataByLevel == 1) {
                rc = this.dm.getDirectoryIndex(child);
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().indexOf(child);
            }
        } else if (parent instanceof Program) {
            Program prog = (Program)parent;
            rc = prog.getIndexOfObservation((Observation)child);
        } else if (parent instanceof Observation) {
            Observation obs = (Observation)parent;
            if (child instanceof OBComponent) {
                rc = obs.getIndexOfComponent((OBComponent)child) + obs.getIntermediateCount();
            }
            if (child instanceof InterContainer) {
                rc = obs.getIndexOfIntermediate((InterContainer)child);
            }
        } else if (parent instanceof InterContainer) {
            InterContainer inter = (InterContainer)parent;
            rc = inter.getIndexOfComponent((OBComponent)child);
        } else if (parent instanceof SortedHashtable) {
            SortedHashtable dir = (SortedHashtable)parent;
            rc = dir.indexOf(child);
        } else {
            rc = -1;
        }
        return rc;
    }

    @Override
    public int getColumnCount() {
        return this.displayCols.size() + 1;
    }

    @Override
    public String getColumnName(int column) {
        String rc = null;
        rc = column == 0 ? "File" : (String)this.displayCols.elementAt(column - 1);
        return rc;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Object rc = null;
        if (column > 0) {
            if (node instanceof KeywordContainerOBComponent) {
                String[] colData = null;
                colData = ((KeywordContainerOBComponent)node).getDisplayData();
                if (colData != null && colData.length >= column) {
                    rc = colData[column - 1];
                }
            }
        } else {
            rc = node;
        }
        return rc;
    }

    public void toggleColumn() {
        this.displayCols = GasProp.getProperties().fsDisplayColumns;
    }

    @Override
    public Class getColumnClass(int column) {
        Class rc = null;
        rc = column == 0 ? TreeTableModel.class : String.class;
        return rc;
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            this.setRootLabel(null);
        }
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean rc = false;
        if (node instanceof OBComponent) {
            rc = true;
        }
        return rc;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void dataModelChanged(DataModelEvent e2) {
        boolean debug = false;
        int delay = 10;
        int eType = 0;
        Object[] path = null;
        Object[] ancestors = null;
        Object child = e2.getFile();
        if (PropertyDB.getInstance().isDebug(2)) {
            debug = true;
        }
        eType = e2.getEvent();
        if (child == null) {
            if (debug) {
                System.err.println("DataModelChange Event sent with no OBComponent/Program/Observation Type:" + eType);
            }
            return;
        }
        path = this.getPathToRoot(child);
        ancestors = new Object[path.length - 1];
        for (int z = 0; z < ancestors.length; ++z) {
            ancestors[z] = path[z];
        }
        if (eType == 0) {
            this.dm.removeObComponent((OBComponent)child);
        }
        if (e2.getTreeType() != this.getGroupDataByLevel() && e2.getTreeType() != -1) {
            return;
        }
        if (debug) {
            System.out.print(">>> firing ");
            switch (eType) {
                case 3: {
                    System.out.print("PROGRAM_DELETED");
                    break;
                }
                case 4: {
                    System.out.print("PROGRAM_ADDED");
                    break;
                }
                case 5: {
                    System.out.print("OBSERVATION_DELETED");
                    break;
                }
                case 6: {
                    System.out.print("OBSERVATION_ADDED");
                    break;
                }
                case 11: {
                    System.out.print("INTERMEDIATE_DELETED");
                    break;
                }
                case 12: {
                    System.out.print("INTERMEDIATE_ADDED");
                    break;
                }
                case 7: {
                    System.out.print("DIRECTORY_DELETED");
                    break;
                }
                case 8: {
                    System.out.print("DIRECTORY_ADDED");
                    break;
                }
                case 10: {
                    System.out.print("TELESCOPE_ADDED");
                    break;
                }
                case 9: {
                    System.out.print("TELESCOPE_DELETED");
                    break;
                }
                case 1: {
                    System.out.print("FILE_ADDED");
                    break;
                }
                case 0: {
                    System.out.print("FILE_DELETED");
                }
            }
            System.out.print(" Level " + e2.getTreeType());
        }
        if (debug) {
            System.out.flush();
            System.out.print(" [ ");
            for (int i = 0; i < path.length; ++i) {
                System.out.print(path[i] + ", ");
                if (path[i] != null) continue;
                System.out.println("\nChild " + child + " has a null element in path");
            }
            System.out.print("]\n");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Reloader(ancestors));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Reloader(ancestors));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setRootLabel(null);
    }

    public void updateTree() {
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(this, path, null, null);
    }

    protected Enumeration getChildren(Object parent) {
        Enumeration rc = null;
        if (parent == this.root) {
            if (this.groupDataByLevel == 0) {
                rc = this.dm.getProgramSet().elements();
            }
            if (this.groupDataByLevel == 1) {
                rc = this.dm.getDirectories();
            }
            if (this.groupDataByLevel == 2) {
                rc = this.dm.getTelescopesSet().elements();
            }
        } else if (parent instanceof Program) {
            Program prog = (Program)parent;
            rc = prog.getObservationSet().elements();
        } else if (parent instanceof InterContainer) {
            InterContainer inter = (InterContainer)parent;
            rc = inter.getComponents().elements();
        } else if (parent instanceof Observation) {
            Observation obs = (Observation)parent;
            rc = obs.getDescendants().elements();
        } else if (parent instanceof SortedHashtable) {
            SortedHashtable dir = (SortedHashtable)parent;
            rc = dir.elements();
        } else {
            rc = null;
        }
        return rc;
    }

    public String getDirectory(Object parent) {
        Observation tmpObs;
        Program prog;
        String rc = null;
        if (parent == this.root) {
            return rc;
        }
        rc = parent.toString();
        if (parent instanceof Program && (prog = (Program)parent).getObservationCount() > 0 && prog.getObservationAt(0).getComponentCount() > 0) {
            rc = prog.getObservationAt(0).getComponentAt(0).getObservation(1).getProgram().getDirectory().toString();
        }
        if (parent instanceof Observation && (tmpObs = (Observation)parent).getComponentCount() > 0) {
            rc = tmpObs.getComponentAt(0).getObservation(1).getProgram().getDirectory().toString();
        }
        return rc;
    }

    public Object[] getPathToRoot(Object child) {
        Object[] path = null;
        boolean interMediate = false;
        boolean interOffset = false;
        if (child instanceof OBComponent) {
            OBComponent child2 = (OBComponent)child;
            if (child2.getIntermediateGrouping() != null) {
                interMediate = true;
                interOffset = true;
                if (this.groupDataByLevel == 0) {
                    path = new Object[5];
                    path[4] = child2;
                    path[3] = child2.getObservation(0);
                    path[2] = ((InterContainer)path[3]).getObservation();
                    path[1] = ((Observation)path[2]).getProgram();
                    path[0] = this.getRoot();
                }
                if (this.groupDataByLevel == 1) {
                    path = new Object[6];
                    path[5] = child2;
                    path[4] = child2.getObservation(1);
                    path[3] = ((InterContainer)path[4]).getObservation();
                    path[2] = ((Observation)path[3]).getProgram();
                    path[1] = ((Program)path[2]).getDirectory();
                    path[0] = this.getRoot();
                }
                if (this.groupDataByLevel == 2) {
                    path = new Object[6];
                    path[5] = child2;
                    path[4] = child2.getObservation(2);
                    path[3] = ((InterContainer)path[4]).getObservation();
                    path[2] = ((Observation)path[3]).getProgram();
                    path[1] = ((Program)path[2]).getTelescope();
                    path[0] = this.getRoot();
                }
            } else {
                if (this.groupDataByLevel == 0) {
                    path = new Object[4];
                    path[3] = child2;
                    path[2] = child2.getObservation(0);
                    path[1] = ((Observation)path[2]).getProgram();
                    path[0] = this.getRoot();
                }
                if (this.groupDataByLevel == 1) {
                    path = new Object[5];
                    path[4] = child2;
                    path[3] = child2.getObservation(1);
                    path[2] = ((Observation)path[3]).getProgram();
                    path[1] = ((Program)path[2]).getDirectory();
                    path[0] = this.getRoot();
                }
                if (this.groupDataByLevel == 2) {
                    path = new Object[5];
                    path[4] = child2;
                    path[3] = child2.getObservation(2);
                    path[2] = ((Observation)path[3]).getProgram();
                    path[1] = ((Program)path[2]).getTelescope();
                    path[0] = this.getRoot();
                }
            }
        }
        if (child instanceof Program) {
            if (this.groupDataByLevel == 0) {
                path = new Object[]{this.getRoot(), child};
            }
            if (this.groupDataByLevel == 1) {
                path = new Object[]{this.getRoot(), ((Program)child).getDirectory(), child};
            }
            if (this.groupDataByLevel == 2) {
                path = new Object[]{this.getRoot(), ((Program)child).getTelescope(), child};
            }
        }
        if (child instanceof InterContainer) {
            if (this.groupDataByLevel == 0) {
                path = new Object[4];
                path[3] = child;
                path[2] = ((InterContainer)child).getObservation();
                path[1] = ((Observation)path[2]).getProgram();
                path[0] = this.getRoot();
            }
            if (this.groupDataByLevel == 1) {
                path = new Object[5];
                path[4] = child;
                path[3] = ((InterContainer)child).getObservation();
                path[2] = ((Observation)path[3]).getProgram();
                path[1] = ((Program)path[2]).getDirectory();
                path[0] = this.getRoot();
            }
            if (this.groupDataByLevel == 2) {
                path = new Object[5];
                path[4] = child;
                path[3] = ((InterContainer)child).getObservation();
                path[2] = ((Observation)path[3]).getProgram();
                path[1] = ((Program)path[2]).getTelescope();
                path[0] = this.getRoot();
            }
        } else if (child instanceof Observation) {
            if (this.groupDataByLevel == 0) {
                path = new Object[]{this.getRoot(), ((Observation)child).getProgram(), child};
            }
            if (this.groupDataByLevel == 1) {
                path = new Object[]{this.getRoot(), ((Observation)child).getProgram().getDirectory(), ((Observation)child).getProgram(), child};
            }
            if (this.groupDataByLevel == 2) {
                path = new Object[]{this.getRoot(), ((Observation)child).getProgram().getTelescope(), ((Observation)child).getProgram(), child};
            }
        }
        if (child instanceof SortedHashtable) {
            path = new Object[]{this.getRoot(), child};
        }
        if (child instanceof RootNode) {
            path = new Object[]{child};
        }
        return path;
    }

    public Vector getAllTheLeaves(Object father) {
        this.allTheLeaves.removeAllElements();
        this.rec_traverse(father);
        return this.allTheLeaves;
    }

    public void rec_traverse(Object father) {
        if (this.isLeaf(father)) {
            this.allTheLeaves.addElement(father);
            return;
        }
        Enumeration e2 = this.getChildren(father);
        while (e2.hasMoreElements()) {
            this.rec_traverse(e2.nextElement());
        }
    }

    class RootNode {
        private String label = null;

        RootNode() {
        }

        public String toString() {
            return this.label;
        }

        void setLabel(String s) {
            this.label = s;
        }

        String getLabel() {
            return this.label;
        }
    }

    class Reloader
    implements Runnable {
        Object[] path = null;

        public Reloader(Object[] path) {
            this.path = path;
        }

        @Override
        public void run() {
            Thread.yield();
            DFSFileTreeTableModel.this.fireTreeStructureChanged(DFSFileTreeTableModel.this, this.path, null, null);
        }
    }
}

